/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.renderer;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.sakaiproject.jsf.util.ConfigurationResource;
import org.sakaiproject.jsf.util.RendererUtil;

public class InputDateRenderer
extends Renderer {
    private static final String HEIGHT = "16";
    private static final String WIDTH = "16";
    private static final String CURSORSTYLE;
    private static final String CLICKALT;
    private static final String CALENDAR_PATH;
    private static final String CALENDAR_ICON;
    private static final boolean inputMonthFirst;
    private static final boolean inputTimeColon;
    private static final boolean inputTime24;
    private static final boolean inputTimeSeconds = true;
    private static final String DATE_FORMAT_STRING;
    private static final String TIME_FORMAT_STRING;
    private static final SimpleDateFormat dateFormat;
    private static final SimpleDateFormat timeFormat;
    private static final SimpleDateFormat dateTimeFormat;
    private static final String DATE_HINT;
    private static final String TIME_HINT;

    public boolean supportsComponentType(UIComponent component) {
        return component instanceof UIInput;
    }

    public void decode(FacesContext context, UIComponent component) {
        if (RendererUtil.isDisabledOrReadonly(context, component)) {
            return;
        }
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String clientId = component.getClientId(context);
        String dateStr = (String)requestParameterMap.get(clientId + "_date");
        String timeStr = (String)requestParameterMap.get(clientId + "_time");
        if (dateStr == null && timeStr == null) {
            return;
        }
        EditableValueHolder ev = (EditableValueHolder)component;
        Date date = null;
        if (dateStr == null && timeStr != null) {
            try {
                date = timeFormat.parse(timeStr);
            }
            catch (ParseException ex) {}
        } else if (dateStr != null && timeStr == null) {
            try {
                date = dateFormat.parse(dateStr);
            }
            catch (ParseException ex) {}
        } else {
            try {
                date = dateTimeFormat.parse(dateStr + " " + timeStr);
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        ev.setSubmittedValue((Object)date);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (RendererUtil.isDisabledOrReadonly(context, component) || !component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        String dateString = "";
        String timeString = "";
        Date date = null;
        Date submittedValue = (Date)((EditableValueHolder)component).getSubmittedValue();
        if (submittedValue != null) {
            date = submittedValue;
        } else {
            Object value = ((ValueHolder)component).getValue();
            if (value instanceof Date) {
                date = (Date)value;
            } else if (value instanceof String) {
                try {
                    date = dateTimeFormat.parse((String)value);
                }
                catch (ParseException ex) {
                    // empty catch block
                }
            }
        }
        if (date != null) {
            dateString = dateFormat.format(date);
            timeString = timeFormat.format(date);
        }
        boolean showDate = "true".equals((String)RendererUtil.getAttribute(context, component, "showDate"));
        boolean showTime = "true".equals((String)RendererUtil.getAttribute(context, component, "showTime"));
        boolean showSecond = "true".equals((String)RendererUtil.getAttribute(context, component, "showSecond"));
        if (showDate) {
            writer.write("<i>&#160;" + DATE_HINT + "&#160;</i>");
            String dateId = clientId + "_date";
            String type = "text";
            writer.write("<input type=\"" + type + "\"" + " size=\"" + DATE_FORMAT_STRING.length() + "\"" + " name=\"" + dateId + "\"" + " id=\"" + dateId + "\"" + " value=\"" + dateString + "\">&#160;");
            String calRand = "cal" + ("" + Math.random()).substring(2);
            String calendar = inputMonthFirst ? "calendar2" : "calendar1";
            String calScript = "var " + calRand + " = new " + calendar + "(" + "document.getElementById('" + dateId + "'));" + "" + calRand + ".year_scroll = true;" + "" + calRand + ".time_comp = false;";
            writer.write("&#160;<img");
            writer.write("  id=\"" + clientId + "_datePickerPopup" + "\"");
            writer.write("  width=\"16\"\n");
            writer.write("  height=\"16\"\n");
            writer.write("  style=\"" + CURSORSTYLE + "\" ");
            writer.write("  src=\"" + CALENDAR_ICON + "\"\n");
            writer.write("  border=\"0\"\n");
            writer.write("  onclick=");
            writer.write("\"javascript:" + calScript + calRand + ".popup('','" + CALENDAR_PATH + "');\"\n");
            writer.write("  alt=\"" + CLICKALT + "\"\n");
            writer.write(" />&#160;&#160;\n");
        }
        if (showTime) {
            writer.write("<i>&#160;" + TIME_HINT + "&#160;</i>");
            String timeId = clientId + "_time";
            writer.write("<input type=\"text\" size=\"" + (DATE_FORMAT_STRING.length() + 1) + "\"" + " name=\"" + timeId + "\"" + " id=\"" + timeId + "\"" + " value=\"" + timeString + "\">&#160;");
        }
    }

    static {
        ConfigurationResource cr = new ConfigurationResource();
        String resources = cr.get("resources");
        CURSORSTYLE = cr.get("picker_style");
        CALENDAR_PATH = "/" + resources + "/" + cr.get("inputDatePopup");
        CALENDAR_ICON = "/" + resources + "/" + cr.get("inputDateImage");
        CLICKALT = cr.get("date_pick_alt");
        inputMonthFirst = "true".equals(cr.get("inputMonthFirst"));
        inputTimeColon = "true".equals(cr.get("inputTimeColon"));
        inputTime24 = "true".equals(cr.get("inputTime24"));
        DATE_HINT = cr.get("inputDateHint");
        TIME_HINT = cr.get("inputTimeHint");
        DATE_FORMAT_STRING = inputMonthFirst ? cr.get("inputMonthFirstFormat") : cr.get("inputDayFirstFormat");
        TIME_FORMAT_STRING = inputTimeColon ? (inputTime24 ? cr.get("inputTimeColonFormat24") : cr.get("inputTimeColonFormatAMPM")) : (inputTime24 ? cr.get("inputTimeDotFormat24") : cr.get("inputTimeDotFormatAMPM"));
        dateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
        timeFormat = new SimpleDateFormat(TIME_FORMAT_STRING);
        dateTimeFormat = new SimpleDateFormat(DATE_FORMAT_STRING + " " + TIME_FORMAT_STRING);
    }
}

