/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.renderer;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.cover.ContentTypeImageService;
import org.sakaiproject.jsf.util.RendererUtil;

public class JsfContentTypeMapRenderer
extends Renderer {
    public boolean supportsComponentType(UIComponent component) {
        return component instanceof UIOutput;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String fileType = (String)RendererUtil.getAttribute(context, component, "fileType");
        String mapType = (String)RendererUtil.getAttribute(context, component, "mapType");
        String pathPrefix = (String)RendererUtil.getAttribute(context, component, "pathPrefix");
        String var = (String)RendererUtil.getAttribute(context, component, "var");
        String result = this.getValue(fileType, mapType, this.getImageTypeService(), pathPrefix);
        if (var == null || var.length() == 0) {
            context.getResponseWriter().write(result);
        } else {
            Map requestMap = context.getExternalContext().getRequestMap();
            requestMap.put(var, result);
        }
    }

    protected String getValue(String fileType, String mapType, org.sakaiproject.content.api.ContentTypeImageService service, String pathPrefix) {
        if (mapType.equals("image")) {
            String imgPath = service.getContentTypeImage(fileType);
            String url = ServerConfigurationService.getServerUrl();
            return url + pathPrefix + imgPath;
        }
        if (mapType.equals("name")) {
            return service.getContentTypeDisplayName(fileType);
        }
        if (mapType.equals("extension")) {
            return service.getContentTypeExtension(fileType);
        }
        return null;
    }

    protected org.sakaiproject.content.api.ContentTypeImageService getImageTypeService() {
        return ContentTypeImageService.getInstance();
    }
}

