/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.renderer;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.sakaiproject.jsf.util.ConfigurationResource;
import org.sakaiproject.jsf.util.RendererUtil;

public class OutputDateRenderer
extends Renderer {
    private static final String OUTPUT_DATE;
    private static final String OUTPUT_DATE_TIME;
    private static final String OUTPUT_DATE_SECS;
    private static final String OUTPUT_TIME;
    private static final String OUTPUT_SECS;

    public boolean supportsComponentType(UIComponent component) {
        return component instanceof UIOutput;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        Date date = (Date)RendererUtil.getDefaultedAttribute(context, component, "value", new Date());
        String dateStr = "";
        String formatStr = this.getFormatString(context, component);
        dateStr = this.format(date, formatStr);
        String clientId = null;
        if (component.getId() != null && !component.getId().startsWith("_id")) {
            clientId = component.getClientId(context);
        }
        if (clientId != null) {
            writer.startElement("span", component);
            writer.writeAttribute("id", (Object)clientId, "id");
        }
        writer.write(dateStr);
        if (clientId != null) {
            writer.endElement("span");
        }
    }

    private String getFormatString(FacesContext context, UIComponent component) {
        boolean hasSeconds;
        String fmt = OUTPUT_DATE;
        String showTime = (String)RendererUtil.getAttribute(context, component, "showTime");
        String showDate = (String)RendererUtil.getAttribute(context, component, "showDate");
        String showSeconds = (String)RendererUtil.getAttribute(context, component, "showSeconds");
        boolean hasTime = "true".equals(showTime);
        boolean hasDate = "true".equals(showDate);
        boolean bl = hasSeconds = "true".equals(showSeconds) && hasTime;
        if (hasTime) {
            fmt = hasDate ? (hasSeconds ? OUTPUT_DATE_SECS : OUTPUT_DATE_TIME) : (hasSeconds ? OUTPUT_SECS : OUTPUT_TIME);
        }
        return fmt;
    }

    private String format(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    static {
        ConfigurationResource cr = new ConfigurationResource();
        OUTPUT_DATE = cr.get("outputDate");
        OUTPUT_DATE_TIME = cr.get("outputDateTime");
        OUTPUT_DATE_SECS = cr.get("outputDateTimeSecs");
        OUTPUT_TIME = cr.get("outputTime");
        OUTPUT_SECS = cr.get("outputTimeSecs");
    }
}

