/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import javax.servlet.http.HttpServletRequest;
import org.sakaiproject.jsf.util.RendererUtil;

public class ViewRenderer
extends Renderer {
    public boolean supportsComponentType(UIComponent component) {
        return component instanceof UIViewRoot || component instanceof UIOutput;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        HttpServletRequest req = (HttpServletRequest)context.getExternalContext().getRequest();
        ResponseWriter writer = context.getResponseWriter();
        if (!ViewRenderer.renderAsFragment(context)) {
            String toolCssHref;
            String headBaseCss = (String)req.getAttribute("sakai.html.head.css.base");
            if (headBaseCss == null || headBaseCss.length() == 0) {
                headBaseCss = "<link href=\"/jsf-resource/css/sakai.css\" type=\"text/css\" rel=\"stylesheet\" media=\"all\" />\n";
            }
            if ((toolCssHref = (String)RendererUtil.getAttribute(context, component, "toolCssHref")) != null) {
                toolCssHref = "<link href=\"" + toolCssHref + "\" type=\"text/css\" rel=\"stylesheet\" media=\"all\" />\n";
            }
            String headSkinCss = (String)req.getAttribute("sakai.html.head.css.skin");
            String headJs = (String)req.getAttribute("sakai.html.head.js");
            String bodyonload = (String)req.getAttribute("sakai.html.body.onload");
            writer.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");
            writer.write("<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n");
            writer.write("<head>\n");
            String title = (String)RendererUtil.getAttribute(context, component, "title");
            if (title != null) {
                writer.write("<title>");
                writer.write(title);
                writer.write("</title>\n");
            }
            writer.write(headBaseCss);
            if (toolCssHref != null) {
                writer.write(toolCssHref);
            }
            if (headSkinCss != null) {
                writer.write(headSkinCss);
            }
            if (headJs != null) {
                writer.write(headJs);
            }
            writer.write("</head>\n");
            writer.write("<body");
            if (bodyonload != null && bodyonload.length() > 0) {
                writer.write(" onload=\"");
                writer.write(bodyonload);
                writer.write("\"");
            }
            writer.write(">\n");
        }
        writer.write("<div class=\"portletBody\">\n");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write("</div>");
        if (!ViewRenderer.renderAsFragment(context)) {
            writer.write("</body></html>");
        }
    }

    protected static boolean renderAsFragment(FacesContext context) {
        String fragStr = (String)((HttpServletRequest)context.getExternalContext().getRequest()).getAttribute("sakai.fragment");
        return fragStr != null && "true".equals(fragStr);
    }
}

