/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleUtil {
    private static final Log log = LogFactory.getLog(LocaleUtil.class);
    private static Object sakaiResourceLoader = null;
    private static Method sakaiResourceLoaderGetLocale;
    private static boolean isInitialized;

    private static void init() {
        if (!isInitialized) {
            block16: {
                try {
                    Class<?> sakaiResourceLoaderClass = Class.forName("org.sakaiproject.util.ResourceLoader");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Found Sakai ResourceLoader class");
                    }
                    Constructor<?> sakaiResourceLoaderConstructor = sakaiResourceLoaderClass.getConstructor(new Class[0]);
                    sakaiResourceLoaderGetLocale = sakaiResourceLoaderClass.getMethod("getLocale", new Class[0]);
                    sakaiResourceLoader = sakaiResourceLoaderConstructor.newInstance(new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Did not find Sakai ResourceLoader class; will use standard JSF localization");
                    }
                }
                catch (SecurityException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Will use standard JSF localization", (Throwable)e);
                    }
                }
                catch (NoSuchMethodException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Will use standard JSF localization", (Throwable)e);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Will use standard JSF localization", (Throwable)e);
                    }
                }
                catch (InstantiationException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Will use standard JSF localization", (Throwable)e);
                    }
                }
                catch (IllegalAccessException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Will use standard JSF localization", (Throwable)e);
                    }
                }
                catch (InvocationTargetException e) {
                    if (!log.isErrorEnabled()) break block16;
                    log.error((Object)"Will use standard JSF localization", (Throwable)e);
                }
            }
            isInitialized = true;
        }
    }

    public static Locale getLocale(FacesContext context) {
        Locale locale;
        block8: {
            locale = null;
            LocaleUtil.init();
            if (sakaiResourceLoader != null) {
                try {
                    locale = (Locale)sakaiResourceLoaderGetLocale.invoke(sakaiResourceLoader, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)e);
                    }
                    break block8;
                }
                catch (IllegalAccessException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)e);
                    }
                    break block8;
                }
                catch (InvocationTargetException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)e);
                    }
                    break block8;
                }
            }
            locale = context.getViewRoot().getLocale();
        }
        return locale;
    }

    public static String getLocalizedString(FacesContext context, String bundleName, String key) {
        String localized = null;
        Locale locale = LocaleUtil.getLocale(context);
        ResourceBundle rb = ResourceBundle.getBundle(bundleName, locale);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getLocalizedString; locale=" + locale.getDisplayName() + ", bundleName=" + bundleName + ", rb=" + rb.getLocale() + ", rb getCountry()=" + rb.getLocale().getCountry()));
        }
        localized = rb.getString(key);
        return localized;
    }

    static {
        isInitialized = false;
    }
}

