/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums;

import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.collection.PersistentSet;
import org.hibernate.type.Type;
import org.sakaiproject.api.app.messageforums.Area;
import org.sakaiproject.api.app.messageforums.AreaManager;
import org.sakaiproject.api.app.messageforums.BaseForum;
import org.sakaiproject.api.app.messageforums.DiscussionForum;
import org.sakaiproject.api.app.messageforums.DiscussionTopic;
import org.sakaiproject.api.app.messageforums.MessageForumsForumManager;
import org.sakaiproject.api.app.messageforums.MessageForumsTypeManager;
import org.sakaiproject.api.app.messageforums.cover.ForumScheduleNotificationCover;
import org.sakaiproject.api.app.messageforums.cover.SynopticMsgcntrManagerCover;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.app.messageforums.TestUtil;
import org.sakaiproject.component.app.messageforums.dao.hibernate.AreaImpl;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.id.api.IdManager;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.util.ResourceLoader;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class AreaManagerImpl
extends HibernateDaoSupport
implements AreaManager {
    private static final Log LOG = LogFactory.getLog(AreaManagerImpl.class);
    private static final String QUERY_AREA_BY_CONTEXT_AND_TYPE_ID = "findAreaByContextIdAndTypeId";
    private static final String QUERY_AREA_BY_TYPE = "findAreaByType";
    private static final String MESSAGECENTER_BUNDLE = "org.sakaiproject.api.app.messagecenter.bundle.Messages";
    private static final String MESSAGES_TITLE = "cdfm_message_pvtarea";
    private static final String FORUMS_TITLE = "cdfm_discussion_forums";
    private IdManager idManager;
    private MessageForumsForumManager forumManager;
    private SessionManager sessionManager;
    private MessageForumsTypeManager typeManager;
    private ServerConfigurationService serverConfigurationService;
    private Boolean DEFAULT_AUTO_MARK_READ = false;
    private SiteService siteService;

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void init() {
        LOG.info((Object)"init()");
        this.DEFAULT_AUTO_MARK_READ = this.serverConfigurationService.getBoolean("msgcntr.forums.default.auto.mark.threads.read", false);
    }

    public MessageForumsTypeManager getTypeManager() {
        return this.typeManager;
    }

    public void setTypeManager(MessageForumsTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public IdManager getIdManager() {
        return this.idManager;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setIdManager(IdManager idManager) {
        this.idManager = idManager;
    }

    public void setForumManager(MessageForumsForumManager forumManager) {
        this.forumManager = forumManager;
    }

    public Area getPrivateArea() {
        return this.getPrivateArea(this.getContextId());
    }

    public Area getPrivateArea(String siteId) {
        Area area = this.getAreaByContextIdAndTypeId(siteId, this.typeManager.getPrivateMessageAreaType());
        if (area == null) {
            area = this.createArea(this.typeManager.getPrivateMessageAreaType(), siteId);
            area.setContextId(siteId);
            area.setName(this.getResourceBundleString(MESSAGES_TITLE));
            area.setEnabled(Boolean.FALSE);
            area.setHidden(Boolean.TRUE);
            area.setLocked(Boolean.FALSE);
            area.setModerated(Boolean.FALSE);
            area.setPostFirst(Boolean.FALSE);
            area.setAutoMarkThreadsRead(this.DEFAULT_AUTO_MARK_READ);
            area.setSendEmailOut(Boolean.TRUE);
            this.saveArea(area);
        }
        return area;
    }

    public Area getDiscusionArea() {
        return this.getDiscussionArea(this.getContextId());
    }

    public Area getDiscussionArea(String contextId) {
        return this.getDiscussionArea(contextId, true);
    }

    public Area getDiscussionArea(String contextId, boolean createDefaultForum) {
        LOG.debug((Object)("getDiscussionArea(" + contextId + ")"));
        if (contextId == null) {
            return this.getDiscusionArea();
        }
        Area area = this.getAreaByContextIdAndTypeId(contextId, this.typeManager.getDiscussionForumType());
        if (area == null) {
            LOG.info((Object)("setting up a new Discussion Area for " + contextId));
            area = this.createArea(this.typeManager.getDiscussionForumType(), contextId);
            area.setName(this.getResourceBundleString(FORUMS_TITLE));
            area.setEnabled(Boolean.TRUE);
            area.setHidden(Boolean.TRUE);
            area.setLocked(Boolean.FALSE);
            area.setModerated(Boolean.FALSE);
            area.setPostFirst(Boolean.FALSE);
            area.setAutoMarkThreadsRead(this.DEFAULT_AUTO_MARK_READ);
            area.setSendEmailOut(Boolean.TRUE);
            area.setAvailabilityRestricted(Boolean.FALSE);
            this.saveArea(area);
            if (createDefaultForum && this.serverConfigurationService.getBoolean("forums.setDefault.forum", true)) {
                this.setAreaDefaultElements(area);
            }
        }
        return area;
    }

    private void setAreaDefaultElements(Area area) {
        LOG.info((Object)("setAreaDefaultElements(" + area.getId() + ")"));
        DiscussionForum forum = this.forumManager.createDiscussionForum();
        forum.setArea(area);
        String siteTitle = null;
        try {
            Site site = this.siteService.getSite(area.getContextId());
            siteTitle = site.getTitle();
        }
        catch (IdUnusedException e) {
            e.printStackTrace();
        }
        forum.setCreatedBy("admin");
        forum.setTitle(this.getResourceBundleString("default_forum", new Object[]{siteTitle}));
        forum.setDraft(Boolean.valueOf(false));
        forum.setModerated(area.getModerated());
        forum.setPostFirst(area.getPostFirst());
        this.forumManager.saveDiscussionForum(forum);
        DiscussionTopic topic = this.forumManager.createDiscussionForumTopic(forum);
        topic.setTitle(this.getResourceBundleString("default_topic"));
        topic.setCreatedBy("admin");
        this.forumManager.saveDiscussionForumTopic(topic, false);
    }

    public boolean isPrivateAreaEnabled() {
        return this.getPrivateArea().getEnabled();
    }

    public Area createArea(String typeId, String contextParam) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createArea(" + typeId + "," + contextParam + ")"));
        }
        AreaImpl area = new AreaImpl();
        area.setUuid(this.getNextUuid());
        area.setTypeUuid(typeId);
        area.setCreated(new Date());
        area.setCreatedBy(this.getCurrentUser());
        if (contextParam == null) {
            String contextId = this.getContextId();
            if (contextId == null) {
                throw new IllegalStateException("Cannot retrive current context");
            }
            area.setContextId(contextId);
        } else {
            area.setContextId(contextParam);
        }
        LOG.debug((Object)("createArea executed with areaId: " + area.getUuid()));
        return area;
    }

    public void saveArea(Area area) {
        String currentUser = this.getCurrentUser();
        this.saveArea(area, currentUser);
    }

    public void saveArea(Area area, String currentUser) {
        boolean isNew = area.getId() == null;
        area.setModified(new Date());
        area.setModifiedBy(currentUser);
        boolean someForumHasZeroSortIndex = false;
        if (area.getOpenForumsSet() != null && (area.getOpenForumsSet() instanceof PersistentSet && ((PersistentSet)area.getOpenForumsSet()).wasInitialized() || !(area.getOpenForumsSet() instanceof PersistentSet))) {
            for (BaseForum forum : area.getOpenForums()) {
                if (forum.getSortIndex() != 0) continue;
                someForumHasZeroSortIndex = true;
                break;
            }
            if (someForumHasZeroSortIndex) {
                for (BaseForum forum : area.getOpenForums()) {
                    forum.setSortIndex(Integer.valueOf(forum.getSortIndex() + 1));
                }
            }
        }
        boolean origVal = area.getAvailability();
        area.setAvailability(Boolean.valueOf(ForumScheduleNotificationCover.makeAvailableHelper((boolean)area.getAvailabilityRestricted(), (Date)area.getOpenDate(), (Date)area.getCloseDate())));
        this.getHibernateTemplate().saveOrUpdate((Object)area);
        if (origVal != area.getAvailability()) {
            SynopticMsgcntrManagerCover.resetAllUsersSynopticInfoInSite((String)area.getContextId());
        }
        ForumScheduleNotificationCover.scheduleAvailability((Area)area);
        LOG.debug((Object)("saveArea executed with areaId: " + area.getId()));
    }

    public void deleteArea(Area area) {
        this.getHibernateTemplate().delete((Object)area);
        LOG.debug((Object)("deleteArea executed with areaId: " + area.getId()));
    }

    private String getContextId() {
        if (TestUtil.isRunningTests()) {
            return "test-context";
        }
        Placement placement = ToolManager.getCurrentPlacement();
        String presentSiteId = placement.getContext();
        return presentSiteId;
    }

    public Area getAreaByContextIdAndTypeId(String typeId) {
        LOG.debug((Object)("getAreaByContextIdAndTypeId executing for current user: " + this.getCurrentUser()));
        return this.getAreaByContextIdAndTypeId(this.getContextId(), typeId);
    }

    public Area getAreaByContextIdAndTypeId(final String contextId, final String typeId) {
        LOG.debug((Object)("getAreaByContextIdAndTypeId executing for current user: " + this.getCurrentUser()));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(AreaManagerImpl.QUERY_AREA_BY_CONTEXT_AND_TYPE_ID);
                q.setParameter("contextId", (Object)contextId, (Type)Hibernate.STRING);
                q.setParameter("typeId", (Object)typeId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Area)this.getHibernateTemplate().execute(hcb);
    }

    public Area getAreaByType(final String typeId) {
        String currentUser = this.getCurrentUser();
        LOG.debug((Object)("getAreaByType executing for current user: " + currentUser));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(AreaManagerImpl.QUERY_AREA_BY_TYPE);
                q.setParameter("typeId", (Object)typeId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Area)this.getHibernateTemplate().execute(hcb);
    }

    private String getNextUuid() {
        return this.idManager.createUuid();
    }

    private String getCurrentUser() {
        String user = this.sessionManager.getCurrentSessionUserId();
        return user == null ? "test-user" : user;
    }

    private String getEventMessage(Object object) {
        return "/MessageCenter/site/" + this.getContextId() + "/" + object.toString() + "/" + this.getCurrentUser();
    }

    public String getResourceBundleString(String key) {
        ResourceLoader rb = new ResourceLoader(MESSAGECENTER_BUNDLE);
        return rb.getString(key);
    }

    private String getResourceBundleString(String key, Object[] replacementValues) {
        ResourceLoader rb = new ResourceLoader(MESSAGECENTER_BUNDLE);
        return rb.getFormattedMessage(key, replacementValues);
    }
}

