/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.messageforums.DefaultPermissionsManager;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.FunctionManager;
import org.sakaiproject.tool.cover.ToolManager;

public class DefaultPermissionsManagerImpl
implements DefaultPermissionsManager {
    private static final Log LOG = LogFactory.getLog(DefaultPermissionsManagerImpl.class);
    private FunctionManager functionManager;
    private AuthzGroupService authzGroupService;

    public void init() {
        LOG.info((Object)"init()");
        List registered = this.functionManager.getRegisteredFunctions("msg.");
        if (!registered.contains("msg.emailout")) {
            this.functionManager.registerFunction("msg.emailout");
        }
        if (!registered.contains("msg.permissions.allowToField.allParticipants")) {
            this.functionManager.registerFunction("msg.permissions.allowToField.allParticipants");
        }
        if (!registered.contains("msg.permissions.allowToField.groups")) {
            this.functionManager.registerFunction("msg.permissions.allowToField.groups");
        }
        if (!registered.contains("msg.permissions.allowToField.roles")) {
            this.functionManager.registerFunction("msg.permissions.allowToField.roles");
        }
        if (!registered.contains("msg.permissions.viewHidden.groups")) {
            this.functionManager.registerFunction("msg.permissions.viewHidden.groups");
        }
    }

    public void setFunctionManager(FunctionManager functionManager) {
        this.functionManager = functionManager;
    }

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        this.authzGroupService = authzGroupService;
    }

    public boolean isNewForum(String role) {
        return this.hasPermission(role, "messagecenter.newForum");
    }

    public boolean isNewTopic(String role) {
        return this.hasPermission(role, "messagecenter.newTopic");
    }

    public boolean isNewResponse(String role) {
        return this.hasPermission(role, "messagecenter.newResponse");
    }

    public boolean isResponseToResponse(String role) {
        return this.hasPermission(role, "messagecenter.newResponseToResponse");
    }

    public boolean isMovePostings(String role) {
        return this.hasPermission(role, "messagecenter.movePostings");
    }

    public boolean isChangeSettings(String role) {
        return this.hasPermission(role, "messagecenter.changeSettings");
    }

    public boolean isPostToGradebook(String role) {
        return this.hasPermission(role, "messagecenter.postToGradebook");
    }

    public boolean isRead(String role) {
        return this.hasPermission(role, "messagecenter.read");
    }

    public boolean isReviseAny(String role) {
        return this.hasPermission(role, "messagecenter.reviseAny");
    }

    public boolean isReviseOwn(String role) {
        return this.hasPermission(role, "messagecenter.reviseOwn");
    }

    public boolean isDeleteAny(String role) {
        return this.hasPermission(role, "messagecenter.deleteAny");
    }

    public boolean isDeleteOwn(String role) {
        return this.hasPermission(role, "messagecenter.deleteOwn");
    }

    public boolean isMarkAsRead(String role) {
        return this.hasPermission(role, "messagecenter.markAsRead");
    }

    private boolean hasPermission(String role, String permission) {
        ArrayList<String> realmList = new ArrayList<String>();
        realmList.add(this.getContextSiteId());
        AuthzGroup authzGroup = null;
        try {
            authzGroup = this.authzGroupService.getAuthzGroup("!site.helper");
        }
        catch (Exception e) {
            LOG.info((Object)"No site helper template found");
        }
        if (authzGroup != null) {
            realmList.add(authzGroup.getId());
        }
        Set allowedFunctions = this.authzGroupService.getAllowedFunctions(role, realmList);
        return allowedFunctions.contains(permission);
    }

    private String getContextSiteId() {
        LOG.debug((Object)"getContextSiteId()");
        return "/site/" + ToolManager.getCurrentPlacement().getContext();
    }
}

