/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.messageforums.Area;
import org.sakaiproject.api.app.messageforums.AreaManager;
import org.sakaiproject.api.app.messageforums.Attachment;
import org.sakaiproject.api.app.messageforums.DBMembershipItem;
import org.sakaiproject.api.app.messageforums.DiscussionForum;
import org.sakaiproject.api.app.messageforums.DiscussionForumService;
import org.sakaiproject.api.app.messageforums.DiscussionTopic;
import org.sakaiproject.api.app.messageforums.MessageForumsForumManager;
import org.sakaiproject.api.app.messageforums.MessageForumsMessageManager;
import org.sakaiproject.api.app.messageforums.MessageForumsTypeManager;
import org.sakaiproject.api.app.messageforums.PermissionLevel;
import org.sakaiproject.api.app.messageforums.PermissionLevelManager;
import org.sakaiproject.api.app.messageforums.PermissionsMask;
import org.sakaiproject.api.app.messageforums.ui.DiscussionForumManager;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.cover.AuthzGroupService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.EntityTransferrer;
import org.sakaiproject.entity.api.EntityTransferrerRefMigrator;
import org.sakaiproject.entity.api.HttpAccess;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.util.Validator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscussionForumServiceImpl
implements DiscussionForumService,
EntityTransferrer,
EntityTransferrerRefMigrator {
    private static final String MESSAGEFORUM = "messageforum";
    private static final String DISCUSSION_FORUM = "discussion_forum";
    private static final String DISCUSSION_TOPIC = "discussion_topic";
    private static final String DISCUSSION_FORUM_TITLE = "category";
    private static final String DISCUSSION_FORUM_DESC = "body";
    private static final String DISCUSSION_FORUM_SHORT_DESC = "summary";
    private static final String TOPIC_TITLE = "subject";
    private static final String DRAFT = "draft";
    private static final String LOCKED = "locked";
    private static final String MODERATED = "moderated";
    private static final String POST_FIRST = "post_first";
    private static final String SORT_INDEX = "sort_index";
    private static final String PROPERTIES = "properties";
    private static final String PROPERTY = "property";
    private static final String TOPIC_SHORT_DESC = "Classic:bboardForums_description";
    private static final String TOPIC_LONG_DESC = "Classic:bboardForums_content";
    private static final String NAME = "name";
    private static final String ENCODE = "enc";
    private static final String BASE64 = "BASE64";
    private static final String VALUE = "value";
    private static final String ATTACHMENT = "attachment";
    private static final String ATTACH_ID = "relative-url";
    private static final String PERMISSIONS = "permissions";
    private static final String PERMISSION = "permission";
    private static final String PERMISSION_TYPE = "permission_type";
    private static final String PERMISSION_NAME = "permission_name";
    private static final String PERMISSION_LEVEL_NAME = "permission_level_name";
    private static final String CUSTOM_PERMISSIONS = "permission_levels";
    private static final String ARCHIVE_VERSION = "2.4";
    private static final String VERSION_ATTR = "version";
    private MessageForumsForumManager forumManager;
    private AreaManager areaManager;
    private MessageForumsMessageManager messageManager;
    private MessageForumsTypeManager typeManager;
    private DiscussionForumManager dfManager;
    private PermissionLevelManager permissionManager;
    private ContentHostingService contentHostingService;
    private static final Log LOG = LogFactory.getLog(DiscussionForumService.class);

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public void init() throws Exception {
        LOG.info((Object)"init()");
        EntityManager.registerEntityProducer((EntityProducer)this, (String)"/messageforum");
    }

    public String archive(String siteId, Document doc, Stack stack, String archivePath, List attachments) {
        Base64 base64Encoder = new Base64();
        StringBuilder results = new StringBuilder();
        try {
            int forumCount = 0;
            results.append("archiving " + this.getLabel() + " context " + "/" + siteId + "/" + SiteService.MAIN_CONTAINER + ".\n");
            Element element = doc.createElement(DiscussionForumService.class.getName());
            element.setAttribute(VERSION_ATTR, ARCHIVE_VERSION);
            ((Element)stack.peek()).appendChild(element);
            stack.push(element);
            if (siteId != null && siteId.trim().length() > 0) {
                Area dfArea = this.areaManager.getAreaByContextIdAndTypeId(siteId, this.typeManager.getDiscussionForumType());
                if (dfArea != null) {
                    Element dfElement = doc.createElement(MESSAGEFORUM);
                    List forums = this.dfManager.getDiscussionForumsWithTopicsMembershipNoAttachments(siteId);
                    if (forums != null && !forums.isEmpty()) {
                        for (DiscussionForum forum : forums) {
                            List topicList;
                            String encoded;
                            if (forum == null) continue;
                            ++forumCount;
                            Element df_data = doc.createElement(DISCUSSION_FORUM);
                            df_data.setAttribute(DISCUSSION_FORUM_TITLE, forum.getTitle());
                            df_data.setAttribute(DRAFT, forum.getDraft().toString());
                            df_data.setAttribute(LOCKED, forum.getLocked().toString());
                            df_data.setAttribute(MODERATED, forum.getModerated().toString());
                            df_data.setAttribute(SORT_INDEX, forum.getSortIndex().toString());
                            try {
                                encoded = new String(base64Encoder.encode(forum.getExtendedDescription().getBytes()));
                                df_data.setAttribute(DISCUSSION_FORUM_DESC, encoded);
                            }
                            catch (Exception e) {
                                df_data.setAttribute(DISCUSSION_FORUM_DESC, "");
                            }
                            try {
                                encoded = new String(base64Encoder.encode(forum.getShortDescription().getBytes()));
                                df_data.setAttribute(DISCUSSION_FORUM_SHORT_DESC, encoded);
                            }
                            catch (Exception e) {
                                df_data.setAttribute(DISCUSSION_FORUM_SHORT_DESC, "");
                            }
                            List atts = this.forumManager.getForumById(true, forum.getId()).getAttachments();
                            for (int i = 0; i < atts.size(); ++i) {
                                Element forum_attachment = doc.createElement(ATTACHMENT);
                                String attachId = ((Attachment)atts.get(i)).getAttachmentId();
                                forum_attachment.setAttribute(ATTACH_ID, attachId);
                                df_data.appendChild(forum_attachment);
                            }
                            Set forumMembershipItems = forum.getMembershipItemSet();
                            if (forumMembershipItems != null && forumMembershipItems.size() > 0) {
                                Element forum_permissions = doc.createElement(PERMISSIONS);
                                for (DBMembershipItem membershipItem : forumMembershipItems) {
                                    List customPerms;
                                    Element permission = doc.createElement(PERMISSION);
                                    permission.setAttribute(PERMISSION_TYPE, membershipItem.getType().toString());
                                    permission.setAttribute(PERMISSION_NAME, membershipItem.getName());
                                    permission.setAttribute(PERMISSION_LEVEL_NAME, membershipItem.getPermissionLevelName());
                                    if ("Custom".equals(membershipItem.getPermissionLevelName()) && (customPerms = this.permissionManager.getCustomPermissions()) != null && customPerms.size() > 0) {
                                        Element customPermissions = doc.createElement(CUSTOM_PERMISSIONS);
                                        for (int i = 0; i < customPerms.size(); ++i) {
                                            String name = (String)customPerms.get(i);
                                            String hasPermission = this.permissionManager.getCustomPermissionByName(name, membershipItem.getPermissionLevel()).toString();
                                            customPermissions.setAttribute(name, hasPermission);
                                        }
                                        permission.appendChild(customPermissions);
                                    }
                                    forum_permissions.appendChild(permission);
                                }
                                df_data.appendChild(forum_permissions);
                            }
                            if ((topicList = this.dfManager.getTopicsByIdWithMessagesMembershipAndAttachments(forum.getId())) != null && topicList.size() > 0) {
                                for (DiscussionTopic topic : topicList) {
                                    Element topic_data = doc.createElement(DISCUSSION_TOPIC);
                                    topic_data.setAttribute(TOPIC_TITLE, topic.getTitle());
                                    topic_data.setAttribute(DRAFT, topic.getDraft().toString());
                                    topic_data.setAttribute(LOCKED, topic.getLocked().toString());
                                    topic_data.setAttribute(MODERATED, topic.getModerated().toString());
                                    if (topic.getSortIndex() != null) {
                                        topic_data.setAttribute(SORT_INDEX, topic.getSortIndex().toString());
                                    } else {
                                        topic_data.setAttribute(SORT_INDEX, "");
                                    }
                                    Element topic_properties = doc.createElement(PROPERTIES);
                                    Element topic_short_desc = doc.createElement(PROPERTY);
                                    try {
                                        String encoded2 = new String(base64Encoder.encode(topic.getShortDescription().getBytes()));
                                        topic_short_desc.setAttribute(NAME, TOPIC_SHORT_DESC);
                                        topic_short_desc.setAttribute(ENCODE, BASE64);
                                        topic_short_desc.setAttribute(VALUE, encoded2);
                                    }
                                    catch (Exception e) {
                                        topic_short_desc.setAttribute(NAME, TOPIC_SHORT_DESC);
                                        topic_short_desc.setAttribute(ENCODE, BASE64);
                                        topic_short_desc.setAttribute(VALUE, "");
                                    }
                                    topic_properties.appendChild(topic_short_desc);
                                    Element topic_long_desc = doc.createElement(PROPERTY);
                                    try {
                                        String encoded3 = new String(base64Encoder.encode(topic.getExtendedDescription().getBytes()));
                                        topic_long_desc.setAttribute(NAME, TOPIC_LONG_DESC);
                                        topic_long_desc.setAttribute(ENCODE, BASE64);
                                        topic_long_desc.setAttribute(VALUE, encoded3);
                                    }
                                    catch (Exception e) {
                                        topic_long_desc.setAttribute(NAME, TOPIC_LONG_DESC);
                                        topic_long_desc.setAttribute(ENCODE, BASE64);
                                        topic_long_desc.setAttribute(VALUE, "");
                                    }
                                    topic_properties.appendChild(topic_long_desc);
                                    topic_data.appendChild(topic_properties);
                                    Set topicMembershipItems = topic.getMembershipItemSet();
                                    if (topicMembershipItems != null && topicMembershipItems.size() > 0) {
                                        Element topic_permissions = doc.createElement(PERMISSIONS);
                                        for (DBMembershipItem membershipItem : topicMembershipItems) {
                                            List customPerms;
                                            Element permission = doc.createElement(PERMISSION);
                                            permission.setAttribute(PERMISSION_TYPE, membershipItem.getType().toString());
                                            permission.setAttribute(PERMISSION_NAME, membershipItem.getName());
                                            permission.setAttribute(PERMISSION_LEVEL_NAME, membershipItem.getPermissionLevelName());
                                            topic_permissions.appendChild(permission);
                                            if (!"Custom".equals(membershipItem.getPermissionLevelName()) || (customPerms = this.permissionManager.getCustomPermissions()) == null || customPerms.size() <= 0) continue;
                                            Element customPermissions = doc.createElement(CUSTOM_PERMISSIONS);
                                            for (int i = 0; i < customPerms.size(); ++i) {
                                                String name = (String)customPerms.get(i);
                                                String hasPermission = this.permissionManager.getCustomPermissionByName(name, membershipItem.getPermissionLevel()).toString();
                                                customPermissions.setAttribute(name, hasPermission);
                                            }
                                            permission.appendChild(customPermissions);
                                        }
                                        topic_data.appendChild(topic_permissions);
                                    }
                                    List topicAtts = this.forumManager.getTopicByIdWithAttachments(topic.getId()).getAttachments();
                                    for (int j = 0; j < topicAtts.size(); ++j) {
                                        Element topic_attachment = doc.createElement(ATTACHMENT);
                                        String attachId = ((Attachment)topicAtts.get(j)).getAttachmentId();
                                        topic_attachment.setAttribute(ATTACH_ID, attachId);
                                        topic_data.appendChild(topic_attachment);
                                    }
                                    df_data.appendChild(topic_data);
                                }
                            }
                            dfElement.appendChild(df_data);
                        }
                    }
                    results.append("archiving " + this.getLabel() + ": (" + forumCount + ") messageforum DF items archived successfully.\n");
                    ((Element)stack.peek()).appendChild(dfElement);
                    stack.push(dfElement);
                } else {
                    results.append("archiving " + this.getLabel() + ": empty messageforum DF archived.\n");
                }
            }
            stack.pop();
        }
        catch (DOMException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return results.toString();
    }

    public Entity getEntity(Reference ref) {
        return null;
    }

    public Collection getEntityAuthzGroups(Reference ref, String userId) {
        return null;
    }

    public String getEntityDescription(Reference ref) {
        return null;
    }

    public ResourceProperties getEntityResourceProperties(Reference ref) {
        return null;
    }

    public String getEntityUrl(Reference ref) {
        return null;
    }

    public HttpAccess getHttpAccess() {
        return null;
    }

    public String getLabel() {
        return MESSAGEFORUM;
    }

    public String[] myToolIds() {
        String[] toolIds = new String[]{"sakai.messagecenter", "sakai.forums"};
        return toolIds;
    }

    public void transferCopyEntities(String fromContext, String toContext, List resourceIds) {
        this.transferCopyEntitiesRefMigrator(fromContext, toContext, resourceIds);
    }

    public Map<String, String> transferCopyEntitiesRefMigrator(String fromContext, String toContext, List resourceIds) {
        HashMap<String, String> transversalMap = new HashMap<String, String>();
        try {
            LOG.debug((Object)"transfer copy mc items by transferCopyEntities");
            List fromDfList = this.dfManager.getDiscussionForumsWithTopicsMembershipNoAttachments(fromContext);
            List existingForums = this.dfManager.getDiscussionForumsByContextId(toContext);
            int numExistingForums = existingForums.size();
            if (fromDfList != null && !fromDfList.isEmpty()) {
                for (int currForum = 0; currForum < fromDfList.size(); ++currForum) {
                    String fromAssignmentTitle;
                    List fromAttach;
                    DiscussionForum fromForum = (DiscussionForum)fromDfList.get(currForum);
                    Long fromForumId = fromForum.getId();
                    DiscussionForum newForum = this.forumManager.createDiscussionForum();
                    if (newForum == null) continue;
                    newForum.setTitle(fromForum.getTitle());
                    if (fromForum.getShortDescription() != null && fromForum.getShortDescription().length() > 0) {
                        newForum.setShortDescription(fromForum.getShortDescription());
                    }
                    if (fromForum.getExtendedDescription() != null && fromForum.getExtendedDescription().length() > 0) {
                        newForum.setExtendedDescription(fromForum.getExtendedDescription());
                    }
                    newForum.setDraft(fromForum.getDraft());
                    newForum.setLocked(fromForum.getLocked());
                    newForum.setModerated(fromForum.getModerated());
                    newForum.setPostFirst(fromForum.getPostFirst());
                    newForum.setAutoMarkThreadsRead(fromForum.getAutoMarkThreadsRead());
                    Integer fromSortIndex = fromForum.getSortIndex();
                    if (fromSortIndex != null && fromSortIndex > 0) {
                        newForum.setSortIndex(Integer.valueOf(fromForum.getSortIndex() + numExistingForums));
                    }
                    Set membershipItemSet = fromForum.getMembershipItemSet();
                    List allowedPermNames = this.getSiteRolesAndGroups(toContext);
                    if (membershipItemSet != null && !membershipItemSet.isEmpty() && allowedPermNames != null && !allowedPermNames.isEmpty()) {
                        for (DBMembershipItem oldItem : membershipItemSet) {
                            DBMembershipItem newItem;
                            if (!allowedPermNames.contains(oldItem.getName()) || (newItem = this.getMembershipItemCopy(oldItem)) == null) continue;
                            this.permissionManager.saveDBMembershipItem(newItem);
                            newForum.addMembershipItem(newItem);
                        }
                    }
                    if ((fromAttach = this.forumManager.getForumById(true, fromForumId).getAttachments()) != null && !fromAttach.isEmpty()) {
                        for (int currAttach = 0; currAttach < fromAttach.size(); ++currAttach) {
                            Attachment thisAttach = (Attachment)fromAttach.get(currAttach);
                            Attachment newAttachment = this.copyAttachment(thisAttach.getAttachmentId(), toContext);
                            if (newAttachment == null) continue;
                            newForum.addAttachment(newAttachment);
                        }
                    }
                    GradebookService gradebookService = (GradebookService)ComponentManager.get((String)"org.sakaiproject.service.gradebook.GradebookService");
                    String gradebookUid = null;
                    gradebookUid = ToolManager.getCurrentPlacement() != null ? ToolManager.getCurrentPlacement().getContext() : fromContext;
                    if (gradebookService.isGradebookDefined(gradebookUid) && gradebookService.isAssignmentDefined(gradebookUid, fromAssignmentTitle = fromForum.getDefaultAssignName())) {
                        newForum.setDefaultAssignName(fromAssignmentTitle);
                    }
                    Area area = this.areaManager.getDiscussionArea(toContext, false);
                    newForum.setArea(area);
                    if ("false".equalsIgnoreCase(ServerConfigurationService.getString((String)"import.importAsDraft"))) {
                        this.forumManager.saveDiscussionForum(newForum, newForum.getDraft().booleanValue());
                    } else {
                        newForum.setDraft(Boolean.valueOf("true"));
                        this.forumManager.saveDiscussionForum(newForum, true);
                    }
                    transversalMap.put("forum/" + fromForumId, "forum/" + newForum.getId());
                    List topicList = this.dfManager.getTopicsByIdWithMessagesMembershipAndAttachments(fromForumId);
                    if (topicList == null || topicList.isEmpty()) continue;
                    for (int currTopic = 0; currTopic < topicList.size(); ++currTopic) {
                        String fromAssignmentTitle2;
                        List fromTopicAttach;
                        DiscussionTopic fromTopic = (DiscussionTopic)topicList.get(currTopic);
                        Long fromTopicId = fromTopic.getId();
                        DiscussionTopic newTopic = this.forumManager.createDiscussionForumTopic(newForum);
                        newTopic.setTitle(fromTopic.getTitle());
                        if (fromTopic.getShortDescription() != null && fromTopic.getShortDescription().length() > 0) {
                            newTopic.setShortDescription(fromTopic.getShortDescription());
                        }
                        if (fromTopic.getExtendedDescription() != null && fromTopic.getExtendedDescription().length() > 0) {
                            newTopic.setExtendedDescription(fromTopic.getExtendedDescription());
                        }
                        newTopic.setLocked(fromTopic.getLocked());
                        newTopic.setDraft(fromTopic.getDraft());
                        newTopic.setModerated(fromTopic.getModerated());
                        newTopic.setPostFirst(fromTopic.getPostFirst());
                        newTopic.setSortIndex(fromTopic.getSortIndex());
                        newTopic.setAutoMarkThreadsRead(fromTopic.getAutoMarkThreadsRead());
                        Set topicMembershipItemSet = fromTopic.getMembershipItemSet();
                        if (topicMembershipItemSet != null && !topicMembershipItemSet.isEmpty() && allowedPermNames != null && !allowedPermNames.isEmpty()) {
                            for (DBMembershipItem oldItem : topicMembershipItemSet) {
                                DBMembershipItem newItem;
                                if (!allowedPermNames.contains(oldItem.getName()) || (newItem = this.getMembershipItemCopy(oldItem)) == null) continue;
                                this.permissionManager.saveDBMembershipItem(newItem);
                                newTopic.addMembershipItem(newItem);
                            }
                        }
                        if ((fromTopicAttach = this.forumManager.getTopicByIdWithAttachments(fromTopicId).getAttachments()) != null && !fromTopicAttach.isEmpty()) {
                            for (int topicAttach = 0; topicAttach < fromTopicAttach.size(); ++topicAttach) {
                                Attachment thisAttach = (Attachment)fromTopicAttach.get(topicAttach);
                                Attachment newAttachment = this.copyAttachment(thisAttach.getAttachmentId(), toContext);
                                if (newAttachment == null) continue;
                                newTopic.addAttachment(newAttachment);
                            }
                        }
                        if (gradebookService.isGradebookDefined(gradebookUid) && gradebookService.isAssignmentDefined(gradebookUid, fromAssignmentTitle2 = fromTopic.getDefaultAssignName())) {
                            newTopic.setDefaultAssignName(fromAssignmentTitle2);
                        }
                        this.forumManager.saveDiscussionForumTopic(newTopic, newForum.getDraft().booleanValue());
                        transversalMap.put("forum_topic/" + fromTopicId, "forum_topic/" + newTopic.getId());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return transversalMap;
    }

    public String merge(String siteId, Element root, String archivePath, String fromSiteId, Map attachmentNames, Map userIdTrans, Set userListAllowImport) {
        List existingForums = this.dfManager.getDiscussionForumsByContextId(siteId);
        int numExistingForums = existingForums.size();
        Base64 base64Encoder = new Base64();
        StringBuilder results = new StringBuilder();
        if (siteId != null && siteId.trim().length() > 0) {
            try {
                NodeList allChildrenNodes = root.getChildNodes();
                int length = allChildrenNodes.getLength();
                for (int i = 0; i < length; ++i) {
                    Element siteElement;
                    Node siteNode = allChildrenNodes.item(i);
                    if (siteNode.getNodeType() != 1 || !(siteElement = (Element)siteNode).getTagName().equals(MESSAGEFORUM)) continue;
                    NodeList allForumNodes = siteElement.getChildNodes();
                    int lengthForum = allForumNodes.getLength();
                    for (int j = 0; j < lengthForum; ++j) {
                        String forumModerated;
                        String forumLocked;
                        Element forumElement;
                        Node child1 = allForumNodes.item(j);
                        if (child1.getNodeType() != 1 || !(forumElement = (Element)child1).getTagName().equals(DISCUSSION_FORUM)) continue;
                        DiscussionForum dfForum = this.forumManager.createDiscussionForum();
                        String forumTitle = forumElement.getAttribute(DISCUSSION_FORUM_TITLE);
                        dfForum.setTitle(forumTitle);
                        String forumDraft = forumElement.getAttribute(DRAFT);
                        if (forumDraft != null && forumDraft.length() > 0) {
                            dfForum.setDraft(Boolean.valueOf(forumDraft));
                        }
                        if ((forumLocked = forumElement.getAttribute(LOCKED)) != null && forumLocked.length() > 0) {
                            dfForum.setLocked(Boolean.valueOf(forumLocked));
                        }
                        if ((forumModerated = forumElement.getAttribute(MODERATED)) != null && forumModerated.length() > 0) {
                            dfForum.setModerated(Boolean.valueOf(forumModerated));
                        } else {
                            dfForum.setModerated(Boolean.FALSE);
                        }
                        String forumPostFirst = forumElement.getAttribute(POST_FIRST);
                        if (forumPostFirst != null && forumPostFirst.length() > 0) {
                            dfForum.setPostFirst(Boolean.valueOf(forumPostFirst));
                        } else {
                            dfForum.setPostFirst(Boolean.FALSE);
                        }
                        String forumSortIndex = forumElement.getAttribute(SORT_INDEX);
                        if (forumSortIndex != null && forumSortIndex.length() > 0) {
                            try {
                                Integer sortIndex = Integer.valueOf(forumSortIndex);
                                sortIndex = sortIndex + numExistingForums;
                                dfForum.setSortIndex(sortIndex);
                            }
                            catch (NumberFormatException nfe) {
                                // empty catch block
                            }
                        }
                        String forumDesc = forumElement.getAttribute(DISCUSSION_FORUM_DESC);
                        String trimBody = null;
                        if (forumDesc != null && forumDesc.length() > 0 && (trimBody = this.trimToNull(forumDesc)) != null && trimBody.length() > 0) {
                            byte[] decoded = base64Encoder.decode(trimBody.getBytes());
                            trimBody = new String(decoded, "UTF-8");
                        }
                        if (trimBody != null) {
                            dfForum.setExtendedDescription(trimBody);
                        }
                        String forumShortDesc = forumElement.getAttribute(DISCUSSION_FORUM_SHORT_DESC);
                        String trimSummary = null;
                        if (forumShortDesc != null && forumShortDesc.length() > 0 && (trimSummary = this.trimToNull(forumShortDesc)) != null && trimSummary.length() > 0) {
                            byte[] decoded = base64Encoder.decode(trimSummary.getBytes());
                            trimSummary = new String(decoded, "UTF-8");
                        }
                        if (trimSummary != null) {
                            dfForum.setShortDescription(trimSummary);
                        }
                        NodeList forumDetailNodes = forumElement.getChildNodes();
                        boolean hasTopic = false;
                        for (int k = 0; k < forumDetailNodes.getLength(); ++k) {
                            String topicModerated;
                            String topicLocked;
                            Node forumChild = forumDetailNodes.item(k);
                            if (forumChild.getNodeType() != 1) continue;
                            Element forumChildElement = (Element)forumChild;
                            if (forumChildElement.getTagName().equals(ATTACHMENT)) {
                                String newUrl;
                                String oldAttachId = forumChildElement.getAttribute(ATTACH_ID);
                                if (oldAttachId == null || oldAttachId.trim().length() <= 0) continue;
                                String oldUrl = oldAttachId;
                                if (oldUrl.startsWith("/content/attachment/")) {
                                    newUrl = (String)attachmentNames.get(oldUrl);
                                    if (newUrl != null) {
                                        oldAttachId = Validator.escapeQuestionMark((String)newUrl);
                                    }
                                } else if (oldUrl.startsWith("/content/group/" + fromSiteId + "/")) {
                                    newUrl = "/content/group/" + siteId + oldUrl.substring(15 + fromSiteId.length());
                                    oldAttachId = Validator.escapeQuestionMark((String)newUrl);
                                }
                                Attachment newAttachment = this.copyAttachment(oldAttachId, siteId);
                                if (newAttachment == null) continue;
                                dfForum.addAttachment(newAttachment);
                                continue;
                            }
                            if (forumChildElement.getTagName().equals(PERMISSIONS)) {
                                Set membershipItemSet = this.getMembershipItemSetFromPermissionElement(forumChildElement, siteId);
                                if (membershipItemSet == null || membershipItemSet.size() <= 0) continue;
                                for (DBMembershipItem oldItem : membershipItemSet) {
                                    DBMembershipItem newItem = this.getMembershipItemCopy(oldItem);
                                    if (newItem == null) continue;
                                    this.permissionManager.saveDBMembershipItem(newItem);
                                    dfForum.addMembershipItem(newItem);
                                }
                                continue;
                            }
                            if (!forumChildElement.getTagName().equals(DISCUSSION_TOPIC)) continue;
                            DiscussionTopic dfTopic = this.forumManager.createDiscussionForumTopic(dfForum);
                            String topicTitle = forumChildElement.getAttribute(TOPIC_TITLE);
                            dfTopic.setTitle(topicTitle);
                            String topicDraft = forumChildElement.getAttribute(DRAFT);
                            if (topicDraft != null && topicDraft.length() > 0) {
                                dfTopic.setDraft(Boolean.valueOf(topicDraft));
                            }
                            if ((topicLocked = forumChildElement.getAttribute(LOCKED)) != null && topicLocked.length() > 0) {
                                dfTopic.setLocked(Boolean.valueOf(topicLocked));
                            }
                            if ((topicModerated = forumChildElement.getAttribute(MODERATED)) != null && topicModerated.length() > 0) {
                                dfTopic.setModerated(Boolean.valueOf(topicModerated));
                            } else {
                                dfTopic.setModerated(Boolean.FALSE);
                            }
                            String topicPostFirst = forumChildElement.getAttribute(POST_FIRST);
                            if (topicPostFirst != null && topicPostFirst.length() > 0) {
                                dfTopic.setPostFirst(Boolean.valueOf(topicPostFirst));
                            } else {
                                dfTopic.setPostFirst(Boolean.FALSE);
                            }
                            String sortIndex = forumChildElement.getAttribute(SORT_INDEX);
                            if (sortIndex != null) {
                                try {
                                    Integer sortIndexAsInt = Integer.valueOf(sortIndex);
                                    dfTopic.setSortIndex(sortIndexAsInt);
                                }
                                catch (NumberFormatException nfe) {
                                    dfTopic.setSortIndex(null);
                                }
                            }
                            NodeList topicPropertiesNodes = forumChildElement.getChildNodes();
                            for (int m = 0; m < topicPropertiesNodes.getLength(); ++m) {
                                Set membershipItemSet;
                                Node propertiesNode = topicPropertiesNodes.item(m);
                                if (propertiesNode.getNodeType() != 1) continue;
                                Element propertiesElement = (Element)propertiesNode;
                                if (propertiesElement.getTagName().equals(PROPERTIES)) {
                                    NodeList propertyList = propertiesElement.getChildNodes();
                                    for (int n = 0; n < propertyList.getLength(); ++n) {
                                        byte[] decoded;
                                        String trimDesc;
                                        String topicDesc;
                                        Element propertyElement;
                                        Node propertyNode = propertyList.item(n);
                                        if (propertyNode.getNodeType() != 1 || !(propertyElement = (Element)propertyNode).getTagName().equals(PROPERTY)) continue;
                                        if (TOPIC_SHORT_DESC.equals(propertyElement.getAttribute(NAME))) {
                                            if (BASE64.equals(propertyElement.getAttribute(ENCODE))) {
                                                topicDesc = propertyElement.getAttribute(VALUE);
                                                trimDesc = null;
                                                if (topicDesc != null && topicDesc.length() > 0 && (trimDesc = this.trimToNull(topicDesc)) != null && trimDesc.length() > 0) {
                                                    decoded = base64Encoder.decode(trimDesc.getBytes());
                                                    trimDesc = new String(decoded, "UTF-8");
                                                }
                                                if (trimDesc != null) {
                                                    dfTopic.setShortDescription(trimDesc);
                                                }
                                            } else {
                                                dfTopic.setShortDescription(propertyElement.getAttribute(VALUE));
                                            }
                                        }
                                        if (!TOPIC_LONG_DESC.equals(propertyElement.getAttribute(NAME))) continue;
                                        if (BASE64.equals(propertyElement.getAttribute(ENCODE))) {
                                            topicDesc = propertyElement.getAttribute(VALUE);
                                            trimDesc = null;
                                            if (topicDesc != null && topicDesc.length() > 0 && (trimDesc = this.trimToNull(topicDesc)) != null && trimDesc.length() > 0) {
                                                decoded = base64Encoder.decode(trimDesc.getBytes());
                                                trimDesc = new String(decoded, "UTF-8");
                                            }
                                            if (trimDesc == null) continue;
                                            dfTopic.setExtendedDescription(trimDesc);
                                            continue;
                                        }
                                        dfTopic.setExtendedDescription(propertyElement.getAttribute(VALUE));
                                    }
                                    continue;
                                }
                                if (propertiesElement.getTagName().equals(ATTACHMENT)) {
                                    String newUrl;
                                    String oldAttachId = propertiesElement.getAttribute(ATTACH_ID);
                                    if (oldAttachId == null || oldAttachId.trim().length() <= 0) continue;
                                    String oldUrl = oldAttachId;
                                    if (oldUrl.startsWith("/content/attachment/")) {
                                        newUrl = (String)attachmentNames.get(oldUrl);
                                        if (newUrl != null) {
                                            oldAttachId = Validator.escapeQuestionMark((String)newUrl);
                                        }
                                    } else if (oldUrl.startsWith("/content/group/" + fromSiteId + "/")) {
                                        newUrl = "/content/group/" + siteId + oldUrl.substring(15 + fromSiteId.length());
                                        oldAttachId = Validator.escapeQuestionMark((String)newUrl);
                                    }
                                    Attachment newAttachment = this.copyAttachment(oldAttachId, siteId);
                                    if (newAttachment == null) continue;
                                    dfTopic.addAttachment(newAttachment);
                                    continue;
                                }
                                if (!propertiesElement.getTagName().equals(PERMISSIONS) || (membershipItemSet = this.getMembershipItemSetFromPermissionElement(propertiesElement, siteId)) == null || membershipItemSet.size() <= 0) continue;
                                for (DBMembershipItem oldItem : membershipItemSet) {
                                    DBMembershipItem newItem = this.getMembershipItemCopy(oldItem);
                                    if (newItem == null) continue;
                                    this.permissionManager.saveDBMembershipItem(newItem);
                                    dfTopic.addMembershipItem(newItem);
                                }
                            }
                            if (!hasTopic) {
                                Area area = this.areaManager.getDiscussionArea(siteId);
                                dfForum.setArea(area);
                                if ("false".equalsIgnoreCase(ServerConfigurationService.getString((String)"import.importAsDraft"))) {
                                    this.forumManager.saveDiscussionForum(dfForum, dfForum.getDraft().booleanValue());
                                } else {
                                    dfForum.setDraft(Boolean.valueOf("true"));
                                    this.forumManager.saveDiscussionForum(dfForum, true);
                                }
                            }
                            hasTopic = true;
                            this.forumManager.saveDiscussionForumTopic(dfTopic, dfForum.getDraft().booleanValue());
                        }
                        if (hasTopic) continue;
                        Area area = this.areaManager.getDiscussionArea(siteId);
                        dfForum.setArea(area);
                        if ("false".equalsIgnoreCase(ServerConfigurationService.getString((String)"import.importAsDraft"))) {
                            this.forumManager.saveDiscussionForum(dfForum, dfForum.getDraft().booleanValue());
                            continue;
                        }
                        dfForum.setDraft(Boolean.valueOf("true"));
                        this.forumManager.saveDiscussionForum(dfForum, true);
                    }
                }
            }
            catch (Exception e) {
                results.append("merging " + this.getLabel() + " failed.\n");
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean parseEntityReference(String reference, Reference ref) {
        if (reference.startsWith("/messageforum")) {
            String[] parts = this.split(reference, "/");
            String subType = null;
            String context = null;
            String id = null;
            String container = null;
            if (parts.length > 2) {
                context = parts[2];
                if (parts.length > 3) {
                    id = parts[3];
                }
            }
            ref.set(SERVICE_NAME, subType, id, container, context);
            return true;
        }
        return false;
    }

    public boolean willArchiveMerge() {
        return true;
    }

    protected String[] split(String source, String splitter) {
        Vector<String> rv = new Vector<String>();
        int last = 0;
        int next = 0;
        do {
            if ((next = source.indexOf(splitter, last)) == -1) continue;
            rv.add(source.substring(last, next));
            last = next + splitter.length();
        } while (next != -1);
        if (last < source.length()) {
            rv.add(source.substring(last, source.length()));
        }
        return rv.toArray(new String[rv.size()]);
    }

    public MessageForumsForumManager getForumManager() {
        return this.forumManager;
    }

    public void setForumManager(MessageForumsForumManager forumManager) {
        this.forumManager = forumManager;
    }

    public AreaManager getAreaManager() {
        return this.areaManager;
    }

    public void setAreaManager(AreaManager areaManager) {
        this.areaManager = areaManager;
    }

    public String trimToNull(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        return value;
    }

    private Attachment copyAttachment(String attachmentId, String toContext) {
        try {
            ContentResource oldAttachment = this.contentHostingService.getResource(attachmentId);
            ContentResource attachment = this.contentHostingService.addAttachmentResource(oldAttachment.getProperties().getProperty("DAV:displayname"), toContext, ToolManager.getTool((String)"sakai.forums").getTitle(), oldAttachment.getContentType(), oldAttachment.getContent(), oldAttachment.getProperties());
            Attachment thisDFAttach = this.dfManager.createDFAttachment(attachment.getId(), attachment.getProperties().getProperty("DAV:displayname"));
            return thisDFAttach;
        }
        catch (IdUnusedException iue) {
            LOG.error((Object)("Error with attachment id: " + attachmentId));
            LOG.error((Object)iue.getMessage(), (Throwable)iue);
        }
        catch (Exception e) {
            LOG.error((Object)("Error with attachment id: " + attachmentId));
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private Set getMembershipItemSetFromPermissionElement(Element permissionsElement, String siteId) {
        HashSet<DBMembershipItem> membershipItemSet = new HashSet<DBMembershipItem>();
        List allowedPermNames = this.getSiteRolesAndGroups(siteId);
        List allowedPermLevels = this.permissionManager.getOrderedPermissionLevelNames();
        if (allowedPermLevels != null && !allowedPermLevels.contains("Custom")) {
            allowedPermLevels.add("Custom");
        }
        NodeList permissionsNodes = permissionsElement.getChildNodes();
        for (int m = 0; m < permissionsNodes.getLength(); ++m) {
            Element permissionElement;
            Node permissionsNode = permissionsNodes.item(m);
            if (permissionsNode.getNodeType() != 1 || !(permissionElement = (Element)permissionsNode).getTagName().equals(PERMISSION)) continue;
            try {
                if (permissionElement.getAttribute(PERMISSION_NAME) == null || permissionElement.getAttribute(PERMISSION_LEVEL_NAME) == null || permissionElement.getAttribute(PERMISSION_TYPE) == null) continue;
                String permissionName = permissionElement.getAttribute(PERMISSION_NAME);
                String permissionLevelName = permissionElement.getAttribute(PERMISSION_LEVEL_NAME);
                if (allowedPermNames == null || allowedPermLevels == null || !allowedPermNames.contains(permissionName) || !allowedPermLevels.contains(permissionLevelName)) continue;
                Integer permissionType = Integer.valueOf(permissionElement.getAttribute(PERMISSION_TYPE));
                DBMembershipItem membershipItem = this.permissionManager.createDBMembershipItem(permissionName, permissionLevelName, permissionType);
                if ("Custom".equals(membershipItem.getPermissionLevelName())) {
                    NodeList customPermNodes = permissionElement.getChildNodes();
                    for (int l = 0; l < customPermNodes.getLength(); ++l) {
                        Element customPermElement;
                        Node customPermNode = customPermNodes.item(l);
                        if (customPermNode.getNodeType() != 1 || !(customPermElement = (Element)customPermNode).getTagName().equals(CUSTOM_PERMISSIONS)) continue;
                        PermissionsMask mask = new PermissionsMask();
                        List customPermList = this.permissionManager.getCustomPermissions();
                        for (int c = 0; c < customPermList.size(); ++c) {
                            String customPermName = (String)customPermList.get(c);
                            Boolean hasPermission = Boolean.valueOf(customPermElement.getAttribute(customPermName));
                            mask.put((Object)customPermName, (Object)hasPermission);
                        }
                        PermissionLevel level = this.permissionManager.createPermissionLevel(membershipItem.getPermissionLevelName(), this.typeManager.getCustomLevelType(), mask);
                        membershipItem.setPermissionLevel(level);
                    }
                }
                this.permissionManager.saveDBMembershipItem(membershipItem);
                membershipItemSet.add(membershipItem);
                continue;
            }
            catch (NumberFormatException nfe) {
                LOG.error((Object)nfe);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return membershipItemSet;
    }

    private List getSiteRolesAndGroups(String contextId) {
        ArrayList<String> rolesAndGroups = new ArrayList<String>();
        try {
            AuthzGroup realm = AuthzGroupService.getAuthzGroup((String)("/site/" + contextId));
            Set roleSet = realm.getRoles();
            if (roleSet != null && roleSet.size() > 0) {
                for (Role role : roleSet) {
                    if (role == null) continue;
                    rolesAndGroups.add(role.getId());
                }
            }
            Site currentSite = SiteService.getSite((String)contextId);
            Collection groups = currentSite.getGroups();
            for (Group currentGroup : groups) {
                rolesAndGroups.add(currentGroup.getTitle());
            }
        }
        catch (GroupNotDefinedException e) {
            LOG.error((Object)"GroupNotDefinedException retrieving site's roles and groups", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception retrieving site's roles and groups", (Throwable)e);
        }
        return rolesAndGroups;
    }

    private DBMembershipItem getMembershipItemCopy(DBMembershipItem itemToCopy) {
        DBMembershipItem newItem = this.permissionManager.createDBMembershipItem(itemToCopy.getName(), itemToCopy.getPermissionLevelName(), itemToCopy.getType());
        PermissionLevel oldPermLevel = itemToCopy.getPermissionLevel();
        if (newItem.getPermissionLevelName().equals("Custom")) {
            PermissionsMask mask = new PermissionsMask();
            List customPermList = this.permissionManager.getCustomPermissions();
            for (int c = 0; c < customPermList.size(); ++c) {
                String customPermName = (String)customPermList.get(c);
                Boolean hasPermission = this.permissionManager.getCustomPermissionByName(customPermName, oldPermLevel);
                mask.put((Object)customPermName, (Object)hasPermission);
            }
            PermissionLevel level = this.permissionManager.createPermissionLevel(newItem.getPermissionLevelName(), this.typeManager.getCustomLevelType(), mask);
            newItem.setPermissionLevel(level);
        }
        return newItem;
    }

    public MessageForumsMessageManager getMessageManager() {
        return this.messageManager;
    }

    public void setMessageManager(MessageForumsMessageManager messageManager) {
        this.messageManager = messageManager;
    }

    public MessageForumsTypeManager getTypeManager() {
        return this.typeManager;
    }

    public void setTypeManager(MessageForumsTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public DiscussionForumManager getDfManager() {
        return this.dfManager;
    }

    public void setDfManager(DiscussionForumManager dfManager) {
        this.dfManager = dfManager;
    }

    public void setPermissionManager(PermissionLevelManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public PermissionLevelManager getPermissionManager() {
        return this.permissionManager;
    }

    public void transferCopyEntities(String fromContext, String toContext, List ids, boolean cleanup) {
        this.transferCopyEntitiesRefMigrator(fromContext, toContext, ids, cleanup);
    }

    public Map<String, String> transferCopyEntitiesRefMigrator(String fromContext, String toContext, List ids, boolean cleanup) {
        HashMap<String, String> transversalMap = new HashMap<String, String>();
        try {
            if (cleanup) {
                try {
                    List existingForums = this.dfManager.getDiscussionForumsByContextId(toContext);
                    if (existingForums != null && !existingForums.isEmpty()) {
                        for (int currForum = 0; currForum < existingForums.size(); ++currForum) {
                            DiscussionForum fromForum = (DiscussionForum)existingForums.get(currForum);
                            this.forumManager.deleteDiscussionForum(fromForum);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.debug((Object)("Remove Forums from Site Import failed" + e));
                }
            }
            transversalMap.putAll(this.transferCopyEntitiesRefMigrator(fromContext, toContext, ids));
        }
        catch (Exception e) {
            LOG.debug((Object)("Forums transferCopyEntities failed" + e));
        }
        return transversalMap;
    }

    public void updateEntityReferences(String toContext, Map<String, String> transversalMap) {
        if (transversalMap != null && transversalMap.size() > 0) {
            Set<Map.Entry<String, String>> entrySet = transversalMap.entrySet();
            List existingForums = this.dfManager.getDiscussionForumsByContextId(toContext);
            if (existingForums != null && !existingForums.isEmpty()) {
                for (int currForum = 0; currForum < existingForums.size(); ++currForum) {
                    List topics;
                    boolean updateForum = false;
                    DiscussionForum fromForum = (DiscussionForum)existingForums.get(currForum);
                    String fLongDesc = fromForum.getExtendedDescription();
                    if (fLongDesc != null && !(fLongDesc = this.replaceAllRefs(fLongDesc, entrySet)).equals(fromForum.getExtendedDescription())) {
                        fromForum.setExtendedDescription(fLongDesc);
                        updateForum = true;
                    }
                    if (updateForum) {
                        this.dfManager.saveForum(fromForum);
                    }
                    if ((topics = fromForum.getTopics()) == null || topics.isEmpty()) continue;
                    for (int currTopic = 0; currTopic < topics.size(); ++currTopic) {
                        boolean updateTopic = false;
                        DiscussionTopic topic = (DiscussionTopic)topics.get(currTopic);
                        String tLongDesc = topic.getExtendedDescription();
                        if (tLongDesc != null && !(tLongDesc = this.replaceAllRefs(tLongDesc, entrySet)).equals(topic.getExtendedDescription())) {
                            topic.setExtendedDescription(tLongDesc);
                            updateTopic = true;
                        }
                        if (!updateTopic) continue;
                        this.dfManager.saveTopic(topic);
                    }
                }
            }
        }
    }

    private String replaceAllRefs(String msgBody, Set<Map.Entry<String, String>> entrySet) {
        if (msgBody != null) {
            boolean updated = false;
            for (Map.Entry<String, String> entry : entrySet) {
                String fromContextRef = entry.getKey();
                if (!msgBody.contains(fromContextRef)) continue;
                msgBody = msgBody.replace(fromContextRef, entry.getValue());
                updated = true;
            }
        }
        return msgBody;
    }
}

