/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.sakaiproject.api.app.messageforums.EmailNotification;
import org.sakaiproject.api.app.messageforums.EmailNotificationManager;
import org.sakaiproject.api.app.messageforums.Topic;
import org.sakaiproject.api.app.messageforums.ui.DiscussionForumManager;
import org.sakaiproject.component.app.messageforums.TestUtil;
import org.sakaiproject.component.app.messageforums.dao.hibernate.EmailNotificationImpl;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailNotificationManagerImpl
extends HibernateDaoSupport
implements EmailNotificationManager {
    private static final Log LOG = LogFactory.getLog(EmailNotificationManagerImpl.class);
    private static final String QUERY_BY_USER_ID = "findEmailNotificationByUserId";
    private static final String QUERY_USERLIST_BY_NOTIFICATION_LEVEL = "findUserIdsByNotificationLevel";
    protected UserDirectoryService userDirectoryService;
    private EventTrackingService eventTrackingService;
    private DiscussionForumManager discussionForumManager;

    public void init() {
        LOG.info((Object)"init()");
    }

    public EventTrackingService getEventTrackingService() {
        return this.eventTrackingService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public void setDiscussionForumManager(DiscussionForumManager discussionForumManager) {
        this.discussionForumManager = discussionForumManager;
    }

    public EmailNotification getEmailNotification(final String userId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getEmailNotification(userId: " + userId + ")"));
        }
        if (userId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(EmailNotificationManagerImpl.QUERY_BY_USER_ID);
                q.setParameter("userId", (Object)userId, (Type)Hibernate.STRING);
                q.setParameter("contextId", (Object)EmailNotificationManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        EmailNotification emailNotification = (EmailNotification)this.getHibernateTemplate().execute(hcb);
        if (emailNotification == null) {
            try {
                this.userDirectoryService.getUser(userId);
            }
            catch (UserNotDefinedException e) {
                e.printStackTrace();
            }
            String notificationDefault = ServerConfigurationService.getString((String)"mc.notificationDefault", (String)"1");
            EmailNotificationImpl newEmailNotification = new EmailNotificationImpl();
            newEmailNotification.setContextId(this.getContextId());
            newEmailNotification.setUserId(userId);
            LOG.debug((Object)("notificationDefault= " + notificationDefault));
            if ("0".equals(notificationDefault)) {
                newEmailNotification.setNotificationLevel("0");
            } else if ("2".equals(notificationDefault)) {
                newEmailNotification.setNotificationLevel("2");
            } else {
                newEmailNotification.setNotificationLevel("1");
            }
            this.saveEmailNotification((EmailNotification)newEmailNotification);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(userId + "  didn't set watch options.  creating a new EmailNotification this user. his level : " + newEmailNotification.getNotificationLevel()));
            }
            return newEmailNotification;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(userId + "  already set watch options. his option is " + emailNotification.getNotificationLevel()));
        }
        return emailNotification;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    private String getContextId() {
        if (TestUtil.isRunningTests()) {
            return "test-context";
        }
        Placement placement = ToolManager.getCurrentPlacement();
        String presentSiteId = placement.getContext();
        return presentSiteId;
    }

    public List<String> getUsersToBeNotifiedByLevel(String notificationlevel) {
        String contextid = this.getContextId();
        int intlevel = Integer.parseInt(notificationlevel);
        List<String> allusers = this.getSiteUsersByNotificationLevel(contextid, intlevel);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("total count of users to be notified = " + allusers.size()));
        }
        return allusers;
    }

    public List<String> filterUsers(List<String> allusers, Topic topic) {
        ArrayList<String> ret = new ArrayList<String>();
        Set readUsers = this.discussionForumManager.getUsersAllowedForTopic(topic.getId(), true, false);
        for (int i = 0; i < allusers.size(); ++i) {
            String userId = allusers.get(i);
            if (readUsers.contains(userId)) {
                LOG.debug((Object)("user " + userId + " has read in topic: " + topic.getId()));
                ret.add(userId);
                continue;
            }
            LOG.debug((Object)("Removing user: " + userId + "as they don't have read rights on topic: " + topic.getId()));
        }
        return ret;
    }

    private List<String> getSiteUsersByNotificationLevel(final String contextid, final int notificationlevel) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getEmailNotification(userid: " + notificationlevel + ")"));
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(EmailNotificationManagerImpl.QUERY_USERLIST_BY_NOTIFICATION_LEVEL);
                q.setParameter("contextId", (Object)contextid, (Type)Hibernate.STRING);
                q.setParameter("level", (Object)notificationlevel, (Type)Hibernate.INTEGER);
                return q.list();
            }
        };
        List siteusers = (List)this.getHibernateTemplate().execute(hcb);
        return siteusers;
    }

    public List<String> getUserEmailsToBeNotifiedByLevel(List<String> userlist) {
        ArrayList<String> emaillist = new ArrayList<String>();
        List usersList = this.userDirectoryService.getUsers(userlist);
        for (int i = 0; i < usersList.size(); ++i) {
            User user = (User)usersList.get(i);
            String useremail = user.getEmail();
            if (useremail == null || "".equalsIgnoreCase(useremail)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Username = " + user.getDisplayId() + " , useremail : " + useremail));
            }
            emaillist.add(useremail);
        }
        return emaillist;
    }

    public void saveEmailNotification(EmailNotification emailoption) {
        this.getHibernateTemplate().saveOrUpdate((Object)emailoption);
        LOG.debug((Object)("saveEmailNotification executed for contextid= " + emailoption.getContextId() + " userid= " + emailoption.getUserId()));
    }
}

