/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums;

import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.messageforums.Area;
import org.sakaiproject.api.app.messageforums.AreaManager;
import org.sakaiproject.api.app.messageforums.DiscussionForum;
import org.sakaiproject.api.app.messageforums.DiscussionTopic;
import org.sakaiproject.api.app.messageforums.ForumScheduleNotification;
import org.sakaiproject.api.app.messageforums.MessageForumsTypeManager;
import org.sakaiproject.api.app.messageforums.cover.SynopticMsgcntrManagerCover;
import org.sakaiproject.api.app.messageforums.ui.DiscussionForumManager;
import org.sakaiproject.api.app.scheduler.DelayedInvocation;
import org.sakaiproject.api.app.scheduler.ScheduledInvocationManager;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.api.TimeService;
import org.springframework.orm.hibernate3.HibernateOptimisticLockingFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumScheduleNotificationImpl
implements ForumScheduleNotification {
    private static final Log LOG = LogFactory.getLog(ForumScheduleNotificationImpl.class);
    private static final String AREA_PREFIX = "area-";
    private static final String FORUM_PREFIX = "forum-";
    private static final String TOPIC_PREFIX = "topic-";
    private MessageForumsTypeManager typeManager;
    private AreaManager areaManager;
    private DiscussionForumManager forumManager;
    private TimeService timeService;
    private ScheduledInvocationManager scheduledInvocationManager;

    public void setTypeManager(MessageForumsTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public void setAreaManager(AreaManager areaManager) {
        this.areaManager = areaManager;
    }

    public void setForumManager(DiscussionForumManager forumManager) {
        this.forumManager = forumManager;
    }

    public void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }

    public void setScheduledInvocationManager(ScheduledInvocationManager scheduledInvocationManager) {
        this.scheduledInvocationManager = scheduledInvocationManager;
    }

    public void init() {
        LOG.info((Object)"init()");
    }

    public void scheduleAvailability(Area area) {
        this.scheduleAvailability(AREA_PREFIX + area.getContextId(), area.getAvailabilityRestricted(), area.getOpenDate(), area.getCloseDate());
    }

    public void scheduleAvailability(DiscussionForum forum) {
        this.scheduleAvailability(FORUM_PREFIX + forum.getId().toString(), forum.getAvailabilityRestricted(), forum.getOpenDate(), forum.getCloseDate());
    }

    public void scheduleAvailability(DiscussionTopic topic) {
        this.scheduleAvailability(TOPIC_PREFIX + topic.getId().toString(), topic.getAvailabilityRestricted(), topic.getOpenDate(), topic.getCloseDate());
    }

    private void scheduleAvailability(String id, boolean availabilityRestricted, Date openDate, Date closeDate) {
        DelayedInvocation[] fdi = this.scheduledInvocationManager.findDelayedInvocations("org.sakaiproject.api.app.messageforums.ForumScheduleNotification", id);
        if (fdi != null && fdi.length > 0) {
            for (DelayedInvocation d : fdi) {
                this.scheduledInvocationManager.deleteDelayedInvocation(d.uuid);
            }
        }
        if (availabilityRestricted) {
            Time openTime = null;
            Time closeTime = null;
            if (openDate != null) {
                openTime = this.timeService.newTime(openDate.getTime());
            }
            if (closeDate != null) {
                closeTime = this.timeService.newTime(closeDate.getTime());
            }
            if (openTime != null && openTime.after(this.timeService.newTime())) {
                this.scheduledInvocationManager.createDelayedInvocation(openTime, "org.sakaiproject.api.app.messageforums.ForumScheduleNotification", id);
            }
            if (closeTime != null && closeTime.after(this.timeService.newTime())) {
                this.scheduledInvocationManager.createDelayedInvocation(closeTime, "org.sakaiproject.api.app.messageforums.ForumScheduleNotification", id);
            }
        }
    }

    public void execute(String opaqueContext) {
        LOG.info((Object)("ForumScheduleNotificationImpl.execute(): " + opaqueContext));
        if (opaqueContext.startsWith(AREA_PREFIX)) {
            String siteId = opaqueContext.substring(AREA_PREFIX.length());
            Area area = this.areaManager.getAreaByContextIdAndTypeId(siteId, this.typeManager.getDiscussionForumType());
            boolean makeAvailable = this.makeAvailableHelper(area.getAvailabilityRestricted(), area.getOpenDate(), area.getCloseDate());
            boolean madeChange = false;
            if (area.getAvailability().booleanValue()) {
                if (!makeAvailable) {
                    area.setAvailability(Boolean.valueOf(makeAvailable));
                    madeChange = true;
                }
            } else if (makeAvailable) {
                area.setAvailability(Boolean.valueOf(makeAvailable));
                madeChange = true;
            }
            if (madeChange) {
                this.areaManager.saveArea(area);
                SynopticMsgcntrManagerCover.resetAllUsersSynopticInfoInSite((String)siteId);
            }
        } else if (opaqueContext.startsWith(FORUM_PREFIX)) {
            Long forumId = Long.parseLong(opaqueContext.substring(FORUM_PREFIX.length()));
            DiscussionForum forum = this.forumManager.getForumById(forumId);
            boolean makeAvailable = this.makeAvailableHelper(forum.getAvailabilityRestricted(), forum.getOpenDate(), forum.getCloseDate());
            boolean madeChange = false;
            if (forum.getAvailability().booleanValue()) {
                if (!makeAvailable) {
                    forum.setAvailability(Boolean.valueOf(makeAvailable));
                    madeChange = true;
                }
            } else if (makeAvailable) {
                forum.setAvailability(Boolean.valueOf(makeAvailable));
                madeChange = true;
            }
            if (madeChange) {
                String siteId = this.forumManager.getContextForForumById(forumId);
                HashMap beforeChangeHM = SynopticMsgcntrManagerCover.getUserToNewMessagesForForumMap((String)siteId, (Long)forum.getId(), null);
                this.forumManager.saveForum(forum, forum.getDraft().booleanValue(), siteId, false, "-forumScheduler-");
                this.updateSynopticMessagesForForumComparingOldMessagesCount(siteId, forum.getId(), null, beforeChangeHM, 20);
            }
        } else if (opaqueContext.startsWith(TOPIC_PREFIX)) {
            Long topicId = Long.parseLong(opaqueContext.substring(TOPIC_PREFIX.length()));
            DiscussionTopic topic = this.forumManager.getTopicById(topicId);
            boolean makeAvailable = this.makeAvailableHelper(topic.getAvailabilityRestricted(), topic.getOpenDate(), topic.getCloseDate());
            boolean madeChange = false;
            if (topic.getAvailability().booleanValue()) {
                if (!makeAvailable) {
                    topic.setAvailability(Boolean.valueOf(makeAvailable));
                    madeChange = true;
                }
            } else if (makeAvailable) {
                topic.setAvailability(Boolean.valueOf(makeAvailable));
                madeChange = true;
            }
            if (madeChange) {
                String siteId = this.forumManager.getContextForTopicById(topicId);
                HashMap beforeChangeHM = SynopticMsgcntrManagerCover.getUserToNewMessagesForForumMap((String)siteId, (Long)topic.getBaseForum().getId(), (Long)topic.getId());
                this.forumManager.saveTopic(topic, topic.getDraft().booleanValue(), false, "-forumScheduler-");
                this.updateSynopticMessagesForForumComparingOldMessagesCount(siteId, topic.getBaseForum().getId(), topic.getId(), beforeChangeHM, 20);
            }
        }
    }

    public boolean makeAvailableHelper(boolean availabilityRestricted, Date openDate, Date closeDate) {
        boolean makeAvailable = true;
        if (availabilityRestricted) {
            makeAvailable = false;
            boolean afterOpen = false;
            boolean beforeClose = false;
            Time openTime = null;
            Time closeTime = null;
            if (openDate != null) {
                openTime = this.timeService.newTime(openDate.getTime());
            }
            if (closeDate != null) {
                closeTime = this.timeService.newTime(closeDate.getTime());
            }
            if (closeDate == null && openDate == null) {
                makeAvailable = true;
            }
            if (openTime != null && openTime.before(this.timeService.newTime())) {
                afterOpen = true;
            } else if (openTime == null) {
                afterOpen = true;
            }
            if (closeTime != null && closeTime.after(this.timeService.newTime())) {
                beforeClose = true;
            } else if (closeTime == null) {
                beforeClose = true;
            }
            if (afterOpen && beforeClose) {
                makeAvailable = true;
            }
        }
        return makeAvailable;
    }

    public void updateSynopticMessagesForForumComparingOldMessagesCount(String siteId, Long forumId, Long topicId, HashMap<String, Integer> beforeChangeHM, int numOfAttempts) {
        try {
            SynopticMsgcntrManagerCover.updateSynopticMessagesForForumComparingOldMessagesCount((String)siteId, (Long)forumId, (Long)topicId, beforeChangeHM);
        }
        catch (HibernateOptimisticLockingFailureException holfe) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (--numOfAttempts <= 0) {
                System.out.println("ForumScheduleNotificationImpl: HibernateOptimisticLockingFailureException no more retries left");
                holfe.printStackTrace();
            }
            System.out.println("ForumScheduleNotificationImpl: HibernateOptimisticLockingFailureException: attempts left: " + numOfAttempts);
            this.updateSynopticMessagesForForumComparingOldMessagesCount(siteId, forumId, topicId, beforeChangeHM, numOfAttempts);
        }
    }
}

