/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.messageforums.MembershipManager;
import org.sakaiproject.api.app.messageforums.ui.PrivateMessageManager;
import org.sakaiproject.api.privacy.PrivacyManager;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.app.messageforums.MembershipItem;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.util.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipManagerImpl
implements MembershipManager {
    private static final Log LOG = LogFactory.getLog(MembershipManagerImpl.class);
    private SiteService siteService;
    private UserDirectoryService userDirectoryService;
    private AuthzGroupService authzGroupService;
    private ToolManager toolManager;
    private SecurityService securityService;
    private PrivacyManager privacyManager;
    private PrivateMessageManager prtMsgManager;
    private static final String MESSAGECENTER_BUNDLE = "org.sakaiproject.api.app.messagecenter.bundle.Messages";
    private ResourceLoader rl = new ResourceLoader("org.sakaiproject.api.app.messagecenter.bundle.Messages");

    public void init() {
        LOG.info((Object)"init()");
    }

    public void setPrivacyManager(PrivacyManager privacyManager) {
        this.privacyManager = privacyManager;
    }

    private Map setPrivacyStatus(List allCourseUsers, Map courseUserMap) {
        ArrayList<String> userIds = new ArrayList<String>();
        HashMap<String, MembershipItem> results = new HashMap<String, MembershipItem>();
        Collection userCollection = courseUserMap.values();
        for (MembershipItem memberItem : allCourseUsers) {
            if (memberItem.getUser() == null) continue;
            userIds.add(memberItem.getUser().getId());
        }
        Set memberSet = null;
        memberSet = this.privacyManager.findViewable("/site/" + this.toolManager.getCurrentPlacement().getContext(), new HashSet(userIds));
        for (MembershipItem memberItem : userCollection) {
            if (memberItem.getUser() != null) {
                memberItem.setViewable(memberSet.contains(memberItem.getUser().getId()));
            } else {
                memberItem.setViewable(true);
            }
            results.put(memberItem.getId(), memberItem);
        }
        return results;
    }

    public Map getFilteredCourseMembers(boolean filterFerpa, List<String> hiddenGroups) {
        List allCourseUsers = this.getAllCourseUsers();
        HashSet<Role> membershipRoleSet = new HashSet<Role>();
        if (this.getPrtMsgManager().isAllowToFieldRoles()) {
            for (MembershipItem item : allCourseUsers) {
                if (item.getRole() == null) continue;
                membershipRoleSet.add(item.getRole());
            }
        }
        Map memberMap = this.getAllCourseMembers(filterFerpa, true, true, hiddenGroups);
        Set<Object> viewableUsersForTA = new HashSet();
        if (this.prtMsgManager.isSectionTA()) {
            viewableUsersForTA = this.getFellowSectionMembers();
        }
        Iterator i = memberMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            MembershipItem item = (MembershipItem)entry.getValue();
            if (MembershipItem.TYPE_ROLE.equals(item.getType())) {
                if (membershipRoleSet.contains(item.getRole())) continue;
                i.remove();
                continue;
            }
            if (MembershipItem.TYPE_GROUP.equals(item.getType())) {
                if (item.getGroup().getMembers().size() != 0) continue;
                i.remove();
                continue;
            }
            if (item.isViewable() || this.prtMsgManager.isInstructor() || this.prtMsgManager.isSectionTA() && viewableUsersForTA.contains(item.getUser().getId())) continue;
            i.remove();
        }
        return memberMap;
    }

    private Set<String> getFellowSectionMembers() {
        HashSet<String> fellowMembers = new HashSet<String>();
        try {
            Collection groups = this.siteService.getSite(this.toolManager.getCurrentPlacement().getContext()).getGroupsWithMember(this.userDirectoryService.getCurrentUser().getId());
            if (groups != null) {
                for (Group group : groups) {
                    Set groupMembers = group.getMembers();
                    if (groupMembers == null) continue;
                    for (Member groupMember : groupMembers) {
                        fellowMembers.add(groupMember.getUserId());
                    }
                }
            }
        }
        catch (IdUnusedException e) {
            LOG.warn((Object)"Unable to retrieve site to determine current user's fellow section members.");
        }
        return fellowMembers;
    }

    public Map getAllCourseMembers(boolean filterFerpa, boolean includeRoles, boolean includeAllParticipantsMember, List<String> hiddenGroups) {
        HashMap<String, MembershipItem> returnMap = new HashMap<String, MembershipItem>();
        String realmId = this.getContextSiteId();
        Site currentSite = null;
        if (this.getPrtMsgManager().isAllowToFieldAllParticipants() && includeAllParticipantsMember) {
            MembershipItem memberAll = MembershipItem.getInstance();
            memberAll.setType(MembershipItem.TYPE_ALL_PARTICIPANTS);
            memberAll.setName(this.rl.getString("all_participants_desc"));
            returnMap.put(memberAll.getId(), memberAll);
        }
        AuthzGroup realm = null;
        try {
            realm = this.authzGroupService.getAuthzGroup(realmId);
            currentSite = this.siteService.getSite(this.toolManager.getCurrentPlacement().getContext());
            if (currentSite == null) {
                throw new RuntimeException("Could not obtain Site object!");
            }
        }
        catch (IdUnusedException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            return returnMap;
        }
        catch (GroupNotDefinedException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.getPrtMsgManager().isAllowToFieldGroups()) {
            boolean viewHiddenGroups = this.getPrtMsgManager().isAllowToViewHiddenGroups();
            if (currentSite == null) {
                throw new IllegalStateException("Site currentSite == null!");
            }
            Collection groups = currentSite.getGroups();
            for (Group currentGroup : groups) {
                if (!viewHiddenGroups && this.containsId(currentGroup.getTitle(), hiddenGroups)) continue;
                MembershipItem member = MembershipItem.getInstance();
                member.setType(MembershipItem.TYPE_GROUP);
                member.setName(this.rl.getFormattedMessage("participants_group_desc", new Object[]{currentGroup.getTitle()}));
                member.setGroup(currentGroup);
                returnMap.put(member.getId(), member);
            }
        }
        if (this.getPrtMsgManager().isAllowToFieldRoles() && includeRoles && realm != null) {
            Set roles = realm.getRoles();
            for (Role role : roles) {
                MembershipItem member = MembershipItem.getInstance();
                member.setType(MembershipItem.TYPE_ROLE);
                String roleId = role.getId();
                if (roleId != null && roleId.length() > 0) {
                    roleId = roleId.substring(0, 1).toUpperCase() + roleId.substring(1);
                }
                member.setName(this.rl.getFormattedMessage("participants_role_desc", new Object[]{roleId}));
                member.setRole(role);
                returnMap.put(member.getId(), member);
            }
        }
        if (realm == null) {
            throw new IllegalStateException("AuthzGroup realm == null!");
        }
        Set users = realm.getMembers();
        if (users == null) {
            throw new RuntimeException("Could not obtain members from realm!");
        }
        for (Member member : users) {
            String userId = member.getUserId();
            Role userRole = member.getRole();
            User user = null;
            try {
                if (realm.getMember(userId) != null && realm.getMember(userId).isActive()) {
                    user = this.userDirectoryService.getUser(userId);
                }
            }
            catch (UserNotDefinedException e) {
                LOG.warn((Object)(" User " + userId + " not defined"));
            }
            if (user == null) continue;
            MembershipItem memberItem = MembershipItem.getInstance();
            memberItem.setType(MembershipItem.TYPE_USER);
            if (ServerConfigurationService.getBoolean((String)"msg.displayEid", (boolean)true)) {
                memberItem.setName(user.getSortName() + " (" + user.getDisplayId() + ")");
            } else {
                memberItem.setName(user.getSortName());
            }
            memberItem.setUser(user);
            memberItem.setRole(userRole);
            if ("admin".equals(userId)) continue;
            returnMap.put(memberItem.getId(), memberItem);
        }
        return this.setPrivacyStatus(this.getAllCourseUsers(), returnMap);
    }

    private boolean containsId(String searchId, List<String> ids) {
        if (ids != null && searchId != null) {
            for (String id : ids) {
                if (!id.equals(searchId)) continue;
                return true;
            }
        }
        return false;
    }

    public List getAllCourseUsers() {
        HashMap<String, MembershipItem> userMap = new HashMap<String, MembershipItem>();
        String realmId = this.getContextSiteId();
        AuthzGroup realm = null;
        try {
            realm = this.authzGroupService.getAuthzGroup(realmId);
        }
        catch (GroupNotDefinedException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (realm == null) {
            throw new IllegalStateException("AuthzGroup realm == null!");
        }
        Set users = realm.getMembers();
        List<String> userIds = this.getRealmIdList(users);
        List userList = this.userDirectoryService.getUsers(userIds);
        Map<String, User> userMMap = this.getuserMap(userList);
        if (users == null) {
            throw new RuntimeException("Could not obtain members from realm!");
        }
        for (Member member : users) {
            String userId = member.getUserId();
            Role userRole = member.getRole();
            User user = null;
            if (realm.getMember(userId) != null && realm.getMember(userId).isActive() && userMMap.containsKey(member.getUserId())) {
                user = this.getUserFromList(member.getUserId(), userList);
            }
            if (user == null || user == null) continue;
            MembershipItem memberItem = MembershipItem.getInstance();
            memberItem.setType(MembershipItem.TYPE_USER);
            memberItem.setName(user.getSortName());
            memberItem.setUser(user);
            memberItem.setRole(userRole);
            if ("admin".equals(userId)) continue;
            userMap.put(memberItem.getId(), memberItem);
        }
        return this.convertMemberMapToList(userMap);
    }

    public List convertMemberMapToList(Map memberMap) {
        Object[] membershipArray = new MembershipItem[memberMap.size()];
        membershipArray = memberMap.values().toArray(membershipArray);
        Arrays.sort(membershipArray);
        return Arrays.asList(membershipArray);
    }

    private User getUserFromList(String userId, List<User> userList) {
        User u = null;
        for (int i = 0; i < userList.size(); ++i) {
            User tu = userList.get(i);
            if (!userId.equals(tu.getId())) continue;
            return tu;
        }
        return u;
    }

    private List<String> getRealmIdList(Set realmUsers) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Member mem : realmUsers) {
            ret.add(mem.getUserId());
        }
        return ret;
    }

    private Map<String, User> getuserMap(List userList) {
        HashMap<String, User> ret = new HashMap<String, User>();
        for (int i = 0; i < userList.size(); ++i) {
            User tu = (User)userList.get(i);
            ret.put(tu.getId(), tu);
        }
        return ret;
    }

    public String getContextSiteId() {
        return "/site/" + this.toolManager.getCurrentPlacement().getContext();
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        this.authzGroupService = authzGroupService;
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public PrivateMessageManager getPrtMsgManager() {
        return this.prtMsgManager;
    }

    public void setPrtMsgManager(PrivateMessageManager prtMsgManager) {
        this.prtMsgManager = prtMsgManager;
    }
}

