/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.collection.PersistentSet;
import org.hibernate.type.Type;
import org.sakaiproject.api.app.messageforums.ActorPermissions;
import org.sakaiproject.api.app.messageforums.Area;
import org.sakaiproject.api.app.messageforums.Attachment;
import org.sakaiproject.api.app.messageforums.BaseForum;
import org.sakaiproject.api.app.messageforums.DiscussionForum;
import org.sakaiproject.api.app.messageforums.DiscussionTopic;
import org.sakaiproject.api.app.messageforums.MessageForumsForumManager;
import org.sakaiproject.api.app.messageforums.MessageForumsTypeManager;
import org.sakaiproject.api.app.messageforums.MessageForumsUser;
import org.sakaiproject.api.app.messageforums.OpenForum;
import org.sakaiproject.api.app.messageforums.OpenTopic;
import org.sakaiproject.api.app.messageforums.PrivateForum;
import org.sakaiproject.api.app.messageforums.PrivateTopic;
import org.sakaiproject.api.app.messageforums.Topic;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.app.messageforums.TestUtil;
import org.sakaiproject.component.app.messageforums.dao.hibernate.ActorPermissionsImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.DiscussionForumImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.DiscussionTopicImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.MessageForumsUserImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.OpenTopicImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.PrivateForumImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.PrivateTopicImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.Util;
import org.sakaiproject.component.app.messageforums.dao.hibernate.util.comparator.ForumBySortIndexAscAndCreatedDateDesc;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.id.api.IdManager;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageForumsForumManagerImpl
extends HibernateDaoSupport
implements MessageForumsForumManager {
    private static final Log LOG = LogFactory.getLog(MessageForumsForumManagerImpl.class);
    private static final String QUERY_FOR_PRIVATE_TOPICS = "findPrivateTopicsByForumId";
    private static final String QUERY_RECEIVED_UUID_BY_CONTEXT_ID = "findReceivedUuidByContextId";
    private static final String QUERY_BY_FORUM_OWNER = "findPrivateForumByOwner";
    private static final String QUERY_BY_FORUM_OWNER_AREA = "findPrivateForumByOwnerArea";
    private static final String QUERY_BY_FORUM_OWNER_AREA_WITH_TOPICS = "findPrivateForumByOwnerAreaWithTopics";
    private static final String QUERY_BY_FORUM_OWNER_AREA_NULL = "findPrivateForumByOwnerAreaNull";
    private static final String QUERY_BY_FORUM_OWNER_AREA_NULL_WITH_ALL_TOPICS = "findPrivateForumByOwnerAreaNullWithAllTopics";
    private static final String QUERY_BY_FORUM_ID = "findForumById";
    private static final String QUERY_BY_FORUM_ID_WITH_ATTACHMENTS = "findForumByIdWithAttachments";
    private static final String QUERY_BY_FORUM_UUID = "findForumByUuid";
    private static final String QUERY_BY_TYPE_AND_CONTEXT = "findForumByTypeAndContext";
    private static final String QUERY_BY_FORUM_ID_AND_TOPICS = "findForumByIdWithTopics";
    private static final String QUERY_BY_TYPE_AND_CONTEXT_WITH_ALL_INFO = "findForumByTypeAndContextWithAllInfo";
    private static final String QUERY_BY_TYPE_AND_CONTEXT_WITH_ALL_TOPICS_MEMBERSHIP = "findForumByTypeAndContextWithTopicsMemberhips";
    private static final String QUERY_TOPIC_WITH_MESSAGES_AND_ATTACHMENTS = "findTopicByIdWithMessagesAndAttachments";
    private static final String QUERY_TOPIC_WITH_MESSAGES = "findTopicByIdWithMessages";
    private static final String QUERY_TOPIC_WITH_ATTACHMENTS = "findTopicWithAttachmentsById";
    private static final String QUERY_TOPICS_WITH_MESSAGES_FOR_FORUM = "findTopicsWithMessagesForForum";
    private static final String QUERY_TOPICS_WITH_MESSAGES_AND_ATTACHMENTS_FOR_FORUM = "findTopicsWithMessagesAndAttachmentsForForum";
    private static final String QUERY_TOPICS_WITH_MSGS_AND_ATTACHMENTS_AND_MEMBERSHIPS_FOR_FORUM = "findTopicsWithMessagesMembershipAndAttachmentsForForum";
    private static final String QUERY_FORUMS_FOR_MAIN_PAGE = "findForumsForMainPage";
    private static final String QUERY_BY_TOPIC_ID = "findTopicById";
    private static final String QUERY_OPEN_BY_TOPIC_AND_PARENT = "findOpenTopicAndParentById";
    private static final String QUERY_PRIVATE_BY_TOPIC_AND_PARENT = "findPrivateTopicAndParentById";
    private static final String QUERY_BY_TOPIC_UUID = "findTopicByUuid";
    private static final String QUERY_OF_SUR_KEY_BY_TOPIC = "findOFTopicSurKeyByTopicId";
    private static final String QUERY_PF_SUR_KEY_BY_TOPIC = "findPFTopicSurKeyByTopicId";
    private static final String QUERY_BY_TOPIC_ID_MESSAGES_ATTACHMENTS = "findTopicByIdWithAttachments";
    private static final String QUERY_GET_ALL_MOD_TOPICS_IN_SITE = "findAllModeratedTopicsForSite";
    private static final String QUERY_GET_NUM_MOD_TOPICS_WITH_MOD_PERM_BY_PERM_LEVEL = "findNumModeratedTopicsForSiteByUserByMembershipWithPermissionLevelId";
    private static final String QUERY_GET_NUM_MOD_TOPICS_WITH_MOD_PERM_BY_PERM_LEVEL_NAME = "findNumModeratedTopicsForSiteByUserByMembershipWithPermissionLevelName";
    private static final String QUERY_GET_FORUM_BY_ID_WITH_TOPICS_AND_ATT_AND_MSGS = "findForumByIdWithTopicsAndAttachmentsAndMessages";
    public static final Comparator FORUM_SORT_INDEX_CREATED_DATE_COMPARATOR_DESC = new ForumBySortIndexAscAndCreatedDateDesc();
    private IdManager idManager;
    private SessionManager sessionManager;
    private ServerConfigurationService serverConfigurationService;
    private Boolean DEFAULT_AUTO_MARK_READ = false;
    private MessageForumsTypeManager typeManager;
    private EventTrackingService eventTrackingService;

    public void init() {
        LOG.info((Object)"init()");
        this.DEFAULT_AUTO_MARK_READ = this.serverConfigurationService.getBoolean("msgcntr.forums.default.auto.mark.threads.read", false);
    }

    public EventTrackingService getEventTrackingService() {
        return this.eventTrackingService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public MessageForumsTypeManager getTypeManager() {
        return this.typeManager;
    }

    public void setTypeManager(MessageForumsTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setIdManager(IdManager idManager) {
        this.idManager = idManager;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public IdManager getIdManager() {
        return this.idManager;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void initializeTopicsForForum(BaseForum forum) {
        this.getHibernateTemplate().initialize((Object)forum);
        this.getHibernateTemplate().initialize((Object)forum.getTopicsSet());
    }

    public List getTopicsByIdWithMessages(final Long forumId) {
        if (forumId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_TOPICS_WITH_MESSAGES_FOR_FORUM);
                q.setParameter("id", (Object)forumId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        Topic tempTopic = null;
        HashSet<Topic> resultSet = new HashSet<Topic>();
        ArrayList temp = (ArrayList)this.getHibernateTemplate().execute(hcb);
        for (Object[] results : temp) {
            if (results == null) continue;
            if (results[0] instanceof Topic) {
                tempTopic = (Topic)results[0];
                tempTopic.setBaseForum((BaseForum)results[1]);
            } else {
                tempTopic = (Topic)results[1];
                tempTopic.setBaseForum((BaseForum)results[0]);
            }
            resultSet.add(tempTopic);
        }
        return Util.setToList(resultSet);
    }

    public List getTopicsByIdWithMessagesAndAttachments(final Long forumId) {
        if (forumId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_TOPICS_WITH_MESSAGES_AND_ATTACHMENTS_FOR_FORUM);
                q.setParameter("id", (Object)forumId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        Topic tempTopic = null;
        HashSet<Topic> resultSet = new HashSet<Topic>();
        ArrayList temp = (ArrayList)this.getHibernateTemplate().execute(hcb);
        for (Object[] results : temp) {
            if (results == null) continue;
            if (results[0] instanceof Topic) {
                tempTopic = (Topic)results[0];
                tempTopic.setBaseForum((BaseForum)results[1]);
            } else {
                tempTopic = (Topic)results[1];
                tempTopic.setBaseForum((BaseForum)results[0]);
            }
            resultSet.add(tempTopic);
        }
        return Util.setToList(resultSet);
    }

    public List getTopicsByIdWithMessagesMembershipAndAttachments(final Long forumId) {
        if (forumId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_TOPICS_WITH_MSGS_AND_ATTACHMENTS_AND_MEMBERSHIPS_FOR_FORUM);
                q.setParameter("id", (Object)forumId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        Topic tempTopic = null;
        HashSet<Topic> resultSet = new HashSet<Topic>();
        ArrayList temp = (ArrayList)this.getHibernateTemplate().execute(hcb);
        for (Object[] results : temp) {
            if (results == null) continue;
            if (results[0] instanceof Topic) {
                tempTopic = (Topic)results[0];
                tempTopic.setBaseForum((BaseForum)results[1]);
            } else {
                tempTopic = (Topic)results[1];
                tempTopic.setBaseForum((BaseForum)results[0]);
            }
            resultSet.add(tempTopic);
        }
        return Util.setToList(resultSet);
    }

    public List<DiscussionForum> getForumsForMainPage() {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_FORUMS_FOR_MAIN_PAGE);
                q.setParameter("typeUuid", (Object)MessageForumsForumManagerImpl.this.typeManager.getDiscussionForumType(), (Type)Hibernate.STRING);
                q.setParameter("contextId", (Object)MessageForumsForumManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List getReceivedUuidByContextId(final List siteList) {
        if (siteList == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_RECEIVED_UUID_BY_CONTEXT_ID);
                q.setParameterList("siteList", (Collection)siteList);
                q.setParameter("userId", (Object)MessageForumsForumManagerImpl.this.getCurrentUser(), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public Topic getTopicByIdWithMessagesAndAttachments(final Long topicId) {
        if (topicId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_TOPIC_WITH_MESSAGES_AND_ATTACHMENTS);
                q.setParameter("id", (Object)topicId, (Type)Hibernate.LONG);
                return q.uniqueResult();
            }
        };
        return (Topic)this.getHibernateTemplate().execute(hcb);
    }

    public Topic getTopicByIdWithMessages(final Long topicId) {
        if (topicId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_TOPIC_WITH_MESSAGES);
                q.setParameter("id", (Object)topicId, (Type)Hibernate.LONG);
                return q.uniqueResult();
            }
        };
        return (Topic)this.getHibernateTemplate().execute(hcb);
    }

    public Topic getTopicWithAttachmentsById(final Long topicId) {
        if (topicId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_TOPIC_WITH_ATTACHMENTS);
                q.setParameter("id", (Object)topicId, (Type)Hibernate.LONG);
                return q.uniqueResult();
            }
        };
        return (Topic)this.getHibernateTemplate().execute(hcb);
    }

    public List<Attachment> getTopicAttachments(final Long topicId) {
        if (topicId == null) {
            throw new IllegalArgumentException("Null Argument topicId");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findTopicAttachments");
                q.setParameter("topic", (Object)topicId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    public BaseForum getForumByIdWithTopics(final Long forumId) {
        if (forumId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_BY_FORUM_ID_AND_TOPICS);
                q.setParameter("id", (Object)forumId, (Type)Hibernate.LONG);
                return q.uniqueResult();
            }
        };
        BaseForum bForum = (BaseForum)this.getHibernateTemplate().execute(hcb);
        if (bForum != null) {
            this.getHibernateTemplate().initialize((Object)bForum.getAttachmentsSet());
        }
        return bForum;
    }

    public List getForumByTypeAndContext(final String typeUuid) {
        if (typeUuid == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_BY_TYPE_AND_CONTEXT);
                q.setParameter("typeUuid", (Object)typeUuid, (Type)Hibernate.STRING);
                q.setParameter("contextId", (Object)MessageForumsForumManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        BaseForum tempForum2 = null;
        HashSet<BaseForum> resultSet = new HashSet<BaseForum>();
        ArrayList temp = (ArrayList)this.getHibernateTemplate().execute(hcb);
        for (Object[] results : temp) {
            if (results == null) continue;
            if (results[0] instanceof BaseForum) {
                tempForum2 = (BaseForum)results[0];
                tempForum2.setArea((Area)results[1]);
            } else {
                tempForum2 = (BaseForum)results[1];
                tempForum2.setArea((Area)results[0]);
            }
            resultSet.add(tempForum2);
        }
        List resultList = Util.setToList(resultSet);
        Collections.sort(resultList, FORUM_SORT_INDEX_CREATED_DATE_COMPARATOR_DESC);
        int sort_index = 1;
        for (BaseForum tempForum2 : resultList) {
            tempForum2.setSortIndex(Integer.valueOf(sort_index++));
        }
        return resultList;
    }

    public List getForumByTypeAndContext(final String typeUuid, final String contextId) {
        if (typeUuid == null || contextId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_BY_TYPE_AND_CONTEXT);
                q.setParameter("typeUuid", (Object)typeUuid, (Type)Hibernate.STRING);
                q.setParameter("contextId", (Object)contextId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        BaseForum tempForum2 = null;
        HashSet<BaseForum> resultSet = new HashSet<BaseForum>();
        ArrayList temp = (ArrayList)this.getHibernateTemplate().execute(hcb);
        for (Object[] results : temp) {
            if (results == null) continue;
            if (results[0] instanceof BaseForum) {
                tempForum2 = (BaseForum)results[0];
                tempForum2.setArea((Area)results[1]);
            } else {
                tempForum2 = (BaseForum)results[1];
                tempForum2.setArea((Area)results[0]);
            }
            resultSet.add(tempForum2);
        }
        List resultList = Util.setToList(resultSet);
        Collections.sort(resultList, FORUM_SORT_INDEX_CREATED_DATE_COMPARATOR_DESC);
        int sort_index = 1;
        for (BaseForum tempForum2 : resultList) {
            tempForum2.setSortIndex(Integer.valueOf(sort_index++));
        }
        return resultList;
    }

    public Topic getTopicByIdWithAttachments(final Long topicId) {
        if (topicId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getTopicByIdWithMessagesAndAttachments executing with topicId: " + topicId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_BY_TOPIC_ID_MESSAGES_ATTACHMENTS);
                q.setParameter("id", (Object)topicId, (Type)Hibernate.LONG);
                return q.uniqueResult();
            }
        };
        return (Topic)this.getHibernateTemplate().execute(hcb);
    }

    public PrivateForum getPrivateForumByOwner(final String owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getForumByOwner executing with owner: " + owner));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_BY_FORUM_OWNER);
                q.setParameter("owner", (Object)owner, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (PrivateForum)this.getHibernateTemplate().execute(hcb);
    }

    public PrivateForum getPrivateForumByOwnerArea(final String owner, final Area area) {
        if (owner == null || area == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getForumByOwnerArea executing with owner: " + owner + " and area:" + area));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_BY_FORUM_OWNER_AREA);
                q.setParameter("owner", (Object)owner, (Type)Hibernate.STRING);
                q.setParameter("area", (Object)area);
                return q.uniqueResult();
            }
        };
        return (PrivateForum)this.getHibernateTemplate().execute(hcb);
    }

    public PrivateForum getPrivateForumByOwnerAreaNull(final String owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getForumByOwnerAreaNull executing with owner: " + owner));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_BY_FORUM_OWNER_AREA_NULL);
                q.setParameter("owner", (Object)owner, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (PrivateForum)this.getHibernateTemplate().execute(hcb);
    }

    public BaseForum getForumByIdWithAttachments(final Long forumId) {
        if (forumId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getForumByIdWithAttachments executing with forumId: " + forumId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_BY_FORUM_ID_WITH_ATTACHMENTS);
                q.setParameter("id", (Object)forumId, (Type)Hibernate.LONG);
                return q.uniqueResult();
            }
        };
        return (BaseForum)this.getHibernateTemplate().execute(hcb);
    }

    public BaseForum getForumById(boolean open, Long forumId) {
        if (forumId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getForumById executing with forumId: " + forumId));
        if (open) {
            return this.getForumByIdWithAttachments(forumId);
        }
        return (BaseForum)this.getHibernateTemplate().get(PrivateForumImpl.class, (Serializable)forumId);
    }

    public BaseForum getForumByUuid(final String forumId) {
        if (forumId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getForumByUuid executing with forumId: " + forumId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_BY_FORUM_UUID);
                q.setParameter("uuid", (Object)forumId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (BaseForum)this.getHibernateTemplate().execute(hcb);
    }

    public Topic getTopicById(final boolean open, final Long topicId) {
        if (topicId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getTopicById executing with topicId: " + topicId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                if (open) {
                    String query = MessageForumsForumManagerImpl.QUERY_OPEN_BY_TOPIC_AND_PARENT;
                } else {
                    String query = MessageForumsForumManagerImpl.QUERY_PRIVATE_BY_TOPIC_AND_PARENT;
                }
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_OPEN_BY_TOPIC_AND_PARENT);
                q.setParameter("id", (Object)topicId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        Topic res = null;
        try {
            Object[] results;
            ArrayList temp = (ArrayList)this.getHibernateTemplate().execute(hcb);
            if (temp != null && temp.size() > 0 && (results = (Object[])temp.get(0)) != null && results.length > 1) {
                if (results[0] instanceof Topic) {
                    res = (Topic)results[0];
                    res.setBaseForum((BaseForum)results[1]);
                } else {
                    res = (Topic)results[1];
                    res.setBaseForum((BaseForum)results[0]);
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
        return res;
    }

    public Topic getTopicByUuid(final String uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getTopicByUuid executing with topicId: " + uuid));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_BY_TOPIC_UUID);
                q.setParameter("uuid", (Object)uuid, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Topic)this.getHibernateTemplate().execute(hcb);
    }

    public List getModeratedTopicsInSite(final String contextId) {
        if (contextId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getModeratedTopicsInSite executing with contextId: " + contextId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_GET_ALL_MOD_TOPICS_IN_SITE);
                q.setParameter("contextId", (Object)contextId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        Topic tempTopic = null;
        HashSet<Topic> resultSet = new HashSet<Topic>();
        ArrayList temp = (ArrayList)this.getHibernateTemplate().execute(hcb);
        for (Object[] results : temp) {
            if (results == null) continue;
            if (results[0] instanceof Topic) {
                tempTopic = (Topic)results[0];
                tempTopic.setBaseForum((BaseForum)results[1]);
            } else {
                tempTopic = (Topic)results[1];
                tempTopic.setBaseForum((BaseForum)results[0]);
            }
            resultSet.add(tempTopic);
        }
        return Util.setToList(resultSet);
    }

    public DiscussionForum createDiscussionForum() {
        DiscussionForumImpl forum = new DiscussionForumImpl();
        forum.setUuid(this.getNextUuid());
        forum.setCreated(new Date());
        if (this.getCurrentUser() != null) {
            forum.setCreatedBy(this.getCurrentUser());
        }
        forum.setLocked(Boolean.FALSE);
        forum.setDraft(Boolean.FALSE);
        forum.setTypeUuid(this.typeManager.getDiscussionForumType());
        forum.setActorPermissions(this.createDefaultActorPermissions());
        forum.setModerated(Boolean.FALSE);
        forum.setPostFirst(Boolean.FALSE);
        forum.setAutoMarkThreadsRead(this.DEFAULT_AUTO_MARK_READ);
        LOG.debug((Object)"createDiscussionForum executed");
        return forum;
    }

    public ActorPermissions createDefaultActorPermissions() {
        ActorPermissionsImpl actorPermissions = new ActorPermissionsImpl();
        MessageForumsUserImpl nonSpecifiedUser = new MessageForumsUserImpl();
        nonSpecifiedUser.setUserId(this.typeManager.getNotSpecifiedType());
        nonSpecifiedUser.setUuid(this.typeManager.getNotSpecifiedType());
        nonSpecifiedUser.setTypeUuid(this.typeManager.getNotSpecifiedType());
        actorPermissions.addAccesssor((MessageForumsUser)nonSpecifiedUser);
        actorPermissions.addContributor((MessageForumsUser)nonSpecifiedUser);
        actorPermissions.addModerator((MessageForumsUser)nonSpecifiedUser);
        return actorPermissions;
    }

    public PrivateForum createPrivateForum(String title) {
        return this.createPrivateForum(title, this.getCurrentUser());
    }

    public PrivateForum createPrivateForum(String title, String userId) {
        PrivateForumImpl forum = new PrivateForumImpl();
        forum.setTitle(title);
        forum.setUuid(this.idManager.createUuid());
        forum.setAutoForwardEmail("");
        forum.setOwner(userId);
        forum.setUuid(this.getNextUuid());
        forum.setCreated(new Date());
        forum.setCreatedBy(userId);
        forum.setSortIndex(Integer.valueOf(0));
        forum.setShortDescription("short-desc");
        forum.setExtendedDescription("ext desc");
        forum.setAutoForward(Boolean.FALSE);
        forum.setAutoForwardEmail("");
        forum.setPreviewPaneEnabled(Boolean.FALSE);
        forum.setModified(new Date());
        if (userId != null) {
            forum.setModifiedBy(userId);
        }
        forum.setTypeUuid(this.typeManager.getPrivateMessageAreaType());
        forum.setModerated(Boolean.FALSE);
        forum.setPostFirst(Boolean.FALSE);
        LOG.debug((Object)"createPrivateForum executed");
        return forum;
    }

    public void savePrivateForum(PrivateForum forum) {
        this.savePrivateForum(forum, this.getCurrentUser());
    }

    public void savePrivateForum(PrivateForum forum, String userId) {
        boolean isNew;
        boolean bl = isNew = forum.getId() == null;
        if (forum.getSortIndex() == null) {
            forum.setSortIndex(Integer.valueOf(0));
        }
        forum.setModified(new Date());
        if (userId != null) {
            forum.setModifiedBy(userId);
        }
        forum.setOwner(userId);
        this.getHibernateTemplate().saveOrUpdate((Object)forum);
        LOG.debug((Object)("savePrivateForum executed with forumId: " + forum.getId()));
    }

    public void saveDiscussionForum(DiscussionForum forum) {
        this.saveDiscussionForum(forum, false);
    }

    public void saveDiscussionForum(DiscussionForum forum, boolean draft) {
        this.saveDiscussionForum(forum, draft, false);
    }

    public void saveDiscussionForum(DiscussionForum forum, boolean draft, boolean logEvent) {
        String currentUser = this.getCurrentUser();
        this.saveDiscussionForum(forum, draft, logEvent, currentUser);
    }

    public void saveDiscussionForum(DiscussionForum forum, boolean draft, boolean logEvent, String currentUser) {
        boolean isNew;
        boolean bl = isNew = forum.getId() == null;
        if (forum.getSortIndex() == null) {
            forum.setSortIndex(Integer.valueOf(0));
        }
        if (forum.getLocked() == null) {
            forum.setLocked(Boolean.FALSE);
        }
        if (forum.getModerated() == null) {
            forum.setModerated(Boolean.FALSE);
        }
        if (forum.getPostFirst() == null) {
            forum.setPostFirst(Boolean.FALSE);
        }
        forum.setDraft(Boolean.valueOf(draft));
        forum.setModified(new Date());
        if (currentUser != null) {
            forum.setModifiedBy(currentUser);
        } else if (currentUser == null) {
            forum.setModifiedBy(forum.getCreatedBy());
        }
        if (forum.getTopicsSet() != null && (forum.getTopicsSet() instanceof PersistentSet && ((PersistentSet)forum.getTopicsSet()).wasInitialized() || !(forum.getTopicsSet() instanceof PersistentSet))) {
            List topics = forum.getTopics();
            boolean someTopicHasZeroSortIndex = false;
            for (DiscussionTopic topic : topics) {
                if (topic.getSortIndex() != 0) continue;
                someTopicHasZeroSortIndex = true;
                break;
            }
            if (someTopicHasZeroSortIndex) {
                for (DiscussionTopic topic : topics) {
                    topic.setSortIndex(Integer.valueOf(topic.getSortIndex() + 1));
                }
            }
        }
        this.getHibernateTemplate().saveOrUpdate((Object)forum);
        if (logEvent) {
            if (isNew) {
                this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.newforum", this.getEventMessage(forum), false));
            } else {
                this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.reviseforum", this.getEventMessage(forum), false));
            }
        }
        LOG.debug((Object)("saveDiscussionForum executed with forumId: " + forum.getId() + ":: draft: " + draft));
    }

    public DiscussionTopic createDiscussionForumTopic(DiscussionForum forum) {
        DiscussionTopicImpl topic = new DiscussionTopicImpl();
        topic.setUuid(this.getNextUuid());
        topic.setTypeUuid(this.typeManager.getDiscussionForumType());
        topic.setCreated(new Date());
        if (this.getCurrentUser() != null) {
            topic.setCreatedBy(this.getCurrentUser());
        }
        topic.setBaseForum((BaseForum)forum);
        topic.setLocked(Boolean.FALSE);
        topic.setDraft(forum.getDraft());
        topic.setModerated(Boolean.FALSE);
        topic.setPostFirst(Boolean.FALSE);
        topic.setAutoMarkThreadsRead(forum.getAutoMarkThreadsRead());
        LOG.debug((Object)"createDiscussionForumTopic executed");
        return topic;
    }

    public void saveDiscussionForumTopic(DiscussionTopic topic) {
        this.saveDiscussionForumTopic(topic, false);
    }

    public void saveDiscussionForumTopic(DiscussionTopic topic, boolean parentForumDraftStatus) {
        this.saveDiscussionForumTopic(topic, parentForumDraftStatus, this.getCurrentUser(), true);
    }

    public void saveDiscussionForumTopic(DiscussionTopic topic, boolean parentForumDraftStatus, String currentUser, boolean logEvent) {
        boolean isNew;
        boolean bl = isNew = topic.getId() == null;
        if (topic.getMutable() == null) {
            topic.setMutable(Boolean.FALSE);
        }
        if (topic.getSortIndex() == null) {
            topic.setSortIndex(Integer.valueOf(0));
        }
        topic.setModified(new Date());
        if (currentUser != null) {
            topic.setModifiedBy(currentUser);
        }
        if (topic.getModerated() == null) {
            topic.setModerated(Boolean.FALSE);
        }
        if (topic.getPostFirst() == null) {
            topic.setPostFirst(Boolean.FALSE);
        }
        if (topic.getId() == null) {
            DiscussionForum discussionForum = (DiscussionForum)this.getForumByIdWithTopics(topic.getBaseForum().getId());
            discussionForum.addTopic((Topic)topic);
            if (topic.getDraft().equals(Boolean.TRUE)) {
                this.saveDiscussionForum(discussionForum, discussionForum.getDraft(), logEvent, currentUser);
            } else {
                this.saveDiscussionForum(discussionForum, parentForumDraftStatus, logEvent, currentUser);
            }
        } else {
            this.getHibernateTemplate().saveOrUpdate((Object)topic);
        }
        LOG.debug((Object)("saveDiscussionForumTopic executed with topicId: " + topic.getId()));
    }

    public OpenTopic createOpenForumTopic(OpenForum forum) {
        OpenTopicImpl topic = new OpenTopicImpl();
        topic.setUuid(this.getNextUuid());
        topic.setTypeUuid(this.typeManager.getOpenDiscussionForumType());
        topic.setCreated(new Date());
        if (this.getCurrentUser() != null) {
            topic.setCreatedBy(this.getCurrentUser());
        }
        topic.setLocked(Boolean.FALSE);
        topic.setModerated(Boolean.FALSE);
        topic.setPostFirst(Boolean.FALSE);
        topic.setDraft(forum.getDraft());
        LOG.debug((Object)"createOpenForumTopic executed");
        return topic;
    }

    public PrivateTopic createPrivateForumTopic(String title, boolean forumIsParent, boolean topicIsMutable, String userId, Long parentId) {
        PrivateTopicImpl topic = new PrivateTopicImpl();
        topic.setTitle(title);
        topic.setUuid(this.getNextUuid());
        topic.setCreated(new Date());
        if (userId != null) {
            topic.setCreatedBy(userId);
        }
        topic.setUserId(userId);
        topic.setShortDescription("short-desc");
        topic.setExtendedDescription("ext-desc");
        topic.setMutable(Boolean.valueOf(topicIsMutable));
        topic.setSortIndex(Integer.valueOf(0));
        topic.setModified(new Date());
        if (userId != null) {
            topic.setModifiedBy(userId);
        }
        topic.setTypeUuid(this.typeManager.getPrivateMessageAreaType());
        topic.setModerated(Boolean.FALSE);
        topic.setPostFirst(Boolean.FALSE);
        topic.setAutoMarkThreadsRead(this.DEFAULT_AUTO_MARK_READ);
        LOG.debug((Object)"createPrivateForumTopic executed");
        return topic;
    }

    public void savePrivateForumTopic(PrivateTopic topic) {
        this.savePrivateForumTopic(topic, this.getCurrentUser());
    }

    public void savePrivateForumTopic(PrivateTopic topic, String userId) {
        this.savePrivateForumTopic(topic, userId, this.getContextId());
    }

    public void savePrivateForumTopic(PrivateTopic topic, String userId, String siteId) {
        boolean isNew = topic.getId() == null;
        topic.setModified(new Date());
        if (userId != null) {
            topic.setModifiedBy(userId);
        }
        this.getHibernateTemplate().saveOrUpdate((Object)topic);
        if (isNew) {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("messages.newfolder", this.getEventMessage(topic, siteId), false));
        } else {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("messages.revisefolder", this.getEventMessage(topic, siteId), false));
        }
        LOG.debug((Object)("savePrivateForumTopic executed with forumId: " + topic.getId()));
    }

    public void saveOpenForumTopic(OpenTopic topic) {
        boolean isNew = topic.getId() == null;
        topic.setModified(new Date());
        if (this.getCurrentUser() != null) {
            topic.setModifiedBy(this.getCurrentUser());
        }
        this.getHibernateTemplate().saveOrUpdate((Object)topic);
        if (isNew) {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.newtopic", this.getEventMessage(topic), false));
        } else {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.revisetopic", this.getEventMessage(topic), false));
        }
        LOG.debug((Object)("saveOpenForumTopic executed with forumId: " + topic.getId()));
    }

    public void deleteDiscussionForum(DiscussionForum forum) {
        long id = forum.getId();
        this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.deleteforum", this.getEventMessage(forum), false));
        try {
            this.getSession().evict((Object)forum);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error((Object)("could not evict forum: " + forum.getId()), (Throwable)e);
        }
        forum = (DiscussionForum)this.getForumById(true, id);
        Area area = forum.getArea();
        area.removeDiscussionForum((BaseForum)forum);
        this.getHibernateTemplate().saveOrUpdate((Object)area);
        LOG.debug((Object)("deleteDiscussionForum executed with forumId: " + id));
    }

    public Area getAreaByContextIdAndTypeId(final String typeId) {
        LOG.debug((Object)("getAreaByContextIdAndTypeId executing for current user: " + this.getCurrentUser()));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findAreaByContextIdAndTypeId");
                q.setParameter("contextId", (Object)MessageForumsForumManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameter("typeId", (Object)typeId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Area)this.getHibernateTemplate().execute(hcb);
    }

    public void deleteDiscussionForumTopic(DiscussionTopic topic) {
        long id = topic.getId();
        this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.deletetopic", this.getEventMessage(topic), false));
        try {
            this.getSession().evict((Object)topic);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error((Object)("could not evict topic: " + topic.getId()), (Throwable)e);
        }
        Topic finder = this.getTopicById(true, topic.getId());
        BaseForum forum = finder.getBaseForum();
        forum.removeTopic((Topic)topic);
        this.getHibernateTemplate().saveOrUpdate((Object)forum);
        LOG.debug((Object)("deleteDiscussionForumTopic executed with topicId: " + id));
    }

    public void deleteOpenForumTopic(OpenTopic topic) {
        this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.deleteforum", this.getEventMessage(topic), false));
        this.getHibernateTemplate().delete((Object)topic);
        LOG.debug((Object)("deleteOpenForumTopic executed with forumId: " + topic.getId()));
    }

    public void deletePrivateForumTopic(PrivateTopic topic) {
        this.eventTrackingService.post(this.eventTrackingService.newEvent("messages.deletefolder", this.getEventMessage(topic), false));
        this.getHibernateTemplate().delete((Object)topic);
        LOG.debug((Object)("deletePrivateForumTopic executed with forumId: " + topic.getId()));
    }

    public List getRecentPrivateMessages(int numberMessages, int numberDaysInPast) {
        throw new UnsupportedOperationException();
    }

    public List getRecentDiscussionForumMessages(int numberMessages, int numberDaysInPast) {
        throw new UnsupportedOperationException();
    }

    public List getRecentOpenForumMessages(int numberMessages, int numberDaysInPast) {
        throw new UnsupportedOperationException();
    }

    private boolean isForumLocked(final Long id) {
        if (id == null) {
            LOG.error((Object)"isForumLocked failed with id: null");
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("isForumLocked executing with id: " + id));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findForumLockedAttribute");
                q.setParameter("id", (Object)id, (Type)Hibernate.LONG);
                return q.uniqueResult();
            }
        };
        return (Boolean)this.getHibernateTemplate().execute(hcb);
    }

    public List searchTopicMessages(final Long topicId, final String searchText) {
        if (topicId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("searchTopicMessages executing with topicId: " + topicId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findMessagesBySearchText");
                q.setParameter("id", (Object)topicId, (Type)Hibernate.LONG);
                q.setParameter("searchByText", (Object)("%" + searchText + "%"), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    private String getContextId() {
        if (TestUtil.isRunningTests()) {
            return "test-context";
        }
        Placement placement = ToolManager.getCurrentPlacement();
        String presentSiteId = placement.getContext();
        return presentSiteId;
    }

    private String getCurrentUser() {
        if (TestUtil.isRunningTests()) {
            return "test-user";
        }
        return this.sessionManager.getCurrentSessionUserId();
    }

    private String getNextUuid() {
        return this.idManager.createUuid();
    }

    private boolean isToolInSite(Site thisSite, String toolId) {
        Collection toolsInSite = thisSite.getTools(toolId);
        return !toolsInSite.isEmpty();
    }

    private String getEventMessage(Object object) {
        return this.getEventMessage(object, this.getContextId());
    }

    private String getEventMessage(Object object, String context) {
        String eventMessagePrefix = "";
        try {
            eventMessagePrefix = this.isToolInSite(SiteService.getSite((String)context), "sakai.messagecenter") ? "/messages&forums/site/" : (this.isToolInSite(SiteService.getSite((String)context), "sakai.messages") ? "/messages/site/" : "/forums/site/");
        }
        catch (IdUnusedException e) {
            LOG.debug((Object)("IdUnusedException attempting to get site with id: " + context));
            eventMessagePrefix = "/messages&forums/";
        }
        return eventMessagePrefix + context + "/" + object.toString() + "/" + this.getCurrentUser();
    }

    public List getForumByTypeAndContextWithTopicsAllAttachments(String typeUuid) {
        return this.getForumByTypeAndContextWithTopicsAllAttachments(typeUuid, this.getContextId());
    }

    public List getForumByTypeAndContextWithTopicsAllAttachments(final String typeUuid, final String contextId) {
        if (typeUuid == null || contextId == null) {
            throw new IllegalArgumentException("Null typeUuid or contextId passed to getForumByTypeAndContextWithTopicsAllAttachments. typeUuid:" + typeUuid + " contextId:" + contextId);
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_BY_TYPE_AND_CONTEXT_WITH_ALL_INFO);
                q.setParameter("typeUuid", (Object)typeUuid, (Type)Hibernate.STRING);
                q.setParameter("contextId", (Object)contextId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        BaseForum tempForum2 = null;
        HashSet<DiscussionForumImpl> resultSet = new HashSet<DiscussionForumImpl>();
        ArrayList temp = (ArrayList)this.getHibernateTemplate().execute(hcb);
        for (DiscussionForumImpl results : temp) {
            resultSet.add(results);
        }
        List resultList = Util.setToList(resultSet);
        Collections.sort(resultList, FORUM_SORT_INDEX_CREATED_DATE_COMPARATOR_DESC);
        int sort_index = 1;
        for (BaseForum tempForum2 : resultList) {
            tempForum2.setSortIndex(Integer.valueOf(sort_index++));
        }
        return resultList;
    }

    public List getForumByTypeAndContextWithTopicsMembership(final String typeUuid, final String contextId) {
        if (typeUuid == null || contextId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_BY_TYPE_AND_CONTEXT_WITH_ALL_TOPICS_MEMBERSHIP);
                q.setParameter("typeUuid", (Object)typeUuid, (Type)Hibernate.STRING);
                q.setParameter("contextId", (Object)contextId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        BaseForum tempForum2 = null;
        HashSet<BaseForum> resultSet = new HashSet<BaseForum>();
        ArrayList temp = (ArrayList)this.getHibernateTemplate().execute(hcb);
        for (Object[] results : temp) {
            if (results == null) continue;
            if (results[0] instanceof BaseForum) {
                tempForum2 = (BaseForum)results[0];
                tempForum2.setArea((Area)results[1]);
            } else {
                tempForum2 = (BaseForum)results[1];
                tempForum2.setArea((Area)results[0]);
            }
            resultSet.add(tempForum2);
        }
        List resultList = Util.setToList(resultSet);
        Collections.sort(resultList, FORUM_SORT_INDEX_CREATED_DATE_COMPARATOR_DESC);
        int sort_index = 1;
        for (BaseForum tempForum2 : resultList) {
            tempForum2.setSortIndex(Integer.valueOf(sort_index++));
        }
        return resultList;
    }

    public PrivateForum getPrivateForumByOwnerAreaWithAllTopics(final String owner, final Area area) {
        if (owner == null || area == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getPrivateForumByOwnerAreaWithAllTopics executing with owner: " + owner + " and area:" + area));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_BY_FORUM_OWNER_AREA_WITH_TOPICS);
                q.setParameter("owner", (Object)owner, (Type)Hibernate.STRING);
                q.setParameter("area", (Object)area);
                return q.uniqueResult();
            }
        };
        return (PrivateForum)this.getHibernateTemplate().execute(hcb);
    }

    public PrivateForum getPrivateForumByOwnerAreaNullWithAllTopics(final String owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getPrivateForumByOwnerAreaNullWithAllTopics executing with owner: " + owner));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_BY_FORUM_OWNER_AREA_NULL_WITH_ALL_TOPICS);
                q.setParameter("owner", (Object)owner, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (PrivateForum)this.getHibernateTemplate().execute(hcb);
    }

    public int getNumModTopicCurrentUserHasModPermForWithPermissionLevel(final List membershipList) {
        if (membershipList == null) {
            LOG.error((Object)"getNumModTopicCurrentUserHasModPermForWithPermissionLevel failed with membershipList: null");
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getNumModTopicCurrentUserHasModPermForWithPermissionLevel executing with membershipItems: " + membershipList));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_GET_NUM_MOD_TOPICS_WITH_MOD_PERM_BY_PERM_LEVEL);
                q.setParameterList("membershipList", (Collection)membershipList);
                q.setParameter("contextId", (Object)MessageForumsForumManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    public int getNumModTopicCurrentUserHasModPermForWithPermissionLevelName(final List membershipList) {
        if (membershipList == null) {
            LOG.error((Object)"getNumModTopicCurrentUserHasModPermForWithPermissionLevelName failed with membershipList: null");
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getNumModTopicCurrentUserHasModPermForWithPermissionLevelName executing with membershipItems: " + membershipList));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_GET_NUM_MOD_TOPICS_WITH_MOD_PERM_BY_PERM_LEVEL_NAME);
                q.setParameterList("membershipList", (Collection)membershipList);
                q.setParameter("contextId", (Object)MessageForumsForumManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameter("customTypeUuid", (Object)MessageForumsForumManagerImpl.this.typeManager.getCustomLevelType(), (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    public BaseForum getForumByIdWithTopicsAttachmentsAndMessages(final Long forumId) {
        if (forumId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsForumManagerImpl.QUERY_GET_FORUM_BY_ID_WITH_TOPICS_AND_ATT_AND_MSGS);
                q.setParameter("id", (Object)forumId, (Type)Hibernate.LONG);
                return q.uniqueResult();
            }
        };
        BaseForum bForum = (BaseForum)this.getHibernateTemplate().execute(hcb);
        if (bForum != null) {
            this.getHibernateTemplate().initialize((Object)bForum.getAttachmentsSet());
        }
        return bForum;
    }

    public Topic getTopicByIdWithMemberships(final Long topicId) {
        if (topicId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findTopicByIdWithMemberships");
                q.setParameter("id", (Object)topicId, (Type)Hibernate.LONG);
                return q.uniqueResult();
            }
        };
        return (Topic)this.getHibernateTemplate().execute(hcb);
    }
}

