/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.sakaiproject.api.app.messageforums.Attachment;
import org.sakaiproject.api.app.messageforums.BaseForum;
import org.sakaiproject.api.app.messageforums.Message;
import org.sakaiproject.api.app.messageforums.MessageForumsMessageManager;
import org.sakaiproject.api.app.messageforums.MessageForumsTypeManager;
import org.sakaiproject.api.app.messageforums.PrivateMessage;
import org.sakaiproject.api.app.messageforums.Topic;
import org.sakaiproject.api.app.messageforums.UnreadStatus;
import org.sakaiproject.api.app.messageforums.cover.SynopticMsgcntrManagerCover;
import org.sakaiproject.component.app.messageforums.TestUtil;
import org.sakaiproject.component.app.messageforums.dao.hibernate.AttachmentImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.MessageImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.PrivateMessageImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.UnreadStatusImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.Util;
import org.sakaiproject.component.app.messageforums.exception.LockedException;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.id.api.IdManager;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateOptimisticLockingFailureException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageForumsMessageManagerImpl
extends HibernateDaoSupport
implements MessageForumsMessageManager {
    private static final Log LOG = LogFactory.getLog(MessageForumsMessageManagerImpl.class);
    private static final String QUERY_BY_MESSAGE_ID_WITH_ATTACHMENTS = "findMessageByIdWithAttachments";
    private static final String QUERY_COUNT_BY_READ = "findReadMessageCountByTopicId";
    private static final String QUERY_COUNT_BY_AUTHORED = "findAuhtoredMessageCountByTopicId";
    private static final String QUERY_MESSAGE_COUNTS_FOR_MAIN_PAGE = "findMessageCountsForMainPage";
    private static final String QUERY_READ_MESSAGE_COUNTS_FOR_MAIN_PAGE = "findReadMessageCountsForMainPage";
    private static final String QUERY_BY_TOPIC_ID = "findMessagesByTopicId";
    private static final String QUERY_COUNT_VIEWABLE_BY_TOPIC_ID = "findViewableMessageCountByTopicIdByUserId";
    private static final String QUERY_COUNT_READ_VIEWABLE_BY_TOPIC_ID = "findReadViewableMessageCountByTopicIdByUserId";
    private static final String QUERY_UNREAD_STATUS = "findUnreadStatusForMessage";
    private static final String QUERY_CHILD_MESSAGES = "finalAllChildMessages";
    private static final String QUERY_READ_STATUS_WITH_MSGS_USER = "findReadStatusByMsgIds";
    private static final String QUERY_FIND_PENDING_MSGS_BY_CONTEXT_AND_USER_AND_PERMISSION_LEVEL = "findAllPendingMsgsByContextByMembershipByPermissionLevel";
    private static final String QUERY_FIND_PENDING_MSGS_BY_CONTEXT_AND_USER_AND_PERMISSION_LEVEL_NAME = "findAllPendingMsgsByContextByMembershipByPermissionLevelName";
    private static final String QUERY_FIND_PENDING_MSGS_BY_TOPICID = "findPendingMsgsByTopicId";
    private static final String QUERY_UNDELETED_MSG_BY_TOPIC_ID = "findUndeletedMessagesByTopicId";
    private static final String MESSAGECENTER_HELPER_TOOL_ID = "sakai.messageforums.helper";
    private IdManager idManager;
    private MessageForumsTypeManager typeManager;
    private SessionManager sessionManager;
    private EventTrackingService eventTrackingService;
    private ContentHostingService contentHostingService;

    public void init() {
        LOG.info((Object)"init()");
    }

    public EventTrackingService getEventTrackingService() {
        return this.eventTrackingService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public MessageForumsTypeManager getTypeManager() {
        return this.typeManager;
    }

    public void setTypeManager(MessageForumsTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setIdManager(IdManager idManager) {
        this.idManager = idManager;
    }

    public IdManager getIdManager() {
        return this.idManager;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public List<Object[]> findDiscussionForumMessageCountsForTopicsWithMissingPermsForAllSites(final List<String> siteList) {
        if (siteList == null) {
            LOG.error((Object)"findDiscussionForumMessageCountsForTopicsWithMissingPermsForAllSites failed with null site list.");
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findDiscussionForumMessageCountsForTopicsWithMissingPermsForAllSites");
                q.setParameterList("siteList", (Collection)siteList);
                q.setParameter("userId", (Object)MessageForumsMessageManagerImpl.this.getCurrentUser(), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<Object[]> findDiscussionForumReadMessageCountsForTopicsWithMissingPermsForAllSites(final List<String> siteList) {
        if (siteList == null) {
            LOG.error((Object)"findDiscussionForumReadMessageCountsForTopicsWithMissingPermsForAllSites failed with null site list.");
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findDiscussionForumReadMessageCountsForTopicsWithMissingPermsForAllSites");
                q.setParameterList("siteList", (Collection)siteList);
                q.setParameter("userId", (Object)MessageForumsMessageManagerImpl.this.getCurrentUser(), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List findDiscussionForumMessageCountsForAllSitesByPermissionLevelId(final List siteList, final List roleList) {
        if (siteList == null) {
            LOG.error((Object)"findDiscussionForumMessageCountsForAllSitesByPermissionLevelId failed with null site list.");
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findDiscussionForumMessageCountsForAllSitesByPermissionLevelId");
                q.setParameterList("siteList", (Collection)siteList);
                q.setParameterList("roleList", (Collection)roleList);
                q.setParameter("userId", (Object)MessageForumsMessageManagerImpl.this.getCurrentUser(), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List findDiscussionForumMessageCountsForAllSitesByPermissionLevelName(final List siteList, final List roleList) {
        if (siteList == null) {
            LOG.error((Object)"findDiscussionForumMessageCountsForAllSitesByPermissionLevelName failed with null site list.");
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findDiscussionForumMessageCountsForAllSitesByPermissionLevelName");
                q.setParameterList("siteList", (Collection)siteList);
                q.setParameterList("roleList", (Collection)roleList);
                q.setParameter("userId", (Object)MessageForumsMessageManagerImpl.this.getCurrentUser(), (Type)Hibernate.STRING);
                q.setParameter("customTypeUuid", (Object)MessageForumsMessageManagerImpl.this.typeManager.getCustomLevelType(), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List findDiscussionForumReadMessageCountsForAllSitesByPermissionLevelId(final List siteList, final List roleList) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findDiscussionForumReadMessageCountsForAllSitesByPermissionLevelId");
                q.setParameterList("siteList", (Collection)siteList);
                q.setParameterList("roleList", (Collection)roleList);
                q.setParameter("userId", (Object)MessageForumsMessageManagerImpl.this.getCurrentUser(), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List findDiscussionForumReadMessageCountsForAllSitesByPermissionLevelName(final List siteList, final List roleList) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findDiscussionForumReadMessageCountsForAllSitesByPermissionLevelName");
                q.setParameterList("siteList", (Collection)siteList);
                q.setParameterList("roleList", (Collection)roleList);
                q.setParameter("userId", (Object)MessageForumsMessageManagerImpl.this.getCurrentUser(), (Type)Hibernate.STRING);
                q.setParameter("customTypeUuid", (Object)MessageForumsMessageManagerImpl.this.typeManager.getCustomLevelType(), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List findDiscussionForumMessageCountsForGroupedSitesByTopic(final List siteList, final List roleList) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findDiscussionForumMessageCountsForGroupedSitesByTopic");
                q.setParameterList("siteList", (Collection)siteList);
                q.setParameterList("roleList", (Collection)roleList);
                q.setParameter("userId", (Object)MessageForumsMessageManagerImpl.this.getCurrentUser(), (Type)Hibernate.STRING);
                q.setParameter("customTypeUuid", (Object)MessageForumsMessageManagerImpl.this.typeManager.getCustomLevelType(), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List findDiscussionForumReadMessageCountsForGroupedSitesByTopic(final List siteList, final List roleList) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findDiscussionForumReadMessageCountsForGroupedSitesByTopic");
                q.setParameterList("siteList", (Collection)siteList);
                q.setParameterList("roleList", (Collection)roleList);
                q.setParameter("userId", (Object)MessageForumsMessageManagerImpl.this.getCurrentUser(), (Type)Hibernate.STRING);
                q.setParameter("customTypeUuid", (Object)MessageForumsMessageManagerImpl.this.typeManager.getCustomLevelType(), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public int findAuhtoredMessageCountByTopicIdByUserId(final Long topicId, final String userId) {
        if (topicId == null || userId == null) {
            LOG.error((Object)("findAuthoredMessageCountByTopicIdByUserId failed with topicId: " + topicId + " and userId: " + userId));
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("findAuthoredMessageCountByTopicIdByUserId executing with topicId: " + topicId + " and userId: " + userId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsMessageManagerImpl.QUERY_COUNT_BY_AUTHORED);
                q.setParameter("topicId", (Object)topicId, (Type)Hibernate.LONG);
                q.setParameter("userId", (Object)userId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    public int findAuthoredMessageCountForStudent(final String userId) {
        if (userId == null) {
            LOG.error((Object)"findAuthoredMessageCountForStudentInSite failed with a null userId");
            throw new IllegalArgumentException("userId cannot be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("findAuthoredMessageCountForStudentInSite executing with userId: " + userId));
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findAuthoredMessageCountForStudentInSite");
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameter("userId", (Object)userId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    public List<Message> findAuthoredMessagesForStudent(final String studentId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findReadMessagesForCurrentStudent()");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findAuthoredMessagesForStudent");
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameter("userId", (Object)studentId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<Message> findAuthoredMessagesForStudentByTopicId(final String studentId, final Long topicId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findReadMessagesForCurrentStudentByTopicId()");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findAuthoredMessagesForStudentByTopicId");
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameter("userId", (Object)studentId, (Type)Hibernate.STRING);
                q.setParameter("topicId", (Object)topicId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<Message> findAuthoredMessagesForStudentByForumId(final String studentId, final Long forumId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findAuthoredMessagesForStudentByForumId()");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findAuthoredMessagesForStudentByForumId");
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameter("userId", (Object)studentId, (Type)Hibernate.STRING);
                q.setParameter("forumId", (Object)forumId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<Object[]> findAuthoredMessageCountForAllStudents() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findAuthoredMessageCountForAllStudents executing");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findAuthoredMessageCountForAllStudents");
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<Object[]> findAuthoredMessageCountForAllStudentsByTopicId(final Long topicId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findAuthoredMessageCountForAllStudentsByTopicId executing");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findAuthoredMessageCountForAllStudentsByTopicId");
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameter("topicId", (Object)topicId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<Object[]> findAuthoredMessageCountForAllStudentsByForumId(final Long forumId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findAuthoredMessageCountForAllStudentsByForumId executing");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findAuthoredMessageCountForAllStudentsByForumId");
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameter("forumId", (Object)forumId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public int findReadMessageCountByTopicIdByUserId(final Long topicId, final String userId) {
        if (topicId == null || userId == null) {
            LOG.error((Object)("findReadMessageCountByTopicIdByUserId failed with topicId: " + topicId + " and userId: " + userId));
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("findReadMessageCountByTopicIdByUserId executing with topicId: " + topicId + " and userId: " + userId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsMessageManagerImpl.QUERY_COUNT_BY_READ);
                q.setParameter("topicId", (Object)topicId, (Type)Hibernate.LONG);
                q.setParameter("userId", (Object)userId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    public int findReadMessageCountForStudent(final String userId) {
        if (userId == null) {
            LOG.error((Object)"findReadMessageCountForStudent failed with null userId");
            throw new IllegalArgumentException("userId cannot be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("findReadMessageCountForStudent executing with userId: " + userId));
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findReadMessageCountForStudent");
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameter("userId", (Object)userId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    public List<Message> findReadMessagesForStudent(final String studentId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findReadMessagesForCurrentStudent()");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findReadMessagesForStudent");
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameter("userId", (Object)studentId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<Message> findReadMessagesForStudentByTopicId(final String studentId, final Long topicId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findReadMessagesForCurrentStudentByTopicId()");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findReadMessagesForStudentByTopicId");
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameter("userId", (Object)studentId, (Type)Hibernate.STRING);
                q.setParameter("topicId", (Object)topicId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<Message> findReadMessagesForStudentByForumId(final String studentId, final Long forumId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findReadMessagesForStudentByForumId()");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findReadMessagesForStudentByForumId");
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameter("userId", (Object)studentId, (Type)Hibernate.STRING);
                q.setParameter("forumId", (Object)forumId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<Object[]> findReadMessageCountForAllStudents() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findReadMessageCountForAllStudentsInSite executing");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findReadMessageCountForAllStudents");
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<Object[]> findReadMessageCountForAllStudentsByTopicId(final Long topicId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findReadMessageCountForAllStudentsByTopicId executing");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findReadMessageCountForAllStudentsByTopicId");
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameter("topicId", (Object)topicId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<Object[]> findReadMessageCountForAllStudentsByForumId(final Long forumId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findReadMessageCountForAllStudentsByForumId executing");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findReadMessageCountForAllStudentsByForumId");
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameter("forumId", (Object)forumId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public int findViewableMessageCountByTopicIdByUserId(final Long topicId, final String userId) {
        if (topicId == null || userId == null) {
            LOG.error((Object)("findViewableMessageCountByTopicIdByUserId failed with topicId: " + topicId + " and userId: " + userId));
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("findViewableMessageCountByTopicIdByUserId executing with topicId: " + topicId + " and userId: " + userId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsMessageManagerImpl.QUERY_COUNT_VIEWABLE_BY_TOPIC_ID);
                q.setParameter("topicId", (Object)topicId, (Type)Hibernate.LONG);
                q.setParameter("userId", (Object)userId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    public int findViewableMessageCountByTopicId(Long topicId) {
        if (topicId == null) {
            LOG.error((Object)"findViewableMessageCountByTopicId failed with topicId: null");
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("findViewableMessageCountByTopicId executing with topicId: " + topicId));
        if (this.getCurrentUser() != null) {
            return this.findViewableMessageCountByTopicIdByUserId(topicId, this.getCurrentUser());
        }
        return 0;
    }

    public int findUnreadMessageCountByTopicIdByUserId(Long topicId, String userId) {
        if (topicId == null || userId == null) {
            LOG.error((Object)("findUnreadMessageCountByTopicIdByUserId failed with topicId: " + topicId + " and userId: " + userId));
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("findUnreadMessageCountByTopicIdByUserId executing with topicId: " + topicId));
        return this.findMessageCountByTopicId(topicId) - this.findReadMessageCountByTopicIdByUserId(topicId, userId);
    }

    public int findUnreadMessageCountByTopicId(Long topicId) {
        if (topicId == null) {
            LOG.error((Object)"findUnreadMessageCountByTopicId failed with topicId: null");
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("findUnreadMessageCountByTopicId executing with topicId: " + topicId));
        return this.findMessageCountByTopicId(topicId) - this.findReadMessageCountByTopicId(topicId);
    }

    public int findUnreadViewableMessageCountByTopicIdByUserId(Long topicId, String userId) {
        if (topicId == null) {
            LOG.error((Object)("findUnreadViewableMessageCountByTopicIdByUserId failed with topicId: null and userid: " + userId));
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("findUnreadViewableMessageCountByTopicIdByUserId executing with topicId: " + topicId + " userId: " + userId));
        return this.findViewableMessageCountByTopicIdByUserId(topicId, userId) - this.findReadViewableMessageCountByTopicIdByUserId(topicId, userId);
    }

    public int findUnreadViewableMessageCountByTopicId(Long topicId) {
        if (topicId == null) {
            LOG.error((Object)"findUnreadViewableMessageCountByTopicId failed with topicId: null");
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("findUnreadViewableMessageCountByTopicId executing with topicId: " + topicId));
        if (this.getCurrentUser() != null) {
            return this.findUnreadViewableMessageCountByTopicIdByUserId(topicId, this.getCurrentUser());
        }
        return 0;
    }

    public int findReadMessageCountByTopicId(Long topicId) {
        if (topicId == null) {
            LOG.error((Object)"findReadMessageCountByTopicId failed with topicId: Null");
            throw new IllegalArgumentException("Null Argument");
        }
        if (this.getCurrentUser() != null) {
            return this.findReadMessageCountByTopicIdByUserId(topicId, this.getCurrentUser());
        }
        return 0;
    }

    public int findReadViewableMessageCountByTopicIdByUserId(final Long topicId, final String userId) {
        if (topicId == null || userId == null) {
            LOG.error((Object)("findReadViewableMessageCountByTopicIdByUserId failed with topicId: " + topicId + " and userId: " + userId));
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("findReadViewableMessageCountByTopicIdByUserId executing with topicId: " + topicId + " and userId: " + userId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsMessageManagerImpl.QUERY_COUNT_READ_VIEWABLE_BY_TOPIC_ID);
                q.setParameter("topicId", (Object)topicId, (Type)Hibernate.LONG);
                q.setParameter("userId", (Object)userId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    public int findReadViewableMessageCountByTopicId(Long topicId) {
        if (topicId == null) {
            LOG.error((Object)"findReadViewableMessageCountByTopicId failed with topicId: null");
            throw new IllegalArgumentException("Null Argument");
        }
        if (this.getCurrentUser() != null) {
            return this.findReadViewableMessageCountByTopicIdByUserId(topicId, this.getCurrentUser());
        }
        return 0;
    }

    public List findMessagesByTopicId(final Long topicId) {
        if (topicId == null) {
            LOG.error((Object)"findMessagesByTopicId failed with topicId: null");
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("findMessagesByTopicId executing with topicId: " + topicId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsMessageManagerImpl.QUERY_BY_TOPIC_ID);
                q.setParameter("topicId", (Object)topicId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List findUndeletedMessagesByTopicId(final Long topicId) {
        if (topicId == null) {
            LOG.error((Object)"findUndeletedMessagesByTopicId failed with topicId: null");
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("findUndeletedMessagesByTopicId executing with topicId: " + topicId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsMessageManagerImpl.QUERY_UNDELETED_MSG_BY_TOPIC_ID);
                q.setParameter("topicId", (Object)topicId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public int findMessageCountByTopicId(final Long topicId) {
        if (topicId == null) {
            LOG.error((Object)"findMessageCountByTopicId failed with topicId: null");
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("findMessageCountByTopicId executing with topicId: " + topicId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findMessageCountByTopicId");
                q.setParameter("topicId", (Object)topicId, (Type)Hibernate.LONG);
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    public int findMessageCountByForumId(final Long forumId) {
        if (forumId == null) {
            LOG.error((Object)("findMessageCountByForumId failed with forumId: " + forumId));
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("findMessageCountByForumId executing with forumId: " + forumId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findMessageCountByForumId");
                q.setParameter("forumId", (Object)forumId, (Type)Hibernate.LONG);
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    public List<Object[]> findMessageCountsForMainPage(final Collection<Long> topicIds) {
        if (topicIds.isEmpty()) {
            return new ArrayList<Object[]>();
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsMessageManagerImpl.QUERY_MESSAGE_COUNTS_FOR_MAIN_PAGE);
                q.setParameterList("topicIds", topicIds);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<Object[]> findReadMessageCountsForMainPage(final Collection<Long> topicIds) {
        if (topicIds.isEmpty()) {
            return new ArrayList<Object[]>();
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsMessageManagerImpl.QUERY_READ_MESSAGE_COUNTS_FOR_MAIN_PAGE);
                q.setParameterList("topicIds", topicIds);
                q.setParameter("userId", (Object)MessageForumsMessageManagerImpl.this.getCurrentUser());
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public int findMessageCountTotal() {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findMessageCountTotal");
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    public UnreadStatus findUnreadStatusByUserId(final Long topicId, final Long messageId, final String userId) {
        if (messageId == null || topicId == null || userId == null) {
            LOG.error((Object)("findUnreadStatusByUserId failed with topicId: " + topicId + ", messageId: " + messageId + ", userId: " + userId));
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("findUnreadStatus executing with topicId: " + topicId + ", messageId: " + messageId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsMessageManagerImpl.QUERY_UNREAD_STATUS);
                q.setParameter("topicId", (Object)topicId, (Type)Hibernate.LONG);
                q.setParameter("messageId", (Object)messageId, (Type)Hibernate.LONG);
                q.setParameter("userId", (Object)userId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (UnreadStatus)this.getHibernateTemplate().execute(hcb);
    }

    public UnreadStatus findUnreadStatus(Long topicId, Long messageId) {
        if (messageId == null || topicId == null) {
            LOG.error((Object)("findUnreadStatus failed with topicId: " + topicId + ", messageId: " + messageId));
            throw new IllegalArgumentException("Null Argument");
        }
        if (this.getCurrentUser() != null) {
            return this.findUnreadStatusByUserId(topicId, messageId, this.getCurrentUser());
        }
        return null;
    }

    public void deleteUnreadStatus(Long topicId, Long messageId) {
        if (messageId == null || topicId == null) {
            LOG.error((Object)("deleteUnreadStatus failed with topicId: " + topicId + ", messageId: " + messageId));
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("deleteUnreadStatus executing with topicId: " + topicId + ", messageId: " + messageId));
        UnreadStatus status = this.findUnreadStatus(topicId, messageId);
        if (status != null) {
            this.getHibernateTemplate().delete((Object)status);
        }
    }

    private boolean isMessageFromForums(Message message) {
        return message.getTopic() != null;
    }

    public void markMessageReadForUser(Long topicId, Long messageId, boolean read) {
        if (messageId == null || topicId == null) {
            LOG.error((Object)("markMessageReadForUser failed with topicId: " + topicId + ", messageId: " + messageId));
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("markMessageReadForUser executing with topicId: " + topicId + ", messageId: " + messageId));
        if (this.getCurrentUser() == null) {
            return;
        }
        this.markMessageReadForUser(topicId, messageId, read, this.getCurrentUser());
    }

    public void markMessageReadForUser(Long topicId, Long messageId, boolean read, String userId) {
        this.markMessageReadForUser(topicId, messageId, read, userId, ToolManager.getCurrentPlacement().getContext(), ToolManager.getCurrentTool().getId());
    }

    public void markMessageReadForUser(Long topicId, Long messageId, boolean read, String userId, String context, String toolId) {
        boolean originalReadStatus;
        boolean trulyUnread;
        if (messageId == null || topicId == null || userId == null) {
            LOG.error((Object)("markMessageReadForUser failed with topicId: " + topicId + ", messageId: " + messageId + ", userId: " + userId));
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("markMessageReadForUser executing with topicId: " + topicId + ", messageId: " + messageId));
        UnreadStatus status = this.findUnreadStatusByUserId(topicId, messageId, userId);
        if (status == null) {
            status = new UnreadStatusImpl();
            trulyUnread = true;
            originalReadStatus = false;
        } else {
            trulyUnread = status.getRead();
            trulyUnread = !trulyUnread;
            originalReadStatus = status.getRead();
        }
        status.setTopicId(topicId);
        status.setMessageId(messageId);
        status.setUserId(userId);
        status.setRead(Boolean.valueOf(read));
        Message message = this.getMessageById(messageId);
        boolean isMessageFromForums = this.isMessageFromForums(message);
        if (trulyUnread) {
            Integer nr = message.getNumReaders();
            if (nr == null) {
                nr = 0;
            }
            nr = nr + 1;
            message.setNumReaders(nr);
            LOG.debug((Object)("set Message readers count to: " + nr));
            if (message.getTopic().getBaseForum() == null && message.getTopic().getOpenForum() != null) {
                message.getTopic().setBaseForum((BaseForum)message.getTopic().getOpenForum());
            }
            this.saveMessage(message, true, toolId, userId, context, true);
            if (isMessageFromForums) {
                this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.read", this.getEventMessage(message, toolId, userId, context), false));
            } else {
                this.eventTrackingService.post(this.eventTrackingService.newEvent("messages.read", this.getEventMessage(message, toolId, userId, context), false));
            }
        }
        this.getHibernateTemplate().saveOrUpdate((Object)status);
        if (isMessageFromForums) {
            if (!originalReadStatus && read) {
                this.decrementForumSynopticToolInfo(userId, context, 20);
            } else if (originalReadStatus && !read) {
                this.incrementForumSynopticToolInfo(userId, context, 20);
            }
        } else if (!originalReadStatus && read) {
            this.decrementMessagesSynopticToolInfo(userId, context, 20);
        } else if (originalReadStatus && !read) {
            this.incrementMessagesSynopticToolInfo(userId, context, 20);
        }
    }

    public void decrementForumSynopticToolInfo(String userId, String siteId, int numOfAttempts) {
        try {
            SynopticMsgcntrManagerCover.decrementForumSynopticToolInfo((String)userId, (String)siteId);
        }
        catch (HibernateOptimisticLockingFailureException holfe) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (--numOfAttempts <= 0) {
                System.out.println("MessageForumsMessageManagerImpl: decrementForumSynopticToolInfo: HibernateOptimisticLockingFailureException no more retries left");
                holfe.printStackTrace();
            }
            System.out.println("MessageForumsMessageManagerImpl: decrementForumSynopticToolInfo: HibernateOptimisticLockingFailureException: attempts left: " + numOfAttempts);
            this.decrementForumSynopticToolInfo(userId, siteId, numOfAttempts);
        }
    }

    public void incrementForumSynopticToolInfo(String userId, String siteId, int numOfAttempts) {
        try {
            SynopticMsgcntrManagerCover.incrementForumSynopticToolInfo((String)userId, (String)siteId);
        }
        catch (HibernateOptimisticLockingFailureException holfe) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (--numOfAttempts <= 0) {
                System.out.println("MessageForumsMessageManagerImpl: incrementForumSynopticToolInfo: HibernateOptimisticLockingFailureException no more retries left");
                holfe.printStackTrace();
            }
            System.out.println("MessageForumsMessageManagerImpl: incrementForumSynopticToolInfo: HibernateOptimisticLockingFailureException: attempts left: " + numOfAttempts);
            this.incrementForumSynopticToolInfo(userId, siteId, numOfAttempts);
        }
    }

    public void decrementMessagesSynopticToolInfo(String userId, String siteId, int numOfAttempts) {
        try {
            SynopticMsgcntrManagerCover.decrementMessagesSynopticToolInfo((String)userId, (String)siteId);
        }
        catch (HibernateOptimisticLockingFailureException holfe) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (--numOfAttempts <= 0) {
                System.out.println("MessageForumsMessageManagerImpl: decrementMessagesSynopticToolInfo: HibernateOptimisticLockingFailureException no more retries left");
                holfe.printStackTrace();
            }
            System.out.println("MessageForumsMessageManagerImpl: decrementMessagesSynopticToolInfo: HibernateOptimisticLockingFailureException: attempts left: " + numOfAttempts);
            this.decrementMessagesSynopticToolInfo(userId, siteId, numOfAttempts);
        }
    }

    public void incrementMessagesSynopticToolInfo(String userId, String siteId, int numOfAttempts) {
        try {
            SynopticMsgcntrManagerCover.incrementMessagesSynopticToolInfo((String)userId, (String)siteId);
        }
        catch (HibernateOptimisticLockingFailureException holfe) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (--numOfAttempts <= 0) {
                System.out.println("MessageForumsMessageManagerImpl: incrementMessagesSynopticToolInfo: HibernateOptimisticLockingFailureException no more retries left");
                holfe.printStackTrace();
            }
            System.out.println("MessageForumsMessageManagerImpl: incrementMessagesSynopticToolInfo: HibernateOptimisticLockingFailureException: attempts left: " + numOfAttempts);
            this.incrementMessagesSynopticToolInfo(userId, siteId, numOfAttempts);
        }
    }

    public boolean isMessageReadForUser(Long topicId, Long messageId) {
        if (messageId == null || topicId == null) {
            LOG.error((Object)("getMessageById failed with topicId: " + topicId + ", messageId: " + messageId));
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getMessageById executing with topicId: " + topicId + ", messageId: " + messageId));
        UnreadStatus status = this.findUnreadStatus(topicId, messageId);
        if (status == null) {
            return false;
        }
        return status.getRead();
    }

    public PrivateMessage createPrivateMessage() {
        PrivateMessageImpl message = new PrivateMessageImpl();
        message.setUuid(this.getNextUuid());
        message.setTypeUuid(this.typeManager.getPrivateMessageAreaType());
        message.setCreated(new Date());
        message.setCreatedBy(this.getCurrentUser());
        message.setDraft(Boolean.FALSE);
        message.setHasAttachments(Boolean.FALSE);
        LOG.debug((Object)("message " + message.getUuid() + " created successfully"));
        return message;
    }

    public Message createDiscussionMessage() {
        return this.createMessage(this.typeManager.getDiscussionForumType());
    }

    public Message createOpenMessage() {
        return this.createMessage(this.typeManager.getOpenDiscussionForumType());
    }

    public Message createMessage(String typeId) {
        MessageImpl message = new MessageImpl();
        message.setUuid(this.getNextUuid());
        message.setTypeUuid(typeId);
        message.setCreated(new Date());
        message.setCreatedBy(this.getCurrentUser());
        message.setDraft(Boolean.FALSE);
        message.setHasAttachments(Boolean.FALSE);
        LOG.debug((Object)("message " + message.getUuid() + " created successfully"));
        return message;
    }

    public Attachment createAttachment() {
        AttachmentImpl attachment = new AttachmentImpl();
        attachment.setUuid(this.getNextUuid());
        attachment.setCreated(new Date());
        attachment.setCreatedBy(this.getCurrentUser());
        attachment.setModified(new Date());
        attachment.setModifiedBy(this.getCurrentUser());
        LOG.debug((Object)("attachment " + attachment.getUuid() + " created successfully"));
        return attachment;
    }

    public void saveMessage(Message message) {
        this.saveMessage(message, true);
    }

    public void saveMessage(Message message, boolean logEvent) {
        this.saveMessage(message, logEvent, ToolManager.getCurrentTool().getId(), this.getCurrentUser(), this.getContextId());
    }

    public void saveMessage(Message message, boolean logEvent, boolean ignoreLockedTopicForum) {
        this.saveMessage(message, logEvent, ToolManager.getCurrentTool().getId(), this.getCurrentUser(), this.getContextId(), ignoreLockedTopicForum);
    }

    public void saveMessage(Message message, boolean logEvent, String toolId, String userId, String contextId) {
        this.saveMessage(message, logEvent, toolId, userId, contextId, false);
    }

    public void saveMessage(Message message, boolean logEvent, String toolId, String userId, String contextId, boolean ignoreLockedTopicForum) {
        boolean isNew;
        boolean bl = isNew = message.getId() == null;
        if (!ignoreLockedTopicForum && !(message instanceof PrivateMessage) && this.isForumOrTopicLocked(message.getTopic().getBaseForum().getId(), message.getTopic().getId())) {
            LOG.info((Object)("saveMessage executed [messageId: " + (isNew ? "new" : message.getId().toString()) + "] but forum is locked -- save aborted"));
            throw new LockedException("Message could not be saved [messageId: " + (isNew ? "new" : message.getId().toString()) + "]");
        }
        message.setModified(new Date());
        if (this.getCurrentUser() != null) {
            message.setModifiedBy(this.getCurrentUser());
        }
        if (message.getUuid() == null || message.getCreated() == null || message.getCreatedBy() == null || message.getModified() == null || message.getModifiedBy() == null || message.getTitle() == null || message.getAuthor() == null || message.getHasAttachments() == null || message.getTypeUuid() == null || message.getDraft() == null) {
            LOG.error((Object)"null attribute(s) for saving message in MessageForumsMessageManagerImpl.saveMessage");
        }
        if (message.getNumReaders() == null) {
            message.setNumReaders(Integer.valueOf(0));
        }
        if (logEvent && isNew && message.getDateThreadlastUpdated() == null) {
            message.setDateThreadlastUpdated(new Date());
            if (message.getInReplyTo() != null) {
                if (message.getInReplyTo().getThreadId() != null) {
                    message.setThreadId(message.getInReplyTo().getThreadId());
                } else {
                    message.setThreadId(message.getInReplyTo().getId());
                }
            }
        }
        this.getHibernateTemplate().saveOrUpdate((Object)message);
        if (logEvent) {
            if (isNew) {
                if (this.isMessageFromForums(message)) {
                    this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.new", this.getEventMessage(message, toolId, userId, contextId), false));
                } else {
                    this.eventTrackingService.post(this.eventTrackingService.newEvent("messages.new", this.getEventMessage(message, toolId, userId, contextId), false));
                }
            } else if (this.isMessageFromForums(message)) {
                this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.response", this.getEventMessage(message, toolId, userId, contextId), false));
            } else {
                this.eventTrackingService.post(this.eventTrackingService.newEvent("messages.reply", this.getEventMessage(message, toolId, userId, contextId), false));
            }
        }
        LOG.debug((Object)("message " + message.getId() + " saved successfully"));
    }

    public void deleteMessage(Message message) {
        long id = message.getId();
        message.setInReplyTo(null);
        this.getHibernateTemplate().saveOrUpdate((Object)message);
        try {
            this.getSession().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.isMessageFromForums(message)) {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.delete", this.getEventMessage(message), false));
        } else {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("messages.delete", this.getEventMessage(message), false));
        }
        try {
            this.getSession().evict((Object)message);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error((Object)("could not evict message: " + message.getId()), (Throwable)e);
        }
        Topic topic = message.getTopic();
        topic.removeMessage(message);
        this.getHibernateTemplate().saveOrUpdate((Object)topic);
        try {
            this.getSession().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOG.debug((Object)("message " + id + " deleted successfully"));
    }

    public Message getMessageById(Long messageId) {
        if (messageId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getMessageById executing with messageId: " + messageId));
        return (Message)this.getHibernateTemplate().get(MessageImpl.class, (Serializable)messageId);
    }

    public Message getMessageByIdWithAttachments(final Long messageId) {
        if (messageId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getMessageByIdWithAttachments executing with messageId: " + messageId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsMessageManagerImpl.QUERY_BY_MESSAGE_ID_WITH_ATTACHMENTS);
                q.setParameter("id", (Object)messageId, (Type)Hibernate.LONG);
                return q.uniqueResult();
            }
        };
        return (Message)this.getHibernateTemplate().execute(hcb);
    }

    public Attachment getAttachmentById(Long attachmentId) {
        if (attachmentId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getAttachmentById executing with attachmentId: " + attachmentId));
        return (Attachment)this.getHibernateTemplate().get(AttachmentImpl.class, (Serializable)attachmentId);
    }

    public void getChildMsgs(final Long messageId, List returnList) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsMessageManagerImpl.QUERY_CHILD_MESSAGES);
                Query qOrdered = session.createQuery(q.getQueryString());
                qOrdered.setParameter("messageId", (Object)messageId, (Type)Hibernate.LONG);
                return qOrdered.list();
            }
        };
        List tempList = (List)this.getHibernateTemplate().execute(hcb);
        if (tempList != null) {
            for (int i = 0; i < tempList.size(); ++i) {
                this.getChildMsgs(((Message)tempList.get(i)).getId(), returnList);
                returnList.add((Message)tempList.get(i));
            }
        }
    }

    public void markMessageApproval(Long messageId, boolean approved) {
        if (messageId == null) {
            LOG.error((Object)"markMessageApproval failed with messageId: null");
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("markMessageApproval executing with messageId: " + messageId));
        Message message = this.getMessageById(messageId);
        message.setApproved(Boolean.valueOf(approved));
        this.getHibernateTemplate().saveOrUpdate((Object)message);
    }

    public void deleteMsgWithChild(Long messageId) {
        ArrayList thisList = new ArrayList();
        this.getChildMsgs(messageId, thisList);
        for (int i = 0; i < thisList.size(); ++i) {
            Message delMessage = this.getMessageById(((Message)thisList.get(i)).getId());
            this.deleteMessage(delMessage);
        }
        this.deleteMessage(this.getMessageById(messageId));
    }

    public List getFirstLevelChildMsgs(final Long messageId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsMessageManagerImpl.QUERY_CHILD_MESSAGES);
                Query qOrdered = session.createQuery(q.getQueryString());
                qOrdered.setParameter("messageId", (Object)messageId, (Type)Hibernate.LONG);
                return qOrdered.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    public List sortMessageBySubject(Topic topic, boolean asc) {
        List list = topic.getMessages();
        if (asc) {
            Collections.sort(list, MessageImpl.SUBJECT_COMPARATOR);
        } else {
            Collections.sort(list, MessageImpl.SUBJECT_COMPARATOR_DESC);
        }
        topic.setMessages(list);
        return list;
    }

    public List sortMessageByAuthor(Topic topic, boolean asc) {
        List list = topic.getMessages();
        if (asc) {
            Collections.sort(list, MessageImpl.AUTHORED_BY_COMPARATOR);
        } else {
            Collections.sort(list, MessageImpl.AUTHORED_BY_COMPARATOR_DESC);
        }
        topic.setMessages(list);
        return list;
    }

    public List sortMessageByDate(Topic topic, boolean asc) {
        List list = topic.getMessages();
        if (asc) {
            Collections.sort(list, MessageImpl.DATE_COMPARATOR);
        } else {
            Collections.sort(list, MessageImpl.DATE_COMPARATOR_DESC);
        }
        topic.setMessages(list);
        return list;
    }

    public List sortMessageByDate(List list, boolean asc) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (asc) {
            Collections.sort(list, MessageImpl.DATE_COMPARATOR);
        } else {
            Collections.sort(list, MessageImpl.DATE_COMPARATOR_DESC);
        }
        return list;
    }

    private boolean isForumOrTopicLocked(final Long forumId, final Long topicId) {
        if (forumId == null || topicId == null) {
            LOG.error((Object)"isForumLocked called with null arguments");
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("isForumLocked executing with forumId: " + forumId + ":: topicId: " + topicId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findForumLockedAttribute");
                q.setParameter("id", (Object)forumId, (Type)Hibernate.LONG);
                return q.uniqueResult();
            }
        };
        HibernateCallback hcb2 = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findTopicLockedAttribute");
                q.setParameter("id", (Object)topicId, (Type)Hibernate.LONG);
                return q.uniqueResult();
            }
        };
        return (Boolean)this.getHibernateTemplate().execute(hcb) != false || (Boolean)this.getHibernateTemplate().execute(hcb2) != false;
    }

    private String getCurrentUser() {
        if (TestUtil.isRunningTests()) {
            return "test-user";
        }
        return this.sessionManager.getCurrentSessionUserId();
    }

    private String getNextUuid() {
        return this.idManager.createUuid();
    }

    private String getEventMessage(Object object) {
        return this.getEventMessage(object, ToolManager.getCurrentTool().getId(), this.getCurrentUser(), this.getContextId());
    }

    private String getEventMessage(Object object, String toolId, String userId, String contextId) {
        String eventMessagePrefix = "";
        eventMessagePrefix = toolId.equals("sakai.messagecenter") ? "/messagesAndForums/site/" : (toolId.equals("sakai.messages") ? "/messages/site/" : "/forums/site/");
        return eventMessagePrefix + contextId + "/" + object.toString() + "/" + userId;
    }

    public List getAllRelatedMsgs(Long messageId) {
        Message rootMsg = this.getMessageById(messageId);
        while (rootMsg.getInReplyTo() != null) {
            rootMsg = rootMsg.getInReplyTo();
        }
        ArrayList childList = new ArrayList();
        this.getChildMsgs(rootMsg.getId(), childList);
        ArrayList<Message> returnList = new ArrayList<Message>();
        returnList.add(rootMsg);
        for (int i = 0; i < childList.size(); ++i) {
            returnList.add((Message)childList.get(i));
        }
        return returnList;
    }

    public List findPvtMsgsBySearchText(final String typeUuid, final String searchText, final Date searchFromDate, final Date searchToDate, final boolean searchByText, final boolean searchByAuthor, final boolean searchByBody, final boolean searchByLabel, final boolean searchByDate) {
        LOG.debug((Object)("findPvtMsgsBySearchText executing with searchText: " + searchText));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findPvtMsgsBySearchText");
                q.setParameter("searchText", (Object)("%" + searchText + "%"));
                q.setParameter("searchByText", (Object)MessageForumsMessageManagerImpl.this.convertBooleanToInteger(searchByText));
                q.setParameter("searchByAuthor", (Object)MessageForumsMessageManagerImpl.this.convertBooleanToInteger(searchByAuthor));
                q.setParameter("searchByBody", (Object)MessageForumsMessageManagerImpl.this.convertBooleanToInteger(searchByBody));
                q.setParameter("searchByLabel", (Object)MessageForumsMessageManagerImpl.this.convertBooleanToInteger(searchByLabel));
                q.setParameter("searchByDate", (Object)MessageForumsMessageManagerImpl.this.convertBooleanToInteger(searchByDate));
                q.setParameter("searchFromDate", (Object)(searchFromDate == null ? new Date(0L) : searchFromDate));
                q.setParameter("searchToDate", (Object)(searchToDate == null ? new Date(System.currentTimeMillis()) : searchToDate));
                q.setParameter("userId", (Object)MessageForumsMessageManagerImpl.this.getCurrentUser());
                q.setParameter("contextId", (Object)ToolManager.getCurrentPlacement().getContext());
                q.setParameter("typeUuid", (Object)typeUuid);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    private Integer convertBooleanToInteger(boolean value) {
        Integer retVal = Boolean.TRUE.equals(value) ? 1 : 0;
        return (int)retVal;
    }

    private String getContextId() {
        if (TestUtil.isRunningTests()) {
            return "test-context";
        }
        Placement placement = ToolManager.getCurrentPlacement();
        String presentSiteId = placement.getContext();
        return presentSiteId;
    }

    public String getAttachmentUrl(String id) {
        try {
            return this.contentHostingService.getResource(id).getUrl(false);
        }
        catch (Exception e) {
            LOG.error((Object)("MessageForumsMessageManagerImpl.getAttachmentUrl" + e), (Throwable)e);
            return null;
        }
    }

    public String getAttachmentRelativeUrl(String id) {
        try {
            return this.contentHostingService.getResource(id).getUrl(true);
        }
        catch (Exception e) {
            LOG.error((Object)("MessageForumsMessageManagerImpl.getAttachmentUrl" + e), (Throwable)e);
            return null;
        }
    }

    public boolean currentToolMatch(String toolId) {
        String curToolId = ToolManager.getCurrentTool().getId();
        if (curToolId.equals(MESSAGECENTER_HELPER_TOOL_ID)) {
            curToolId = ToolManager.getCurrentPlacement().getTool().getId();
        }
        return toolId.equals(curToolId);
    }

    public boolean isToolInSite(String siteId, String toolId) {
        try {
            Site thisSite = SiteService.getSite((String)siteId);
            Collection toolsInSite = thisSite.getTools(toolId);
            return !toolsInSite.isEmpty();
        }
        catch (IdUnusedException e) {
            LOG.error((Object)("IdUnusedException attempting to get site for id " + siteId + " to check if tool " + "with id " + toolId + " is in it."), (Throwable)e);
            return false;
        }
    }

    public Map<Long, Boolean> getReadStatusForMessagesWithId(final List msgIds, final String userId) {
        HashMap<Long, Boolean> statusMap = new HashMap<Long, Boolean>();
        if (msgIds != null && msgIds.size() > 0) {
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Query q = session.getNamedQuery(MessageForumsMessageManagerImpl.QUERY_READ_STATUS_WITH_MSGS_USER);
                    q.setParameter("userId", (Object)userId, (Type)Hibernate.STRING);
                    q.setParameterList("msgIds", (Collection)msgIds);
                    return q.list();
                }
            };
            for (Long msgId : msgIds) {
                statusMap.put(msgId, Boolean.FALSE);
            }
            List statusList = (List)this.getHibernateTemplate().execute(hcb);
            if (statusList != null) {
                for (int i = 0; i < statusList.size(); ++i) {
                    UnreadStatus status = (UnreadStatus)statusList.get(i);
                    if (status == null) continue;
                    statusMap.put(status.getMessageId(), status.getRead());
                }
            }
        }
        return statusMap;
    }

    public List getPendingMsgsInSiteByMembership(final List membershipList) {
        if (membershipList == null) {
            LOG.error((Object)"getPendingMsgsInSiteByMembership failed with membershipList: null");
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsMessageManagerImpl.QUERY_FIND_PENDING_MSGS_BY_CONTEXT_AND_USER_AND_PERMISSION_LEVEL);
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameterList("membershipList", (Collection)membershipList);
                return q.list();
            }
        };
        Message tempMsg = null;
        HashSet<Message> resultSet = new HashSet<Message>();
        ArrayList temp = (ArrayList)this.getHibernateTemplate().execute(hcb);
        for (Object[] results : temp) {
            if (results == null) continue;
            if (results[0] instanceof Message) {
                tempMsg = (Message)results[0];
                tempMsg.setTopic((Topic)results[1]);
                tempMsg.getTopic().setBaseForum((BaseForum)results[2]);
            }
            resultSet.add(tempMsg);
        }
        HibernateCallback hcb2 = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsMessageManagerImpl.QUERY_FIND_PENDING_MSGS_BY_CONTEXT_AND_USER_AND_PERMISSION_LEVEL_NAME);
                q.setParameter("contextId", (Object)MessageForumsMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameterList("membershipList", (Collection)membershipList);
                q.setParameter("customTypeUuid", (Object)MessageForumsMessageManagerImpl.this.typeManager.getCustomLevelType(), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        temp = (ArrayList)this.getHibernateTemplate().execute(hcb2);
        for (Object[] results : temp) {
            if (results == null) continue;
            if (results[0] instanceof Message) {
                tempMsg = (Message)results[0];
                tempMsg.setTopic((Topic)results[1]);
                tempMsg.getTopic().setBaseForum((BaseForum)results[2]);
            }
            resultSet.add(tempMsg);
        }
        return Util.setToList(resultSet);
    }

    public List getPendingMsgsInTopic(final Long topicId) {
        if (topicId == null) {
            LOG.error((Object)"getPendingMsgsInTopic failed with topicId: null");
            throw new IllegalArgumentException("Null Argument");
        }
        LOG.debug((Object)("getPendingMsgsInTopic executing with topicId: " + topicId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsMessageManagerImpl.QUERY_FIND_PENDING_MSGS_BY_TOPICID);
                q.setParameter("topicId", (Object)topicId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        Message tempMsg = null;
        HashSet<Message> resultSet = new HashSet<Message>();
        ArrayList temp = (ArrayList)this.getHibernateTemplate().execute(hcb);
        for (Object[] results : temp) {
            if (results == null) continue;
            if (results[0] instanceof Message) {
                tempMsg = (Message)results[0];
                tempMsg.setTopic((Topic)results[1]);
                tempMsg.getTopic().setBaseForum((BaseForum)results[2]);
            }
            resultSet.add(tempMsg);
        }
        return Util.setToList(resultSet);
    }

    public List<Message> getAllMessagesInSite(final String siteId) {
        LOG.debug((Object)("getAllMessagesInSite executing with siteId: " + siteId));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findDiscussionForumMessagesInSite");
                q.setParameter("contextId", (Object)siteId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        Message tempMsg = null;
        HashSet<Message> resultSet = new HashSet<Message>();
        ArrayList temp = (ArrayList)this.getHibernateTemplate().execute(hcb);
        LOG.debug((Object)("got an initial list of " + temp.size()));
        for (Object[] results : temp) {
            if (results == null) continue;
            if (results[0] instanceof Message) {
                tempMsg = (Message)results[0];
                tempMsg.setTopic((Topic)results[1]);
                tempMsg.getTopic().setBaseForum((BaseForum)results[2]);
            }
            resultSet.add(tempMsg);
        }
        LOG.debug((Object)"about to return");
        return Util.setToList(resultSet);
    }
}

