/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.messageforums.MessageForumsTypeManager;
import org.sakaiproject.api.common.type.Type;
import org.sakaiproject.api.common.type.TypeManager;
import org.sakaiproject.db.api.SqlService;

public class MessageForumsTypeManagerImpl
implements MessageForumsTypeManager {
    private static final Log LOG = LogFactory.getLog(MessageForumsTypeManagerImpl.class);
    private static final String NOT_SPECIFIED = "notSpecified";
    private static final String ALL_PARTICIPANTS = "allParticipants";
    private static final String GROUP = "group";
    private static final String ROLE = "role";
    private static final String USER = "user";
    private static final String AUTHORITY = "org.sakaiproject.component.app.messageforums";
    private static final String DOMAIN = "sakai_messageforums";
    private static final String PRIVATE = "privateForums";
    private static final String PRIVATE_USER_DEFINED_TOPIC = "privateUserDefinedTopic";
    private static final String DISCUSSION = "discussionForums";
    private static final String OPEN = "openForums";
    private static final String RECEIVED = "ReceivedPrivateMessageType";
    private static final String SENT = "SentPrivateMessageType";
    private static final String DELETED = "DeletedPrivateMessageType";
    private static final String DRAFT = "DraftPrivateMessageType";
    private static final String OWNER = "Owner Permission Level";
    private static final String AUTHOR = "Author Permission Level";
    private static final String NONEDITING_AUTHOR = "Nonediting Author Permission Level";
    private static final String CONTRIBUTOR = "Contributor Permission Level";
    private static final String REVIEWER = "Reviewer Permission Level";
    private static final String NONE = "None Permission Level";
    private static final String CUSTOM = "Custom Permission Level";
    private Map initPermissionTypes;
    private TypeManager typeManager;
    private SqlService sqlService;
    private Boolean autoDdl;

    public void init() throws Exception {
        LOG.info((Object)"init()");
        try {
            this.loadInitialDefaultPermissionType();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error loading initial default permissions", (Throwable)e);
        }
    }

    public void setTypeManager(TypeManager typeManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setTypeManager(TypeManager " + typeManager + ")"));
        }
        this.typeManager = typeManager;
    }

    public String getOwnerLevelType() {
        LOG.debug((Object)"getOwnerLevelType()");
        if (this.initPermissionTypes != null && this.initPermissionTypes.get(OWNER) != null) {
            return (String)this.initPermissionTypes.get(OWNER);
        }
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, OWNER);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, OWNER, OWNER, OWNER).getUuid();
    }

    public String getAuthorLevelType() {
        LOG.debug((Object)"getAuthorLevelType()");
        if (this.initPermissionTypes != null && this.initPermissionTypes.get(AUTHOR) != null) {
            return (String)this.initPermissionTypes.get(AUTHOR);
        }
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, AUTHOR);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, AUTHOR, AUTHOR, AUTHOR).getUuid();
    }

    public String getNoneditingAuthorLevelType() {
        LOG.debug((Object)"getNoneditingAuthorLevelType()");
        if (this.initPermissionTypes != null && this.initPermissionTypes.get(NONEDITING_AUTHOR) != null) {
            return (String)this.initPermissionTypes.get(NONEDITING_AUTHOR);
        }
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, NONEDITING_AUTHOR);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, NONEDITING_AUTHOR, NONEDITING_AUTHOR, NONEDITING_AUTHOR).getUuid();
    }

    public String getReviewerLevelType() {
        LOG.debug((Object)"getReviewerLevelType()");
        if (this.initPermissionTypes != null && this.initPermissionTypes.get(REVIEWER) != null) {
            return (String)this.initPermissionTypes.get(REVIEWER);
        }
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, REVIEWER);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, REVIEWER, REVIEWER, REVIEWER).getUuid();
    }

    public String getContributorLevelType() {
        LOG.debug((Object)"getContributorLevelType()");
        if (this.initPermissionTypes != null && this.initPermissionTypes.get(CONTRIBUTOR) != null) {
            return (String)this.initPermissionTypes.get(CONTRIBUTOR);
        }
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, CONTRIBUTOR);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, CONTRIBUTOR, CONTRIBUTOR, CONTRIBUTOR).getUuid();
    }

    public String getNoneLevelType() {
        LOG.debug((Object)"getNoneLevelType()");
        if (this.initPermissionTypes != null && this.initPermissionTypes.get(NONE) != null) {
            return (String)this.initPermissionTypes.get(NONE);
        }
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, NONE);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, NONE, NONE, NONE).getUuid();
    }

    public String getCustomLevelType() {
        LOG.debug((Object)"getCustomLevelType()");
        if (this.initPermissionTypes != null && this.initPermissionTypes.get(CUSTOM) != null) {
            return (String)this.initPermissionTypes.get(CUSTOM);
        }
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, CUSTOM);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, CUSTOM, CUSTOM, CUSTOM).getUuid();
    }

    public String getPrivateMessageAreaType() {
        LOG.debug((Object)"getPrivateMessageAreaType()");
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, PRIVATE);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, PRIVATE, "Private Forums", "Private Message Forums").getUuid();
    }

    public String getUserDefinedPrivateTopicType() {
        LOG.debug((Object)"getUserDefinedPrivateTopicType()");
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, PRIVATE_USER_DEFINED_TOPIC);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, PRIVATE_USER_DEFINED_TOPIC, "Private Forums", "Private Message Forums").getUuid();
    }

    public String getDiscussionForumType() {
        LOG.debug((Object)"getDiscussionForumType()");
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, DISCUSSION);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, DISCUSSION, "DISCUSSION FORUMS", "DISCUSSION Message Forums").getUuid();
    }

    public String getOpenDiscussionForumType() {
        LOG.debug((Object)"getOpenDiscussionForumType()");
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, OPEN);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, OPEN, "OPEN DISCUSSION FORUMS", "OPEN DISCUSSION Message Forums").getUuid();
    }

    public String getReceivedPrivateMessageType() {
        LOG.debug((Object)"getReceivedPrivateMessageType()");
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, RECEIVED);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, RECEIVED, "Received Private Message Type", "Received Private Message Type").getUuid();
    }

    public String getSentPrivateMessageType() {
        LOG.debug((Object)"getSentPrivateMessageType()");
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, SENT);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, SENT, "Sent Private MessageType", "Sent Private Message Type").getUuid();
    }

    public String getDeletedPrivateMessageType() {
        LOG.debug((Object)"getDeletedPrivateMessageType()");
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, DELETED);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, DELETED, "Deleted Private Message Type", "Deleted Private Message Type").getUuid();
    }

    public String getDraftPrivateMessageType() {
        LOG.debug((Object)"getDraftPrivateMessageType()");
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, DRAFT);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, DRAFT, "Draft Private Message Type", "Draft Private Message Type").getUuid();
    }

    public String getRoleType() {
        LOG.debug((Object)"getRoleType()");
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, ROLE);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, ROLE, "ROLES", "Site Roles").getUuid();
    }

    public String getUserType() {
        LOG.debug((Object)"getUserType()");
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, USER);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, USER, "USERS", "Users").getUuid();
    }

    public String getGroupType() {
        LOG.debug((Object)"getGroupType()");
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, GROUP);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, GROUP, "Groups", "Site Groups").getUuid();
    }

    public String getAllParticipantType() {
        LOG.debug((Object)"getAllParticipantType()");
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, ALL_PARTICIPANTS);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, ALL_PARTICIPANTS, "All Participants", "All Site Participants").getUuid();
    }

    public String getNotSpecifiedType() {
        LOG.debug((Object)"getNotSpecifiedType()");
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, NOT_SPECIFIED);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, NOT_SPECIFIED, "Not Specified", "Not Specified").getUuid();
    }

    public String getCustomTopicType(String topicTitle) {
        LOG.debug((Object)"getCustomTopicType()");
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, topicTitle);
        if (type != null) {
            return type.getUuid();
        }
        return this.typeManager.createType(AUTHORITY, DOMAIN, topicTitle, topicTitle, topicTitle).getUuid();
    }

    public String renameCustomTopicType(String oldTopicTitle, String newTopicTitle) {
        Type type = this.typeManager.getType(AUTHORITY, DOMAIN, oldTopicTitle);
        Type typeNew = this.typeManager.getType(AUTHORITY, DOMAIN, newTopicTitle);
        if (type != null && typeNew == null) {
            return this.typeManager.createType(AUTHORITY, DOMAIN, newTopicTitle, newTopicTitle, newTopicTitle).getUuid();
        }
        if (type != null && typeNew != null) {
            return typeNew.getUuid();
        }
        return null;
    }

    private void loadInitialDefaultPermissionType() {
        this.initPermissionTypes = new HashMap();
        this.initPermissionTypes.put(OWNER, this.getOwnerLevelType());
        this.initPermissionTypes.put(AUTHOR, this.getAuthorLevelType());
        this.initPermissionTypes.put(NONEDITING_AUTHOR, this.getNoneditingAuthorLevelType());
        this.initPermissionTypes.put(REVIEWER, this.getReviewerLevelType());
        this.initPermissionTypes.put(CONTRIBUTOR, this.getContributorLevelType());
        this.initPermissionTypes.put(NONE, this.getNoneLevelType());
        this.initPermissionTypes.put(CUSTOM, this.getCustomLevelType());
    }

    public void setSqlService(SqlService sqlService) {
        this.sqlService = sqlService;
    }

    public void setAutoDdl(Boolean autoDdl) {
        this.autoDdl = autoDdl;
    }
}

