/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.sakaiproject.api.app.messageforums.MessageForumsUser;
import org.sakaiproject.api.app.messageforums.MessageForumsUserManager;
import org.sakaiproject.component.app.messageforums.TestUtil;
import org.sakaiproject.component.app.messageforums.dao.hibernate.MessageForumsUserImpl;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.id.api.IdManager;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class MessageForumsUserManagerImpl
extends HibernateDaoSupport
implements MessageForumsUserManager {
    private static final Log LOG = LogFactory.getLog(MessageForumsUserManagerImpl.class);
    private static final String QUERY_BY_USER_ID = "findUserByUserId";
    protected IdManager idManager;
    protected UserDirectoryService userDirectoryService;
    private EventTrackingService eventTrackingService;

    public void init() {
        LOG.info((Object)"init()");
    }

    public EventTrackingService getEventTrackingService() {
        return this.eventTrackingService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public MessageForumsUser getForumUser(final String userId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getForumUser(userId: " + userId + ")"));
        }
        if (userId == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        if (TestUtil.isRunningTests()) {
            MessageForumsUserImpl newUser = new MessageForumsUserImpl();
            newUser.setUuid(this.getNextUuid());
            newUser.setUserId(userId);
            this.saveForumUser((MessageForumsUser)newUser);
            return newUser;
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(MessageForumsUserManagerImpl.QUERY_BY_USER_ID);
                q.setParameter("userId", (Object)userId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        MessageForumsUser user = (MessageForumsUser)this.getHibernateTemplate().execute(hcb);
        if (user == null) {
            try {
                this.userDirectoryService.getUser(userId);
            }
            catch (UserNotDefinedException e) {
                e.printStackTrace();
            }
            MessageForumsUserImpl newUser = new MessageForumsUserImpl();
            newUser.setUuid(this.getNextUuid());
            newUser.setUserId(userId);
            this.saveForumUser((MessageForumsUser)newUser);
            return newUser;
        }
        return user;
    }

    public void saveForumUser(MessageForumsUser user) {
        this.getHibernateTemplate().saveOrUpdate((Object)user);
        LOG.debug((Object)("saveDiscussionForumTopic executed with topicId: " + user.getUuid()));
    }

    private String getNextUuid() {
        return this.idManager.createUuid();
    }

    public void setIdManager(IdManager idManager) {
        this.idManager = idManager;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    private String getEventMessage(Object object) {
        return "/MessageCenter/site/" + this.getContextId() + "/" + object.toString();
    }

    private String getContextId() {
        if (TestUtil.isRunningTests()) {
            return "test-context";
        }
        Placement placement = ToolManager.getCurrentPlacement();
        String presentSiteId = placement.getContext();
        return presentSiteId;
    }
}

