/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.sakaiproject.api.app.messageforums.AreaManager;
import org.sakaiproject.api.app.messageforums.DBMembershipItem;
import org.sakaiproject.api.app.messageforums.MessageForumsTypeManager;
import org.sakaiproject.api.app.messageforums.PermissionLevel;
import org.sakaiproject.api.app.messageforums.PermissionLevelManager;
import org.sakaiproject.api.app.messageforums.PermissionsMask;
import org.sakaiproject.api.app.messageforums.Topic;
import org.sakaiproject.component.app.messageforums.dao.hibernate.DBMembershipItemImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.PermissionLevelImpl;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.id.api.IdManager;
import org.sakaiproject.tool.api.SessionManager;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionLevelManagerImpl
extends HibernateDaoSupport
implements PermissionLevelManager {
    private static final Log LOG = LogFactory.getLog(PermissionLevelManagerImpl.class);
    private EventTrackingService eventTrackingService;
    private SessionManager sessionManager;
    private IdManager idManager;
    private MessageForumsTypeManager typeManager;
    private AreaManager areaManager;
    private Map<String, PermissionLevel> defaultPermissionsMap;
    private static final String QUERY_BY_TYPE_UUID = "findPermissionLevelByTypeUuid";
    private static final String QUERY_ORDERED_LEVEL_NAMES = "findOrderedPermissionLevelNames";
    private static final String QUERY_BY_AREA_ALL_FORUMS_MEMBERSHIP = "findAllMembershipItemsForForumsForSite";
    private static final String QUERY_GET_ALL_TOPICS = "findAllTopicsForSite";
    private static final String QUERY_BY_TOPIC_IDS_ALL_TOPIC_MEMBERSHIP = "findAllMembershipItemsForTopicsForSite";
    private static final String QUERY_BY_AREA_ID_ALL_MEMBERSHIP = "findAllMembershipItemsForSite";
    private Boolean autoDdl;
    public static final int MAX_NUMBER_OF_SQL_PARAMETERS_IN_LIST = 999;

    public void init() {
        LOG.info((Object)"init()");
        try {
            if (this.autoDdl != null && this.autoDdl.booleanValue()) {
                this.loadDefaultTypeAndPermissionLevelData();
            }
            this.initializePermissionLevelData();
        }
        catch (Exception ex) {
            LOG.error((Object)"PermissionsLevelManager - a problem occurred loading default permission level data ", (Throwable)ex);
        }
    }

    public PermissionLevel getPermissionLevelByName(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getPermissionLevelByName executing(" + name + ")"));
        }
        if ("Owner".equals(name)) {
            return this.getDefaultOwnerPermissionLevel();
        }
        if ("Author".equals(name)) {
            return this.getDefaultAuthorPermissionLevel();
        }
        if ("Nonediting Author".equals(name)) {
            return this.getDefaultNoneditingAuthorPermissionLevel();
        }
        if ("Contributor".equals(name)) {
            return this.getDefaultContributorPermissionLevel();
        }
        if ("Reviewer".equals(name)) {
            return this.getDefaultReviewerPermissionLevel();
        }
        if ("None".equals(name)) {
            return this.getDefaultNonePermissionLevel();
        }
        return null;
    }

    public List getOrderedPermissionLevelNames() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getOrderedPermissionLevelNames executing");
        }
        ArrayList<String> levelNames = new ArrayList<String>();
        List<PermissionLevel> levels = this.getDefaultPermissionLevels();
        if (levels != null && !levels.isEmpty()) {
            for (PermissionLevel level : levels) {
                levelNames.add(level.getName());
            }
            Collections.sort(levelNames);
        }
        return levelNames;
    }

    public String getPermissionLevelType(PermissionLevel level) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getPermissionLevelType executing(" + level + ")"));
        }
        if (level == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        PermissionLevel ownerLevel = this.getDefaultOwnerPermissionLevel();
        if (level.equals(ownerLevel)) {
            return ownerLevel.getTypeUuid();
        }
        PermissionLevel authorLevel = this.getDefaultAuthorPermissionLevel();
        if (level.equals(authorLevel)) {
            return authorLevel.getTypeUuid();
        }
        PermissionLevel noneditingAuthorLevel = this.getDefaultNoneditingAuthorPermissionLevel();
        if (level.equals(noneditingAuthorLevel)) {
            return noneditingAuthorLevel.getTypeUuid();
        }
        PermissionLevel reviewerLevel = this.getDefaultReviewerPermissionLevel();
        if (level.equals(reviewerLevel)) {
            return reviewerLevel.getTypeUuid();
        }
        PermissionLevel contributorLevel = this.getDefaultContributorPermissionLevel();
        if (level.equals(contributorLevel)) {
            return contributorLevel.getTypeUuid();
        }
        PermissionLevel noneLevel = this.getDefaultNonePermissionLevel();
        if (level.equals(noneLevel)) {
            return noneLevel.getTypeUuid();
        }
        return null;
    }

    private PermissionLevel createDefaultPermissionLevel(String name, String typeUuid, PermissionsMask mask) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createDefaultPermissionLevel executing(" + name + "," + typeUuid + "," + mask + ")"));
        }
        if (name == null || typeUuid == null || mask == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        PermissionLevelImpl newPermissionLevel = new PermissionLevelImpl();
        Date now = new Date();
        newPermissionLevel.setName(name);
        newPermissionLevel.setUuid(this.idManager.createUuid());
        newPermissionLevel.setCreated(now);
        newPermissionLevel.setCreatedBy("admin");
        newPermissionLevel.setModified(now);
        newPermissionLevel.setModifiedBy("admin");
        newPermissionLevel.setTypeUuid(typeUuid);
        for (Map.Entry entry : mask.entrySet()) {
            String key = (String)entry.getKey();
            Boolean value = (Boolean)entry.getValue();
            try {
                PropertyUtils.setSimpleProperty((Object)newPermissionLevel, (String)key, (Object)value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return newPermissionLevel;
    }

    public PermissionLevel createPermissionLevel(String name, String typeUuid, PermissionsMask mask) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createPermissionLevel executing(" + name + "," + typeUuid + "," + mask + ")"));
        }
        if (name == null || typeUuid == null || mask == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        PermissionLevelImpl newPermissionLevel = new PermissionLevelImpl();
        Date now = new Date();
        String currentUser = this.getCurrentUser();
        newPermissionLevel.setName(name);
        newPermissionLevel.setUuid(this.idManager.createUuid());
        newPermissionLevel.setCreated(now);
        newPermissionLevel.setCreatedBy(currentUser);
        newPermissionLevel.setModified(now);
        newPermissionLevel.setModifiedBy(currentUser);
        newPermissionLevel.setTypeUuid(typeUuid);
        for (Map.Entry entry : mask.entrySet()) {
            String key = (String)entry.getKey();
            Boolean value = (Boolean)entry.getValue();
            try {
                PropertyUtils.setSimpleProperty((Object)newPermissionLevel, (String)key, (Object)value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return newPermissionLevel;
    }

    public DBMembershipItem createDBMembershipItem(String name, String permissionLevelName, Integer type) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createDBMembershipItem executing(" + name + "," + type + ")"));
        }
        if (name == null || type == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        DBMembershipItemImpl newDBMembershipItem = new DBMembershipItemImpl();
        Date now = new Date();
        String currentUser = this.getCurrentUser();
        newDBMembershipItem.setName(name);
        newDBMembershipItem.setPermissionLevelName(permissionLevelName);
        newDBMembershipItem.setUuid(this.idManager.createUuid());
        newDBMembershipItem.setCreated(now);
        newDBMembershipItem.setCreatedBy(currentUser);
        newDBMembershipItem.setModified(now);
        newDBMembershipItem.setModifiedBy(currentUser);
        newDBMembershipItem.setType(type);
        return newDBMembershipItem;
    }

    public void saveDBMembershipItem(DBMembershipItem item) {
        this.getHibernateTemplate().saveOrUpdate((Object)item);
    }

    public void savePermissionLevel(PermissionLevel level) {
        this.getHibernateTemplate().saveOrUpdate((Object)level);
    }

    public PermissionLevel getDefaultOwnerPermissionLevel() {
        String typeUuid;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getDefaultOwnerPermissionLevel executing");
        }
        if ((typeUuid = this.typeManager.getOwnerLevelType()) == null) {
            throw new IllegalStateException("type cannot be null");
        }
        PermissionLevel level = this.getDefaultPermissionLevel(typeUuid);
        if (level == null) {
            LOG.info((Object)"No permission level data exists for the Owner level in the MFR_PERMISSION_LEVEL_T table. Default Owner permissions will be used. If you want to customize this permission level, use mfr.sql as a reference to add this level to the table.");
            PermissionsMask mask = this.getDefaultOwnerPermissionsMask();
            level = this.createPermissionLevel("Owner", typeUuid, mask);
        }
        return level;
    }

    public PermissionLevel getDefaultAuthorPermissionLevel() {
        String typeUuid;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getDefaultAuthorPermissionLevel executing");
        }
        if ((typeUuid = this.typeManager.getAuthorLevelType()) == null) {
            throw new IllegalStateException("type cannot be null");
        }
        PermissionLevel level = this.getDefaultPermissionLevel(typeUuid);
        if (level == null) {
            LOG.info((Object)"No permission level data exists for the Author level in the MFR_PERMISSION_LEVEL_T table. Default Author permissions will be used. If you want to customize this permission level, use mfr.sql as a reference to add this level to the table.");
            PermissionsMask mask = this.getDefaultAuthorPermissionsMask();
            level = this.createPermissionLevel("Author", typeUuid, mask);
        }
        return level;
    }

    public PermissionLevel getDefaultNoneditingAuthorPermissionLevel() {
        String typeUuid;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getDefaultNoneditingAuthorPermissionLevel executing");
        }
        if ((typeUuid = this.typeManager.getNoneditingAuthorLevelType()) == null) {
            throw new IllegalStateException("type cannot be null");
        }
        PermissionLevel level = this.getDefaultPermissionLevel(typeUuid);
        if (level == null) {
            LOG.info((Object)"No permission level data exists for the NoneditingAuthor level in the MFR_PERMISSION_LEVEL_T table. Default NoneditingAuthor permissions will be used. If you want to customize this permission level, use mfr.sql as a reference to add this level to the table.");
            PermissionsMask mask = this.getDefaultNoneditingAuthorPermissionsMask();
            level = this.createPermissionLevel("Nonediting Author", typeUuid, mask);
        }
        return level;
    }

    public PermissionLevel getDefaultReviewerPermissionLevel() {
        String typeUuid;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getDefaultReviewerPermissionLevel executing");
        }
        if ((typeUuid = this.typeManager.getReviewerLevelType()) == null) {
            throw new IllegalStateException("type cannot be null");
        }
        PermissionLevel level = this.getDefaultPermissionLevel(typeUuid);
        if (level == null) {
            LOG.info((Object)"No permission level data exists for the Reviewer level in the MFR_PERMISSION_LEVEL_T table. Default Reviewer permissions will be used. If you want to customize this permission level, use mfr.sql as a reference to add this level to the table.");
            PermissionsMask mask = this.getDefaultReviewerPermissionsMask();
            level = this.createPermissionLevel("Reviewer", typeUuid, mask);
        }
        return level;
    }

    public PermissionLevel getDefaultContributorPermissionLevel() {
        String typeUuid;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getDefaultContributorPermissionLevel executing");
        }
        if ((typeUuid = this.typeManager.getContributorLevelType()) == null) {
            throw new IllegalStateException("type cannot be null");
        }
        PermissionLevel level = this.getDefaultPermissionLevel(typeUuid);
        if (level == null) {
            LOG.info((Object)"No permission level data exists for the Contributor level in the MFR_PERMISSION_LEVEL_T table. Default Contributor permissions will be used. If you want to customize this permission level, use mfr.sql as a reference to add this level to the table.");
            PermissionsMask mask = this.getDefaultContributorPermissionsMask();
            level = this.createPermissionLevel("Contributor", typeUuid, mask);
        }
        return level;
    }

    public PermissionLevel getDefaultNonePermissionLevel() {
        String typeUuid;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getDefaultNonePermissionLevel executing");
        }
        if ((typeUuid = this.typeManager.getNoneLevelType()) == null) {
            throw new IllegalStateException("type cannot be null");
        }
        PermissionLevel level = this.getDefaultPermissionLevel(typeUuid);
        if (level == null) {
            LOG.info((Object)"No permission level data exists for the None level in the MFR_PERMISSION_LEVEL_T table. Default None permissions will be used. If you want to customize this permission level, use mfr.sql as a reference to add this level to the table.");
            PermissionsMask mask = this.getDefaultNonePermissionsMask();
            level = this.createPermissionLevel("None", typeUuid, mask);
        }
        return level;
    }

    private PermissionLevel getDefaultPermissionLevel(final String typeUuid) {
        if (typeUuid == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getDefaultPermissionLevel executing with typeUuid: " + typeUuid));
        }
        PermissionLevel level = null;
        if (this.defaultPermissionsMap != null && this.defaultPermissionsMap.containsKey(typeUuid)) {
            level = this.defaultPermissionsMap.get(typeUuid).clone();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("got Default PermissionLevel from defaultPermissionsMap as " + level));
            }
        } else {
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Query q = session.getNamedQuery(PermissionLevelManagerImpl.QUERY_BY_TYPE_UUID);
                    q.setParameter("typeUuid", (Object)typeUuid);
                    return q.uniqueResult();
                }
            };
            level = (PermissionLevel)this.getHibernateTemplate().execute(hcb);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Returned Permission Level from query was " + level));
            }
        }
        return level;
    }

    public Boolean getCustomPermissionByName(String customPermName, PermissionLevel permissionLevel) {
        if (customPermName == null) {
            throw new IllegalArgumentException("Null permissionLevelName passed");
        }
        if (permissionLevel == null) {
            throw new IllegalArgumentException("Null permissionLevel passed");
        }
        if (customPermName.equals("newForum")) {
            return permissionLevel.getNewForum();
        }
        if (customPermName.equals("newResponse")) {
            return permissionLevel.getNewResponse();
        }
        if (customPermName.equals("newResponseToResponse")) {
            return permissionLevel.getNewResponseToResponse();
        }
        if (customPermName.equals("newTopic")) {
            return permissionLevel.getNewTopic();
        }
        if (customPermName.equals("postToGradebook")) {
            return permissionLevel.getPostToGradebook();
        }
        if (customPermName.equals("deleteAny")) {
            return permissionLevel.getDeleteAny();
        }
        if (customPermName.equals("deleteOwn")) {
            return permissionLevel.getDeleteOwn();
        }
        if (customPermName.equals("markAsRead")) {
            return permissionLevel.getMarkAsRead();
        }
        if (customPermName.equals("moderatePostings")) {
            return permissionLevel.getModeratePostings();
        }
        if (customPermName.equals("movePosting")) {
            return permissionLevel.getMovePosting();
        }
        if (customPermName.equals("read")) {
            return permissionLevel.getRead();
        }
        if (customPermName.equals("reviseAny")) {
            return permissionLevel.getReviseAny();
        }
        if (customPermName.equals("reviseOwn")) {
            return permissionLevel.getReviseOwn();
        }
        if (customPermName.equals("changeSettings")) {
            return permissionLevel.getChangeSettings();
        }
        return null;
    }

    public List getCustomPermissions() {
        ArrayList<String> customPerms = new ArrayList<String>();
        customPerms.add("newForum");
        customPerms.add("newResponse");
        customPerms.add("newResponseToResponse");
        customPerms.add("newTopic");
        customPerms.add("deleteAny");
        customPerms.add("deleteOwn");
        customPerms.add("markAsRead");
        customPerms.add("moderatePostings");
        customPerms.add("movePosting");
        customPerms.add("postToGradebook");
        customPerms.add("read");
        customPerms.add("reviseAny");
        customPerms.add("reviseOwn");
        customPerms.add("changeSettings");
        return customPerms;
    }

    private String getCurrentUser() {
        String user = this.sessionManager.getCurrentSessionUserId();
        return user == null ? "test-user" : user;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public void setTypeManager(MessageForumsTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public void setIdManager(IdManager idManager) {
        this.idManager = idManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setAreaManager(AreaManager areaManager) {
        this.areaManager = areaManager;
    }

    public List getAllMembershipItemsForForumsForSite(final Long areaId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getAllMembershipItemsForForumsForSite executing");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(PermissionLevelManagerImpl.QUERY_BY_AREA_ALL_FORUMS_MEMBERSHIP);
                q.setParameter("areaId", (Object)areaId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    private List getAllTopicsForSite(final Long areaId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getAllTopicsForSite executing");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(PermissionLevelManagerImpl.QUERY_GET_ALL_TOPICS);
                q.setParameter("areaId", (Object)areaId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        List topicList = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<Long> ids = new ArrayList<Long>();
        try {
            if (topicList != null) {
                block2: for (int i = 0; i < topicList.size(); ++i) {
                    Object[] thisObject = (Object[])topicList.get(i);
                    if (thisObject == null) continue;
                    for (int j = 0; j < thisObject.length; ++j) {
                        Object thisTopic = thisObject[j];
                        if (!(thisTopic instanceof Topic)) continue;
                        ids.add(((Topic)thisTopic).getId());
                        continue block2;
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("PermissionLevelManagerImpl.getAllTopicsForSite--" + e));
        }
        return ids;
    }

    public List getAllMembershipItemsForTopicsForSite(Long areaId) {
        final List topicIds = this.getAllTopicsForSite(areaId);
        if (topicIds != null && topicIds.size() > 0) {
            HibernateCallback hcb1 = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Query q = session.getNamedQuery(PermissionLevelManagerImpl.QUERY_BY_TOPIC_IDS_ALL_TOPIC_MEMBERSHIP);
                    return PermissionLevelManagerImpl.this.queryWithParameterList(q, "topicIdList", topicIds);
                }
            };
            return (List)this.getHibernateTemplate().execute(hcb1);
        }
        return new ArrayList();
    }

    private void initializePermissionLevelData() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"loadInitialDefaultPermissionLevel executing");
        }
        this.defaultPermissionsMap = new HashMap<String, PermissionLevel>();
        this.defaultPermissionsMap.put(this.typeManager.getOwnerLevelType(), this.getDefaultOwnerPermissionLevel());
        this.defaultPermissionsMap.put(this.typeManager.getAuthorLevelType(), this.getDefaultAuthorPermissionLevel());
        this.defaultPermissionsMap.put(this.typeManager.getNoneditingAuthorLevelType(), this.getDefaultNoneditingAuthorPermissionLevel());
        this.defaultPermissionsMap.put(this.typeManager.getContributorLevelType(), this.getDefaultContributorPermissionLevel());
        this.defaultPermissionsMap.put(this.typeManager.getReviewerLevelType(), this.getDefaultReviewerPermissionLevel());
        this.defaultPermissionsMap.put(this.typeManager.getNoneLevelType(), this.getDefaultNonePermissionLevel());
    }

    private void loadDefaultTypeAndPermissionLevelData() {
        try {
            PermissionLevel permLevel;
            PermissionsMask mask;
            String ownerType = this.typeManager.getOwnerLevelType();
            String authorType = this.typeManager.getAuthorLevelType();
            String contributorType = this.typeManager.getContributorLevelType();
            String reviewerType = this.typeManager.getReviewerLevelType();
            String noneditingAuthorType = this.typeManager.getNoneditingAuthorLevelType();
            String noneType = this.typeManager.getNoneLevelType();
            if (this.getDefaultPermissionLevel(ownerType) == null) {
                mask = this.getDefaultOwnerPermissionsMask();
                permLevel = this.createPermissionLevel("Owner", ownerType, mask);
                this.savePermissionLevel(permLevel);
            }
            if (this.getDefaultPermissionLevel(authorType) == null) {
                mask = this.getDefaultAuthorPermissionsMask();
                permLevel = this.createPermissionLevel("Author", authorType, mask);
                this.savePermissionLevel(permLevel);
            }
            if (this.getDefaultPermissionLevel(contributorType) == null) {
                mask = this.getDefaultContributorPermissionsMask();
                permLevel = this.createPermissionLevel("Contributor", contributorType, mask);
                this.savePermissionLevel(permLevel);
            }
            if (this.getDefaultPermissionLevel(reviewerType) == null) {
                mask = this.getDefaultReviewerPermissionsMask();
                permLevel = this.createPermissionLevel("Reviewer", reviewerType, mask);
                this.savePermissionLevel(permLevel);
            }
            if (this.getDefaultPermissionLevel(noneditingAuthorType) == null) {
                mask = this.getDefaultNoneditingAuthorPermissionsMask();
                permLevel = this.createPermissionLevel("Nonediting Author", noneditingAuthorType, mask);
                this.savePermissionLevel(permLevel);
            }
            if (this.getDefaultPermissionLevel(noneType) == null) {
                mask = this.getDefaultNonePermissionsMask();
                permLevel = this.createPermissionLevel("None", noneType, mask);
                this.savePermissionLevel(permLevel);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error loading initial default types and/or permissions", (Throwable)e);
        }
    }

    public void deleteMembershipItems(Set membershipSet) {
        if (membershipSet != null) {
            Iterator iter = membershipSet.iterator();
            HashSet<PermissionLevel> permissionLevels = new HashSet<PermissionLevel>();
            while (iter.hasNext()) {
                DBMembershipItem item = (DBMembershipItem)iter.next();
                if (item != null && item.getPermissionLevel() != null && "Custom".equals(item.getPermissionLevelName())) {
                    permissionLevels.add(item.getPermissionLevel());
                }
                if (item != null && item.getPermissionLevel() != null && "Owner".equals(item.getPermissionLevelName())) {
                    permissionLevels.add(item.getPermissionLevel());
                }
                if (item != null && item.getPermissionLevel() != null && "Author".equals(item.getPermissionLevelName())) {
                    permissionLevels.add(item.getPermissionLevel());
                }
                if (item != null && item.getPermissionLevel() != null && "Nonediting Author".equals(item.getPermissionLevelName())) {
                    permissionLevels.add(item.getPermissionLevel());
                }
                if (item != null && item.getPermissionLevel() != null && "Contributor".equals(item.getPermissionLevelName())) {
                    permissionLevels.add(item.getPermissionLevel());
                }
                if (item != null && item.getPermissionLevel() != null && "Reviewer".equals(item.getPermissionLevelName())) {
                    permissionLevels.add(item.getPermissionLevel());
                }
                if (item == null || item.getPermissionLevel() == null || !"None".equals(item.getPermissionLevelName())) continue;
                permissionLevels.add(item.getPermissionLevel());
            }
            this.getHibernateTemplate().deleteAll((Collection)membershipSet);
            this.getHibernateTemplate().deleteAll(permissionLevels);
        }
    }

    private PermissionsMask getDefaultOwnerPermissionsMask() {
        PermissionsMask mask = new PermissionsMask();
        mask.put((Object)"newForum", (Object)true);
        mask.put((Object)"newTopic", (Object)true);
        mask.put((Object)"newResponse", (Object)true);
        mask.put((Object)"newResponseToResponse", (Object)true);
        mask.put((Object)"movePosting", (Object)true);
        mask.put((Object)"changeSettings", (Object)true);
        mask.put((Object)"postToGradebook", (Object)true);
        mask.put((Object)"read", (Object)true);
        mask.put((Object)"markAsRead", (Object)true);
        mask.put((Object)"moderatePostings", (Object)true);
        mask.put((Object)"deleteOwn", (Object)false);
        mask.put((Object)"deleteAny", (Object)true);
        mask.put((Object)"reviseOwn", (Object)false);
        mask.put((Object)"reviseAny", (Object)true);
        return mask;
    }

    private PermissionsMask getDefaultAuthorPermissionsMask() {
        PermissionsMask mask = new PermissionsMask();
        mask.put((Object)"newForum", (Object)true);
        mask.put((Object)"newTopic", (Object)true);
        mask.put((Object)"newResponse", (Object)true);
        mask.put((Object)"newResponseToResponse", (Object)true);
        mask.put((Object)"movePosting", (Object)true);
        mask.put((Object)"changeSettings", (Object)true);
        mask.put((Object)"postToGradebook", (Object)true);
        mask.put((Object)"read", (Object)true);
        mask.put((Object)"markAsRead", (Object)true);
        mask.put((Object)"moderatePostings", (Object)false);
        mask.put((Object)"deleteOwn", (Object)true);
        mask.put((Object)"deleteAny", (Object)false);
        mask.put((Object)"reviseOwn", (Object)true);
        mask.put((Object)"reviseAny", (Object)false);
        return mask;
    }

    private PermissionsMask getDefaultContributorPermissionsMask() {
        PermissionsMask mask = new PermissionsMask();
        mask.put((Object)"newForum", (Object)false);
        mask.put((Object)"newTopic", (Object)false);
        mask.put((Object)"newResponse", (Object)true);
        mask.put((Object)"newResponseToResponse", (Object)true);
        mask.put((Object)"movePosting", (Object)false);
        mask.put((Object)"changeSettings", (Object)false);
        mask.put((Object)"postToGradebook", (Object)false);
        mask.put((Object)"read", (Object)true);
        mask.put((Object)"markAsRead", (Object)true);
        mask.put((Object)"moderatePostings", (Object)false);
        mask.put((Object)"deleteOwn", (Object)false);
        mask.put((Object)"deleteAny", (Object)false);
        mask.put((Object)"reviseOwn", (Object)false);
        mask.put((Object)"reviseAny", (Object)false);
        return mask;
    }

    private PermissionsMask getDefaultNoneditingAuthorPermissionsMask() {
        PermissionsMask mask = new PermissionsMask();
        mask.put((Object)"newForum", (Object)true);
        mask.put((Object)"newTopic", (Object)true);
        mask.put((Object)"newResponse", (Object)true);
        mask.put((Object)"newResponseToResponse", (Object)true);
        mask.put((Object)"movePosting", (Object)false);
        mask.put((Object)"changeSettings", (Object)true);
        mask.put((Object)"postToGradebook", (Object)true);
        mask.put((Object)"read", (Object)true);
        mask.put((Object)"markAsRead", (Object)true);
        mask.put((Object)"moderatePostings", (Object)false);
        mask.put((Object)"deleteOwn", (Object)false);
        mask.put((Object)"deleteAny", (Object)false);
        mask.put((Object)"reviseOwn", (Object)true);
        mask.put((Object)"reviseAny", (Object)false);
        return mask;
    }

    private PermissionsMask getDefaultNonePermissionsMask() {
        PermissionsMask mask = new PermissionsMask();
        mask.put((Object)"newForum", (Object)false);
        mask.put((Object)"newTopic", (Object)false);
        mask.put((Object)"newResponse", (Object)false);
        mask.put((Object)"newResponseToResponse", (Object)false);
        mask.put((Object)"movePosting", (Object)false);
        mask.put((Object)"changeSettings", (Object)false);
        mask.put((Object)"postToGradebook", (Object)false);
        mask.put((Object)"read", (Object)false);
        mask.put((Object)"markAsRead", (Object)false);
        mask.put((Object)"moderatePostings", (Object)false);
        mask.put((Object)"deleteOwn", (Object)false);
        mask.put((Object)"deleteAny", (Object)false);
        mask.put((Object)"reviseOwn", (Object)false);
        mask.put((Object)"reviseAny", (Object)false);
        return mask;
    }

    private PermissionsMask getDefaultReviewerPermissionsMask() {
        PermissionsMask mask = new PermissionsMask();
        mask.put((Object)"newForum", (Object)false);
        mask.put((Object)"newTopic", (Object)false);
        mask.put((Object)"newResponse", (Object)false);
        mask.put((Object)"newResponseToResponse", (Object)false);
        mask.put((Object)"movePosting", (Object)false);
        mask.put((Object)"changeSettings", (Object)false);
        mask.put((Object)"postToGradebook", (Object)false);
        mask.put((Object)"read", (Object)true);
        mask.put((Object)"markAsRead", (Object)true);
        mask.put((Object)"moderatePostings", (Object)false);
        mask.put((Object)"deleteOwn", (Object)false);
        mask.put((Object)"deleteAny", (Object)false);
        mask.put((Object)"reviseOwn", (Object)false);
        mask.put((Object)"reviseAny", (Object)false);
        return mask;
    }

    public void setAutoDdl(Boolean autoDdl) {
        this.autoDdl = autoDdl;
    }

    public List<PermissionLevel> getDefaultPermissionLevels() {
        ArrayList<PermissionLevel> defaultLevels = new ArrayList<PermissionLevel>();
        if (this.defaultPermissionsMap != null && !this.defaultPermissionsMap.isEmpty()) {
            defaultLevels.addAll(this.defaultPermissionsMap.values());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Default permissions map was null!! Loading defaults to return from getDefaultPermissionLevels");
            }
            defaultLevels.add(this.getDefaultOwnerPermissionLevel());
            defaultLevels.add(this.getDefaultAuthorPermissionLevel());
            defaultLevels.add(this.getDefaultContributorPermissionLevel());
            defaultLevels.add(this.getDefaultNoneditingAuthorPermissionLevel());
            defaultLevels.add(this.getDefaultNonePermissionLevel());
            defaultLevels.add(this.getDefaultReviewerPermissionLevel());
        }
        return defaultLevels;
    }

    private List queryWithParameterList(Query query, String queryParamName, List fullList) {
        List queryResultList = new ArrayList();
        if (fullList.size() < 999) {
            query.setParameterList(queryParamName, (Collection)fullList);
            queryResultList = query.list();
        } else {
            int begIndex = 0;
            int endIndex = 0;
            while (begIndex < fullList.size()) {
                endIndex = begIndex + 999;
                if (endIndex > fullList.size()) {
                    endIndex = fullList.size();
                }
                ArrayList tempSubList = new ArrayList();
                tempSubList.addAll(fullList.subList(begIndex, endIndex));
                query.setParameterList(queryParamName, tempSubList);
                queryResultList.addAll(query.list());
                begIndex = endIndex;
            }
        }
        return queryResultList;
    }
}

