/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.sakaiproject.api.app.messageforums.Area;
import org.sakaiproject.api.app.messageforums.AreaControlPermission;
import org.sakaiproject.api.app.messageforums.AreaManager;
import org.sakaiproject.api.app.messageforums.BaseForum;
import org.sakaiproject.api.app.messageforums.ControlPermissions;
import org.sakaiproject.api.app.messageforums.DefaultPermissionsManager;
import org.sakaiproject.api.app.messageforums.ForumControlPermission;
import org.sakaiproject.api.app.messageforums.MessageForumsTypeManager;
import org.sakaiproject.api.app.messageforums.MessagePermissions;
import org.sakaiproject.api.app.messageforums.PermissionManager;
import org.sakaiproject.api.app.messageforums.Topic;
import org.sakaiproject.api.app.messageforums.TopicControlPermission;
import org.sakaiproject.component.app.messageforums.TestUtil;
import org.sakaiproject.component.app.messageforums.dao.hibernate.AreaControlPermissionImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.ControlPermissionsImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.ForumControlPermissionImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.MessagePermissionsImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.TopicControlPermissionImpl;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.id.api.IdManager;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class PermissionManagerImpl
extends HibernateDaoSupport
implements PermissionManager {
    private static final Log LOG = LogFactory.getLog(PermissionManagerImpl.class);
    private static final String QUERY_CP_BY_ROLE = "findAreaControlPermissionByRole";
    private static final String QUERY_CP_BY_FORUM = "findForumControlPermissionByRole";
    private static final String QUERY_CP_BY_TOPIC = "findTopicControlPermissionByRole";
    private static final String QUERY_MP_BY_ROLE = "findAreaMessagePermissionByRole";
    private static final String QUERY_MP_BY_FORUM = "findForumMessagePermissionByRole";
    private static final String QUERY_MP_BY_TOPIC = "findTopicMessagePermissionByRole";
    private IdManager idManager;
    private SessionManager sessionManager;
    private MessageForumsTypeManager typeManager;
    private AreaManager areaManager;
    private EventTrackingService eventTrackingService;
    private DefaultPermissionsManager defaultPermissionsManager;

    public void init() {
        LOG.info((Object)"init()");
    }

    public EventTrackingService getEventTrackingService() {
        return this.eventTrackingService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public AreaManager getAreaManager() {
        return this.areaManager;
    }

    public void setAreaManager(AreaManager areaManager) {
        this.areaManager = areaManager;
    }

    public MessageForumsTypeManager getTypeManager() {
        return this.typeManager;
    }

    public void setTypeManager(MessageForumsTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public IdManager getIdManager() {
        return this.idManager;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setIdManager(IdManager idManager) {
        this.idManager = idManager;
    }

    public void setDefaultPermissionsManager(DefaultPermissionsManager defaultPermissionManager) {
        this.defaultPermissionsManager = defaultPermissionManager;
    }

    public AreaControlPermission getAreaControlPermissionForRole(String role, String typeId) {
        ControlPermissions permissions = this.getAreaControlPermissionByRoleAndType(role, typeId, false);
        AreaControlPermissionImpl cp = new AreaControlPermissionImpl();
        if (permissions == null) {
            return this.getDefaultAreaControlPermissionForRole(role, typeId);
        }
        cp.setPostToGradebook(permissions.getPostToGradebook());
        cp.setChangeSettings(permissions.getChangeSettings());
        cp.setMovePostings(permissions.getMovePostings());
        cp.setNewForum(permissions.getNewForum());
        cp.setNewResponse(permissions.getNewResponse());
        cp.setNewTopic(permissions.getNewTopic());
        cp.setResponseToResponse(permissions.getResponseToResponse());
        cp.setRole(role);
        return cp;
    }

    public AreaControlPermission getDefaultAreaControlPermissionForRole(String role, String typeId) {
        AreaControlPermissionImpl cp = new AreaControlPermissionImpl();
        cp.setChangeSettings(Boolean.valueOf(this.defaultPermissionsManager.isChangeSettings(role)));
        cp.setMovePostings(Boolean.valueOf(this.defaultPermissionsManager.isMovePostings(role)));
        cp.setNewForum(Boolean.valueOf(this.defaultPermissionsManager.isNewForum(role)));
        cp.setNewResponse(Boolean.valueOf(this.defaultPermissionsManager.isNewResponse(role)));
        cp.setNewTopic(Boolean.valueOf(this.defaultPermissionsManager.isNewTopic(role)));
        cp.setResponseToResponse(Boolean.valueOf(this.defaultPermissionsManager.isResponseToResponse(role)));
        cp.setPostToGradebook(Boolean.valueOf(this.defaultPermissionsManager.isPostToGradebook(role)));
        cp.setRole(role);
        return cp;
    }

    public AreaControlPermission createAreaControlPermissionForRole(String role, String typeId) {
        AreaControlPermissionImpl permission = new AreaControlPermissionImpl();
        AreaControlPermission acp = this.getDefaultAreaControlPermissionForRole(role, typeId);
        permission.setChangeSettings(acp.getChangeSettings());
        permission.setMovePostings(acp.getMovePostings());
        permission.setNewForum(acp.getNewForum());
        permission.setNewResponse(acp.getNewResponse());
        permission.setNewTopic(acp.getNewTopic());
        permission.setResponseToResponse(acp.getResponseToResponse());
        permission.setPostToGradebook(acp.getPostToGradebook());
        permission.setRole(role);
        return permission;
    }

    public void saveAreaControlPermissionForRole(Area area, AreaControlPermission permission, String typeId) {
        ControlPermissions permissions = this.getAreaControlPermissionByRoleAndType(permission.getRole(), typeId, false);
        if (permissions == null) {
            permissions = new ControlPermissionsImpl();
        }
        boolean isNew = permissions.getId() == null;
        permissions.setArea(area);
        permissions.setDefaultValue(Boolean.FALSE);
        permissions.setChangeSettings(permission.getChangeSettings());
        permissions.setMovePostings(permission.getMovePostings());
        permissions.setNewForum(permission.getNewForum());
        permissions.setNewResponse(permission.getNewResponse());
        permissions.setNewTopic(permission.getNewTopic());
        permissions.setResponseToResponse(permission.getResponseToResponse());
        permissions.setPostToGradebook(permission.getPostToGradebook());
        permissions.setRole(permission.getRole());
        this.getHibernateTemplate().saveOrUpdate((Object)permissions);
    }

    public void saveDefaultAreaControlPermissionForRole(Area area, AreaControlPermission permission, String typeId) {
        ControlPermissions permissions = this.getAreaControlPermissionByRoleAndType(permission.getRole(), typeId, true);
        if (permissions == null) {
            permissions = new ControlPermissionsImpl();
        }
        boolean isNew = permissions.getId() == null;
        permissions.setArea(area);
        permissions.setDefaultValue(Boolean.TRUE);
        permissions.setChangeSettings(permission.getChangeSettings());
        permissions.setMovePostings(permission.getMovePostings());
        permissions.setNewForum(permission.getNewForum());
        permissions.setNewResponse(permission.getNewResponse());
        permissions.setNewTopic(permission.getNewTopic());
        permissions.setResponseToResponse(permission.getResponseToResponse());
        permissions.setPostToGradebook(permission.getPostToGradebook());
        permissions.setRole(permission.getRole());
        this.getHibernateTemplate().saveOrUpdate((Object)permissions);
    }

    public ForumControlPermission getForumControlPermissionForRole(BaseForum forum, String role, String typeId) {
        ControlPermissions permissions = forum == null || forum.getId() == null ? null : this.getControlPermissionByKeyValue(role, "forumId", forum.getId().toString(), false);
        ForumControlPermissionImpl cp = new ForumControlPermissionImpl();
        if (permissions == null) {
            return null;
        }
        cp.setChangeSettings(permissions.getChangeSettings());
        cp.setMovePostings(permissions.getMovePostings());
        cp.setNewResponse(permissions.getNewResponse());
        cp.setNewTopic(permissions.getNewTopic());
        cp.setPostToGradebook(permissions.getPostToGradebook());
        cp.setResponseToResponse(permissions.getResponseToResponse());
        cp.setRole(role);
        return cp;
    }

    public ForumControlPermission getDefaultForumControlPermissionForRole(BaseForum forum, String role, String typeId) {
        ControlPermissions permissions = forum == null || forum.getId() == null ? null : this.getControlPermissionByKeyValue(role, "forumId", forum.getId().toString(), true);
        ForumControlPermissionImpl cp = new ForumControlPermissionImpl();
        if (permissions == null) {
            return null;
        }
        cp.setPostToGradebook(permissions.getPostToGradebook());
        cp.setChangeSettings(permissions.getChangeSettings());
        cp.setMovePostings(permissions.getMovePostings());
        cp.setNewResponse(permissions.getNewResponse());
        cp.setNewTopic(permissions.getNewTopic());
        cp.setResponseToResponse(permissions.getResponseToResponse());
        cp.setRole(role);
        return cp;
    }

    public ForumControlPermission createForumControlPermissionForRole(String role, String typeId) {
        ForumControlPermissionImpl permission = new ForumControlPermissionImpl();
        AreaControlPermission acp = this.getAreaControlPermissionForRole(role, typeId);
        permission.setChangeSettings(acp.getChangeSettings());
        permission.setMovePostings(acp.getMovePostings());
        permission.setNewResponse(acp.getNewResponse());
        permission.setNewTopic(acp.getNewTopic());
        permission.setResponseToResponse(acp.getResponseToResponse());
        permission.setPostToGradebook(acp.getPostToGradebook());
        permission.setRole(role);
        return permission;
    }

    public void saveForumControlPermissionForRole(BaseForum forum, ForumControlPermission permission) {
        ControlPermissionsImpl permissions;
        Object object = permissions = forum == null || forum.getId() == null ? null : this.getControlPermissionByKeyValue(permission.getRole(), "forumId", forum.getId().toString(), false);
        if (permissions == null) {
            permissions = new ControlPermissionsImpl();
        }
        boolean isNew = permissions.getId() == null;
        permissions.setForum(forum);
        permissions.setDefaultValue(Boolean.FALSE);
        permissions.setChangeSettings(permission.getChangeSettings());
        permissions.setMovePostings(permission.getMovePostings());
        permissions.setNewForum(Boolean.FALSE);
        permissions.setNewResponse(permission.getNewResponse());
        permissions.setPostToGradebook(permission.getPostToGradebook());
        permissions.setNewTopic(permission.getNewTopic());
        permissions.setResponseToResponse(permission.getResponseToResponse());
        permissions.setRole(permission.getRole());
        this.getHibernateTemplate().saveOrUpdate((Object)permissions);
        if (this.eventTrackingService == null) {
            throw new RuntimeException("eventTrackingService is null!");
        }
        if (isNew) {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.newforum", this.getEventMessage(forum, permissions), false));
        } else {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.reviseforum", this.getEventMessage(forum, permissions), false));
        }
    }

    public void saveDefaultForumControlPermissionForRole(BaseForum forum, ForumControlPermission permission) {
        ControlPermissionsImpl permissions;
        Object object = permissions = forum == null || forum.getId() == null ? null : this.getControlPermissionByKeyValue(permission.getRole(), "forumId", forum.getId().toString(), false);
        if (permissions == null) {
            permissions = new ControlPermissionsImpl();
        }
        boolean isNew = permissions.getId() == null;
        permissions.setForum(forum);
        permissions.setDefaultValue(Boolean.TRUE);
        permissions.setChangeSettings(permission.getChangeSettings());
        permissions.setMovePostings(permission.getMovePostings());
        permissions.setNewForum(Boolean.FALSE);
        permissions.setNewResponse(permission.getNewResponse());
        permissions.setPostToGradebook(permission.getPostToGradebook());
        permissions.setNewTopic(permission.getNewTopic());
        permissions.setResponseToResponse(permission.getResponseToResponse());
        permissions.setRole(permission.getRole());
        this.getHibernateTemplate().saveOrUpdate((Object)permissions);
        if (this.eventTrackingService == null) {
            throw new RuntimeException("eventTrackingService is null!");
        }
        if (isNew) {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.newforum", this.getEventMessage(forum, permissions), false));
        } else {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.reviseforum", this.getEventMessage(forum, permissions), false));
        }
    }

    public TopicControlPermission getTopicControlPermissionForRole(Topic topic, String role, String typeId) {
        ControlPermissions permissions = topic == null || topic.getId() == null ? null : this.getControlPermissionByKeyValue(role, "topicId", topic.getId().toString(), false);
        TopicControlPermissionImpl cp = new TopicControlPermissionImpl();
        if (permissions == null) {
            return null;
        }
        cp.setChangeSettings(permissions.getChangeSettings());
        cp.setMovePostings(permissions.getMovePostings());
        cp.setNewResponse(permissions.getNewResponse());
        cp.setResponseToResponse(permissions.getResponseToResponse());
        cp.setPostToGradebook(permissions.getPostToGradebook());
        cp.setRole(role);
        return cp;
    }

    public TopicControlPermission getDefaultTopicControlPermissionForRole(Topic topic, String role, String typeId) {
        ControlPermissions permissions = topic == null || topic.getId() == null ? null : this.getControlPermissionByKeyValue(role, "topicId", topic.getId().toString(), true);
        TopicControlPermissionImpl cp = new TopicControlPermissionImpl();
        if (permissions == null) {
            return null;
        }
        cp.setPostToGradebook(permissions.getPostToGradebook());
        cp.setChangeSettings(permissions.getChangeSettings());
        cp.setMovePostings(permissions.getMovePostings());
        cp.setNewResponse(permissions.getNewResponse());
        cp.setResponseToResponse(permissions.getResponseToResponse());
        cp.setRole(role);
        return cp;
    }

    public TopicControlPermission createTopicControlPermissionForRole(BaseForum forum, String role, String typeId) {
        TopicControlPermissionImpl permission = new TopicControlPermissionImpl();
        ForumControlPermission fcp = this.getForumControlPermissionForRole(forum, role, typeId);
        permission.setChangeSettings(fcp.getChangeSettings());
        permission.setMovePostings(fcp.getMovePostings());
        permission.setNewResponse(fcp.getNewResponse());
        permission.setResponseToResponse(fcp.getResponseToResponse());
        permission.setPostToGradebook(fcp.getPostToGradebook());
        permission.setRole(role);
        return permission;
    }

    public void saveTopicControlPermissionForRole(Topic topic, TopicControlPermission permission) {
        ControlPermissionsImpl permissions;
        Object object = permissions = topic == null || topic.getId() == null ? null : this.getControlPermissionByKeyValue(permission.getRole(), "topicId", topic.getId().toString(), false);
        if (permissions == null) {
            permissions = new ControlPermissionsImpl();
        }
        boolean isNew = permissions.getId() == null;
        permissions.setTopic(topic);
        permissions.setDefaultValue(Boolean.FALSE);
        permissions.setChangeSettings(permission.getChangeSettings());
        permissions.setMovePostings(permission.getMovePostings());
        permissions.setNewForum(Boolean.FALSE);
        permissions.setNewResponse(permission.getNewResponse());
        permissions.setNewTopic(Boolean.FALSE);
        permissions.setPostToGradebook(permission.getPostToGradebook());
        permissions.setResponseToResponse(permission.getResponseToResponse());
        permissions.setRole(permission.getRole());
        this.getHibernateTemplate().saveOrUpdate((Object)permissions);
        if (this.eventTrackingService == null) {
            throw new RuntimeException("eventTrackingService is null!");
        }
        if (isNew) {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.newtopic", this.getEventMessage(topic, permissions), false));
        } else {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.revisetopic", this.getEventMessage(topic, permissions), false));
        }
    }

    public void saveDefaultTopicControlPermissionForRole(Topic topic, TopicControlPermission permission) {
        ControlPermissionsImpl permissions;
        Object object = permissions = topic == null || topic.getId() == null ? null : this.getControlPermissionByKeyValue(permission.getRole(), "topicId", topic.getId().toString(), false);
        if (permissions == null) {
            permissions = new ControlPermissionsImpl();
        }
        boolean isNew = permissions.getId() == null;
        permissions.setTopic(topic);
        permissions.setDefaultValue(Boolean.TRUE);
        permissions.setChangeSettings(permission.getChangeSettings());
        permissions.setMovePostings(permission.getMovePostings());
        permissions.setNewForum(Boolean.FALSE);
        permissions.setNewResponse(permission.getNewResponse());
        permissions.setNewTopic(Boolean.FALSE);
        permissions.setResponseToResponse(permission.getResponseToResponse());
        permissions.setPostToGradebook(permission.getPostToGradebook());
        permissions.setRole(permission.getRole());
        this.getHibernateTemplate().saveOrUpdate((Object)permissions);
        if (this.eventTrackingService == null) {
            throw new RuntimeException("eventTrackingService is null!");
        }
        if (isNew) {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.newtopic", this.getEventMessage(topic, permissions), false));
        } else {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.revisetopic", this.getEventMessage(topic, permissions), false));
        }
    }

    public ControlPermissions getAreaControlPermissionByRoleAndType(final String roleId, String typeId, final boolean defaultValue) {
        LOG.debug((Object)("getAreaControlPermissionByRole executing for current user: " + this.getCurrentUser()));
        final Area area = this.areaManager.getAreaByContextIdAndTypeId(typeId);
        if (area == null) {
            return null;
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(PermissionManagerImpl.QUERY_CP_BY_ROLE);
                q.setParameter("roleId", (Object)roleId, (Type)Hibernate.STRING);
                q.setParameter("areaId", (Object)area.getId().toString(), (Type)Hibernate.STRING);
                q.setParameter("defaultValue", (Object)defaultValue, (Type)Hibernate.BOOLEAN);
                return q.uniqueResult();
            }
        };
        return (ControlPermissions)this.getHibernateTemplate().execute(hcb);
    }

    private ControlPermissions getControlPermissionByKeyValue(final String roleId, final String key, final String value, final boolean defaultValue) {
        LOG.debug((Object)("getAreaControlPermissionByRole executing for current user: " + this.getCurrentUser()));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                String queryString = "forumId".equals(key) ? PermissionManagerImpl.QUERY_CP_BY_FORUM : PermissionManagerImpl.QUERY_CP_BY_TOPIC;
                Query q = session.getNamedQuery(queryString);
                q.setParameter("roleId", (Object)roleId, (Type)Hibernate.STRING);
                q.setParameter(key, (Object)value, (Type)Hibernate.STRING);
                q.setParameter("defaultValue", (Object)defaultValue, (Type)Hibernate.BOOLEAN);
                return q.uniqueResult();
            }
        };
        return (ControlPermissions)this.getHibernateTemplate().execute(hcb);
    }

    private MessagePermissions getMessagePermissionByKeyValue(final String roleId, final String key, final String value, final boolean defaultValue) {
        LOG.debug((Object)("getAreaMessagePermissionByRole executing for current user: " + this.getCurrentUser()));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                String queryString = "forumId".equals(key) ? PermissionManagerImpl.QUERY_MP_BY_FORUM : PermissionManagerImpl.QUERY_MP_BY_TOPIC;
                Query q = session.getNamedQuery(queryString);
                q.setParameter("roleId", (Object)roleId, (Type)Hibernate.STRING);
                q.setParameter(key, (Object)value, (Type)Hibernate.STRING);
                q.setParameter("defaultValue", (Object)defaultValue, (Type)Hibernate.BOOLEAN);
                return q.uniqueResult();
            }
        };
        return (MessagePermissions)this.getHibernateTemplate().execute(hcb);
    }

    public MessagePermissions getAreaMessagePermissionForRole(String role, String typeId) {
        MessagePermissions permissions = this.getAreaMessagePermissionByRoleAndType(role, typeId, false);
        MessagePermissionsImpl mp = new MessagePermissionsImpl();
        if (permissions == null) {
            return this.getDefaultAreaMessagePermissionForRole(role, typeId);
        }
        mp.setDeleteAny(permissions.getDeleteAny());
        mp.setDeleteOwn(permissions.getDeleteOwn());
        mp.setRead(permissions.getRead());
        mp.setReadDrafts(permissions.getReadDrafts());
        mp.setReviseAny(permissions.getReviseAny());
        mp.setReviseOwn(permissions.getReviseOwn());
        mp.setMarkAsRead(permissions.getMarkAsRead());
        mp.setRole(role);
        return mp;
    }

    public MessagePermissions getDefaultAreaMessagePermissionForRole(String role, String typeId) {
        MessagePermissionsImpl mp = new MessagePermissionsImpl();
        mp.setRole(role);
        mp.setDeleteAny(Boolean.valueOf(this.defaultPermissionsManager.isDeleteAny(role)));
        mp.setDeleteOwn(Boolean.valueOf(this.defaultPermissionsManager.isDeleteOwn(role)));
        mp.setRead(Boolean.valueOf(this.defaultPermissionsManager.isRead(role)));
        mp.setReadDrafts(Boolean.valueOf(false));
        mp.setReviseAny(Boolean.valueOf(this.defaultPermissionsManager.isReviseAny(role)));
        mp.setReviseOwn(Boolean.valueOf(this.defaultPermissionsManager.isReviseOwn(role)));
        mp.setMarkAsRead(Boolean.valueOf(this.defaultPermissionsManager.isMarkAsRead(role)));
        return mp;
    }

    public MessagePermissions createAreaMessagePermissionForRole(String role, String typeId) {
        MessagePermissionsImpl permissions = new MessagePermissionsImpl();
        MessagePermissions mp = this.getDefaultAreaMessagePermissionForRole(role, typeId);
        if (mp != null) {
            permissions.setDefaultValue(mp.getDefaultValue());
            permissions.setDeleteAny(mp.getDeleteAny());
            permissions.setDeleteOwn(mp.getDeleteOwn());
            permissions.setRead(mp.getRead());
            permissions.setReadDrafts(mp.getReadDrafts());
            permissions.setReviseAny(mp.getReviseAny());
            permissions.setReviseOwn(mp.getReviseOwn());
            permissions.setMarkAsRead(mp.getMarkAsRead());
            permissions.setRole(role);
        }
        return permissions;
    }

    public void saveAreaMessagePermissionForRole(Area area, MessagePermissions permission, String typeId) {
        MessagePermissions permissions = this.getAreaMessagePermissionByRoleAndType(permission.getRole(), typeId, false);
        if (permissions == null) {
            permissions = new MessagePermissionsImpl();
        }
        boolean isNew = permissions.getId() == null;
        permissions.setArea(area);
        permissions.setDefaultValue(Boolean.FALSE);
        permissions.setDeleteAny(permission.getDeleteAny());
        permissions.setDeleteOwn(permission.getDeleteOwn());
        permissions.setRead(permission.getRead());
        permissions.setReadDrafts(permission.getReadDrafts());
        permissions.setReviseAny(permission.getReviseAny());
        permissions.setReviseOwn(permission.getReviseOwn());
        permissions.setRole(permission.getRole());
        permissions.setMarkAsRead(permission.getMarkAsRead());
        this.getHibernateTemplate().saveOrUpdate((Object)permissions);
    }

    public void saveDefaultAreaMessagePermissionForRole(Area area, MessagePermissions permission, String typeId) {
        MessagePermissions permissions = this.getAreaMessagePermissionByRoleAndType(permission.getRole(), typeId, true);
        if (permissions == null) {
            permissions = new MessagePermissionsImpl();
        }
        boolean isNew = permissions.getId() == null;
        permissions.setArea(area);
        permissions.setDefaultValue(Boolean.TRUE);
        permissions.setDeleteAny(permission.getDeleteAny());
        permissions.setDeleteOwn(permission.getDeleteOwn());
        permissions.setRead(permission.getRead());
        permissions.setReadDrafts(permission.getReadDrafts());
        permissions.setReviseAny(permission.getReviseAny());
        permissions.setReviseOwn(permission.getReviseOwn());
        permissions.setMarkAsRead(permission.getMarkAsRead());
        permissions.setRole(permission.getRole());
        this.getHibernateTemplate().saveOrUpdate((Object)permissions);
    }

    public MessagePermissions getForumMessagePermissionForRole(BaseForum forum, String role, String typeId) {
        MessagePermissions permissions = forum == null || forum.getId() == null ? null : this.getMessagePermissionByKeyValue(role, "forumId", forum.getId().toString(), false);
        MessagePermissionsImpl mp = new MessagePermissionsImpl();
        if (permissions == null) {
            return null;
        }
        mp.setDeleteAny(permissions.getDeleteAny());
        mp.setDeleteOwn(permissions.getDeleteOwn());
        mp.setRead(permissions.getRead());
        mp.setReadDrafts(permissions.getReadDrafts());
        mp.setReviseAny(permissions.getReviseAny());
        mp.setReviseOwn(permissions.getReviseOwn());
        mp.setMarkAsRead(permissions.getMarkAsRead());
        mp.setRole(role);
        return mp;
    }

    public MessagePermissions getDefaultForumMessagePermissionForRole(BaseForum forum, String role, String typeId) {
        MessagePermissions permissions = forum == null || forum.getId() == null ? null : this.getMessagePermissionByKeyValue(role, "forumId", forum.getId().toString(), true);
        MessagePermissionsImpl mp = new MessagePermissionsImpl();
        if (permissions == null) {
            return null;
        }
        mp.setDeleteAny(permissions.getDeleteAny());
        mp.setDeleteOwn(permissions.getDeleteOwn());
        mp.setRead(permissions.getRead());
        mp.setReadDrafts(permissions.getReadDrafts());
        mp.setReviseAny(permissions.getReviseAny());
        mp.setReviseOwn(permissions.getReviseOwn());
        mp.setMarkAsRead(permissions.getMarkAsRead());
        mp.setRole(role);
        return mp;
    }

    public MessagePermissions createForumMessagePermissionForRole(String role, String typeId) {
        MessagePermissionsImpl permissions = new MessagePermissionsImpl();
        MessagePermissions mp = this.getAreaMessagePermissionForRole(role, typeId);
        if (mp != null) {
            permissions.setDefaultValue(mp.getDefaultValue());
            permissions.setDeleteAny(mp.getDeleteAny());
            permissions.setDeleteOwn(mp.getDeleteOwn());
            permissions.setRead(mp.getRead());
            permissions.setReadDrafts(mp.getReadDrafts());
            permissions.setReviseAny(mp.getReviseAny());
            permissions.setReviseOwn(mp.getReviseOwn());
            permissions.setMarkAsRead(mp.getMarkAsRead());
            permissions.setRole(role);
        }
        return permissions;
    }

    public void saveForumMessagePermissionForRole(BaseForum forum, MessagePermissions permission) {
        MessagePermissionsImpl permissions;
        Object object = permissions = forum == null || forum.getId() == null ? null : this.getMessagePermissionByKeyValue(permission.getRole(), "forumId", forum.getId().toString(), false);
        if (permissions == null) {
            permissions = new MessagePermissionsImpl();
        }
        boolean isNew = permissions.getId() == null;
        permissions.setForum(forum);
        permissions.setDefaultValue(Boolean.FALSE);
        permissions.setDeleteAny(permission.getDeleteAny());
        permissions.setDeleteOwn(permission.getDeleteOwn());
        permissions.setRead(permission.getRead());
        permissions.setReadDrafts(permission.getReadDrafts());
        permissions.setReviseAny(permission.getReviseAny());
        permissions.setReviseOwn(permission.getReviseOwn());
        permissions.setMarkAsRead(permission.getMarkAsRead());
        permissions.setRole(permission.getRole());
        this.getHibernateTemplate().saveOrUpdate((Object)permissions);
        if (this.eventTrackingService == null) {
            throw new RuntimeException("eventTrackingService is null!");
        }
        if (isNew) {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.newforum", this.getEventMessage(forum, permissions), false));
        } else {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.reviseforum", this.getEventMessage(forum, permissions), false));
        }
    }

    public void saveDefaultForumMessagePermissionForRole(BaseForum forum, MessagePermissions permission) {
        MessagePermissionsImpl permissions;
        Object object = permissions = forum == null || forum.getId() == null ? null : this.getMessagePermissionByKeyValue(permission.getRole(), "forumId", forum.getId().toString(), true);
        if (permissions == null) {
            permissions = new MessagePermissionsImpl();
        }
        boolean isNew = permissions.getId() == null;
        permissions.setForum(forum);
        permissions.setDefaultValue(Boolean.TRUE);
        permissions.setDeleteAny(permission.getDeleteAny());
        permissions.setDeleteOwn(permission.getDeleteOwn());
        permissions.setRead(permission.getRead());
        permissions.setReadDrafts(permission.getReadDrafts());
        permissions.setReviseAny(permission.getReviseAny());
        permissions.setReviseOwn(permission.getReviseOwn());
        permissions.setMarkAsRead(permission.getMarkAsRead());
        permissions.setRole(permission.getRole());
        this.getHibernateTemplate().saveOrUpdate((Object)permissions);
        if (this.eventTrackingService == null) {
            throw new RuntimeException("eventTrackingService is null!");
        }
        if (isNew) {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.newforum", this.getEventMessage(forum, permissions), false));
        } else {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.reviseforum", this.getEventMessage(forum, permissions), false));
        }
    }

    public MessagePermissions getTopicMessagePermissionForRole(Topic topic, String role, String typeId) {
        MessagePermissions permissions = topic == null || topic.getId() == null ? null : this.getMessagePermissionByKeyValue(role, "topicId", topic.getId().toString(), false);
        MessagePermissionsImpl mp = new MessagePermissionsImpl();
        if (permissions == null) {
            return null;
        }
        mp.setDeleteAny(permissions.getDeleteAny());
        mp.setDeleteOwn(permissions.getDeleteOwn());
        mp.setRead(permissions.getRead());
        mp.setReadDrafts(permissions.getReadDrafts());
        mp.setReviseAny(permissions.getReviseAny());
        mp.setReviseOwn(permissions.getReviseOwn());
        mp.setMarkAsRead(permissions.getMarkAsRead());
        mp.setRole(role);
        return mp;
    }

    public MessagePermissions getDefaultTopicMessagePermissionForRole(Topic topic, String role, String typeId) {
        MessagePermissions permissions = topic == null || topic.getId() == null ? null : this.getMessagePermissionByKeyValue(role, "topicId", topic.getId().toString(), true);
        MessagePermissionsImpl mp = new MessagePermissionsImpl();
        if (permissions == null) {
            return null;
        }
        mp.setDeleteAny(permissions.getDeleteAny());
        mp.setDeleteOwn(permissions.getDeleteOwn());
        mp.setRead(permissions.getRead());
        mp.setReadDrafts(permissions.getReadDrafts());
        mp.setReviseAny(permissions.getReviseAny());
        mp.setReviseOwn(permissions.getReviseOwn());
        mp.setMarkAsRead(permissions.getMarkAsRead());
        mp.setRole(role);
        return mp;
    }

    public MessagePermissions createTopicMessagePermissionForRole(BaseForum forum, String role, String typeId) {
        MessagePermissionsImpl permissions = new MessagePermissionsImpl();
        MessagePermissions mp = this.getForumMessagePermissionForRole(forum, role, typeId);
        if (mp != null) {
            permissions.setDefaultValue(mp.getDefaultValue());
            permissions.setDeleteAny(mp.getDeleteAny());
            permissions.setDeleteOwn(mp.getDeleteOwn());
            permissions.setRead(mp.getRead());
            permissions.setReadDrafts(mp.getReadDrafts());
            permissions.setReviseAny(mp.getReviseAny());
            permissions.setReviseOwn(mp.getReviseOwn());
            permissions.setMarkAsRead(mp.getMarkAsRead());
            permissions.setRole(role);
        }
        return permissions;
    }

    public void saveTopicMessagePermissionForRole(Topic topic, MessagePermissions permission) {
        MessagePermissionsImpl permissions;
        Object object = permissions = topic == null || topic.getId() == null ? null : this.getMessagePermissionByKeyValue(permission.getRole(), "topicId", topic.getId().toString(), false);
        if (permissions == null) {
            permissions = new MessagePermissionsImpl();
        }
        boolean isNew = permissions.getId() == null;
        permissions.setTopic(topic);
        permissions.setDefaultValue(Boolean.FALSE);
        permissions.setDeleteAny(permission.getDeleteAny());
        permissions.setDeleteOwn(permission.getDeleteOwn());
        permissions.setRead(permission.getRead());
        permissions.setReadDrafts(permission.getReadDrafts());
        permissions.setReviseAny(permission.getReviseAny());
        permissions.setReviseOwn(permission.getReviseOwn());
        permissions.setMarkAsRead(permission.getMarkAsRead());
        permissions.setRole(permission.getRole());
        this.getHibernateTemplate().saveOrUpdate((Object)permissions);
        if (this.eventTrackingService == null) {
            throw new RuntimeException("eventTrackingService is null!");
        }
        if (isNew) {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.newtopic", this.getEventMessage(topic, permissions), false));
        } else {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.revisetopic", this.getEventMessage(topic, permissions), false));
        }
    }

    public void saveDefaultTopicMessagePermissionForRole(Topic topic, MessagePermissions permission) {
        MessagePermissionsImpl permissions;
        Object object = permissions = topic == null || topic.getId() == null ? null : this.getMessagePermissionByKeyValue(permission.getRole(), "topicId", topic.getId().toString(), true);
        if (permissions == null) {
            permissions = new MessagePermissionsImpl();
        }
        boolean isNew = permissions.getId() == null;
        permissions.setTopic(topic);
        permissions.setDefaultValue(Boolean.TRUE);
        permissions.setDeleteAny(permission.getDeleteAny());
        permissions.setDeleteOwn(permission.getDeleteOwn());
        permissions.setRead(permissions.getRead());
        permissions.setReadDrafts(permission.getReadDrafts());
        permissions.setReviseAny(permission.getReviseAny());
        permissions.setReviseOwn(permission.getReviseOwn());
        permissions.setMarkAsRead(permission.getMarkAsRead());
        permissions.setRole(permission.getRole());
        this.getHibernateTemplate().saveOrUpdate((Object)permissions);
        if (this.eventTrackingService == null) {
            throw new RuntimeException("eventTrackingService is null!");
        }
        if (isNew) {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.newtopic", this.getEventMessage(topic, permissions), false));
        } else {
            this.eventTrackingService.post(this.eventTrackingService.newEvent("forums.revisetopic", this.getEventMessage(topic, permissions), false));
        }
    }

    public MessagePermissions getAreaMessagePermissionByRoleAndType(final String roleId, String typeId, final boolean defaultValue) {
        LOG.debug((Object)("getAreaMessagePermissionByRole executing for current user: " + this.getCurrentUser()));
        final Area area = this.areaManager.getAreaByContextIdAndTypeId(typeId);
        if (area == null) {
            return null;
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(PermissionManagerImpl.QUERY_MP_BY_ROLE);
                q.setParameter("roleId", (Object)roleId, (Type)Hibernate.STRING);
                q.setParameter("areaId", (Object)area.getId().toString(), (Type)Hibernate.STRING);
                q.setParameter("defaultValue", (Object)defaultValue, (Type)Hibernate.BOOLEAN);
                return q.uniqueResult();
            }
        };
        return (MessagePermissions)this.getHibernateTemplate().execute(hcb);
    }

    private String getCurrentUser() {
        if (TestUtil.isRunningTests()) {
            return "test-user";
        }
        return this.sessionManager.getCurrentSessionUserId();
    }

    private String getEventMessage(Object parent, Object child) {
        return "/MessageCenter/site/" + this.getContextId() + "/" + parent.toString() + "/" + child.toString() + "/" + this.getCurrentUser();
    }

    private String getContextId() {
        if (TestUtil.isRunningTests()) {
            return "test-context";
        }
        Placement placement = ToolManager.getCurrentPlacement();
        String presentSiteId = placement.getContext();
        return presentSiteId;
    }
}

