/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.sakaiproject.api.app.messageforums.Area;
import org.sakaiproject.api.app.messageforums.MessageForumsMessageManager;
import org.sakaiproject.api.app.messageforums.MessageForumsTypeManager;
import org.sakaiproject.api.app.messageforums.SynopticMsgcntrItem;
import org.sakaiproject.api.app.messageforums.SynopticMsgcntrManager;
import org.sakaiproject.api.app.messageforums.ui.DiscussionForumManager;
import org.sakaiproject.api.app.messageforums.ui.PrivateMessageManager;
import org.sakaiproject.api.app.messageforums.ui.UIPermissionsManager;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.component.app.messageforums.dao.hibernate.SynopticMsgcntrItemImpl;
import org.sakaiproject.db.cover.SqlService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynopticMsgcntrManagerImpl
extends HibernateDaoSupport
implements SynopticMsgcntrManager {
    private static final Log LOG = LogFactory.getLog(SynopticMsgcntrManagerImpl.class);
    private static final String QUERY_WORKSPACE_SYNOPTIC_ITEMS = "findWorkspaceSynopticMsgcntrItems";
    private static final String QUERY_SITE_SYNOPTIC_ITEMS = "findSiteSynopticMsgcntrItems";
    private static final String QUERY_UPDATE_ALL_SITE_TITLES = "updateSiteTitles";
    private HashMap mfPageInSiteMap;
    private HashMap sitesMap;
    private transient DecoratedCompiledMessageStats siteContents;
    private MessageForumsMessageManager messageManager;
    private UIPermissionsManager uiPermissionsManager;
    private PrivateMessageManager pvtMessageManager;
    private MessageForumsTypeManager typeManager;
    private DiscussionForumManager forumManager;

    public void init() {
        LOG.info((Object)"init()");
    }

    public List<SynopticMsgcntrItem> getWorkspaceSynopticMsgcntrItems(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(SynopticMsgcntrManagerImpl.QUERY_WORKSPACE_SYNOPTIC_ITEMS);
                q.setParameter("userId", (Object)userId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public SynopticMsgcntrItem getSiteSynopticMsgcntrItem(final String userId, final String siteId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(SynopticMsgcntrManagerImpl.QUERY_SITE_SYNOPTIC_ITEMS);
                q.setParameter("userId", (Object)userId, (Type)Hibernate.STRING);
                q.setParameter("siteId", (Object)siteId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (SynopticMsgcntrItem)this.getHibernateTemplate().execute(hcb);
    }

    public SynopticMsgcntrItem createSynopticMsgcntrItem(String userId, String siteId, String siteTitle) {
        return new SynopticMsgcntrItemImpl(userId, siteId, siteTitle);
    }

    public void saveSynopticMsgcntrItem(SynopticMsgcntrItem item) {
        this.getHibernateTemplate().saveOrUpdate((Object)item);
    }

    public void deleteSynopticMsgcntrItem(SynopticMsgcntrItem item) {
        this.getHibernateTemplate().delete((Object)item);
    }

    public void incrementMessagesSynopticToolInfo(String userId, String siteId) {
        this.incrementSynopticToolInfo(userId, siteId, true);
    }

    public void incrementForumSynopticToolInfo(String userId, String siteId) {
        this.incrementSynopticToolInfo(userId, siteId, false);
    }

    private void incrementSynopticToolInfo(String userId, String siteId, boolean messages) {
        SynopticMsgcntrItem item = this.getSiteSynopticMsgcntrItem(userId, siteId);
        if (item == null) {
            this.resetMessagesAndForumSynopticInfo(userId, siteId);
        } else {
            if (messages) {
                item.incrementNewMessagesCount();
            } else {
                item.incrementNewForumCount();
            }
            this.saveSynopticMsgcntrItem(item);
        }
    }

    public void decrementMessagesSynopticToolInfo(String userId, String siteId) {
        this.decrementSynopticToolInfo(userId, siteId, true);
    }

    public void decrementForumSynopticToolInfo(String userId, String siteId) {
        this.decrementSynopticToolInfo(userId, siteId, false);
    }

    private void decrementSynopticToolInfo(String userId, String siteId, boolean messages) {
        SynopticMsgcntrItem item = this.getSiteSynopticMsgcntrItem(userId, siteId);
        if (item == null) {
            this.resetMessagesAndForumSynopticInfo(userId, siteId);
        } else {
            if (messages) {
                item.decrementNewMessagesCount();
            } else {
                item.decrementNewForumCount();
            }
            this.saveSynopticMsgcntrItem(item);
        }
    }

    public void resetMessagesAndForumSynopticInfo(String userId, String siteId) {
        if (userId == null) {
            return;
        }
        DecoratedCompiledMessageStats dcmStats = this.getSiteInfo(siteId, userId);
        SynopticMsgcntrItem item = this.getSiteSynopticMsgcntrItem(userId, siteId);
        if (item == null) {
            SynopticMsgcntrItem synopticMsgcntrItem = this.createSynopticMsgcntrItem(userId, siteId, dcmStats.getSiteName());
            synopticMsgcntrItem.setNewMessagesCount(dcmStats.getUnreadPrivateAmt());
            synopticMsgcntrItem.setNewForumCount(dcmStats.getUnreadForumsAmt());
            this.saveSynopticMsgcntrItem(synopticMsgcntrItem);
        } else {
            item.setNewMessagesCount(dcmStats.getUnreadPrivateAmt());
            item.setMessagesLastVisitToCurrentDt();
            item.setNewForumCount(dcmStats.getUnreadForumsAmt());
            item.setForumLastVisitToCurrentDt();
            this.saveSynopticMsgcntrItem(item);
        }
    }

    public void setMessagesSynopticInfoHelper(String userId, String siteId, int newMessageCount) {
        this.setSynopticInfoHelper(userId, siteId, true, newMessageCount);
    }

    public void setForumSynopticInfoHelper(String userId, String siteId, int newMessageCount) {
        this.setSynopticInfoHelper(userId, siteId, false, newMessageCount);
    }

    private void setSynopticInfoHelper(String userId, String siteId, boolean messages, int newMessageCount) {
        if (userId == null && this.forumManager.getAnonRole()) {
            return;
        }
        SynopticMsgcntrItem item = this.getSiteSynopticMsgcntrItem(userId, siteId);
        if (item == null) {
            this.resetMessagesAndForumSynopticInfo(userId, siteId);
        } else {
            if (messages) {
                item.setNewMessagesCount(newMessageCount);
                item.setMessagesLastVisitToCurrentDt();
            } else {
                item.setNewForumCount(newMessageCount);
                item.setForumLastVisitToCurrentDt();
            }
            this.saveSynopticMsgcntrItem(item);
        }
    }

    public void updateDifferenceMessagesSynopticInfoHelper(String userId, String siteId, int differenceCount) {
        this.updateDifferenceSynopticInfoHelper(userId, siteId, true, differenceCount);
    }

    public void updateDifferenceForumSynopticInfoHelper(String userId, String siteId, int differenceCount) {
        this.updateDifferenceSynopticInfoHelper(userId, siteId, false, differenceCount);
    }

    private void updateDifferenceSynopticInfoHelper(String userId, String siteId, boolean messages, int differenceCount) {
        SynopticMsgcntrItem item = this.getSiteSynopticMsgcntrItem(userId, siteId);
        if (item == null) {
            this.resetMessagesAndForumSynopticInfo(userId, siteId);
        } else {
            if (messages) {
                int newCount = item.getNewMessagesCount() + differenceCount;
                if (newCount < 0) {
                    newCount = 0;
                }
                item.setNewMessagesCount(newCount);
                item.setMessagesLastVisitToCurrentDt();
            } else {
                int newCount = item.getNewForumCount() + differenceCount;
                if (newCount < 0) {
                    newCount = 0;
                }
                item.setNewForumCount(newCount);
                item.setForumLastVisitToCurrentDt();
            }
            this.saveSynopticMsgcntrItem(item);
        }
    }

    public void createOrUpdateSynopticToolInfo(String userId, String siteId, String siteTitle, int unreadMessageCount, int unreadForumCount) {
        SynopticMsgcntrItem item = this.getSiteSynopticMsgcntrItem(userId, siteId);
        if (item == null) {
            SynopticMsgcntrItem synopticMsgcntrItem = this.createSynopticMsgcntrItem(userId, siteId, siteTitle);
            synopticMsgcntrItem.setNewMessagesCount(unreadMessageCount);
            synopticMsgcntrItem.setNewForumCount(unreadForumCount);
            this.saveSynopticMsgcntrItem(synopticMsgcntrItem);
        } else {
            item.setNewMessagesCount(unreadMessageCount);
            item.setMessagesLastVisitToCurrentDt();
            item.setNewForumCount(unreadForumCount);
            item.setForumLastVisitToCurrentDt();
            this.saveSynopticMsgcntrItem(item);
            if (item.getSiteTitle() == null || item.getSiteTitle() != null && !item.getSiteTitle().equals(siteTitle)) {
                this.updateAllSiteTitles(siteId, siteTitle);
            }
        }
    }

    public DecoratedCompiledMessageStats getSiteInfo(String siteId, String userId) {
        return this.getSiteContents(siteId, userId);
    }

    public int findAllUnreadMessages(List aggregateList) {
        int unreadCount = 0;
        for (Object[] element : aggregateList) {
            if (Boolean.TRUE.equals(element[0])) continue;
            unreadCount += ((Integer)element[2]).intValue();
        }
        return unreadCount;
    }

    public void resetAllUsersSynopticInfoInSite(String siteId) {
        ArrayList<String> users = new ArrayList<String>();
        try {
            Site site = this.getSite(siteId);
            for (Member member : site.getMembers()) {
                String userId = member.getUserId();
                users.add(userId);
            }
            this.resetAllUsersSynopticInfoInSite(siteId, users);
        }
        catch (IdUnusedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void resetAllUsersSynopticInfoInSite(String siteId, List<String> users) {
        block46: {
            String NEW_MESSAGE_COUNT_FOR_ALL_USERS_SQL = "SELECT USER_ID, count(*) unread_messages FROM MFR_PVT_MSG_USR_T message where READ_STATUS = 0 and CONTEXT_ID = ? Group By USER_ID";
            String RETURN_ALL_FORUMS_AND_TOPICS_SQL = "select forum.ID as FORUM_ID, topic.ID as TOPIC_ID, forum.DRAFT as isForumDraft, topic.DRAFT as isTopicDraft, topic.MODERATED as isTopicModerated, forum.LOCKED as isForumLocked, topic.LOCKED as isTopicLocked, forum.CREATED_BY as forumCreatedBy, topic.CREATED_BY as topicCreatedBy, forum.AVAILABILITY as forumAvailability, topic.AVAILABILITY as topicAvailability  from MFR_AREA_T area, MFR_OPEN_FORUM_T forum, MFR_TOPIC_T topic Where area.ID = forum.surrogateKey and forum.ID = topic.of_surrogateKey and area.CONTEXT_ID = ?";
            Connection clConnection = null;
            PreparedStatement newMessageCountForAllUsers = null;
            PreparedStatement returnAllForumsAndTopics = null;
            ResultSet forumsAndTopicsRS = null;
            ResultSet newMessagesCountRS = null;
            Site site = this.getSite(siteId);
            clConnection = SqlService.borrowConnection();
            newMessageCountForAllUsers = clConnection.prepareStatement(NEW_MESSAGE_COUNT_FOR_ALL_USERS_SQL);
            newMessageCountForAllUsers.setString(1, siteId);
            returnAllForumsAndTopics = clConnection.prepareStatement(RETURN_ALL_FORUMS_AND_TOPICS_SQL);
            returnAllForumsAndTopics.setString(1, siteId);
            forumsAndTopicsRS = returnAllForumsAndTopics.executeQuery();
            HashMap<Long, DecoratedForumInfo> dfHM = this.getDecoratedForumsAndTopics(forumsAndTopicsRS);
            newMessagesCountRS = newMessageCountForAllUsers.executeQuery();
            HashMap<String, Integer> unreadMessagesHM = this.getUnreadMessagesHM(newMessagesCountRS);
            for (String userId : users) {
                DecoratedCompiledMessageStats dcms = this.getDMessageStats(userId, siteId, site, dfHM, unreadMessagesHM);
                this.createOrUpdateSynopticToolInfo(userId, siteId, dcms.getSiteName(), dcms.getUnreadPrivateAmt(), dcms.getUnreadForumsAmt());
            }
            Object var17_18 = null;
            try {
                if (forumsAndTopicsRS != null) {
                    forumsAndTopicsRS.close();
                }
            }
            catch (Exception e2) {
                LOG.warn((Object)e2);
            }
            try {
                if (newMessagesCountRS != null) {
                    newMessagesCountRS.close();
                }
            }
            catch (Exception e2) {
                LOG.warn((Object)e2);
            }
            try {
                if (newMessageCountForAllUsers != null) {
                    newMessageCountForAllUsers.close();
                }
            }
            catch (Exception e2) {
                LOG.warn((Object)e2);
            }
            try {
                if (returnAllForumsAndTopics != null) {
                    returnAllForumsAndTopics.close();
                }
            }
            catch (Exception e2) {
                LOG.warn((Object)e2);
            }
            SqlService.returnConnection((Connection)clConnection);
            {
                break block46;
                catch (IdUnusedException e) {
                    LOG.error((Object)e);
                    Object var17_19 = null;
                    try {
                        if (forumsAndTopicsRS != null) {
                            forumsAndTopicsRS.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    try {
                        if (newMessagesCountRS != null) {
                            newMessagesCountRS.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    try {
                        if (newMessageCountForAllUsers != null) {
                            newMessageCountForAllUsers.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    try {
                        if (returnAllForumsAndTopics != null) {
                            returnAllForumsAndTopics.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    SqlService.returnConnection((Connection)clConnection);
                    break block46;
                }
                catch (SQLException e) {
                    LOG.error((Object)e);
                    Object var17_20 = null;
                    try {
                        if (forumsAndTopicsRS != null) {
                            forumsAndTopicsRS.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    try {
                        if (newMessagesCountRS != null) {
                            newMessagesCountRS.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    try {
                        if (newMessageCountForAllUsers != null) {
                            newMessageCountForAllUsers.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    try {
                        if (returnAllForumsAndTopics != null) {
                            returnAllForumsAndTopics.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    SqlService.returnConnection((Connection)clConnection);
                }
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                try {
                    if (forumsAndTopicsRS != null) {
                        forumsAndTopicsRS.close();
                    }
                }
                catch (Exception e2) {
                    LOG.warn((Object)e2);
                }
                try {
                    if (newMessagesCountRS != null) {
                        newMessagesCountRS.close();
                    }
                }
                catch (Exception e2) {
                    LOG.warn((Object)e2);
                }
                try {
                    if (newMessageCountForAllUsers != null) {
                        newMessageCountForAllUsers.close();
                    }
                }
                catch (Exception e2) {
                    LOG.warn((Object)e2);
                }
                try {
                    if (returnAllForumsAndTopics != null) {
                        returnAllForumsAndTopics.close();
                    }
                }
                catch (Exception e2) {
                    LOG.warn((Object)e2);
                }
                SqlService.returnConnection((Connection)clConnection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap<String, Integer> getUserToNewMessagesForForumMap(String siteId, Long forumId, Long topicId) {
        HashMap<String, Integer> returnHM;
        block29: {
            returnHM = new HashMap<String, Integer>();
            String RETURN_ALL_TOPICS_FOR_FORUM_SQL = "select forum.ID as FORUM_ID, topic.ID as TOPIC_ID, forum.DRAFT as isForumDraft, topic.DRAFT as isTopicDraft, topic.MODERATED as isTopicModerated, forum.LOCKED as isForumLocked, topic.LOCKED as isTopicLocked, forum.CREATED_BY as forumCreatedBy, topic.CREATED_BY as topicCreatedBy, forum.AVAILABILITY as forumAvailability, topic.AVAILABILITY as topicAvailability  from MFR_AREA_T area, MFR_OPEN_FORUM_T forum, MFR_TOPIC_T topic Where area.ID = forum.surrogateKey and forum.ID = topic.of_surrogateKey and area.CONTEXT_ID = ? and forum.ID = ?";
            if (topicId != null) {
                RETURN_ALL_TOPICS_FOR_FORUM_SQL = RETURN_ALL_TOPICS_FOR_FORUM_SQL + " and topic.ID = ?";
            }
            ArrayList<String> users = new ArrayList<String>();
            Connection clConnection = null;
            Statement returnAllTopicsForForum = null;
            ResultSet forumsAndTopicsRS = null;
            Site site = this.getSite(siteId);
            for (Member member : site.getMembers()) {
                String userId = member.getUserId();
                users.add(userId);
            }
            clConnection = SqlService.borrowConnection();
            returnAllTopicsForForum = clConnection.prepareStatement(RETURN_ALL_TOPICS_FOR_FORUM_SQL);
            returnAllTopicsForForum.setString(1, siteId);
            returnAllTopicsForForum.setString(2, "" + forumId);
            if (topicId != null) {
                returnAllTopicsForForum.setString(3, "" + topicId);
            }
            forumsAndTopicsRS = returnAllTopicsForForum.executeQuery();
            HashMap<Long, DecoratedForumInfo> dfHM = this.getDecoratedForumsAndTopics(forumsAndTopicsRS);
            for (String userId : users) {
                DecoratedCompiledMessageStats dcms = this.getDMessageStats(userId, siteId, site, dfHM, null);
                returnHM.put(userId, dcms.getUnreadForumsAmt());
            }
            Object var16_17 = null;
            try {
                if (forumsAndTopicsRS != null) {
                    forumsAndTopicsRS.close();
                }
            }
            catch (Exception e2) {
                LOG.warn((Object)e2);
            }
            try {
                if (returnAllTopicsForForum != null) {
                    returnAllTopicsForForum.close();
                }
            }
            catch (Exception e2) {
                LOG.warn((Object)e2);
            }
            SqlService.returnConnection((Connection)clConnection);
            {
                break block29;
                catch (IdUnusedException e) {
                    LOG.error((Object)e);
                    Object var16_18 = null;
                    try {
                        if (forumsAndTopicsRS != null) {
                            forumsAndTopicsRS.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    try {
                        if (returnAllTopicsForForum != null) {
                            returnAllTopicsForForum.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    SqlService.returnConnection((Connection)clConnection);
                    break block29;
                }
                catch (SQLException e) {
                    LOG.error((Object)e);
                    Object var16_19 = null;
                    try {
                        if (forumsAndTopicsRS != null) {
                            forumsAndTopicsRS.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    try {
                        if (returnAllTopicsForForum != null) {
                            returnAllTopicsForForum.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    SqlService.returnConnection((Connection)clConnection);
                }
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                try {
                    if (forumsAndTopicsRS != null) {
                        forumsAndTopicsRS.close();
                    }
                }
                catch (Exception e2) {
                    LOG.warn((Object)e2);
                }
                try {
                    if (returnAllTopicsForForum != null) {
                        returnAllTopicsForForum.close();
                    }
                }
                catch (Exception e2) {
                    LOG.warn((Object)e2);
                }
                SqlService.returnConnection((Connection)clConnection);
                throw throwable;
            }
        }
        return returnHM;
    }

    public void updateSynopticMessagesForForumComparingOldMessagesCount(String siteId, Long forumId, Long topicId, HashMap<String, Integer> previousCountHM) {
        HashMap<String, Integer> newCountHM;
        if (previousCountHM != null && (newCountHM = this.getUserToNewMessagesForForumMap(siteId, forumId, topicId)) != null) {
            Set<String> users = newCountHM.keySet();
            int oldForumCount = 0;
            int newForumCount = 0;
            int forumCountDiff = 0;
            for (String userId : users) {
                Integer newForumCountInt;
                oldForumCount = 0;
                newForumCount = 0;
                forumCountDiff = 0;
                Integer oldForumCountInt = previousCountHM.get(userId);
                if (oldForumCountInt != null) {
                    oldForumCount = oldForumCountInt;
                }
                if ((newForumCountInt = newCountHM.get(userId)) != null) {
                    newForumCount = newForumCountInt;
                }
                forumCountDiff = newForumCount - oldForumCount;
                this.updateDifferenceForumSynopticInfoHelper(userId, siteId, forumCountDiff);
            }
        }
    }

    private DecoratedCompiledMessageStats getDMessageStats(String userId, String siteId, Site site, HashMap<Long, DecoratedForumInfo> dfHM, HashMap<String, Integer> unreadMessagesHM) {
        DecoratedCompiledMessageStats dcms = new DecoratedCompiledMessageStats();
        boolean isMessageForumsPageInSite = this.isMessageForumsPageInSite(site);
        dcms.setSiteName(site.getTitle());
        dcms.setSiteId(siteId);
        if (userId == null) {
            return dcms;
        }
        if ((isMessageForumsPageInSite || this.isMessagesPageInSite(site)) && unreadMessagesHM != null) {
            Integer newMessageCount;
            boolean isEnabled;
            if (isMessageForumsPageInSite) {
                Area area = this.pvtMessageManager.getPrivateMessageArea(siteId);
                isEnabled = area.getEnabled();
            } else {
                isEnabled = true;
            }
            if (isEnabled && (newMessageCount = unreadMessagesHM.get(userId)) != null) {
                dcms.setUnreadPrivateAmt(newMessageCount);
            }
        }
        if (isMessageForumsPageInSite || this.isForumsPageInSite(site)) {
            Set<Long> dfKeySet = null;
            int unreadForum = 0;
            if (dfHM != null) {
                Area area;
                boolean isSuperUser = SecurityService.isSuperUser((String)userId);
                dfKeySet = dfHM.keySet();
                boolean isInstructor = this.getForumManager().isInstructor(userId, "/site/" + siteId);
                boolean hasOverridingPermission = false;
                if (isInstructor || isSuperUser) {
                    hasOverridingPermission = true;
                }
                boolean isAreaAvailable = true;
                if (!hasOverridingPermission && (area = this.forumManager.getDiscussionForumArea(siteId)) != null) {
                    isAreaAvailable = area.getAvailability();
                }
                if (isAreaAvailable) {
                    for (Long dfId : dfKeySet) {
                        DecoratedForumInfo dForum = dfHM.get(dfId);
                        if ((!dForum.getIsDraft().equals(Boolean.FALSE) || !dForum.getAvailability().booleanValue()) && !hasOverridingPermission && !this.forumManager.isForumOwner(dfId, dForum.getCreator(), userId, "/site/" + siteId)) continue;
                        for (DecoratedTopicsInfo topic : dForum.getTopics()) {
                            Long topicId = topic.getTopicId();
                            Boolean isTopicDraft = topic.getIsDraft();
                            Boolean isTopicModerated = topic.getIsModerated();
                            Boolean isTopicLocked = topic.getIsLocked();
                            String topicOwner = topic.getCreator();
                            if ((!isTopicDraft.equals(Boolean.FALSE) || !topic.getAvailability().booleanValue()) && !isInstructor && !isSuperUser && !this.forumManager.isTopicOwner(topicId, topicOwner, userId, "/site/" + siteId) || !this.getUiPermissionsManager().isRead(topicId, isTopicDraft, dForum.getIsDraft(), userId, siteId)) continue;
                            if (!isTopicModerated.booleanValue() || isTopicModerated.booleanValue() && this.getUiPermissionsManager().isModeratePostings(topicId, dForum.getIsLocked(), dForum.getIsDraft(), isTopicLocked, isTopicDraft, userId, siteId)) {
                                unreadForum += this.getMessageManager().findUnreadMessageCountByTopicIdByUserId(topicId, userId);
                                continue;
                            }
                            unreadForum += this.getMessageManager().findUnreadViewableMessageCountByTopicIdByUserId(topicId, userId);
                        }
                    }
                }
            }
            dcms.setUnreadForumsAmt(unreadForum);
        }
        return dcms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private DecoratedCompiledMessageStats getSiteContents(String siteId, String userId) {
        DecoratedCompiledMessageStats dcms;
        block49: {
            String NEW_MESSAGE_COUNT_SQL = "SELECT USER_ID, count(*) unread_messages FROM MFR_PVT_MSG_USR_T message where READ_STATUS = 0 and USER_ID = ? and CONTEXT_ID = ? Group By USER_ID";
            String RETURN_ALL_FORUMS_AND_TOPICS_SQL = "select forum.ID as FORUM_ID, topic.ID as TOPIC_ID, forum.DRAFT as isForumDraft, topic.DRAFT as isTopicDraft, topic.MODERATED as isTopicModerated, forum.LOCKED as isForumLocked, topic.LOCKED as isTopicLocked, forum.CREATED_BY as forumCreatedBy, topic.CREATED_BY as topicCreatedBy, forum.AVAILABILITY as forumAvailability, topic.AVAILABILITY as topicAvailability  from MFR_AREA_T area, MFR_OPEN_FORUM_T forum, MFR_TOPIC_T topic Where area.ID = forum.surrogateKey and forum.ID = topic.of_surrogateKey and area.CONTEXT_ID = ?";
            Connection clConnection = null;
            PreparedStatement newMessageCount = null;
            Statement returnAllForumsAndTopics = null;
            ResultSet forumsAndTopicsRS = null;
            ResultSet newMessagesCountRS = null;
            dcms = new DecoratedCompiledMessageStats();
            clConnection = SqlService.borrowConnection();
            newMessageCount = clConnection.prepareStatement(NEW_MESSAGE_COUNT_SQL);
            newMessageCount.setString(1, userId);
            newMessageCount.setString(2, siteId);
            returnAllForumsAndTopics = clConnection.prepareStatement(RETURN_ALL_FORUMS_AND_TOPICS_SQL);
            returnAllForumsAndTopics.setString(1, siteId);
            Site site = this.getSite(siteId);
            forumsAndTopicsRS = returnAllForumsAndTopics.executeQuery();
            HashMap<Long, DecoratedForumInfo> dfHM = this.getDecoratedForumsAndTopics(forumsAndTopicsRS);
            newMessagesCountRS = newMessageCount.executeQuery();
            HashMap<String, Integer> unreadMessagesHM = this.getUnreadMessagesHM(newMessagesCountRS);
            DecoratedCompiledMessageStats decoratedCompiledMessageStats = this.getDMessageStats(userId, siteId, site, dfHM, unreadMessagesHM);
            Object var16_17 = null;
            try {
                if (forumsAndTopicsRS != null) {
                    forumsAndTopicsRS.close();
                }
            }
            catch (Exception e2) {
                LOG.warn((Object)e2);
            }
            try {
                if (newMessagesCountRS != null) {
                    newMessagesCountRS.close();
                }
            }
            catch (Exception e2) {
                LOG.warn((Object)e2);
            }
            try {
                if (returnAllForumsAndTopics != null) {
                    returnAllForumsAndTopics.close();
                }
            }
            catch (Exception e2) {
                LOG.warn((Object)e2);
            }
            try {
                if (newMessageCount != null) {
                    newMessageCount.close();
                }
            }
            catch (Exception e2) {
                LOG.warn((Object)e2);
            }
            SqlService.returnConnection((Connection)clConnection);
            {
                return decoratedCompiledMessageStats;
                catch (IdUnusedException e) {
                    LOG.error((Object)"IdUnusedException while trying to check if site has MF tool.");
                    Object var16_18 = null;
                    try {
                        if (forumsAndTopicsRS != null) {
                            forumsAndTopicsRS.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    try {
                        if (newMessagesCountRS != null) {
                            newMessagesCountRS.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    try {
                        if (returnAllForumsAndTopics != null) {
                            returnAllForumsAndTopics.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    try {
                        if (newMessageCount != null) {
                            newMessageCount.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    SqlService.returnConnection((Connection)clConnection);
                    break block49;
                }
                catch (SQLException e) {
                    LOG.error((Object)e);
                    Object var16_19 = null;
                    try {
                        if (forumsAndTopicsRS != null) {
                            forumsAndTopicsRS.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    try {
                        if (newMessagesCountRS != null) {
                            newMessagesCountRS.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    try {
                        if (returnAllForumsAndTopics != null) {
                            returnAllForumsAndTopics.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    try {
                        if (newMessageCount != null) {
                            newMessageCount.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    SqlService.returnConnection((Connection)clConnection);
                }
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                try {
                    if (forumsAndTopicsRS != null) {
                        forumsAndTopicsRS.close();
                    }
                }
                catch (Exception e2) {
                    LOG.warn((Object)e2);
                }
                try {
                    if (newMessagesCountRS != null) {
                        newMessagesCountRS.close();
                    }
                }
                catch (Exception e2) {
                    LOG.warn((Object)e2);
                }
                try {
                    if (returnAllForumsAndTopics != null) {
                        returnAllForumsAndTopics.close();
                    }
                }
                catch (Exception e2) {
                    LOG.warn((Object)e2);
                }
                try {
                    if (newMessageCount != null) {
                        newMessageCount.close();
                    }
                }
                catch (Exception e2) {
                    LOG.warn((Object)e2);
                }
                SqlService.returnConnection((Connection)clConnection);
                throw throwable;
            }
        }
        return dcms;
    }

    private HashMap<Long, DecoratedForumInfo> getDecoratedForumsAndTopics(ResultSet rs) {
        HashMap<Long, DecoratedForumInfo> returnHM = new HashMap<Long, DecoratedForumInfo>();
        try {
            while (rs.next()) {
                DecoratedTopicsInfo dTopic;
                Long FORUM_ID = rs.getLong("FORUM_ID");
                Long TOPIC_ID = rs.getLong("TOPIC_ID");
                Boolean IS_TOPIC_DRAFT = rs.getBoolean("isTopicDraft");
                Boolean IS_FORUM_DRAFT = rs.getBoolean("isForumDraft");
                Boolean IS_TOPIC_MODERATED = rs.getBoolean("isTopicModerated");
                Boolean IS_FORUM_LOCKED = rs.getBoolean("isForumLocked");
                Boolean IS_TOPIC_LOCKED = rs.getBoolean("isTopicLocked");
                String FORUM_CREATED_BY = rs.getString("forumCreatedBy");
                String TOPIC_CREATED_BY = rs.getString("topicCreatedBy");
                Boolean FORUM_AVAILABILITY = rs.getBoolean("forumAvailability");
                Boolean TOPIC_AVAILABILITY = rs.getBoolean("topicAvailability");
                if (returnHM.containsKey(FORUM_ID)) {
                    dTopic = new DecoratedTopicsInfo(TOPIC_ID, IS_TOPIC_LOCKED, IS_TOPIC_DRAFT, TOPIC_AVAILABILITY, IS_TOPIC_MODERATED, TOPIC_CREATED_BY);
                    returnHM.get(FORUM_ID).addTopic(dTopic);
                    continue;
                }
                dTopic = new DecoratedTopicsInfo(TOPIC_ID, IS_TOPIC_LOCKED, IS_TOPIC_DRAFT, TOPIC_AVAILABILITY, IS_TOPIC_MODERATED, TOPIC_CREATED_BY);
                DecoratedForumInfo dForum = new DecoratedForumInfo(FORUM_ID, IS_FORUM_LOCKED, IS_FORUM_DRAFT, FORUM_AVAILABILITY, FORUM_CREATED_BY);
                dForum.addTopic(dTopic);
                returnHM.put(FORUM_ID, dForum);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return returnHM;
    }

    public HashMap<String, Integer> getUnreadMessagesHM(ResultSet rs) {
        HashMap<String, Integer> returnHM = new HashMap<String, Integer>();
        if (rs != null) {
            try {
                while (rs.next()) {
                    String userId = rs.getString("USER_ID");
                    Integer messageCount = rs.getInt("unread_messages");
                    returnHM.put(userId, messageCount);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return returnHM;
    }

    private boolean isMessageForumsPageInSite(Site thisSite) {
        Boolean isMFPageInSite;
        if (this.mfPageInSiteMap == null) {
            this.mfPageInSiteMap = new HashMap();
        }
        if ((isMFPageInSite = (Boolean)this.mfPageInSiteMap.get(thisSite)) == null) {
            isMFPageInSite = this.isToolInSite(thisSite, "sakai.messagecenter");
            this.mfPageInSiteMap.put(thisSite, isMFPageInSite);
        }
        return isMFPageInSite;
    }

    private boolean isToolInSite(Site thisSite, String toolId) {
        Collection toolsInSite = thisSite.getTools(toolId);
        return !toolsInSite.isEmpty();
    }

    private Site getSite(String siteId) throws IdUnusedException {
        if (this.sitesMap == null) {
            this.sitesMap = new HashMap();
        }
        if (this.sitesMap.get(siteId) == null) {
            Site site = SiteService.getSite((String)siteId);
            this.sitesMap.put(site.getId(), site);
            return site;
        }
        return (Site)this.sitesMap.get(siteId);
    }

    private boolean isMessagesPageInSite(Site thisSite) {
        return this.isToolInSite(thisSite, "sakai.messages");
    }

    private boolean isForumsPageInSite(Site thisSite) {
        return this.isToolInSite(thisSite, "sakai.forums");
    }

    public MessageForumsMessageManager getMessageManager() {
        return this.messageManager;
    }

    public void setMessageManager(MessageForumsMessageManager messageManager) {
        this.messageManager = messageManager;
    }

    public UIPermissionsManager getUiPermissionsManager() {
        return this.uiPermissionsManager;
    }

    public void setUiPermissionsManager(UIPermissionsManager uiPermissionsManager) {
        this.uiPermissionsManager = uiPermissionsManager;
    }

    public PrivateMessageManager getPvtMessageManager() {
        return this.pvtMessageManager;
    }

    public void setPvtMessageManager(PrivateMessageManager pvtMessageManager) {
        this.pvtMessageManager = pvtMessageManager;
    }

    public MessageForumsTypeManager getTypeManager() {
        return this.typeManager;
    }

    public void setTypeManager(MessageForumsTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public DiscussionForumManager getForumManager() {
        return this.forumManager;
    }

    public void setForumManager(DiscussionForumManager forumManager) {
        this.forumManager = forumManager;
    }

    public void updateAllSiteTitles(final String siteId, final String siteTitle) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(SynopticMsgcntrManagerImpl.QUERY_UPDATE_ALL_SITE_TITLES);
                q.setParameter("siteTitle", (Object)siteTitle, (Type)Hibernate.STRING);
                q.setParameter("siteId", (Object)siteId, (Type)Hibernate.STRING);
                return q.executeUpdate();
            }
        };
        this.getHibernateTemplate().execute(hcb);
    }

    public class DecoratedTopicsInfo {
        private Long topicId;
        private Boolean isLocked;
        private Boolean isDraft;
        private Boolean isModerated;
        private Boolean availability;
        private String creator;

        public DecoratedTopicsInfo(Long topicId, Boolean isLocked, Boolean isDraft, Boolean availability, Boolean isModerated, String creator) {
            this.topicId = topicId;
            this.isLocked = isLocked;
            this.isDraft = isDraft;
            this.isModerated = isModerated;
            this.creator = creator;
            this.availability = availability;
        }

        public Long getTopicId() {
            return this.topicId;
        }

        public void setTopicId(Long topicId) {
            this.topicId = topicId;
        }

        public Boolean getIsLocked() {
            return this.isLocked;
        }

        public void setIsLocked(Boolean isLocked) {
            this.isLocked = isLocked;
        }

        public Boolean getIsDraft() {
            return this.isDraft;
        }

        public void setIsDraft(Boolean isDraft) {
            this.isDraft = isDraft;
        }

        public Boolean getIsModerated() {
            return this.isModerated;
        }

        public void setIsModerated(Boolean isModerated) {
            this.isModerated = isModerated;
        }

        public String getCreator() {
            return this.creator;
        }

        public void setCreator(String creator) {
            this.creator = creator;
        }

        public Boolean getAvailability() {
            return this.availability;
        }

        public void setAvailability(Boolean availability) {
            this.availability = availability;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DecoratedForumInfo {
        private Long forumId;
        private Boolean isLocked;
        private Boolean isDraft;
        private Boolean availability;
        private String creator;
        private ArrayList<DecoratedTopicsInfo> topics = new ArrayList();

        public DecoratedForumInfo(Long forumId, Boolean isLocked, Boolean isDraft, Boolean availability, String creator) {
            this.forumId = forumId;
            this.isLocked = isLocked;
            this.isDraft = isDraft;
            this.creator = creator;
            this.availability = availability;
        }

        public Long getForumId() {
            return this.forumId;
        }

        public void setForumId(Long forumId) {
            this.forumId = forumId;
        }

        public Boolean getIsLocked() {
            return this.isLocked;
        }

        public void setIsLocked(Boolean isLocked) {
            this.isLocked = isLocked;
        }

        public Boolean getIsDraft() {
            return this.isDraft;
        }

        public void setIsDraft(Boolean isDraft) {
            this.isDraft = isDraft;
        }

        public String getCreator() {
            return this.creator;
        }

        public void setCreator(String creator) {
            this.creator = creator;
        }

        public void addTopic(DecoratedTopicsInfo dTopics) {
            this.topics.add(dTopics);
        }

        public ArrayList<DecoratedTopicsInfo> getTopics() {
            return this.topics;
        }

        public Boolean getAvailability() {
            return this.availability;
        }

        public void setAvailability(Boolean availability) {
            this.availability = availability;
        }
    }

    public class DecoratedCompiledMessageStats {
        private String siteName;
        private String siteId;
        private int unreadPrivateAmt = 0;
        private int unreadForumsAmt = 0;
        private String mcPageURL;
        private String privateMessagesUrl;
        private boolean messagesandForums;
        private boolean messages;
        private boolean forums;

        public String getSiteName() {
            return this.siteName;
        }

        public void setSiteName(String siteName) {
            this.siteName = siteName;
        }

        public int getUnreadPrivateAmt() {
            return this.unreadPrivateAmt;
        }

        public void setUnreadPrivateAmt(int unreadPrivateAmt) {
            this.unreadPrivateAmt = unreadPrivateAmt;
        }

        public int getUnreadForumsAmt() {
            return this.unreadForumsAmt;
        }

        public void setUnreadForumsAmt(int unreadForumsAmt) {
            this.unreadForumsAmt = unreadForumsAmt;
        }

        public String getMcPageURL() {
            return this.mcPageURL;
        }

        public void setMcPageURL(String mcPageURL) {
            this.mcPageURL = mcPageURL;
        }

        public String getSiteId() {
            return this.siteId;
        }

        public void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        public String getPrivateMessagesUrl() {
            return this.privateMessagesUrl;
        }

        public void setPrivateMessagesUrl(String privateMessagesUrl) {
            this.privateMessagesUrl = privateMessagesUrl;
        }

        public boolean isMessagesandForums() {
            return this.messagesandForums;
        }

        public void setMessagesandForums(boolean messagesandForums) {
            this.messagesandForums = messagesandForums;
        }

        public boolean isMessages() {
            return this.messages;
        }

        public void setMessages(boolean messages) {
            this.messages = messages;
        }

        public boolean isForums() {
            return this.forums;
        }

        public void setForums(boolean forums) {
            this.forums = forums;
        }
    }
}

