/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums.entity;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sakaiproject.api.app.messageforums.DiscussionForum;
import org.sakaiproject.api.app.messageforums.entity.ForumEntityProvider;
import org.sakaiproject.api.app.messageforums.ui.DiscussionForumManager;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.PropertyProvideable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumEntityProviderImpl
implements ForumEntityProvider,
AutoRegisterEntityProvider,
PropertyProvideable {
    private DiscussionForumManager forumManager;

    public String getEntityPrefix() {
        return "forum";
    }

    public boolean entityExists(String id) {
        DiscussionForum forum = null;
        try {
            forum = this.forumManager.getForumById(Long.valueOf(id));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return forum != null;
    }

    public List<String> findEntityRefs(String[] prefixes, String[] name, String[] searchValue, boolean exactMatch) {
        ArrayList<String> rv = new ArrayList<String>();
        String userId = null;
        String siteId = null;
        if ("forum".equals(prefixes[0])) {
            for (int i = 0; i < name.length; ++i) {
                if ("context".equalsIgnoreCase(name[i]) || "site".equalsIgnoreCase(name[i])) {
                    siteId = searchValue[i];
                    continue;
                }
                if (!"user".equalsIgnoreCase(name[i]) && !"userId".equalsIgnoreCase(name[i])) continue;
                userId = searchValue[i];
            }
            if (siteId != null && userId != null) {
                List forums = this.forumManager.getDiscussionForumsByContextId(siteId);
                for (int i = 0; i < forums.size(); ++i) {
                    if (!this.forumManager.isInstructor(userId, siteId) && !userId.equals(((DiscussionForum)forums.get(i)).getCreatedBy())) continue;
                    rv.add("/forum/" + ((DiscussionForum)forums.get(i)).getId().toString());
                }
            }
        }
        return rv;
    }

    public Map<String, String> getProperties(String reference) {
        HashMap<String, String> props = new HashMap<String, String>();
        DiscussionForum forum = this.forumManager.getForumById(Long.valueOf(reference.substring(reference.lastIndexOf("/") + 1)));
        props.put("title", forum.getTitle());
        props.put("author", forum.getCreatedBy());
        if (forum.getCreated() != null) {
            props.put("date", DateFormat.getInstance().format(forum.getCreated()));
        }
        if (forum.getModified() != null) {
            props.put("modified_date", DateFormat.getInstance().format(forum.getModified()));
            props.put("modified_by", forum.getModifiedBy());
        }
        props.put("short_description", forum.getShortDescription());
        props.put("description", forum.getExtendedDescription());
        if (forum.getDraft() != null) {
            props.put("draft", forum.getDraft().toString());
        }
        if (forum.getModerated() != null) {
            props.put("moderated", forum.getModerated().toString());
        }
        props.put("child_provider", "forum_topic");
        props.put("assignment_name", forum.getDefaultAssignName());
        return props;
    }

    public String getPropertyValue(String reference, String name) {
        Map<String, String> props = this.getProperties(reference);
        return props.get(name);
    }

    public void setPropertyValue(String reference, String name, String value) {
    }

    public void setForumManager(DiscussionForumManager forumManager) {
        this.forumManager = forumManager;
    }
}

