/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums.entity;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.messageforums.Attachment;
import org.sakaiproject.api.app.messageforums.DiscussionForum;
import org.sakaiproject.api.app.messageforums.DiscussionTopic;
import org.sakaiproject.api.app.messageforums.Message;
import org.sakaiproject.api.app.messageforums.MessageForumsMessageManager;
import org.sakaiproject.api.app.messageforums.PrivateMessage;
import org.sakaiproject.api.app.messageforums.PrivateMessageRecipient;
import org.sakaiproject.api.app.messageforums.entity.ForumMessageEntityProvider;
import org.sakaiproject.api.app.messageforums.ui.DiscussionForumManager;
import org.sakaiproject.api.app.messageforums.ui.PrivateMessageManager;
import org.sakaiproject.api.app.messageforums.ui.UIPermissionsManager;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.PropertyProvideable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RESTful;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RequestAware;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RequestStorable;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestGetter;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestStorage;
import org.sakaiproject.entitybroker.entityprovider.search.Restriction;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.springframework.orm.hibernate3.HibernateOptimisticLockingFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumMessageEntityProviderImpl
implements ForumMessageEntityProvider,
AutoRegisterEntityProvider,
PropertyProvideable,
RESTful,
RequestStorable,
RequestAware,
ActionsExecutable {
    private DiscussionForumManager forumManager;
    private PrivateMessageManager privateMessageManager;
    private UIPermissionsManager uiPermissionsManager;
    private MessageForumsMessageManager messageManager;
    private static final Log LOG = LogFactory.getLog(ForumMessageEntityProviderImpl.class);
    private RequestStorage requestStorage;
    private RequestGetter requestGetter;

    public void setRequestStorage(RequestStorage requestStorage) {
        this.requestStorage = requestStorage;
    }

    public void setRequestGetter(RequestGetter requestGetter) {
        this.requestGetter = requestGetter;
    }

    public String getEntityPrefix() {
        return "forum_message";
    }

    public boolean entityExists(String id) {
        DiscussionTopic topic = null;
        try {
            topic = this.forumManager.getTopicById(Long.valueOf(id));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return topic != null;
    }

    public List<String> findEntityRefs(String[] prefixes, String[] name, String[] searchValue, boolean exactMatch) {
        ArrayList<String> rv = new ArrayList<String>();
        String userId = null;
        String siteId = null;
        String topicId = null;
        if ("forum_message".equals(prefixes[0])) {
            for (int i = 0; i < name.length; ++i) {
                if ("context".equalsIgnoreCase(name[i]) || "site".equalsIgnoreCase(name[i])) {
                    siteId = searchValue[i];
                    continue;
                }
                if ("user".equalsIgnoreCase(name[i]) || "userId".equalsIgnoreCase(name[i])) {
                    userId = searchValue[i];
                    continue;
                }
                if ("topic".equalsIgnoreCase(name[i]) || "topicId".equalsIgnoreCase(name[i])) {
                    topicId = searchValue[i];
                    continue;
                }
                if (!"parentReference".equalsIgnoreCase(name[i])) continue;
                String[] parts = searchValue[i].split("/");
                topicId = parts[parts.length - 1];
            }
            if (topicId != null) {
                List messages = this.forumManager.getTopicByIdWithMessagesAndAttachments(Long.valueOf(topicId)).getMessages();
                for (int i = 0; i < messages.size(); ++i) {
                    if (!this.forumManager.isInstructor(userId, siteId) && !userId.equals(((Message)messages.get(i)).getCreatedBy())) continue;
                    rv.add("/forum_message/" + ((Message)messages.get(i)).getId().toString());
                }
            }
        }
        return rv;
    }

    public Map<String, String> getProperties(String reference) {
        HashMap<String, String> props = new HashMap<String, String>();
        Message message = this.forumManager.getMessageById(Long.valueOf(reference.substring(reference.lastIndexOf("/") + 1)));
        props.put("title", message.getTitle());
        props.put("author", message.getCreatedBy());
        if (message.getCreated() != null) {
            props.put("date", DateFormat.getInstance().format(message.getCreated()));
        }
        if (message.getModifiedBy() != null) {
            props.put("modified_by", message.getModifiedBy());
            props.put("modified_date", DateFormat.getInstance().format(message.getModified()));
        }
        props.put("label", message.getLabel());
        if (message.getDraft() != null) {
            props.put("draft", message.getDraft().toString());
        }
        if (message.getApproved() != null) {
            props.put("approved", message.getApproved().toString());
        }
        if (message.getGradeAssignmentName() != null) {
            props.put("assignment_name", message.getGradeAssignmentName());
        }
        return props;
    }

    public String getPropertyValue(String reference, String name) {
        Map<String, String> props = this.getProperties(reference);
        return props.get(name);
    }

    public void setPropertyValue(String reference, String name, String value) {
    }

    public void setForumManager(DiscussionForumManager forumManager) {
        this.forumManager = forumManager;
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        return null;
    }

    public Object getSampleEntity() {
        return null;
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
    }

    public Object getEntity(EntityReference ref) {
        return null;
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
    }

    public List<DecoratedMessage> findReplies(List<Message> messages, Long messageId, Long topicId, Map msgIdReadStatusMap) {
        ArrayList<DecoratedMessage> replies = new ArrayList<DecoratedMessage>();
        for (Message message : messages) {
            Boolean readStatus;
            if (message.getInReplyTo() == null || !messageId.equals(message.getInReplyTo().getId()) || message.getDeleted().booleanValue()) continue;
            ArrayList<String> attachments = new ArrayList<String>();
            if (message.getHasAttachments().booleanValue()) {
                for (Attachment attachment : message.getAttachments()) {
                    attachments.add(attachment.getAttachmentName());
                }
            }
            if ((readStatus = (Boolean)msgIdReadStatusMap.get(message.getId())) == null) {
                readStatus = Boolean.FALSE;
            }
            DecoratedMessage dMessage = new DecoratedMessage(message.getId(), topicId, message.getTitle(), message.getBody(), "" + message.getModified().getTime(), attachments, this.findReplies(messages, message.getId(), topicId, msgIdReadStatusMap), message.getAuthor(), message.getInReplyTo() == null ? null : message.getInReplyTo().getId(), "" + message.getCreated().getTime(), readStatus, "", "");
            replies.add(dMessage);
        }
        Collections.sort(replies, new Comparator<DecoratedMessage>(){

            @Override
            public int compare(DecoratedMessage arg0, DecoratedMessage arg1) {
                Long date1 = Long.parseLong(arg0.getCreatedOn());
                Long date2 = Long.parseLong(arg1.getCreatedOn());
                return date1.compareTo(date2);
            }
        });
        return replies;
    }

    public List<DecoratedMessage> generateFlattenedMessagesListHelper(List<DecoratedMessage> messages, int indent) {
        ArrayList<DecoratedMessage> flattenedList = new ArrayList<DecoratedMessage>();
        for (DecoratedMessage message : messages) {
            message.setIndentIndex(indent);
            List<Object> helperList = new ArrayList();
            if (message.getReplies().size() > 0) {
                helperList = this.generateFlattenedMessagesListHelper(message.getReplies(), indent + 1);
            }
            message.setReplies(null);
            flattenedList.add(message);
            flattenedList.addAll(helperList);
        }
        return flattenedList;
    }

    public List<?> getEntities(EntityReference ref, Search search) {
        String topicId = "";
        String typeUuid = "";
        String siteId = "";
        String userId = UserDirectoryService.getCurrentUser().getId();
        if (userId == null || "".equals(userId)) {
            return null;
        }
        if (!search.isEmpty()) {
            Restriction siteRes;
            Restriction typeRes;
            Restriction topicRes = search.getRestrictionByProperty("topicId");
            if (topicRes != null) {
                topicId = topicRes.getStringValue();
            }
            if ((typeRes = search.getRestrictionByProperty("typeUuid")) != null) {
                typeUuid = typeRes.getStringValue();
            }
            if ((siteRes = search.getRestrictionByProperty("siteId")) != null) {
                siteId = siteRes.getStringValue();
            }
        }
        ArrayList<DecoratedMessage> dMessages = new ArrayList<DecoratedMessage>();
        if (topicId != null && !"".equals(topicId)) {
            List messages = this.forumManager.getTopicByIdWithMessagesAndAttachments(new Long(topicId)).getMessages();
            DiscussionTopic dTopic = this.forumManager.getTopicById(Long.valueOf(topicId));
            DiscussionForum dForum = this.forumManager.getForumById(dTopic.getBaseForum().getId());
            siteId = this.forumManager.getContextForForumById(dForum.getId());
            if (dForum.getDraft().equals(Boolean.FALSE) && dTopic.getDraft().equals(Boolean.FALSE) && SecurityService.unlock((String)userId, (String)SiteService.SITE_VISIT, (String)("/site/" + siteId)) && this.getUiPermissionsManager().isRead(dTopic.getId(), Boolean.valueOf(false), Boolean.valueOf(false), userId, siteId)) {
                messages = this.filterModeratedMessages(messages, dTopic, dForum, userId, siteId);
                ArrayList<Long> messageIds = new ArrayList<Long>();
                for (DecoratedMessage message : messages) {
                    if (message == null || message.getDraft().booleanValue() || message.getDeleted().booleanValue()) continue;
                    messageIds.add(message.getId());
                }
                Map msgIdReadStatusMap = this.forumManager.getReadStatusForMessagesWithId(messageIds, userId);
                for (Message message : messages) {
                    Boolean readStatus;
                    if (message.getInReplyTo() != null || message.getDeleted().booleanValue()) continue;
                    ArrayList<String> attachments = new ArrayList<String>();
                    if (message.getHasAttachments().booleanValue()) {
                        for (Attachment attachment : message.getAttachments()) {
                            attachments.add(attachment.getAttachmentName());
                        }
                    }
                    if ((readStatus = (Boolean)msgIdReadStatusMap.get(message.getId())) == null) {
                        readStatus = Boolean.FALSE;
                    }
                    DecoratedMessage dMessage = new DecoratedMessage(message.getId(), new Long(topicId), message.getTitle(), message.getBody(), "" + message.getModified().getTime(), attachments, this.findReplies(messages, message.getId(), new Long(topicId), msgIdReadStatusMap), message.getAuthor(), message.getInReplyTo() == null ? null : message.getInReplyTo().getId(), "" + message.getCreated().getTime(), readStatus, "", "");
                    dMessages.add(dMessage);
                }
            }
            Collections.sort(dMessages, new Comparator<DecoratedMessage>(){

                @Override
                public int compare(DecoratedMessage arg0, DecoratedMessage arg1) {
                    Long date1 = Long.parseLong(arg0.getCreatedOn());
                    Long date2 = Long.parseLong(arg1.getCreatedOn());
                    return date1.compareTo(date2);
                }
            });
            ArrayList<DecoratedMessage> flattenedList = new ArrayList<DecoratedMessage>();
            for (DecoratedMessage message : dMessages) {
                List<Object> helperList = new ArrayList();
                if (message.getReplies().size() > 0) {
                    helperList = this.generateFlattenedMessagesListHelper(message.getReplies(), 1);
                }
                message.setReplies(null);
                flattenedList.add(message);
                flattenedList.addAll(helperList);
            }
            dMessages = flattenedList;
        } else if (typeUuid != null && !"".equals(typeUuid) && siteId != null && !"".equals(siteId)) {
            List decoratedPvtMsgs = this.getPrivateMessageManager().getMessagesByTypeByContext(typeUuid, siteId, userId, "message.created", "desc");
            for (PrivateMessage pvtMessage : decoratedPvtMsgs) {
                PrivateMessage initPvtMessage = this.getPrivateMessageManager().initMessageWithAttachmentsAndRecipients(pvtMessage);
                ArrayList<String> attachments = new ArrayList<String>();
                if (initPvtMessage.getHasAttachments().booleanValue()) {
                    for (Attachment attachment : initPvtMessage.getAttachments()) {
                        attachments.add(attachment.getAttachmentName());
                    }
                }
                boolean read = false;
                for (PrivateMessageRecipient el : pvtMessage.getRecipients()) {
                    if (el == null) continue;
                    read = el.getRead();
                }
                DecoratedMessage dMessage = new DecoratedMessage(pvtMessage.getId(), null, pvtMessage.getTitle(), pvtMessage.getBody(), "" + pvtMessage.getModified().getTime(), attachments, null, pvtMessage.getAuthor(), pvtMessage.getInReplyTo() == null ? null : pvtMessage.getInReplyTo().getId(), "" + pvtMessage.getCreated().getTime(), read, pvtMessage.getRecipientsAsText(), pvtMessage.getLabel());
                dMessages.add(dMessage);
            }
        }
        return dMessages;
    }

    public void markAsRead(String userId, String siteId, String readMessageId, int numOfAttempts) {
        try {
            Message msg = this.getMessageManager().getMessageById(new Long(readMessageId));
            if (msg instanceof PrivateMessage) {
                String toolId = "sakai.messages";
                this.getPrivateMessageManager().markMessageAsReadForUser((PrivateMessage)msg, siteId, userId, toolId);
            } else {
                String toolId = "sakai.forums";
                String topicId = msg.getTopic().getId().toString();
                this.messageManager.markMessageReadForUser(new Long(topicId), new Long(readMessageId), true, userId, siteId, toolId);
            }
        }
        catch (HibernateOptimisticLockingFailureException holfe) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (--numOfAttempts <= 0) {
                System.out.println("ForumMessageEntityProviderImpl: markAsRead: HibernateOptimisticLockingFailureException no more retries left");
                holfe.printStackTrace();
            } else {
                System.out.println("ForumMessageEntityProviderImpl: markAsRead: HibernateOptimisticLockingFailureException: attempts left: " + numOfAttempts);
                this.markAsRead(userId, siteId, readMessageId, numOfAttempts);
            }
        }
        catch (Exception e) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            if (--numOfAttempts <= 0) {
                System.out.println("ForumMessageEntityProviderImpl: markAsRead: no more retries left");
                e.printStackTrace();
            }
            System.out.println("ForumMessageEntityProviderImpl: markAsRead:  attempts left: " + numOfAttempts);
            this.markAsRead(userId, siteId, readMessageId, numOfAttempts);
        }
    }

    private List filterModeratedMessages(List messages, DiscussionTopic topic, DiscussionForum forum, String userId, String siteId) {
        ArrayList<Message> viewableMsgs = new ArrayList<Message>();
        if (messages != null && messages.size() > 0) {
            boolean hasModeratePerm = this.getUiPermissionsManager().isModeratePostings(topic, forum, userId, siteId);
            if (hasModeratePerm) {
                return messages;
            }
            for (Message msg : messages) {
                if (msg.getApproved() == null || !msg.getApproved().booleanValue()) continue;
                viewableMsgs.add(msg);
            }
        }
        return viewableMsgs;
    }

    @EntityCustomAction(action="markread", viewKey="new")
    public boolean getForum(EntityView view, Map<String, Object> params) {
        String userId;
        String messageId = view.getPathSegment(2);
        String siteId = "";
        if ("site".equals(view.getPathSegment(3))) {
            siteId = view.getPathSegment(4);
        }
        if ((userId = UserDirectoryService.getCurrentUser().getId()) == null || "".equals(userId) || siteId == null || "".equals(siteId) || messageId == null || "".equals(messageId)) {
            return false;
        }
        this.markAsRead(userId, siteId, messageId, 20);
        return true;
    }

    @EntityCustomAction(action="topic", viewKey="list")
    public List<?> getTopicMessagesInSite(EntityView view, Map<String, Object> params) {
        String topicId = view.getPathSegment(2);
        if (topicId == null && (topicId = (String)params.get("topicId")) == null) {
            throw new IllegalArgumentException("topicId must be set in order to get the topic messages, set in params or in the URL /forum_message/topic/topicId");
        }
        List<?> l = this.getEntities(new EntityReference("forum_message", ""), new Search("topicId", (Object)topicId));
        return l;
    }

    @EntityCustomAction(action="private", viewKey="list")
    public List<?> getPrivateTopicMessagesInSite(EntityView view, Map<String, Object> params) {
        String topicId = view.getPathSegment(2);
        if (topicId == null && (topicId = (String)params.get("typeUuid")) == null) {
            throw new IllegalArgumentException("typeUuid and siteId must be set in order to get the topic messages, set in params or in the URL /forum_message/private/typeUuid/site/siteId");
        }
        String siteId = "";
        if ("site".equals(view.getPathSegment(3))) {
            siteId = view.getPathSegment(4);
        }
        List<?> l = this.getEntities(new EntityReference("forum_message", ""), new Search(new String[]{"typeUuid", "siteId"}, (Object[])new String[]{topicId, siteId}));
        return l;
    }

    public String[] getHandledOutputFormats() {
        return null;
    }

    public String[] getHandledInputFormats() {
        return null;
    }

    public PrivateMessageManager getPrivateMessageManager() {
        return this.privateMessageManager;
    }

    public void setPrivateMessageManager(PrivateMessageManager privateMessageManager) {
        this.privateMessageManager = privateMessageManager;
    }

    public UIPermissionsManager getUiPermissionsManager() {
        return this.uiPermissionsManager;
    }

    public void setUiPermissionsManager(UIPermissionsManager uiPermissionsManager) {
        this.uiPermissionsManager = uiPermissionsManager;
    }

    public MessageForumsMessageManager getMessageManager() {
        return this.messageManager;
    }

    public void setMessageManager(MessageForumsMessageManager messageManager) {
        this.messageManager = messageManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DecoratedMessage {
        private Long messageId;
        private Long topicId;
        private String title;
        private String body;
        private String lastModified;
        private List<String> attachments;
        private List<DecoratedMessage> replies;
        private String authoredBy;
        private int indentIndex = 0;
        private Long replyTo;
        private String createdOn;
        private boolean read;
        private String recipients;
        private String label;

        public DecoratedMessage(Long messageId, Long topicId, String title, String body, String lastModified, List<String> attachments, List<DecoratedMessage> replies, String authoredBy, Long replyTo, String createdOn, boolean read, String recipients, String label) {
            this.messageId = messageId;
            this.topicId = topicId;
            this.title = title;
            this.body = body;
            this.attachments = attachments;
            this.replies = replies;
            this.lastModified = lastModified;
            this.authoredBy = authoredBy;
            this.replyTo = replyTo;
            this.createdOn = createdOn;
            this.read = read;
            this.recipients = recipients;
            this.label = label;
        }

        public Long getMessageId() {
            return this.messageId;
        }

        public void setMessageId(Long messageId) {
            this.messageId = messageId;
        }

        public Long getTopicId() {
            return this.topicId;
        }

        public void setTopicId(Long topicId) {
            this.topicId = topicId;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public List<String> getAttachments() {
            return this.attachments;
        }

        public void setAttachments(List<String> attachments) {
            this.attachments = attachments;
        }

        public List<DecoratedMessage> getReplies() {
            return this.replies;
        }

        public void setReplies(List<DecoratedMessage> replies) {
            this.replies = replies;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        public String getAuthoredBy() {
            return this.authoredBy;
        }

        public void setAuthoredBy(String authoredBy) {
            this.authoredBy = authoredBy;
        }

        public int getIndentIndex() {
            return this.indentIndex;
        }

        public void setIndentIndex(int indentIndex) {
            this.indentIndex = indentIndex;
        }

        public Long getReplyTo() {
            return this.replyTo;
        }

        public void setReplyTo(Long replyTo) {
            this.replyTo = replyTo;
        }

        public String getCreatedOn() {
            return this.createdOn;
        }

        public void setCreatedOn(String createdOn) {
            this.createdOn = createdOn;
        }

        public boolean isRead() {
            return this.read;
        }

        public void setRead(boolean read) {
            this.read = read;
        }

        public String getRecipients() {
            return this.recipients;
        }

        public void setRecipients(String recipients) {
            this.recipients = recipients;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }
    }

    public class DecoratedMessagesTopic {
        private String title;
        private Long id;
        private int totalMessages = 0;
        private int totalUnreadMessages = 0;

        public DecoratedMessagesTopic(String title, Long id, int totalMessages, int totalUnreadMessages) {
            this.title = title;
            this.id = id;
            this.totalMessages = totalMessages;
            this.totalUnreadMessages = totalUnreadMessages;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public int getTotalMessages() {
            return this.totalMessages;
        }

        public void setTotalMessages(int totalMessages) {
            this.totalMessages = totalMessages;
        }

        public int getTotalUnreadMessages() {
            return this.totalUnreadMessages;
        }

        public void setTotalUnreadMessages(int totalUnreadMessages) {
            this.totalUnreadMessages = totalUnreadMessages;
        }
    }
}

