/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums.entity;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sakaiproject.api.app.messageforums.DiscussionForum;
import org.sakaiproject.api.app.messageforums.DiscussionTopic;
import org.sakaiproject.api.app.messageforums.Topic;
import org.sakaiproject.api.app.messageforums.entity.ForumTopicEntityProvider;
import org.sakaiproject.api.app.messageforums.ui.DiscussionForumManager;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.PropertyProvideable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumTopicEntityProviderImpl
implements ForumTopicEntityProvider,
AutoRegisterEntityProvider,
PropertyProvideable {
    private DiscussionForumManager forumManager;

    public String getEntityPrefix() {
        return "forum_topic";
    }

    public boolean entityExists(String id) {
        DiscussionTopic topic = null;
        try {
            topic = this.forumManager.getTopicById(Long.valueOf(id));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return topic != null;
    }

    public List<String> findEntityRefs(String[] prefixes, String[] name, String[] searchValue, boolean exactMatch) {
        ArrayList<String> rv;
        block6: {
            String siteId;
            String userId;
            block7: {
                rv = new ArrayList<String>();
                String forumId = null;
                userId = null;
                siteId = null;
                if (!"forum_topic".equals(prefixes[0])) break block6;
                for (int i = 0; i < name.length; ++i) {
                    if ("context".equalsIgnoreCase(name[i]) || "site".equalsIgnoreCase(name[i])) {
                        siteId = searchValue[i];
                        continue;
                    }
                    if ("user".equalsIgnoreCase(name[i]) || "userId".equalsIgnoreCase(name[i])) {
                        userId = searchValue[i];
                        continue;
                    }
                    if (!"parentReference".equalsIgnoreCase(name[i])) continue;
                    String[] parts = searchValue[i].split("/");
                    forumId = parts[parts.length - 1];
                }
                if (forumId == null || userId == null) break block7;
                DiscussionForum forum = this.forumManager.getForumByIdWithTopics(Long.valueOf(forumId));
                List topics = forum.getTopics();
                for (int i = 0; i < topics.size(); ++i) {
                    if (!this.forumManager.isInstructor(userId, siteId) && !userId.equals(((Topic)topics.get(i)).getCreatedBy())) continue;
                    rv.add("/forum_topic/" + ((Topic)topics.get(i)).getId().toString());
                }
                break block6;
            }
            if (siteId == null || userId == null) break block6;
            List forums = this.forumManager.getDiscussionForumsByContextId(siteId);
            for (int i = 0; i < forums.size(); ++i) {
                List topics = ((DiscussionForum)forums.get(i)).getTopics();
                for (int j = 0; j < topics.size(); ++j) {
                    if (!this.forumManager.isInstructor(userId, siteId) && !userId.equals(((Topic)topics.get(j)).getCreatedBy())) continue;
                    rv.add("/forum_topic/" + ((Topic)topics.get(j)).getId().toString());
                }
            }
        }
        return rv;
    }

    public Map<String, String> getProperties(String reference) {
        HashMap<String, String> props = new HashMap<String, String>();
        DiscussionTopic topic = this.forumManager.getTopicById(Long.valueOf(reference.substring(reference.lastIndexOf("/") + 1)));
        props.put("title", topic.getTitle());
        props.put("author", topic.getCreatedBy());
        if (topic.getCreated() != null) {
            props.put("date", DateFormat.getInstance().format(topic.getCreated()));
        }
        if (topic.getModified() != null) {
            props.put("modified_by", topic.getModifiedBy());
            props.put("modified_date", DateFormat.getInstance().format(topic.getModified()));
        }
        props.put("short_description", topic.getShortDescription());
        props.put("description", topic.getExtendedDescription());
        if (topic.getModerated() != null) {
            props.put("moderated", topic.getModerated().toString());
        }
        props.put("child_provider", "forum_message");
        return props;
    }

    public String getPropertyValue(String reference, String name) {
        Map<String, String> props = this.getProperties(reference);
        return props.get(name);
    }

    public void setPropertyValue(String reference, String name, String value) {
    }

    public void setForumManager(DiscussionForumManager forumManager) {
        this.forumManager = forumManager;
    }
}

