/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums.entity;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.messageforums.DiscussionForum;
import org.sakaiproject.api.app.messageforums.DiscussionTopic;
import org.sakaiproject.api.app.messageforums.Message;
import org.sakaiproject.api.app.messageforums.MessageForumsMessageManager;
import org.sakaiproject.api.app.messageforums.Topic;
import org.sakaiproject.api.app.messageforums.ui.DiscussionForumManager;
import org.sakaiproject.api.app.messageforums.ui.UIPermissionsManager;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.entitybroker.DeveloperHelperService;
import org.sakaiproject.entitybroker.EntityBroker;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.util.FormattedText;

public class MessageForumsEntityContentProducer
implements EntityContentProducer {
    private static Log log = LogFactory.getLog(MessageForumsEntityContentProducer.class);
    private List addEvents = null;
    private List removeEvents = null;
    private String toolName = null;
    private DeveloperHelperService developerHelperService;
    private ServerConfigurationService serverConfigurationService;
    private SearchService searchService = null;
    private SearchIndexBuilder searchIndexBuilder = null;
    private MessageForumsMessageManager messageForumsMessageManager;
    private DiscussionForumManager discussionForumManager;
    private UIPermissionsManager uIPermissionManager;
    private EntityBroker entityBroker;

    public void setAddEvents(List addEvents) {
        this.addEvents = addEvents;
    }

    public void setRemoveEvents(List removeEvents) {
        this.removeEvents = removeEvents;
    }

    public void setToolName(String toolName) {
        this.toolName = toolName;
    }

    public void setDeveloperHelperService(DeveloperHelperService developerHelperService) {
        this.developerHelperService = developerHelperService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setSearchIndexBuilder(SearchIndexBuilder searchIndexBuilder) {
        this.searchIndexBuilder = searchIndexBuilder;
    }

    public void setMessageForumsMessageManager(MessageForumsMessageManager messageForumsMessageManager) {
        this.messageForumsMessageManager = messageForumsMessageManager;
    }

    public void setDiscussionForumManager(DiscussionForumManager discussionForumManager) {
        this.discussionForumManager = discussionForumManager;
    }

    public void setUIPermissionManager(UIPermissionsManager permissionManager) {
        this.uIPermissionManager = permissionManager;
    }

    public void setEntityBroker(EntityBroker eb) {
        this.entityBroker = eb;
    }

    public void init() {
        if ("true".equals(this.serverConfigurationService.getString("search.enable", "false"))) {
            Iterator i = this.addEvents.iterator();
            while (i.hasNext()) {
                this.searchService.registerFunction((String)i.next());
            }
            i = this.removeEvents.iterator();
            while (i.hasNext()) {
                this.searchService.registerFunction((String)i.next());
            }
            this.searchIndexBuilder.registerEntityContentProducer((EntityContentProducer)this);
        }
    }

    public boolean canRead(String reference) {
        String msgId = EntityReference.getIdFromRefByKey((String)reference, (String)"Message");
        Message m = this.messageForumsMessageManager.getMessageById(Long.valueOf(msgId));
        Topic topic = m.getTopic();
        boolean canRead = false;
        DiscussionTopic dt = this.discussionForumManager.getTopicById(topic.getId());
        if (dt != null) {
            DiscussionForum df = this.discussionForumManager.getForumById(dt.getOpenForum().getId());
            canRead = this.uIPermissionManager.isRead(dt, df);
        }
        return canRead;
    }

    public Integer getAction(Event event) {
        String evt = event.getEvent();
        if (evt == null) {
            return SearchBuilderItem.ACTION_UNKNOWN;
        }
        for (String match : this.addEvents) {
            if (!evt.equals(match)) continue;
            return SearchBuilderItem.ACTION_ADD;
        }
        for (String match : this.removeEvents) {
            if (!evt.equals(match)) continue;
            return SearchBuilderItem.ACTION_DELETE;
        }
        return SearchBuilderItem.ACTION_UNKNOWN;
    }

    public String getContainer(String ref) {
        log.debug((Object)("getContainer(String " + ref + ")"));
        return "/site/" + this.getSiteId(ref);
    }

    public String getContent(String reference) {
        log.debug((Object)("getting content for " + reference));
        String msgId = EntityReference.getIdFromRefByKey((String)reference, (String)"Message");
        Message m = this.messageForumsMessageManager.getMessageById(Long.valueOf(msgId));
        StringBuilder sb = new StringBuilder();
        if (m != null) {
            sb.append("author: " + m.getAuthor());
            sb.append(" title: " + m.getTitle());
            sb.append(" body: " + FormattedText.convertFormattedTextToPlaintext((String)m.getBody()));
        }
        return sb.toString();
    }

    public Reader getContentReader(String reference) {
        return new StringReader(this.getContent(reference));
    }

    public Map getCustomProperties(String ref) {
        return null;
    }

    public String getCustomRDF(String ref) {
        return null;
    }

    public String getId(String ref) {
        return EntityReference.getIdFromRefByKey((String)ref, (String)"Message");
    }

    public List getSiteContent(String context) {
        log.warn((Object)"DEPRECATED method getSiteContent called");
        return null;
    }

    public Iterator getSiteContentIterator(String context) {
        log.debug((Object)("getSiteContentIterator(String " + context + ")"));
        List messages = this.messageForumsMessageManager.getAllMessagesInSite(context);
        log.debug((Object)("got a list of " + messages.size() + "messages"));
        ArrayList<String> out = new ArrayList<String>();
        for (int i = 0; i < messages.size(); ++i) {
            Message m = (Message)messages.get(i);
            String ref = this.buildRefForContextAndId(context, m.getId());
            log.debug((Object)("adding " + ref));
            out.add(ref);
        }
        return out.iterator();
    }

    private String buildRefForContextAndId(String context, Long messageId) {
        String ret = "/forums/site/" + context + "/Message/" + messageId.toString();
        return ret;
    }

    public String getSiteId(String reference) {
        return EntityReference.getIdFromRefByKey((String)reference, (String)"site");
    }

    public String getSubType(String ref) {
        log.debug((Object)("getSubType(" + ref));
        return "message";
    }

    public String getTitle(String reference) {
        log.debug((Object)("getTitle: " + reference));
        String msgId = EntityReference.getIdFromRefByKey((String)reference, (String)"Message");
        Message m = this.messageForumsMessageManager.getMessageById(Long.valueOf(msgId));
        if (m != null) {
            return m.getTitle();
        }
        return null;
    }

    public String getTool() {
        return this.toolName;
    }

    public String getType(String ref) {
        log.debug((Object)("getType(" + ref));
        return "Message";
    }

    public String getUrl(String reference) {
        log.debug((Object)("getUrl(" + reference + ")"));
        HashMap<String, String> params = new HashMap<String, String>();
        String msgId = EntityReference.getIdFromRefByKey((String)reference, (String)"Message");
        Message m = this.messageForumsMessageManager.getMessageById(Long.valueOf(msgId));
        params.put("messageId", msgId);
        params.put("topicId", m.getTopic().getId().toString());
        log.debug((Object)("got topic: " + m.getTopic().getId().toString()));
        DiscussionTopic topic = this.discussionForumManager.getTopicById(m.getTopic().getId());
        params.put("forumId", topic.getOpenForum().getId().toString());
        String context = "/site/" + this.getSiteId(reference);
        log.debug((Object)("context: " + context));
        String path = "/discussionForum/message/dfViewThreadDirect";
        try {
            String url = this.developerHelperService.getToolViewURL("sakai.forums", path, params, context);
            log.debug((Object)("got url" + url));
            return url;
        }
        catch (Exception e) {
            log.warn((Object)"swallowing exception", (Throwable)e);
            return null;
        }
    }

    public boolean isContentFromReader(String reference) {
        return false;
    }

    public boolean isForIndex(String reference) {
        String msgId = EntityReference.getIdFromRefByKey((String)reference, (String)"Message");
        Message m = this.messageForumsMessageManager.getMessageById(Long.valueOf(msgId));
        if (m != null && !m.getDeleted().booleanValue()) {
            log.debug((Object)("we will index " + reference));
            return true;
        }
        return false;
    }

    public boolean matches(String reference) {
        if (reference == null) {
            return false;
        }
        String prefix = EntityReference.getPrefix((String)reference);
        log.debug((Object)("checkin if " + prefix + " matches"));
        return this.toolName.equals(prefix);
    }

    public boolean matches(Event event) {
        return this.matches(event.getResource());
    }
}

