/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums.entity;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.messageforums.Area;
import org.sakaiproject.api.app.messageforums.DiscussionForum;
import org.sakaiproject.api.app.messageforums.DiscussionTopic;
import org.sakaiproject.api.app.messageforums.MessageForumsMessageManager;
import org.sakaiproject.api.app.messageforums.MessageForumsTypeManager;
import org.sakaiproject.api.app.messageforums.PrivateForum;
import org.sakaiproject.api.app.messageforums.PrivateTopic;
import org.sakaiproject.api.app.messageforums.Topic;
import org.sakaiproject.api.app.messageforums.entity.TopicEntityProvider;
import org.sakaiproject.api.app.messageforums.ui.DiscussionForumManager;
import org.sakaiproject.api.app.messageforums.ui.PrivateMessageManager;
import org.sakaiproject.api.app.messageforums.ui.UIPermissionsManager;
import org.sakaiproject.component.app.messageforums.dao.hibernate.PrivateTopicImpl;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.PropertyProvideable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RESTful;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RequestAware;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RequestStorable;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestGetter;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestStorage;
import org.sakaiproject.entitybroker.entityprovider.search.Restriction;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.sakaiproject.util.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicEntityProviderImpl
implements TopicEntityProvider,
AutoRegisterEntityProvider,
PropertyProvideable,
RESTful,
RequestStorable,
RequestAware,
ActionsExecutable {
    private DiscussionForumManager forumManager;
    private UIPermissionsManager uiPermissionsManager;
    private MessageForumsMessageManager messageManager;
    private MessageForumsTypeManager typeManager;
    private PrivateMessageManager privateMessageManager;
    private static final ResourceLoader rb = new ResourceLoader("org.sakaiproject.api.app.messagecenter.bundle.Messages");
    private static final Log LOG = LogFactory.getLog(TopicEntityProviderImpl.class);
    public static final String PVTMSG_MODE_DRAFT = "Drafts";
    private RequestStorage requestStorage;
    private RequestGetter requestGetter;

    public void setRequestStorage(RequestStorage requestStorage) {
        this.requestStorage = requestStorage;
    }

    public void setRequestGetter(RequestGetter requestGetter) {
        this.requestGetter = requestGetter;
    }

    public String getEntityPrefix() {
        return "topic";
    }

    public boolean entityExists(String id) {
        DiscussionTopic topic = null;
        try {
            topic = this.forumManager.getTopicById(new Long(id));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return topic != null;
    }

    public List<String> findEntityRefs(String[] prefixes, String[] name, String[] searchValue, boolean exactMatch) {
        ArrayList<String> rv;
        block6: {
            String siteId;
            String userId;
            block7: {
                rv = new ArrayList<String>();
                String forumId = null;
                userId = null;
                siteId = null;
                if (!"topic".equals(prefixes[0])) break block6;
                for (int i = 0; i < name.length; ++i) {
                    if ("context".equalsIgnoreCase(name[i]) || "site".equalsIgnoreCase(name[i])) {
                        siteId = searchValue[i];
                        continue;
                    }
                    if ("user".equalsIgnoreCase(name[i]) || "userId".equalsIgnoreCase(name[i])) {
                        userId = searchValue[i];
                        continue;
                    }
                    if (!"parentReference".equalsIgnoreCase(name[i])) continue;
                    String[] parts = searchValue[i].split("/");
                    forumId = parts[parts.length - 1];
                }
                if (forumId == null || userId == null) break block7;
                DiscussionForum forum = this.forumManager.getForumByIdWithTopics(new Long(forumId));
                List topics = forum.getTopics();
                for (int i = 0; i < topics.size(); ++i) {
                    if (!this.forumManager.isInstructor(userId, siteId) && !userId.equals(((Topic)topics.get(i)).getCreatedBy())) continue;
                    rv.add("/topic/" + ((Topic)topics.get(i)).getId().toString());
                }
                break block6;
            }
            if (siteId == null || userId == null) break block6;
            List forums = this.forumManager.getDiscussionForumsByContextId(siteId);
            for (int i = 0; i < forums.size(); ++i) {
                List topics = ((DiscussionForum)forums.get(i)).getTopics();
                for (int j = 0; j < topics.size(); ++j) {
                    if (!this.forumManager.isInstructor(userId, siteId) && !userId.equals(((Topic)topics.get(j)).getCreatedBy())) continue;
                    rv.add("/topic/" + ((Topic)topics.get(j)).getId().toString());
                }
            }
        }
        return rv;
    }

    public Map<String, String> getProperties(String reference) {
        HashMap<String, String> props = new HashMap<String, String>();
        DiscussionTopic topic = this.forumManager.getTopicById(new Long(reference.substring(reference.lastIndexOf("/") + 1)));
        props.put("title", topic.getTitle());
        props.put("author", topic.getCreatedBy());
        if (topic.getCreated() != null) {
            props.put("date", DateFormat.getInstance().format(topic.getCreated()));
        }
        if (topic.getModified() != null) {
            props.put("modified_by", topic.getModifiedBy());
            props.put("modified_date", DateFormat.getInstance().format(topic.getModified()));
        }
        props.put("short_description", topic.getShortDescription());
        props.put("description", topic.getExtendedDescription());
        if (topic.getModerated() != null) {
            props.put("moderated", topic.getModerated().toString());
        }
        props.put("child_provider", "forum_message");
        return props;
    }

    public String getPropertyValue(String reference, String name) {
        Map<String, String> props = this.getProperties(reference);
        return props.get(name);
    }

    public void setPropertyValue(String reference, String name, String value) {
    }

    public void setForumManager(DiscussionForumManager forumManager) {
        this.forumManager = forumManager;
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        return null;
    }

    public Object getSampleEntity() {
        return null;
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
    }

    public Object getEntity(EntityReference ref) {
        return null;
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
    }

    public List<?> getEntities(EntityReference ref, Search search) {
        String userId;
        Restriction locRes;
        String siteId = null;
        String forumId = null;
        boolean privateMessages = false;
        if (!search.isEmpty() && (locRes = search.getRestrictionByProperty("_locationReference")) != null) {
            ForumSearch fs = this.findLocationByReference(locRes.getStringValue());
            siteId = fs.siteId;
            forumId = fs.forumId;
            privateMessages = fs.isPrivate;
        }
        if ((userId = UserDirectoryService.getCurrentUser().getId()) == null || "".equals(userId)) {
            return null;
        }
        ArrayList<DecoratedForumInfo> dForums = new ArrayList<DecoratedForumInfo>();
        if (privateMessages && siteId != null) {
            DecoratedForumInfo dForum = new DecoratedForumInfo(0L, "Messages");
            Area area = this.getPrivateMessageManager().getPrivateMessageArea(siteId);
            if (area != null) {
                ArrayList aggregateList = new ArrayList();
                PrivateForum pf = this.getPrivateMessageManager().initializePrivateMessageArea(area, aggregateList, userId, siteId);
                pf = this.getPrivateMessageManager().initializationHelper(pf, area, userId);
                List pvtTopics = pf.getTopics();
                Collections.sort(pvtTopics, PrivateTopicImpl.TITLE_COMPARATOR);
                ArrayList<String> topicsbyLocalization = new ArrayList<String>();
                String local_received = rb.getString("pvt_received");
                String local_sent = rb.getString("pvt_sent");
                String local_deleted = rb.getString("pvt_deleted");
                String current_NAV = rb.getString("pvt_message_nav");
                topicsbyLocalization.add(local_received);
                topicsbyLocalization.add(local_sent);
                topicsbyLocalization.add(local_deleted);
                int countForFolderNum = 0;
                Iterator iterator = pvtTopics.iterator();
                for (int indexlittlethanTHREE = 0; indexlittlethanTHREE < 3; ++indexlittlethanTHREE) {
                    PrivateTopic topic = (PrivateTopic)iterator.next();
                    if (topic == null) continue;
                    String CurrentTopicTitle = topic.getTitle();
                    if (topic.getTypeUuid() != null && topic.getTypeUuid().equals(this.typeManager.getUserDefinedPrivateTopicType()) && topic.getContextId() != null && !topic.getContextId().equals(this.getPrivateMessageManager().getContextId())) continue;
                    String typeUuid = "";
                    typeUuid = this.getLanguage(CurrentTopicTitle).toString().equals(this.getLanguage(current_NAV).toString()) ? this.getPrivateMessageTypeFromContext(topicsbyLocalization.get(countForFolderNum).toString()) : this.getPrivateMessageTypeFromContext(topic.getTitle());
                    ++countForFolderNum;
                    int totalNoMessages = this.getPrivateMessageManager().findMessageCount(typeUuid, aggregateList);
                    int totalUnreadMessages = this.getPrivateMessageManager().findUnreadMessageCount(typeUuid, aggregateList);
                    DecoratedTopicInfo dTopicInfo = new DecoratedTopicInfo(topic.getId(), topic.getTitle(), totalUnreadMessages, totalNoMessages, typeUuid);
                    dForum.addTopic(dTopicInfo);
                }
                while (iterator.hasNext()) {
                    PrivateTopic topic = (PrivateTopic)iterator.next();
                    if (topic == null || topic.getTypeUuid() != null && topic.getTypeUuid().equals(this.typeManager.getUserDefinedPrivateTopicType()) && topic.getContextId() != null && !topic.getContextId().equals(siteId)) continue;
                    String typeUuid = this.getPrivateMessageTypeFromContext(topic.getTitle());
                    int totalNoMessages = this.getPrivateMessageManager().findMessageCount(typeUuid, aggregateList);
                    int totalUnreadMessages = this.getPrivateMessageManager().findUnreadMessageCount(typeUuid, aggregateList);
                    DecoratedTopicInfo dTopicInfo = new DecoratedTopicInfo(topic.getId(), topic.getTitle(), totalUnreadMessages, totalNoMessages, typeUuid);
                    dForum.addTopic(dTopicInfo);
                }
            }
            dForums.add(dForum);
        } else if (siteId != null && !"".equals(siteId) || forumId != null && !"".equals(forumId)) {
            List<DiscussionForum> forums = new ArrayList();
            if (forumId != null && !"".equals(forumId)) {
                DiscussionForum forum = this.forumManager.getForumByIdWithTopics(new Long(forumId));
                siteId = this.forumManager.getContextForForumById(forum.getId());
                forums.add(forum);
            } else {
                forums = this.forumManager.getDiscussionForumsByContextId(siteId);
            }
            for (DiscussionForum forum : forums) {
                if (!forum.getDraft().equals(Boolean.FALSE)) continue;
                DecoratedForumInfo dForum = new DecoratedForumInfo(forum.getId(), forum.getTitle());
                List topics = forum.getTopics();
                int viewableTopics = 0;
                for (DiscussionTopic topic : topics) {
                    if (!topic.getDraft().equals(Boolean.FALSE) || !this.forumManager.isInstructor(userId, siteId) && !this.getUiPermissionsManager().isRead(topic.getId(), topic.getDraft(), forum.getDraft(), userId, siteId)) continue;
                    int unreadMessages = 0;
                    int totalMessages = 0;
                    unreadMessages = topic.getModerated() == false || topic.getModerated() != false && this.getUiPermissionsManager().isModeratePostings(topic.getId(), forum.getLocked(), forum.getDraft(), topic.getLocked(), topic.getDraft(), userId, siteId) ? this.getMessageManager().findUnreadMessageCountByTopicIdByUserId(topic.getId(), userId) : this.getMessageManager().findUnreadViewableMessageCountByTopicIdByUserId(topic.getId(), userId);
                    totalMessages = this.getMessageManager().findViewableMessageCountByTopicIdByUserId(topic.getId(), userId);
                    dForum.addTopic(new DecoratedTopicInfo(topic.getId(), topic.getTitle(), unreadMessages, totalMessages, ""));
                    ++viewableTopics;
                }
                if (!this.forumManager.isInstructor(userId, siteId) && viewableTopics <= 0) continue;
                dForums.add(dForum);
            }
        }
        return dForums;
    }

    @EntityCustomAction(action="forum", viewKey="list")
    public List<?> getForum(EntityView view, Map<String, Object> params) {
        String forumId = view.getPathSegment(2);
        if (forumId == null && (forumId = (String)params.get("forumId")) == null) {
            throw new IllegalArgumentException("forumId must be set in order to get the forum info, set in params or in the URL /topic/forum/forumId");
        }
        List<?> l = this.getEntities(new EntityReference("topic", ""), new Search("_locationReference", (Object)("/forum/" + forumId)));
        return l;
    }

    @EntityCustomAction(action="site", viewKey="list")
    public List<?> getForumsInSite(EntityView view, Map<String, Object> params) {
        String siteId = view.getPathSegment(2);
        if (siteId == null && (siteId = (String)params.get("site")) == null) {
            throw new IllegalArgumentException("site must be set in order to get the forum info, set in params or in the URL /topic/site/siteId");
        }
        List<?> l = this.getEntities(new EntityReference("topic", ""), new Search("_locationReference", (Object)("/site/" + siteId)));
        return l;
    }

    @EntityCustomAction(action="private", viewKey="list")
    public List<?> getPrivateTopicsInSite(EntityView view, Map<String, Object> params) {
        String siteId = view.getPathSegment(2);
        if (siteId == null && (siteId = (String)params.get("private")) == null) {
            throw new IllegalArgumentException("siteId must be set in order to get the private topic info, set in params or in the URL /topic/private/siteId");
        }
        List<?> l = this.getEntities(new EntityReference("topic", ""), new Search("_locationReference", (Object)("/private/" + siteId)));
        return l;
    }

    public ForumSearch findLocationByReference(String locationReference) {
        ForumSearch holder = new ForumSearch(locationReference);
        if (locationReference.contains("/forum/")) {
            String forumId;
            EntityReference ref = new EntityReference(locationReference);
            holder.forumId = forumId = ref.getId();
        } else if (locationReference.contains("/site/")) {
            String siteId;
            EntityReference ref = new EntityReference(locationReference);
            holder.siteId = siteId = ref.getId();
        } else if (locationReference.contains("/private/")) {
            String siteId;
            EntityReference ref = new EntityReference(locationReference);
            holder.siteId = siteId = ref.getId();
            holder.isPrivate = true;
        } else {
            throw new IllegalArgumentException("Do not know how to handle this location reference (" + locationReference + "), only can handle forum, site and private references");
        }
        return holder;
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"html", "xml", "json"};
    }

    public String[] getHandledInputFormats() {
        return null;
    }

    public UIPermissionsManager getUiPermissionsManager() {
        return this.uiPermissionsManager;
    }

    public void setUiPermissionsManager(UIPermissionsManager uiPermissionsManager) {
        this.uiPermissionsManager = uiPermissionsManager;
    }

    public MessageForumsMessageManager getMessageManager() {
        return this.messageManager;
    }

    public void setMessageManager(MessageForumsMessageManager messageManager) {
        this.messageManager = messageManager;
    }

    public PrivateMessageManager getPrivateMessageManager() {
        return this.privateMessageManager;
    }

    public void setPrivateMessageManager(PrivateMessageManager privateMessageManager) {
        this.privateMessageManager = privateMessageManager;
    }

    private String getLanguage(String navName) {
        String Tmp = "";
        Tmp = navName.equals("Received") || navName.equals("Sent") || navName.equals("Deleted") ? "en" : (navName.equals("Recibidos") || navName.equals("Enviados") || navName.equals("Borrados") ? "es" : "en");
        return Tmp;
    }

    private String getPrivateMessageTypeFromContext(String navMode) {
        ArrayList<String> topicsbyLocalization = new ArrayList<String>();
        String local_received = rb.getString("pvt_received");
        String local_sent = rb.getString("pvt_sent");
        String local_deleted = rb.getString("pvt_deleted");
        topicsbyLocalization.add(local_received);
        topicsbyLocalization.add(local_sent);
        topicsbyLocalization.add(local_deleted);
        if (((String)topicsbyLocalization.get(0)).equalsIgnoreCase(navMode) || "Recibidos".equalsIgnoreCase(navMode) || "Received".equalsIgnoreCase(navMode)) {
            return this.typeManager.getReceivedPrivateMessageType();
        }
        if (((String)topicsbyLocalization.get(1)).equalsIgnoreCase(navMode) || "Enviados".equalsIgnoreCase(navMode) || "Sent".equalsIgnoreCase(navMode)) {
            return this.typeManager.getSentPrivateMessageType();
        }
        if (((String)topicsbyLocalization.get(2)).equalsIgnoreCase(navMode) || "Borrados".equalsIgnoreCase(navMode) || "Deleted".equalsIgnoreCase(navMode)) {
            return this.typeManager.getDeletedPrivateMessageType();
        }
        if (PVTMSG_MODE_DRAFT.equalsIgnoreCase(navMode)) {
            return this.typeManager.getDraftPrivateMessageType();
        }
        return this.typeManager.getCustomTopicType(navMode);
    }

    public MessageForumsTypeManager getTypeManager() {
        return this.typeManager;
    }

    public void setTypeManager(MessageForumsTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public class DecoratedTopicInfo {
        private String topicTitle;
        private Long topicId;
        private int unreadMessagesCount = 0;
        private int messagesCount = 0;
        private String typeUuid;

        public String getTypeUuid() {
            return this.typeUuid;
        }

        public void setTypeUuid(String typeUuid) {
            this.typeUuid = typeUuid;
        }

        public DecoratedTopicInfo(Long topicId, String topicTitle, int unreadMessagesCount, int messagesCount, String typeUuid) {
            this.topicId = topicId;
            this.topicTitle = topicTitle;
            this.unreadMessagesCount = unreadMessagesCount;
            this.messagesCount = messagesCount;
            this.typeUuid = typeUuid;
        }

        public Long getTopicId() {
            return this.topicId;
        }

        public void setTopicId(Long topicId) {
            this.topicId = topicId;
        }

        public String getTopicTitle() {
            return this.topicTitle;
        }

        public void setTopicTitle(String topicTitle) {
            this.topicTitle = topicTitle;
        }

        public int getUnreadMessagesCount() {
            return this.unreadMessagesCount;
        }

        public void setUnreadMessagesCount(int unreadMessagesCount) {
            this.unreadMessagesCount = unreadMessagesCount;
        }

        public int getMessagesCount() {
            return this.messagesCount;
        }

        public void setMessagesCount(int messagesCount) {
            this.messagesCount = messagesCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DecoratedForumInfo {
        private Long forumId;
        private String forumTitle;
        private List<DecoratedTopicInfo> topics = new ArrayList<DecoratedTopicInfo>();

        public Long getForumId() {
            return this.forumId;
        }

        public void setForumId(Long forumId) {
            this.forumId = forumId;
        }

        public String getForumTitle() {
            return this.forumTitle;
        }

        public void setForumTitle(String forumTitle) {
            this.forumTitle = forumTitle;
        }

        public List<DecoratedTopicInfo> getTopics() {
            return this.topics;
        }

        public void setTopics(List<DecoratedTopicInfo> topics) {
            this.topics = topics;
        }

        public DecoratedForumInfo(Long forumId, String forumTitle) {
            this.forumId = forumId;
            this.forumTitle = forumTitle;
        }

        public void addTopic(DecoratedTopicInfo topic) {
            this.topics.add(topic);
        }
    }

    public static class ForumSearch {
        public String forumId;
        public String siteId;
        public boolean isPrivate = false;
        public String locationReference;

        public ForumSearch(String locationReference) {
            this.locationReference = locationReference;
        }
    }
}

