/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums.jobs;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.sakaiproject.api.app.messageforums.MessageForumsMessageManager;
import org.sakaiproject.api.app.messageforums.MessageForumsTypeManager;
import org.sakaiproject.api.app.messageforums.cover.SynopticMsgcntrManagerCover;
import org.sakaiproject.api.app.messageforums.ui.DiscussionForumManager;
import org.sakaiproject.api.app.messageforums.ui.PrivateMessageManager;
import org.sakaiproject.api.app.messageforums.ui.UIPermissionsManager;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.db.cover.SqlService;
import org.sakaiproject.site.api.SiteService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSynopticMessageCounts
implements Job {
    private PrivateMessageManager pvtMessageManager;
    private MessageForumsTypeManager typeManager;
    private DiscussionForumManager forumManager;
    private UIPermissionsManager uiPermissionsManager;
    private MessageForumsMessageManager messageManager;
    private SiteService siteService;
    private static final Log LOG = LogFactory.getLog(UpdateSynopticMessageCounts.class);
    private static final boolean runOracleSQL = false;
    private static final String FIND_ALL_SYNOPTIC_SITES_QUERY_GENERIC = "select SITE_ID, TITLE from SAKAI_SITE where IS_USER = 0 and PUBLISHED = 1 and IS_SPECIAL = 0";
    private static final String FIND_ALL_SYNOPTIC_SITES_BY_SITE_QUERY_GENERIC = "select SITE_ID, TITLE from SAKAI_SITE where IS_USER = 0 and PUBLISHED = 1 and IS_SPECIAL = 0 and SITE_ID like ?";
    private static final String FIND_ALL_SYNOPTIC_SITES_QUERY_ORACLE_PART1 = "select q.SITE_ID, q.TITLE, sum(q.Decoded) as BINARY_FLAGS from (select ss.SITE_ID, ss.TITLE, decode (sst.REGISTRATION,'sakai.messagecenter',100,'sakai.messages',10,'sakai.forums',1,0) as Decoded from SAKAI_SITE ss, SAKAI_SITE_TOOL sst where ss.IS_USER = 0 and ss.PUBLISHED = 1 and ss.IS_SPECIAL = 0 and ss.SITE_ID = sst.SITE_ID ";
    private static final String FIND_ALL_SYNOPTIC_SITES_QUERY_ORACLE_PART2 = "and sst.REGISTRATION in ('sakai.messagecenter','sakai.messages','sakai.forums')) q Group By q.SITE_ID, q.TITLE";
    private static final String FIND_ALL_SYNOPTIC_SITES_QUERY_ORACLE = "select q.SITE_ID, q.TITLE, sum(q.Decoded) as BINARY_FLAGS from (select ss.SITE_ID, ss.TITLE, decode (sst.REGISTRATION,'sakai.messagecenter',100,'sakai.messages',10,'sakai.forums',1,0) as Decoded from SAKAI_SITE ss, SAKAI_SITE_TOOL sst where ss.IS_USER = 0 and ss.PUBLISHED = 1 and ss.IS_SPECIAL = 0 and ss.SITE_ID = sst.SITE_ID and sst.REGISTRATION in ('sakai.messagecenter','sakai.messages','sakai.forums')) q Group By q.SITE_ID, q.TITLE";
    private static final String FIND_ALL_SYNOPTIC_SITES_BY_SITE_QUERY_ORACLE = "select q.SITE_ID, q.TITLE, sum(q.Decoded) as BINARY_FLAGS from (select ss.SITE_ID, ss.TITLE, decode (sst.REGISTRATION,'sakai.messagecenter',100,'sakai.messages',10,'sakai.forums',1,0) as Decoded from SAKAI_SITE ss, SAKAI_SITE_TOOL sst where ss.IS_USER = 0 and ss.PUBLISHED = 1 and ss.IS_SPECIAL = 0 and ss.SITE_ID = sst.SITE_ID and ss.SITE_ID like ? and sst.REGISTRATION in ('sakai.messagecenter','sakai.messages','sakai.forums')) q Group By q.SITE_ID, q.TITLE";
    private static final String UNREAD_MESSAGES_QUERY = "SELECT message.USER_ID, message.CONTEXT_ID, count(*) unread_messages FROM MFR_PVT_MSG_USR_T message where READ_STATUS = 0 group by message.USER_ID, message.CONTEXT_ID";
    private static final String UNREAD_MESSAGES_BY_SITE_QUERY = "SELECT message.USER_ID, message.CONTEXT_ID, count(*) unread_messages FROM MFR_PVT_MSG_USR_T message where READ_STATUS = 0 and message.CONTEXT_ID like ?group by message.USER_ID, message.CONTEXT_ID";
    private static final String TOPICS_AND_FORUMS_QUERY = "select area.CONTEXT_ID, forum.ID as FORUM_ID, topic.ID as TOPIC_ID, forum.DRAFT as isForumDraft, topic.DRAFT as isTopicDraft, topic.MODERATED as isTopicModerated, forum.LOCKED as isForumLocked, topic.LOCKED as isTopicLocked, forum.CREATED_BY as forumCreatedBy, topic.CREATED_BY as topicCreatedBy from MFR_AREA_T area, MFR_OPEN_FORUM_T forum, MFR_TOPIC_T topic Where area.ID = forum.surrogateKey and forum.ID = topic.of_surrogateKey";
    private boolean updateNewMembersOnly = ServerConfigurationService.getBoolean((String)"msgcntr.synoptic.updateMessageCounts.updateNewMembersOnly", (boolean)false);
    private boolean addItemsWhenNoUnreadCounts = ServerConfigurationService.getBoolean((String)"msgcntr.synoptic.updateMessageCounts.addItemsWhenNoUnreadCounts", (boolean)false);

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        block57: {
            Connection clConnection = null;
            Statement statement = null;
            ResultSet unreadMessageCountRS = null;
            ResultSet allTopicsAndForumsRS = null;
            ResultSet synotpicSitesRS = null;
            PreparedStatement unreadMessagesbySitePS = null;
            Statement findSitesbySitePS = null;
            String siteFilter = ServerConfigurationService.getString((String)"msgcntr.synoptic.updateMessageCountsSiteFilter");
            boolean filterSites = siteFilter != null && !"".equals(siteFilter);
            int count = 0;
            LOG.info((Object)("UpdateSynopticMessageCounts job launched: " + new Date()));
            clConnection = SqlService.borrowConnection();
            statement = clConnection.createStatement();
            if (filterSites) {
                unreadMessagesbySitePS = clConnection.prepareStatement(UNREAD_MESSAGES_BY_SITE_QUERY);
                unreadMessagesbySitePS.setString(1, siteFilter);
                unreadMessageCountRS = unreadMessagesbySitePS.executeQuery();
            } else {
                unreadMessageCountRS = statement.executeQuery(UNREAD_MESSAGES_QUERY);
            }
            HashMap<String, HashMap<String, Integer>> siteAndUserMessageCountHM = this.getSiteAndUserMessageCountHM(unreadMessageCountRS);
            allTopicsAndForumsRS = statement.executeQuery(TOPICS_AND_FORUMS_QUERY);
            HashMap<String, HashMap<Long, DecoratedForumInfo>> allTopicsAndForumsHM = this.getAllTopicsAndForumsHM(allTopicsAndForumsRS);
            String siteId = "";
            String siteTitle = "";
            if (filterSites) {
                findSitesbySitePS = clConnection.prepareStatement(FIND_ALL_SYNOPTIC_SITES_BY_SITE_QUERY_GENERIC);
                findSitesbySitePS.setString(1, siteFilter);
                synotpicSitesRS = findSitesbySitePS.executeQuery();
            } else {
                synotpicSitesRS = statement.executeQuery(FIND_ALL_SYNOPTIC_SITES_QUERY_GENERIC);
            }
            while (synotpicSitesRS.next()) {
                boolean isMessageForumsPageInSite = false;
                boolean isMessagesPageInSite = false;
                boolean isForumsPageInSite = false;
                siteId = synotpicSitesRS.getString("SITE_ID");
                siteTitle = synotpicSitesRS.getString("TITLE");
                this.updateSynopticToolInfoForAllUsers(siteId, siteTitle, clConnection, isMessageForumsPageInSite, isMessagesPageInSite, isForumsPageInSite, siteAndUserMessageCountHM, allTopicsAndForumsHM);
                if (++count % 1000 != 0) continue;
                LOG.info((Object)("UpdateSynopticMessageCounts Progress: " + count + " Sites updated"));
            }
            Object var21_20 = null;
            try {
                if (unreadMessageCountRS != null) {
                    unreadMessageCountRS.close();
                }
            }
            catch (Exception e) {
                LOG.warn((Object)e);
            }
            try {
                if (allTopicsAndForumsRS != null) {
                    allTopicsAndForumsRS.close();
                }
            }
            catch (Exception e) {
                LOG.warn((Object)e);
            }
            try {
                if (synotpicSitesRS != null) {
                    synotpicSitesRS.close();
                }
            }
            catch (Exception e) {
                LOG.warn((Object)e);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                LOG.warn((Object)e);
            }
            try {
                if (unreadMessagesbySitePS != null) {
                    unreadMessagesbySitePS.close();
                }
            }
            catch (Exception e) {
                LOG.warn((Object)e);
            }
            try {
                if (findSitesbySitePS != null) {
                    findSitesbySitePS.close();
                }
            }
            catch (Exception e) {
                LOG.warn((Object)e);
            }
            SqlService.returnConnection((Connection)clConnection);
            {
                break block57;
                catch (Exception e1) {
                    LOG.error((Object)e1);
                    Object var21_21 = null;
                    try {
                        if (unreadMessageCountRS != null) {
                            unreadMessageCountRS.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)e);
                    }
                    try {
                        if (allTopicsAndForumsRS != null) {
                            allTopicsAndForumsRS.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)e);
                    }
                    try {
                        if (synotpicSitesRS != null) {
                            synotpicSitesRS.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)e);
                    }
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)e);
                    }
                    try {
                        if (unreadMessagesbySitePS != null) {
                            unreadMessagesbySitePS.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)e);
                    }
                    try {
                        if (findSitesbySitePS != null) {
                            findSitesbySitePS.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)e);
                    }
                    SqlService.returnConnection((Connection)clConnection);
                }
            }
            catch (Throwable throwable) {
                Object var21_22 = null;
                try {
                    if (unreadMessageCountRS != null) {
                        unreadMessageCountRS.close();
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)e);
                }
                try {
                    if (allTopicsAndForumsRS != null) {
                        allTopicsAndForumsRS.close();
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)e);
                }
                try {
                    if (synotpicSitesRS != null) {
                        synotpicSitesRS.close();
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)e);
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)e);
                }
                try {
                    if (unreadMessagesbySitePS != null) {
                        unreadMessagesbySitePS.close();
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)e);
                }
                try {
                    if (findSitesbySitePS != null) {
                        findSitesbySitePS.close();
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)e);
                }
                SqlService.returnConnection((Connection)clConnection);
                throw throwable;
            }
        }
        LOG.info((Object)("UpdateSynopticMessageCounts job finished: " + new Date()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void updateSynopticToolInfoForAllUsers(String siteId, String siteTitle, Connection clConnection, boolean isMessageForumsPageInSite, boolean isMessagesPageInSite, boolean isForumsPageInSite, HashMap<String, HashMap<String, Integer>> siteAndUserMessageCountHM, HashMap<String, HashMap<Long, DecoratedForumInfo>> allTopicsAndForumsHM) throws Exception {
        block84: {
            PreparedStatement getAllUsersInSiteQuery;
            PreparedStatement isForumsPageInSiteQuery;
            PreparedStatement isMessagesPageInSiteQuery;
            PreparedStatement isMessageForumsPageInSiteQuery;
            block77: {
                isMessageForumsPageInSiteQuery = null;
                isMessagesPageInSiteQuery = null;
                isForumsPageInSiteQuery = null;
                getAllUsersInSiteQuery = null;
                ResultSet rsMessagesForums = null;
                ResultSet rsMessages = null;
                ResultSet rsForusm = null;
                isMessageForumsPageInSiteQuery = clConnection.prepareStatement("select * from SAKAI_SITE_TOOL where SITE_ID = ? and REGISTRATION = 'sakai.messagecenter'");
                isMessageForumsPageInSiteQuery.setString(1, siteId);
                isMessagesPageInSiteQuery = clConnection.prepareStatement("select * from SAKAI_SITE_TOOL where SITE_ID = ? and REGISTRATION = 'sakai.messages'");
                isMessagesPageInSiteQuery.setString(1, siteId);
                isForumsPageInSiteQuery = clConnection.prepareStatement("select * from SAKAI_SITE_TOOL where SITE_ID = ? and REGISTRATION = 'sakai.forums'");
                isForumsPageInSiteQuery.setString(1, siteId);
                rsMessagesForums = isMessageForumsPageInSiteQuery.executeQuery();
                while (rsMessagesForums.next()) {
                    isMessageForumsPageInSite = true;
                }
                rsMessages = isMessagesPageInSiteQuery.executeQuery();
                while (rsMessages.next()) {
                    isMessagesPageInSite = true;
                }
                rsForusm = isForumsPageInSiteQuery.executeQuery();
                while (rsForusm.next()) {
                    isForumsPageInSite = true;
                }
                Object var18_17 = null;
                try {
                    if (rsMessagesForums != null) {
                        rsMessagesForums.close();
                    }
                }
                catch (Exception e2) {
                    LOG.warn((Object)e2);
                }
                try {
                    if (rsMessages != null) {
                        rsMessages.close();
                    }
                }
                catch (Exception e2) {
                    LOG.warn((Object)e2);
                }
                try {
                    if (rsForusm != null) {
                        rsForusm.close();
                    }
                    break block77;
                }
                catch (Exception e2) {
                    LOG.warn((Object)e2);
                }
                break block77;
                {
                    catch (Exception e) {
                        LOG.warn((Object)e);
                        var18_17 = null;
                        try {
                            if (rsMessagesForums != null) {
                                rsMessagesForums.close();
                            }
                        }
                        catch (Exception e2) {
                            LOG.warn((Object)e2);
                        }
                        try {
                            if (rsMessages != null) {
                                rsMessages.close();
                            }
                        }
                        catch (Exception e2) {
                            LOG.warn((Object)e2);
                        }
                        try {
                            if (rsForusm != null) {
                                rsForusm.close();
                            }
                            break block77;
                        }
                        catch (Exception e2) {
                            LOG.warn((Object)e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var18_18 = null;
                    try {
                        if (rsMessagesForums != null) {
                            rsMessagesForums.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    try {
                        if (rsMessages != null) {
                            rsMessages.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    try {
                        if (rsForusm != null) {
                            rsForusm.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn((Object)e2);
                    }
                    throw throwable;
                }
            }
            ResultSet usersMap = null;
            String allUsersQuery = "select USER_ID from SAKAI_SITE_USER where SITE_ID = ?";
            if (this.updateNewMembersOnly) {
                allUsersQuery = allUsersQuery + " and USER_ID not in (select USER_ID from MFR_SYNOPTIC_ITEM where SITE_ID = ?)";
            }
            getAllUsersInSiteQuery = clConnection.prepareStatement(allUsersQuery);
            getAllUsersInSiteQuery.setString(1, siteId);
            if (this.updateNewMembersOnly) {
                getAllUsersInSiteQuery.setString(2, siteId);
            }
            usersMap = getAllUsersInSiteQuery.executeQuery();
            HashMap<String, Integer> userHM = null;
            Integer count = null;
            while (usersMap.next()) {
                int unreadPrivate = 0;
                int unreadForum = 0;
                String userId = usersMap.getString("USER_ID");
                if ((isMessageForumsPageInSite || isMessagesPageInSite) && (userHM = siteAndUserMessageCountHM.get(siteId)) != null && (count = userHM.get(userId)) != null) {
                    unreadPrivate = count;
                }
                boolean isSuperUser = SecurityService.isSuperUser((String)userId);
                HashMap<Long, DecoratedForumInfo> dfHM = null;
                if ((isMessageForumsPageInSite || isForumsPageInSite) && (dfHM = allTopicsAndForumsHM.get(siteId)) != null) {
                    Set<Map.Entry<Long, DecoratedForumInfo>> dfEntrySet = dfHM.entrySet();
                    for (Map.Entry<Long, DecoratedForumInfo> entry : dfEntrySet) {
                        Long dfId = entry.getKey();
                        DecoratedForumInfo dForum = entry.getValue();
                        boolean isInstructor = this.getForumManager().isInstructor(userId, "/site/" + siteId);
                        if (!dForum.getIsDraft().equals(Boolean.FALSE) && !isInstructor && !isSuperUser && !this.forumManager.isForumOwner(dfId, dForum.getCreator(), userId, "/site/" + siteId)) continue;
                        for (DecoratedTopicsInfo topic : dForum.getTopics()) {
                            Long topicId = topic.getTopicId();
                            Boolean isTopicDraft = topic.getIsDraft();
                            Boolean isTopicModerated = topic.getIsModerated();
                            Boolean isTopicLocked = topic.getIsLocked();
                            String topicOwner = topic.getCreator();
                            if (!isTopicDraft.equals(Boolean.FALSE) && !isInstructor && !isSuperUser && !this.forumManager.isTopicOwner(topicId, topicOwner, userId, "/site/" + siteId) || !this.getUiPermissionsManager().isRead(topicId, isTopicDraft, dForum.getIsDraft(), userId, siteId)) continue;
                            if (!isTopicModerated.booleanValue() || isTopicModerated.booleanValue() && this.getUiPermissionsManager().isModeratePostings(topicId, dForum.getIsLocked(), dForum.getIsDraft(), isTopicLocked, isTopicDraft, userId, siteId)) {
                                unreadForum += this.getMessageManager().findUnreadMessageCountByTopicIdByUserId(topicId, userId);
                                continue;
                            }
                            unreadForum += this.getMessageManager().findUnreadViewableMessageCountByTopicIdByUserId(topicId, userId);
                        }
                    }
                }
                if (unreadPrivate == 0 && unreadForum == 0 && !this.updateNewMembersOnly && !this.addItemsWhenNoUnreadCounts) continue;
                SynopticMsgcntrManagerCover.createOrUpdateSynopticToolInfo((String)userId, (String)siteId, (String)siteTitle, (int)unreadPrivate, (int)unreadForum);
            }
            Object var36_41 = null;
            try {
                if (usersMap != null) {
                    usersMap.close();
                }
            }
            catch (Exception e3) {
                LOG.warn((Object)e3);
            }
            try {
                if (getAllUsersInSiteQuery != null) {
                    getAllUsersInSiteQuery.close();
                }
            }
            catch (Exception e3) {
                LOG.warn((Object)e3);
            }
            try {
                if (isForumsPageInSiteQuery != null) {
                    isForumsPageInSiteQuery.close();
                }
            }
            catch (Exception e3) {
                LOG.warn((Object)e3);
            }
            try {
                if (isMessagesPageInSiteQuery != null) {
                    isMessagesPageInSiteQuery.close();
                }
            }
            catch (Exception e3) {
                LOG.warn((Object)e3);
            }
            try {
                if (isMessageForumsPageInSiteQuery != null) {
                    isMessageForumsPageInSiteQuery.close();
                }
                break block84;
            }
            catch (Exception e3) {
                LOG.warn((Object)e3);
            }
            break block84;
            {
                catch (Exception e) {
                    LOG.warn((Object)e);
                    Object var36_42 = null;
                    try {
                        if (usersMap != null) {
                            usersMap.close();
                        }
                    }
                    catch (Exception e3) {
                        LOG.warn((Object)e3);
                    }
                    try {
                        if (getAllUsersInSiteQuery != null) {
                            getAllUsersInSiteQuery.close();
                        }
                    }
                    catch (Exception e3) {
                        LOG.warn((Object)e3);
                    }
                    try {
                        if (isForumsPageInSiteQuery != null) {
                            isForumsPageInSiteQuery.close();
                        }
                    }
                    catch (Exception e3) {
                        LOG.warn((Object)e3);
                    }
                    try {
                        if (isMessagesPageInSiteQuery != null) {
                            isMessagesPageInSiteQuery.close();
                        }
                    }
                    catch (Exception e3) {
                        LOG.warn((Object)e3);
                    }
                    try {
                        if (isMessageForumsPageInSiteQuery != null) {
                            isMessageForumsPageInSiteQuery.close();
                        }
                        break block84;
                    }
                    catch (Exception e3) {
                        LOG.warn((Object)e3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var36_43 = null;
                try {
                    if (usersMap != null) {
                        usersMap.close();
                    }
                }
                catch (Exception e3) {
                    LOG.warn((Object)e3);
                }
                try {
                    if (getAllUsersInSiteQuery != null) {
                        getAllUsersInSiteQuery.close();
                    }
                }
                catch (Exception e3) {
                    LOG.warn((Object)e3);
                }
                try {
                    if (isForumsPageInSiteQuery != null) {
                        isForumsPageInSiteQuery.close();
                    }
                }
                catch (Exception e3) {
                    LOG.warn((Object)e3);
                }
                try {
                    if (isMessagesPageInSiteQuery != null) {
                        isMessagesPageInSiteQuery.close();
                    }
                }
                catch (Exception e3) {
                    LOG.warn((Object)e3);
                }
                try {
                    if (isMessageForumsPageInSiteQuery != null) {
                        isMessageForumsPageInSiteQuery.close();
                    }
                }
                catch (Exception e3) {
                    LOG.warn((Object)e3);
                }
                throw throwable;
            }
        }
    }

    public HashMap<String, HashMap<Long, DecoratedForumInfo>> getAllTopicsAndForumsHM(ResultSet rs) {
        HashMap<String, HashMap<Long, DecoratedForumInfo>> returnHM = new HashMap<String, HashMap<Long, DecoratedForumInfo>>();
        if (rs != null) {
            try {
                while (rs.next()) {
                    DecoratedForumInfo dForum;
                    DecoratedTopicsInfo dTopic;
                    String CONTEXT_ID = rs.getString("CONTEXT_ID");
                    Long FORUM_ID = rs.getLong("FORUM_ID");
                    Long TOPIC_ID = rs.getLong("TOPIC_ID");
                    Boolean IS_TOPIC_DRAFT = rs.getBoolean("isForumDraft");
                    Boolean IS_FORUM_DRAFT = rs.getBoolean("isTopicDraft");
                    Boolean IS_TOPIC_MODERATED = rs.getBoolean("isTopicModerated");
                    Boolean IS_FORUM_LOCKED = rs.getBoolean("isForumLocked");
                    Boolean IS_TOPIC_LOCKED = rs.getBoolean("isTopicLocked");
                    String FORUM_CREATED_BY = rs.getString("forumCreatedBy");
                    String TOPIC_CREATED_BY = rs.getString("topicCreatedBy");
                    if (returnHM.containsKey(CONTEXT_ID)) {
                        if (returnHM.get(CONTEXT_ID).containsKey(FORUM_ID)) {
                            dTopic = new DecoratedTopicsInfo(TOPIC_ID, IS_TOPIC_LOCKED, IS_TOPIC_DRAFT, IS_TOPIC_MODERATED, TOPIC_CREATED_BY);
                            returnHM.get(CONTEXT_ID).get(FORUM_ID).addTopic(dTopic);
                            continue;
                        }
                        dTopic = new DecoratedTopicsInfo(TOPIC_ID, IS_TOPIC_LOCKED, IS_TOPIC_DRAFT, IS_TOPIC_MODERATED, TOPIC_CREATED_BY);
                        dForum = new DecoratedForumInfo(FORUM_ID, IS_FORUM_LOCKED, IS_FORUM_DRAFT, FORUM_CREATED_BY);
                        dForum.addTopic(dTopic);
                        returnHM.get(CONTEXT_ID).put(FORUM_ID, dForum);
                        continue;
                    }
                    dTopic = new DecoratedTopicsInfo(TOPIC_ID, IS_TOPIC_LOCKED, IS_TOPIC_DRAFT, IS_TOPIC_MODERATED, TOPIC_CREATED_BY);
                    dForum = new DecoratedForumInfo(FORUM_ID, IS_FORUM_LOCKED, IS_FORUM_DRAFT, FORUM_CREATED_BY);
                    dForum.addTopic(dTopic);
                    HashMap<Long, DecoratedForumInfo> forumHM = new HashMap<Long, DecoratedForumInfo>();
                    forumHM.put(FORUM_ID, dForum);
                    returnHM.put(CONTEXT_ID, forumHM);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return returnHM;
    }

    public HashMap<String, HashMap<String, Integer>> getSiteAndUserMessageCountHM(ResultSet rs) {
        HashMap<String, HashMap<String, Integer>> returnHM = new HashMap<String, HashMap<String, Integer>>();
        if (rs != null) {
            try {
                while (rs.next()) {
                    String siteId = rs.getString("CONTEXT_ID");
                    String userId = rs.getString("USER_ID");
                    Integer messageCount = rs.getInt("unread_messages");
                    if (returnHM.containsKey(siteId)) {
                        returnHM.get(siteId).put(userId, messageCount);
                        continue;
                    }
                    HashMap<String, Integer> newHashMap = new HashMap<String, Integer>();
                    newHashMap.put(userId, messageCount);
                    returnHM.put(siteId, newHashMap);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return returnHM;
    }

    public PrivateMessageManager getPvtMessageManager() {
        return this.pvtMessageManager;
    }

    public void setPvtMessageManager(PrivateMessageManager pvtMessageManager) {
        this.pvtMessageManager = pvtMessageManager;
    }

    public MessageForumsTypeManager getTypeManager() {
        return this.typeManager;
    }

    public void setTypeManager(MessageForumsTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public DiscussionForumManager getForumManager() {
        return this.forumManager;
    }

    public void setForumManager(DiscussionForumManager forumManager) {
        this.forumManager = forumManager;
    }

    public UIPermissionsManager getUiPermissionsManager() {
        return this.uiPermissionsManager;
    }

    public void setUiPermissionsManager(UIPermissionsManager uiPermissionsManager) {
        this.uiPermissionsManager = uiPermissionsManager;
    }

    public MessageForumsMessageManager getMessageManager() {
        return this.messageManager;
    }

    public void setMessageManager(MessageForumsMessageManager messageManager) {
        this.messageManager = messageManager;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public class DecoratedTopicsInfo {
        private Long topicId;
        private Boolean isLocked;
        private Boolean isDraft;
        private Boolean isModerated;
        private String creator;

        public DecoratedTopicsInfo(Long topicId, Boolean isLocked, Boolean isDraft, Boolean isModerated, String creator) {
            this.topicId = topicId;
            this.isLocked = isLocked;
            this.isDraft = isDraft;
            this.isModerated = isModerated;
            this.creator = creator;
        }

        public Long getTopicId() {
            return this.topicId;
        }

        public void setTopicId(Long topicId) {
            this.topicId = topicId;
        }

        public Boolean getIsLocked() {
            return this.isLocked;
        }

        public void setIsLocked(Boolean isLocked) {
            this.isLocked = isLocked;
        }

        public Boolean getIsDraft() {
            return this.isDraft;
        }

        public void setIsDraft(Boolean isDraft) {
            this.isDraft = isDraft;
        }

        public Boolean getIsModerated() {
            return this.isModerated;
        }

        public void setIsModerated(Boolean isModerated) {
            this.isModerated = isModerated;
        }

        public String getCreator() {
            return this.creator;
        }

        public void setCreator(String creator) {
            this.creator = creator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DecoratedForumInfo {
        private Long forumId;
        private Boolean isLocked;
        private Boolean isDraft;
        private String creator;
        private ArrayList<DecoratedTopicsInfo> topics = new ArrayList();

        public DecoratedForumInfo(Long forumId, Boolean isLocked, Boolean isDraft, String creator) {
            this.forumId = forumId;
            this.isLocked = isLocked;
            this.isDraft = isDraft;
            this.creator = creator;
        }

        public Long getForumId() {
            return this.forumId;
        }

        public void setForumId(Long forumId) {
            this.forumId = forumId;
        }

        public Boolean getIsLocked() {
            return this.isLocked;
        }

        public void setIsLocked(Boolean isLocked) {
            this.isLocked = isLocked;
        }

        public Boolean getIsDraft() {
            return this.isDraft;
        }

        public void setIsDraft(Boolean isDraft) {
            this.isDraft = isDraft;
        }

        public String getCreator() {
            return this.creator;
        }

        public void setCreator(String creator) {
            this.creator = creator;
        }

        public void addTopic(DecoratedTopicsInfo dTopics) {
            this.topics.add(dTopics);
        }

        public ArrayList<DecoratedTopicsInfo> getTopics() {
            return this.topics;
        }
    }
}

