/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.messageforums.ActorPermissions;
import org.sakaiproject.api.app.messageforums.Area;
import org.sakaiproject.api.app.messageforums.AreaControlPermission;
import org.sakaiproject.api.app.messageforums.AreaManager;
import org.sakaiproject.api.app.messageforums.Attachment;
import org.sakaiproject.api.app.messageforums.BaseForum;
import org.sakaiproject.api.app.messageforums.DBMembershipItem;
import org.sakaiproject.api.app.messageforums.DiscussionForum;
import org.sakaiproject.api.app.messageforums.DiscussionTopic;
import org.sakaiproject.api.app.messageforums.DummyDataHelperApi;
import org.sakaiproject.api.app.messageforums.ForumControlPermission;
import org.sakaiproject.api.app.messageforums.MembershipManager;
import org.sakaiproject.api.app.messageforums.Message;
import org.sakaiproject.api.app.messageforums.MessageForumsForumManager;
import org.sakaiproject.api.app.messageforums.MessageForumsMessageManager;
import org.sakaiproject.api.app.messageforums.MessageForumsTypeManager;
import org.sakaiproject.api.app.messageforums.MessageForumsUser;
import org.sakaiproject.api.app.messageforums.MessagePermissions;
import org.sakaiproject.api.app.messageforums.PermissionLevel;
import org.sakaiproject.api.app.messageforums.PermissionLevelManager;
import org.sakaiproject.api.app.messageforums.PermissionManager;
import org.sakaiproject.api.app.messageforums.Topic;
import org.sakaiproject.api.app.messageforums.TopicControlPermission;
import org.sakaiproject.api.app.messageforums.cover.ForumScheduleNotificationCover;
import org.sakaiproject.api.app.messageforums.ui.DiscussionForumManager;
import org.sakaiproject.api.app.messageforums.ui.UIPermissionsManager;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.authz.cover.AuthzGroupService;
import org.sakaiproject.component.app.messageforums.MembershipItem;
import org.sakaiproject.component.app.messageforums.dao.hibernate.ActorPermissionsImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.DBMembershipItemImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.MessageForumsUserImpl;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entitybroker.EntityBroker;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.thread_local.cover.ThreadLocalManager;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscussionForumManagerImpl
extends HibernateDaoSupport
implements DiscussionForumManager {
    private static final String MC_DEFAULT = "mc.default.";
    private static final Log LOG = LogFactory.getLog(DiscussionForumManagerImpl.class);
    private AreaManager areaManager;
    private MessageForumsForumManager forumManager;
    private MessageForumsMessageManager messageManager;
    private DummyDataHelperApi helper;
    private PermissionManager permissionManager;
    private MessageForumsTypeManager typeManager;
    private SiteService siteService;
    private UserDirectoryService userDirectoryService;
    private MembershipManager membershipManager;
    private SecurityService securityService;
    private SessionManager sessionManager;
    private PermissionLevelManager permissionLevelManager;
    private Map courseMemberMap = null;
    private boolean usingHelper = false;
    private ContentHostingService contentHostingService;
    private UIPermissionsManager permissionsManager;
    private EntityBroker entityBroker;
    public static final int MAX_NUMBER_OF_SQL_PARAMETERS_IN_LIST = 1000;

    public void init() {
        LOG.info((Object)"init()");
    }

    public void setEntityBroker(EntityBroker entityBroker) {
        this.entityBroker = entityBroker;
    }

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public List searchTopicMessages(Long topicId, String searchText) {
        return this.forumManager.searchTopicMessages(topicId, searchText);
    }

    public Topic getTopicByIdWithAttachments(Long topicId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getTopicByIdWithAttachments(Long " + topicId + ")"));
        }
        return this.forumManager.getTopicByIdWithAttachments(topicId);
    }

    public List getTopicsByIdWithMessages(Long forumId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getTopicsByIdWithMessages(final Long" + forumId + ")"));
        }
        return this.forumManager.getTopicsByIdWithMessages(forumId);
    }

    public List getTopicsByIdWithMessagesAndAttachments(Long forumId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getTopicsByIdWithMessagesAndAttachments(final Long" + forumId + ")"));
        }
        return this.forumManager.getTopicsByIdWithMessagesAndAttachments(forumId);
    }

    public List getTopicsByIdWithMessagesMembershipAndAttachments(Long forumId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getTopicsByIdWithMessagesMembershipAndAttachments(final Long" + forumId + ")"));
        }
        return this.forumManager.getTopicsByIdWithMessagesMembershipAndAttachments(forumId);
    }

    public List<DiscussionForum> getForumsForMainPage() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getForumsForMainPage()");
        }
        return this.forumManager.getForumsForMainPage();
    }

    public List<Object[]> getMessageCountsForMainPage(Collection<Long> topicIds) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getMessageCountsForMainPage(" + topicIds + ")"));
        }
        return this.messageManager.findMessageCountsForMainPage(topicIds);
    }

    public List<Object[]> getReadMessageCountsForMainPage(Collection<Long> topicIds) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getReadMessageCountsForMainPage(" + topicIds + ")"));
        }
        return this.messageManager.findReadMessageCountsForMainPage(topicIds);
    }

    public Topic getTopicByIdWithMessages(Long topicId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getTopicByIdWithMessages(final Long" + topicId + ")"));
        }
        return this.forumManager.getTopicByIdWithMessages(topicId);
    }

    public Topic getTopicWithAttachmentsById(Long topicId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getTopicWithAttachmentsById(final Long" + topicId + ")"));
        }
        return this.forumManager.getTopicWithAttachmentsById(topicId);
    }

    public Topic getTopicByIdWithMessagesAndAttachments(Long topicId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getTopicByIdWithMessagesAndAttachments(final Long" + topicId + ")"));
        }
        return this.forumManager.getTopicByIdWithMessagesAndAttachments(topicId);
    }

    public List getModeratedTopicsInSite() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getModeratedTopicsInSite()");
        }
        return this.forumManager.getModeratedTopicsInSite(ToolManager.getCurrentPlacement().getContext());
    }

    public void setHelper(DummyDataHelperApi helper) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setHelper(DummyDataHelperApi " + helper + ")"));
        }
        this.helper = helper;
    }

    public void setAreaManager(AreaManager areaManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setAreaManager(AreaManager" + areaManager + ")"));
        }
        this.areaManager = areaManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setPermissionManager(PermissionManager" + permissionManager + ")"));
        }
        this.permissionManager = permissionManager;
    }

    public void setPermissionLevelManager(PermissionLevelManager permissionLevelManager) {
        this.permissionLevelManager = permissionLevelManager;
    }

    public void setTypeManager(MessageForumsTypeManager typeManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setTypeManager(MessageForumsTypeManager" + typeManager + ")"));
        }
        this.typeManager = typeManager;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setMembershipManager(MembershipManager membershipManager) {
        this.membershipManager = membershipManager;
    }

    public MessageForumsMessageManager getMessageManager() {
        LOG.debug((Object)"getMessageManager()");
        return this.messageManager;
    }

    public void setMessageManager(MessageForumsMessageManager messageManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setMessageManager(MessageForumsMessageManager" + messageManager + ")"));
        }
        this.messageManager = messageManager;
    }

    public Area getDiscussionForumArea() {
        return this.getDiscussionForumArea(ToolManager.getCurrentPlacement().getContext());
    }

    public Area getDiscussionForumArea(String siteId) {
        LOG.debug((Object)"getDiscussionForumArea");
        if (this.usingHelper) {
            return this.helper.getDiscussionForumArea();
        }
        return this.areaManager.getDiscussionArea(siteId);
    }

    public Message getMessageById(Long id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getMessageById( Long" + id + ")"));
        }
        if (this.usingHelper) {
            return this.helper.getMessageById(id);
        }
        return this.messageManager.getMessageById(id);
    }

    public void saveMessage(Message message) {
        this.saveMessage(message, true);
    }

    public void saveMessage(Message message, boolean logEvent) {
        this.saveMessage(message, logEvent, false);
    }

    public void saveMessage(Message message, boolean logEvent, boolean ignoreLockedTopicForum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveMessage(Message " + message + ")"));
        }
        if (message.getTopic().getBaseForum() == null) {
            message.setTopic((Topic)this.getTopicById(message.getTopic().getId()));
        }
        if (this.getAnonRole() && message.getCreatedBy() == null) {
            message.setCreatedBy(".anon");
        }
        if (this.getAnonRole() && message.getModifiedBy() == null) {
            message.setModifiedBy(".anon");
        }
        this.messageManager.saveMessage(message, logEvent, ignoreLockedTopicForum);
    }

    public void deleteMessage(Message message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deleteMessage(Message" + message + ")"));
        }
        this.messageManager.deleteMessage(message);
    }

    public int getTotalNoMessages(Topic topic) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getTotalNoMessages(Topic" + topic + ")"));
        }
        if (this.usingHelper) {
            return 20;
        }
        return this.messageManager.findMessageCountByTopicId(topic.getId());
    }

    public int getTotalViewableMessagesWhenMod(Topic topic) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getTotalViewableMessagesWhenMod(Topic" + topic + ")"));
        }
        if (this.usingHelper) {
            return 20;
        }
        return this.messageManager.findViewableMessageCountByTopicId(topic.getId());
    }

    public int getUnreadNoMessages(Topic topic) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getUnreadNoMessages(Topic" + topic + ")"));
        }
        if (this.usingHelper) {
            return 10;
        }
        return this.messageManager.findUnreadMessageCountByTopicId(topic.getId());
    }

    public int getNumUnreadViewableMessagesWhenMod(Topic topic) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getNumUnreadViewableMessagesWhenMod(Topic" + topic + ")"));
        }
        if (this.usingHelper) {
            return 10;
        }
        return this.messageManager.findUnreadViewableMessageCountByTopicId(topic.getId());
    }

    public void approveAllPendingMessages(Long topicId) {
        if (topicId == null) {
            LOG.error((Object)"approveAllPendingMessages failed with topicId: Null");
            throw new IllegalArgumentException("Null Argument");
        }
        List messages = this.getMessagesByTopicId(topicId);
        if (messages != null && messages.size() > 0) {
            for (Message msg : messages) {
                if (msg.getApproved() != null) continue;
                msg.setApproved(Boolean.TRUE);
            }
        }
    }

    public List getPendingMsgsInSiteByMembership(List membershipList) {
        return this.messageManager.getPendingMsgsInSiteByMembership(membershipList);
    }

    public List getDiscussionForums() {
        LOG.debug((Object)"getDiscussionForums()");
        if (this.usingHelper) {
            return this.helper.getDiscussionForumArea().getDiscussionForums();
        }
        return this.forumManager.getForumByTypeAndContext(this.typeManager.getDiscussionForumType());
    }

    public List getDiscussionForums(String siteId) {
        LOG.debug((Object)"getDiscussionForums(siteId)");
        if (this.usingHelper) {
            return this.helper.getDiscussionForumArea().getDiscussionForums();
        }
        return this.forumManager.getForumByTypeAndContext(this.typeManager.getDiscussionForumType(), siteId);
    }

    public List getDiscussionForumsByContextId(String contextId) {
        LOG.debug((Object)"getDiscussionForumsByContextId(String contextId)");
        return this.forumManager.getForumByTypeAndContext(this.typeManager.getDiscussionForumType(), contextId);
    }

    public DiscussionForum getForumById(Long forumId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getForumById(Long" + forumId + ")"));
        }
        if (this.usingHelper) {
            return this.helper.getForumById(forumId);
        }
        return (DiscussionForum)this.forumManager.getForumById(true, forumId);
    }

    public DiscussionForum getForumByUuid(String forumId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getForumByUuid(String" + forumId + ")"));
        }
        return (DiscussionForum)this.forumManager.getForumByUuid(forumId);
    }

    public List getMessagesByTopicId(Long topicId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getMessagesByTopicId(Long" + topicId + ")"));
        }
        return this.messageManager.findMessagesByTopicId(topicId);
    }

    public DiscussionTopic getTopicById(Long topicId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getTopicById(Long" + topicId + ")"));
        }
        return (DiscussionTopic)this.forumManager.getTopicById(true, topicId);
    }

    public DiscussionForum getForumByIdWithTopics(Long forumId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getForumByIdWithTopics(Long" + forumId + ")"));
        }
        return (DiscussionForum)this.forumManager.getForumByIdWithTopics(forumId);
    }

    public DiscussionForum getForumByIdWithTopicsAttachmentsAndMessages(Long forumId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getForumByIdWithTopicsAttachmentsAndMessages(Long " + forumId + ")"));
        }
        return (DiscussionForum)this.forumManager.getForumByIdWithTopicsAttachmentsAndMessages(forumId);
    }

    public DiscussionTopic getTopicByUuid(String topicId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" getTopicByUuid(String" + topicId + ")"));
        }
        return (DiscussionTopic)this.forumManager.getTopicByUuid(topicId);
    }

    public boolean hasNextTopic(DiscussionTopic topic) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("hasNextTopic(DiscussionTopic" + topic + ")"));
        }
        if (this.usingHelper) {
            return this.helper.hasNextTopic(topic);
        }
        boolean next = false;
        DiscussionForum forum = this.getForumById(topic.getBaseForum().getId());
        if (forum != null && forum.getTopics() != null) {
            Iterator iter = forum.getTopics().iterator();
            while (iter.hasNext()) {
                try {
                    DiscussionTopic t = (DiscussionTopic)iter.next();
                    if (next && this.getTopicAccess(t)) {
                        return true;
                    }
                    if (t == null || !this.getTopicAccess(t) || !t.getId().equals(topic.getId())) continue;
                    next = true;
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage());
                }
            }
        }
        return false;
    }

    public boolean hasPreviousTopic(DiscussionTopic topic) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("hasPreviousTopic(DiscussionTopic" + topic + ")"));
        }
        if (this.usingHelper) {
            return this.helper.hasPreviousTopic(topic);
        }
        DiscussionTopic prev = null;
        DiscussionForum forum = this.getForumById(topic.getBaseForum().getId());
        if (forum != null && forum.getTopics() != null) {
            for (DiscussionTopic t : forum.getTopics()) {
                if (t == null || !this.getTopicAccess(t)) continue;
                if (t.getId().equals(topic.getId())) {
                    return prev != null;
                }
                prev = t;
            }
        }
        return false;
    }

    public DiscussionTopic getNextTopic(DiscussionTopic topic) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getNextTopic(DiscussionTopic" + topic + ")"));
        }
        if (this.usingHelper) {
            if (this.hasNextTopic(topic)) {
                return this.helper.getNextTopic(topic);
            }
            return null;
        }
        boolean next = false;
        DiscussionForum forum = this.getForumById(topic.getBaseForum().getId());
        if (forum != null && forum.getTopics() != null) {
            Iterator iter = forum.getTopics().iterator();
            while (iter.hasNext()) {
                DiscussionTopic t = (DiscussionTopic)iter.next();
                if (next && this.getTopicAccess(t)) {
                    if (t == null) {
                        while ((t = (DiscussionTopic)iter.next()) == null) {
                        }
                    }
                    return t;
                }
                if (t == null || !this.getTopicAccess(t) || !t.getId().equals(topic.getId())) continue;
                next = true;
            }
        }
        return null;
    }

    public DiscussionTopic getPreviousTopic(DiscussionTopic topic) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getPreviousTopic(DiscussionTopic" + topic + ")"));
        }
        if (this.usingHelper) {
            if (this.hasPreviousTopic(topic)) {
                return this.helper.getPreviousTopic(topic);
            }
            return null;
        }
        DiscussionTopic prev = null;
        DiscussionForum forum = this.getForumById(topic.getBaseForum().getId());
        if (forum != null && forum.getTopics() != null) {
            for (DiscussionTopic t : forum.getTopics()) {
                if (t == null || !this.getTopicAccess(t)) continue;
                if (t.getId().equals(topic.getId())) {
                    return prev;
                }
                if (t == null || !this.getTopicAccess(t)) continue;
                prev = t;
            }
        }
        return null;
    }

    public boolean isInstructor() {
        LOG.debug((Object)"isInstructor()");
        return this.isInstructor(this.userDirectoryService.getCurrentUser());
    }

    public boolean isInstructor(String userId) {
        LOG.debug((Object)"isInstructor()");
        try {
            return this.isInstructor(this.userDirectoryService.getUser(userId));
        }
        catch (UserNotDefinedException e) {
            LOG.error((Object)("DiscussionForumManagerImpl: isInstructor(String userId, String siteId): " + e.getMessage()));
            return false;
        }
    }

    public boolean isInstructor(String userId, String siteId) {
        LOG.debug((Object)("isInstructor(String " + userId + ", " + siteId + ")"));
        try {
            return this.isInstructor(this.userDirectoryService.getUser(userId), siteId);
        }
        catch (UserNotDefinedException e) {
            LOG.debug((Object)("DiscussionForumManagerImpl: isInstructor(String userId, String siteId): " + e.getMessage()));
            return false;
        }
    }

    private boolean isInstructor(User user) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isInstructor(User " + user + ")"));
        }
        if (user != null) {
            return this.isInstructor(user, this.getContextSiteId());
        }
        return false;
    }

    public boolean isSectionTA() {
        LOG.debug((Object)"isSectionTA()");
        return this.isSectionTA(this.userDirectoryService.getCurrentUser());
    }

    private boolean isInstructor(User user, String siteId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isInstructor(User " + user + ", " + siteId + ")"));
        }
        if (user != null) {
            return this.securityService.unlock(user, "site.upd", siteId);
        }
        return false;
    }

    private boolean isSectionTA(User user) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isSectionTA(User " + user + ")"));
        }
        if (user != null) {
            return this.securityService.unlock(user, "section.role.ta", this.getContextSiteId());
        }
        return false;
    }

    private String getContextSiteId() {
        LOG.debug((Object)"getContextSiteId()");
        return "/site/" + this.getCurrentContext();
    }

    private String getCurrentContext() {
        return ToolManager.getCurrentPlacement().getContext();
    }

    private String getCurrentUser() {
        return this.sessionManager.getCurrentSessionUserId();
    }

    public void setForumManager(MessageForumsForumManager forumManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setForumManager(MessageForumsForumManager" + forumManager + ")"));
        }
        this.forumManager = forumManager;
    }

    public DiscussionForum createForum() {
        LOG.debug((Object)"createForum()");
        return this.forumManager.createDiscussionForum();
    }

    public void deleteForum(DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setForumManager(DiscussionForum" + forum + ")"));
        }
        this.forumManager.deleteDiscussionForum(forum);
    }

    public DiscussionTopic createTopic(DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createTopic(DiscussionForum" + forum + ")"));
        }
        if (forum == null) {
            LOG.debug((Object)"Attempt to create topic with out forum");
            return null;
        }
        return this.forumManager.createDiscussionForumTopic(forum);
    }

    public void saveForum(DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveForum(DiscussionForum" + forum + ")"));
        }
        this.saveForum(forum, false, this.getCurrentContext(), true, this.getCurrentUser());
    }

    public void saveForum(String contextId, DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"saveForum(String contextId, DiscussionForum forum)");
        }
        if (contextId == null || forum == null) {
            throw new IllegalArgumentException("Null contextId or forum passed to saveForum. contextId:" + contextId);
        }
        this.saveForum(forum, forum.getDraft(), contextId, true, this.getCurrentUser());
    }

    public void saveForumAsDraft(DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveForumAsDraft(DiscussionForum" + forum + ")"));
        }
        this.saveForum(forum, true, this.getCurrentContext(), true, this.getCurrentUser());
    }

    public void saveForum(DiscussionForum forum, boolean draft, String contextId, boolean logEvent, String currentUser) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveForum(DiscussionForum" + forum + "boolean " + draft + ")"));
        }
        boolean saveArea = forum.getId() == null;
        forum.setDraft(Boolean.valueOf(draft));
        forum.setAvailability(Boolean.valueOf(ForumScheduleNotificationCover.makeAvailableHelper((boolean)forum.getAvailabilityRestricted(), (Date)forum.getOpenDate(), (Date)forum.getCloseDate())));
        this.forumManager.saveDiscussionForum(forum, draft, logEvent, currentUser);
        ForumScheduleNotificationCover.scheduleAvailability((DiscussionForum)forum);
        ThreadLocalManager.set((String)"message_center_permission_set", (Object)false);
        if (saveArea) {
            String dfType = this.typeManager.getDiscussionForumType();
            Area area = this.areaManager.getAreaByContextIdAndTypeId(contextId, dfType);
            forum.setArea(area);
            forum.setSortIndex(Integer.valueOf(0));
            area.addDiscussionForum((BaseForum)forum);
            this.areaManager.saveArea(area, currentUser);
        }
    }

    public void saveTopic(DiscussionTopic topic) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveTopic(DiscussionTopic" + topic + ")"));
        }
        this.saveTopic(topic, false);
    }

    public void saveTopicAsDraft(DiscussionTopic topic) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveTopicAsDraft(DiscussionTopic" + topic + ")"));
        }
        this.saveTopic(topic, true);
    }

    private void saveTopic(DiscussionTopic topic, boolean draft) {
        this.saveTopic(topic, draft, true);
    }

    public void saveTopic(DiscussionTopic topic, boolean draft, boolean logEvent) {
        this.saveTopic(topic, draft, logEvent, this.getCurrentUser());
    }

    public void saveTopic(DiscussionTopic topic, boolean draft, boolean logEvent, String currentUser) {
        Topic topicTmp;
        LOG.debug((Object)("saveTopic(DiscussionTopic " + topic + ", boolean " + draft + ")"));
        boolean saveForum = topic.getId() == null;
        topic.setAvailability(Boolean.valueOf(ForumScheduleNotificationCover.makeAvailableHelper((boolean)topic.getAvailabilityRestricted(), (Date)topic.getOpenDate(), (Date)topic.getCloseDate())));
        topic.setDraft(Boolean.valueOf(draft));
        this.forumManager.saveDiscussionForumTopic(topic, false, currentUser, logEvent);
        Long topicId = topic.getId();
        if (topicId == null && (topicTmp = this.forumManager.getTopicByUuid(topic.getUuid())) != null) {
            topicId = topicTmp.getId();
        }
        if (topicId != null) {
            ForumScheduleNotificationCover.scheduleAvailability((DiscussionTopic)topic);
        }
        if (saveForum) {
            DiscussionForum forum = (DiscussionForum)topic.getBaseForum();
            forum.addTopic((Topic)topic);
            this.forumManager.saveDiscussionForum(forum, forum.getDraft().booleanValue(), logEvent, currentUser);
        }
        if (logEvent) {
            if (topic.getId() == null) {
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"forums.newtopic", (String)this.getEventMessage(topic), (boolean)false));
            } else {
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"forums.revisetopic", (String)this.getEventMessage(topic), (boolean)false));
            }
        }
    }

    public void deleteTopic(DiscussionTopic topic) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deleteTopic(DiscussionTopic " + topic + ")"));
        }
        this.forumManager.deleteDiscussionForumTopic(topic);
    }

    public List getDefaultControlPermissions() {
        LOG.debug((Object)"getDefaultControlPermissions()");
        ArrayList<AreaControlPermission> defaultControlPermissions = new ArrayList<AreaControlPermission>();
        Iterator roles = this.getRoles();
        while (roles.hasNext()) {
            String roleId = (String)roles.next();
            AreaControlPermission controlPermission = this.permissionManager.getDefaultAreaControlPermissionForRole(roleId, this.typeManager.getDiscussionForumType());
            defaultControlPermissions.add(controlPermission);
        }
        return defaultControlPermissions;
    }

    public List getAreaControlPermissions() {
        LOG.debug((Object)"getAreaControlPermissions()");
        ArrayList<AreaControlPermission> areaControlPermissions = new ArrayList<AreaControlPermission>();
        Iterator roles = this.getRoles();
        while (roles.hasNext()) {
            String roleId = (String)roles.next();
            AreaControlPermission controlPermission = this.permissionManager.getAreaControlPermissionForRole(roleId, this.typeManager.getDiscussionForumType());
            if (controlPermission == null) {
                controlPermission = this.permissionManager.createAreaControlPermissionForRole(roleId, this.typeManager.getDiscussionForumType());
            }
            areaControlPermissions.add(controlPermission);
        }
        return areaControlPermissions;
    }

    public List getAreaMessagePermissions() {
        LOG.debug((Object)"getAreaMessagePermissions()");
        ArrayList<MessagePermissions> areaMessagePermissions = new ArrayList<MessagePermissions>();
        Iterator roles = this.getRoles();
        while (roles.hasNext()) {
            String roleId = (String)roles.next();
            MessagePermissions messagePermission = this.permissionManager.getAreaMessagePermissionForRole(roleId, this.typeManager.getDiscussionForumType());
            if (messagePermission == null) {
                messagePermission = this.permissionManager.createAreaMessagePermissionForRole(roleId, this.typeManager.getDiscussionForumType());
            }
            areaMessagePermissions.add(messagePermission);
        }
        return areaMessagePermissions;
    }

    public List getDefaultMessagePermissions() {
        LOG.debug((Object)"getDefaultMessagePermissions()");
        ArrayList<MessagePermissions> defaultMessagePermissions = new ArrayList<MessagePermissions>();
        Iterator roles = this.getRoles();
        while (roles.hasNext()) {
            String roleId = (String)roles.next();
            MessagePermissions messagePermission = this.permissionManager.getDefaultAreaMessagePermissionForRole(roleId, this.typeManager.getDiscussionForumType());
            defaultMessagePermissions.add(messagePermission);
        }
        return defaultMessagePermissions;
    }

    public void saveAreaMessagePermissions(List messagePermissions) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveDefaultMessagePermissions(List " + messagePermissions + ")"));
        }
        if (messagePermissions != null && messagePermissions.size() > 0) {
            for (MessagePermissions msgPermission : messagePermissions) {
                this.permissionManager.saveAreaMessagePermissionForRole(this.getDiscussionForumArea(), msgPermission, this.typeManager.getDiscussionForumType());
            }
        }
    }

    public List getForumControlPermissions(DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getForumControlPermissions(DiscussionForum " + forum + ")"));
        }
        ArrayList<ForumControlPermission> forumControlPermissions = new ArrayList<ForumControlPermission>();
        Iterator roles = this.getRoles();
        while (roles.hasNext()) {
            String roleId = (String)roles.next();
            ForumControlPermission controlPermission = this.permissionManager.getForumControlPermissionForRole((BaseForum)forum, roleId, this.typeManager.getDiscussionForumType());
            if (controlPermission == null) {
                controlPermission = this.permissionManager.createForumControlPermissionForRole(roleId, this.typeManager.getDiscussionForumType());
            }
            forumControlPermissions.add(controlPermission);
        }
        return forumControlPermissions;
    }

    public List getForumMessagePermissions(DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getForumMessagePermissions(DiscussionForum " + forum + ")"));
        }
        ArrayList<MessagePermissions> forumMessagePermissions = new ArrayList<MessagePermissions>();
        Iterator roles = this.getRoles();
        while (roles.hasNext()) {
            String roleId = (String)roles.next();
            MessagePermissions messagePermission = this.permissionManager.getForumMessagePermissionForRole((BaseForum)forum, roleId, this.typeManager.getDiscussionForumType());
            if (messagePermission == null) {
                messagePermission = this.permissionManager.createForumMessagePermissionForRole(roleId, this.typeManager.getDiscussionForumType());
            }
            forumMessagePermissions.add(messagePermission);
        }
        return forumMessagePermissions;
    }

    public List getTopicControlPermissions(DiscussionTopic topic) {
        LOG.debug((Object)("getTopicControlPermissions(DiscussionTopic " + topic + ")"));
        ArrayList<TopicControlPermission> topicControlPermissions = new ArrayList<TopicControlPermission>();
        Iterator roles = this.getRoles();
        while (roles.hasNext()) {
            String roleId = (String)roles.next();
            TopicControlPermission controlPermission = this.permissionManager.getTopicControlPermissionForRole((Topic)topic, roleId, this.typeManager.getDiscussionForumType());
            if (controlPermission == null) {
                controlPermission = this.permissionManager.createTopicControlPermissionForRole(topic.getBaseForum(), roleId, this.typeManager.getDiscussionForumType());
            }
            topicControlPermissions.add(controlPermission);
        }
        return topicControlPermissions;
    }

    public List getTopicMessagePermissions(DiscussionTopic topic) {
        LOG.debug((Object)("getTopicMessagePermissions(DiscussionTopic " + topic + ")"));
        ArrayList<MessagePermissions> topicMessagePermissions = new ArrayList<MessagePermissions>();
        Iterator roles = this.getRoles();
        while (roles.hasNext()) {
            String roleId = (String)roles.next();
            MessagePermissions messagePermission = this.permissionManager.getTopicMessagePermissionForRole((Topic)topic, roleId, this.typeManager.getDiscussionForumType());
            if (messagePermission == null) {
                messagePermission = this.permissionManager.createTopicMessagePermissionForRole(topic.getBaseForum(), roleId, this.typeManager.getDiscussionForumType());
            }
            topicMessagePermissions.add(messagePermission);
        }
        return topicMessagePermissions;
    }

    public void saveAreaControlPermissions(List controlpermissions) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveAreaControlPermissions(List" + controlpermissions + ")"));
        }
        if (controlpermissions != null && controlpermissions.size() > 0) {
            for (AreaControlPermission controlPermission : controlpermissions) {
                this.permissionManager.saveAreaControlPermissionForRole(this.getDiscussionForumArea(), controlPermission, this.typeManager.getDiscussionForumType());
            }
        }
    }

    public void saveForumControlPermissions(DiscussionForum forum, List controlPermissions) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveForumControlPermissions(List " + controlPermissions + ")"));
        }
        if (forum != null && controlPermissions != null && controlPermissions.size() > 0) {
            for (ForumControlPermission controlPermission : controlPermissions) {
                this.permissionManager.saveForumControlPermissionForRole((BaseForum)forum, controlPermission);
            }
        }
    }

    public void saveForumMessagePermissions(DiscussionForum forum, List messagePermissions) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveForumMessagePermissions(List " + messagePermissions + ")"));
        }
        if (forum != null && messagePermissions != null && messagePermissions.size() > 0) {
            for (MessagePermissions messagePermission : messagePermissions) {
                this.permissionManager.saveForumMessagePermissionForRole((BaseForum)forum, messagePermission);
            }
        }
    }

    public void saveTopicControlPermissions(DiscussionTopic topic, List controlPermissions) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveTopicControlPermissions(List " + controlPermissions + ")"));
        }
        if (topic != null && controlPermissions != null && controlPermissions.size() > 0) {
            for (TopicControlPermission controlPermission : controlPermissions) {
                this.permissionManager.saveTopicControlPermissionForRole((Topic)topic, controlPermission);
            }
        }
    }

    public void saveTopicMessagePermissions(DiscussionTopic topic, List messagePermissions) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveTopicMessagePermissions(List " + messagePermissions + ")"));
        }
        if (topic != null && messagePermissions != null && messagePermissions.size() > 0) {
            for (MessagePermissions messagePermission : messagePermissions) {
                this.permissionManager.saveTopicMessagePermissionForRole((Topic)topic, messagePermission);
            }
        }
    }

    private Iterator getRoles() {
        LOG.debug((Object)"getRoles()");
        ArrayList<String> roleList = new ArrayList<String>();
        AuthzGroup realm = null;
        try {
            realm = AuthzGroupService.getAuthzGroup((String)this.getContextSiteId());
            Set roles = realm.getRoles();
            if (roles != null && roles.size() > 0) {
                for (Role role : roles) {
                    if (role == null) continue;
                    roleList.add(role.getId());
                }
            }
        }
        catch (GroupNotDefinedException e) {
            e.printStackTrace();
        }
        Collections.sort(roleList);
        return roleList.iterator();
    }

    public boolean getAnonRole() {
        LOG.debug((Object)"getAnonRoles()");
        AuthzGroup realm = null;
        try {
            realm = AuthzGroupService.getAuthzGroup((String)this.getContextSiteId());
            Role anon = realm.getRole(".anon");
            if (this.sessionManager.getCurrentSessionUserId() == null && anon != null && anon.getAllowedFunctions().contains("site.visit")) {
                return true;
            }
        }
        catch (GroupNotDefinedException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public void markMessageAs(Message message, boolean readStatus) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("markMessageAsRead(Message" + message + ")"));
        }
        try {
            this.messageManager.markMessageReadForUser(message.getTopic().getId(), message.getId(), readStatus);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void markMessageReadStatusForUser(Message message, boolean readStatus, String userId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("markMessageReadStatusForUser(Message" + message + " readStatus:" + readStatus + " userId: " + userId + ")"));
        }
        try {
            this.messageManager.markMessageReadForUser(message.getTopic().getId(), message.getId(), readStatus, userId);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isForumOwner(DiscussionForum forum) {
        return this.isForumOwner(forum, this.userDirectoryService.getCurrentUser().getId());
    }

    public boolean isForumOwner(DiscussionForum forum, String userId) {
        return this.isForumOwner(forum, userId, this.getContextSiteId());
    }

    public boolean isForumOwner(DiscussionForum forum, String userId, String siteId) {
        return this.isForumOwner(forum.getId(), forum.getCreatedBy(), userId, siteId);
    }

    public boolean isForumOwner(Long forumId, String forumCreatedBy, String userId, String siteId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isForumOwner(DiscussionForum " + forumId + ")"));
        }
        return forumCreatedBy.equals(userId) && !this.isRoleSwapView(siteId);
    }

    private boolean isRoleSwapView(String siteId) {
        return this.securityService.getUserEffectiveRole(siteId) != null;
    }

    public boolean isTopicOwner(DiscussionTopic topic) {
        return this.isTopicOwner(topic, this.userDirectoryService.getCurrentUser().getId());
    }

    public boolean isTopicOwner(DiscussionTopic topic, String userId) {
        return this.isTopicOwner(topic, userId, this.getContextSiteId());
    }

    public boolean isTopicOwner(DiscussionTopic topic, String userId, String siteId) {
        return this.isTopicOwner(topic.getId(), topic.getCreatedBy(), userId, siteId);
    }

    public boolean isTopicOwner(Long topicId, String topicCreatedBy, String userId, String siteId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isTopicOwner(DiscussionTopic " + topicId + ")"));
        }
        return topicCreatedBy.equals(userId) && !this.isRoleSwapView(siteId);
    }

    private boolean getTopicAccess(DiscussionTopic t) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getTopicAccess(DiscussionTopic" + t + ")"));
        }
        boolean nonePermission = false;
        User user = this.userDirectoryService.getCurrentUser();
        String role = AuthzGroupService.getUserRole((String)user.getId(), (String)this.getContextSiteId());
        Set membershipItemSet = t.getMembershipItemSet();
        for (DBMembershipItem membershipItem : membershipItemSet) {
            String roleName = membershipItem.getName();
            String permissionName = membershipItem.getPermissionLevelName();
            if (!roleName.equals(role) || !permissionName.equals("None")) continue;
            nonePermission = true;
        }
        return t.getDraft().equals(Boolean.FALSE) && !nonePermission || this.isInstructor() || this.securityService.isSuperUser() || this.isTopicOwner(t);
    }

    private List decodeActorPermissionTypeList(List selectedList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("decodeActorPermissionTypeList(List" + selectedList + ")"));
        }
        ArrayList<MessageForumsUserImpl> newSelectedMemberList = new ArrayList<MessageForumsUserImpl>();
        for (String selectedItem : selectedList) {
            MessageForumsUserImpl user = new MessageForumsUserImpl();
            MembershipItem item = (MembershipItem)this.getAllCourseMembers().get(selectedItem);
            if (item == null) {
                LOG.warn((Object)("decodeActorPermissionTypeList() could not resolve uuid: " + selectedItem));
                continue;
            }
            if (MembershipItem.TYPE_ALL_PARTICIPANTS.equals(item.getType())) {
                user.setTypeUuid(this.typeManager.getAllParticipantType());
                user.setUserId(this.typeManager.getAllParticipantType());
                newSelectedMemberList.add(user);
                continue;
            }
            if (MembershipItem.TYPE_NOT_SPECIFIED.equals(item.getType())) {
                user.setTypeUuid(this.typeManager.getNotSpecifiedType());
                user.setUserId(this.typeManager.getNotSpecifiedType());
                newSelectedMemberList = null;
                newSelectedMemberList = new ArrayList();
                newSelectedMemberList.add(user);
                break;
            }
            if (MembershipItem.TYPE_ROLE.equals(item.getType())) {
                user.setTypeUuid(this.typeManager.getRoleType());
                user.setUserId(item.getRole().getId());
                newSelectedMemberList.add(user);
                continue;
            }
            if (MembershipItem.TYPE_GROUP.equals(item.getType())) {
                user.setTypeUuid(this.typeManager.getGroupType());
                user.setUserId(item.getGroup().getId());
                newSelectedMemberList.add(user);
                continue;
            }
            if (MembershipItem.TYPE_USER.equals(item.getType())) {
                user.setTypeUuid(this.typeManager.getUserType());
                user.setUserId(item.getUser().getId());
                newSelectedMemberList.add(user);
                continue;
            }
            LOG.warn((Object)("getRecipients() could not resolve membership type: " + item.getType()));
        }
        return newSelectedMemberList;
    }

    public List decodeAccessorsList(ArrayList accessorList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("decodeAccessorsList(List" + accessorList + ")"));
        }
        if (accessorList == null || accessorList.size() < 1) {
            return this.forumManager.createDefaultActorPermissions().getAccessors();
        }
        return this.decodeActorPermissionTypeList(accessorList);
    }

    public List decodeContributorsList(ArrayList contributorList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("decodeContributorsList(List" + contributorList + ")"));
        }
        if (contributorList == null || contributorList.size() < 1) {
            return this.forumManager.createDefaultActorPermissions().getContributors();
        }
        return this.decodeActorPermissionTypeList(contributorList);
    }

    public List getContributorsList(DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" getContributorsList(DiscussionForum" + forum + ")"));
        }
        List contributorList = null;
        if (forum == null) {
            return null;
        }
        if (forum.getActorPermissions() == null || forum.getActorPermissions().getContributors() == null) {
            forum.setActorPermissions(this.forumManager.createDefaultActorPermissions());
            contributorList = this.forumManager.createDefaultActorPermissions().getContributors();
        } else {
            contributorList = forum.getActorPermissions().getContributors();
        }
        Iterator iterator = contributorList.iterator();
        return this.getContributorAccessorList(iterator);
    }

    public List getAccessorsList(DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getAccessorsList(DiscussionForum" + forum + ")"));
        }
        List accessorsList = null;
        if (forum == null) {
            return null;
        }
        if (forum.getActorPermissions() == null || forum.getActorPermissions().getAccessors() == null) {
            forum.setActorPermissions(this.forumManager.createDefaultActorPermissions());
            accessorsList = this.forumManager.createDefaultActorPermissions().getAccessors();
        } else {
            accessorsList = forum.getActorPermissions().getAccessors();
        }
        Iterator iterator = accessorsList.iterator();
        return this.getContributorAccessorList(iterator);
    }

    private List getContributorAccessorList(Iterator iterator) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getContributorAccessorList(Iterator" + iterator + ")"));
        }
        ArrayList<String> modifiedContributorList = new ArrayList<String>();
        while (iterator.hasNext()) {
            MembershipItem member;
            String selectedId = null;
            MessageForumsUser user = (MessageForumsUser)iterator.next();
            List totalmembers = this.membershipManager.convertMemberMapToList(this.courseMemberMap);
            Iterator iter = totalmembers.iterator();
            if (user.getTypeUuid().equals(this.typeManager.getAllParticipantType())) {
                while (iter.hasNext()) {
                    member = (MembershipItem)iter.next();
                    if (!member.getType().equals(MembershipItem.TYPE_ALL_PARTICIPANTS)) continue;
                    selectedId = member.getId();
                }
            }
            if (user.getTypeUuid().equals(this.typeManager.getNotSpecifiedType())) {
                while (iter.hasNext()) {
                    member = (MembershipItem)iter.next();
                    if (!member.getType().equals(MembershipItem.TYPE_NOT_SPECIFIED)) continue;
                    selectedId = member.getId();
                }
            }
            if (user.getTypeUuid().equals(this.typeManager.getGroupType())) {
                while (iter.hasNext()) {
                    member = (MembershipItem)iter.next();
                    if (!member.getType().equals(MembershipItem.TYPE_GROUP) || !user.getUserId().equals(member.getGroup().getId())) continue;
                    selectedId = member.getId();
                }
            }
            if (user.getTypeUuid().equals(this.typeManager.getRoleType())) {
                while (iter.hasNext()) {
                    member = (MembershipItem)iter.next();
                    if (!member.getType().equals(MembershipItem.TYPE_ROLE) || !user.getUserId().equals(member.getRole().getId())) continue;
                    selectedId = member.getId();
                }
            }
            if (user.getTypeUuid().equals(this.typeManager.getUserType())) {
                while (iter.hasNext()) {
                    member = (MembershipItem)iter.next();
                    if (!member.getType().equals(MembershipItem.TYPE_USER) || !user.getUserId().equals(member.getUser().getId())) continue;
                    selectedId = member.getId();
                }
            }
            modifiedContributorList.add(selectedId);
        }
        return modifiedContributorList;
    }

    public Map getAllCourseMembers() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getAllCourseMembers()");
        }
        if (this.courseMemberMap == null) {
            this.courseMemberMap = this.membershipManager.getAllCourseMembers(true, false, true, null);
        }
        return this.courseMemberMap;
    }

    public void setCourseMemberMapToNull() {
        this.courseMemberMap = null;
    }

    public List getContributorsList(DiscussionTopic topic, DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getContributorsList(DiscussionTopic " + topic + ", DiscussionForum " + forum + ")"));
        }
        List contributorList = null;
        if (topic == null) {
            return null;
        }
        if (topic.getActorPermissions() == null || topic.getActorPermissions().getContributors() == null) {
            topic.setActorPermissions(this.getDeepCopyOfParentActorPermissions(forum.getActorPermissions()));
            contributorList = topic.getActorPermissions().getContributors();
        } else {
            contributorList = topic.getActorPermissions().getContributors();
        }
        Iterator iterator = contributorList.iterator();
        return this.getContributorAccessorList(iterator);
    }

    private ActorPermissions getDeepCopyOfParentActorPermissions(ActorPermissions actorPermissions) {
        ActorPermissionsImpl newAP = new ActorPermissionsImpl();
        List parentAccessors = actorPermissions.getAccessors();
        List parentContributors = actorPermissions.getContributors();
        ArrayList<MessageForumsUserImpl> newAccessors = new ArrayList<MessageForumsUserImpl>();
        ArrayList<MessageForumsUserImpl> newContributor = new ArrayList<MessageForumsUserImpl>();
        for (MessageForumsUser accessParent : parentAccessors) {
            MessageForumsUserImpl newaccessor = new MessageForumsUserImpl();
            newaccessor.setTypeUuid(accessParent.getTypeUuid());
            newaccessor.setUserId(accessParent.getUserId());
            newaccessor.setUuid(accessParent.getUuid());
            newAccessors.add(newaccessor);
        }
        for (MessageForumsUser contribParent : parentContributors) {
            MessageForumsUserImpl newcontributor = new MessageForumsUserImpl();
            newcontributor.setTypeUuid(contribParent.getTypeUuid());
            newcontributor.setUserId(contribParent.getUserId());
            newcontributor.setUuid(contribParent.getUuid());
            newContributor.add(newcontributor);
        }
        newAP.setAccessors(newAccessors);
        newAP.setContributors(newContributor);
        return newAP;
    }

    public List getAccessorsList(DiscussionTopic topic, DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getAccessorsList(DiscussionTopic " + topic + ", DiscussionForum " + forum + ")"));
        }
        List accessorsList = null;
        if (topic == null) {
            return null;
        }
        if (topic.getActorPermissions() == null || topic.getActorPermissions().getAccessors() == null) {
            topic.setActorPermissions(this.getDeepCopyOfParentActorPermissions(forum.getActorPermissions()));
            accessorsList = topic.getActorPermissions().getAccessors();
        } else {
            accessorsList = topic.getActorPermissions().getAccessors();
        }
        Iterator iterator = accessorsList.iterator();
        return this.getContributorAccessorList(iterator);
    }

    public DBMembershipItem getAreaDBMember(Set originalSet, String name, Integer type) {
        DBMembershipItem newItem = this.getDBMember(originalSet, name, type);
        return newItem;
    }

    public DBMembershipItem getDBMember(Set originalSet, String name, Integer type) {
        return this.getDBMember(originalSet, name, type, this.getContextSiteId());
    }

    public DBMembershipItem getDBMember(Set originalSet, String name, Integer type, String contextSiteId) {
        DBMembershipItemImpl membershipItem = null;
        if (originalSet != null) {
            for (DBMembershipItem membershipItemIter : originalSet) {
                if (!membershipItemIter.getType().equals(type) || !membershipItemIter.getName().equals(name)) continue;
                membershipItem = membershipItemIter;
                break;
            }
        }
        if (membershipItem == null || membershipItem.getPermissionLevel() == null) {
            PermissionLevel level = null;
            if (type.equals(DBMembershipItem.TYPE_ROLE) || type.equals(DBMembershipItem.TYPE_GROUP)) {
                String levelName = null;
                levelName = membershipItem != null ? membershipItem.getPermissionLevelName() : ServerConfigurationService.getString((String)(MC_DEFAULT + name));
                if (levelName != null && levelName.trim().length() > 0) {
                    level = this.permissionLevelManager.getPermissionLevelByName(levelName);
                } else if (name == null || ".anon".equals(name)) {
                    level = this.permissionLevelManager.getDefaultNonePermissionLevel();
                } else {
                    Vector<String> siteIds = new Vector<String>();
                    siteIds.add(contextSiteId);
                    level = type.equals(DBMembershipItem.TYPE_GROUP) ? this.permissionLevelManager.getDefaultNonePermissionLevel() : (AuthzGroupService.getAllowedFunctions((String)name, siteIds).contains("site.upd") ? this.permissionLevelManager.getDefaultOwnerPermissionLevel() : this.permissionLevelManager.getDefaultContributorPermissionLevel());
                }
            }
            PermissionLevel noneLevel = this.permissionLevelManager.getDefaultNonePermissionLevel();
            membershipItem = new DBMembershipItemImpl();
            membershipItem.setName(name);
            membershipItem.setPermissionLevelName(level == null ? noneLevel.getName() : level.getName());
            membershipItem.setType(type);
            membershipItem.setPermissionLevel(level == null ? noneLevel : level);
        }
        return membershipItem;
    }

    public Attachment createDFAttachment(String attachId, String name) {
        try {
            Attachment attach = this.messageManager.createAttachment();
            attach.setAttachmentId(attachId);
            attach.setAttachmentName(name);
            ContentResource cr = this.contentHostingService.getResource(attachId);
            attach.setAttachmentSize(Long.valueOf(cr.getContentLength()).toString());
            attach.setCreatedBy(cr.getProperties().getProperty(cr.getProperties().getNamePropCreator()));
            attach.setModifiedBy(cr.getProperties().getProperty(cr.getProperties().getNamePropModifiedBy()));
            attach.setAttachmentType(cr.getContentType());
            attach.setAttachmentUrl("/url");
            return attach;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List getDiscussionForumsWithTopics() {
        LOG.debug((Object)"getDiscussionForumsWithTopics()");
        return this.forumManager.getForumByTypeAndContextWithTopicsAllAttachments(this.typeManager.getDiscussionForumType());
    }

    public List getDiscussionForumsWithTopics(String contextId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getDiscussionForumsWithTopics(String contextId)");
        }
        if (contextId == null) {
            throw new IllegalArgumentException("Null contextId passed to getDiscussionForumsWithTopics");
        }
        String dfType = this.typeManager.getDiscussionForumType();
        return this.forumManager.getForumByTypeAndContextWithTopicsAllAttachments(dfType, contextId);
    }

    public Map<Long, Boolean> getReadStatusForMessagesWithId(List<Long> msgIds, String userId) {
        LOG.debug((Object)"getDiscussionForumsWithTopics()");
        HashMap<Long, Boolean> msgIdStatusMap = new HashMap<Long, Boolean>();
        if (msgIds == null || msgIds.size() == 0) {
            LOG.debug((Object)"empty map returns b/c no msgIds passed to getReadStatusForMessagesWithId");
            return msgIdStatusMap;
        }
        if (userId == null) {
            LOG.debug((Object)"empty user assume that all messages are read");
            for (int i = 0; i < msgIds.size(); ++i) {
                msgIdStatusMap.put(msgIds.get(i), true);
            }
            return msgIdStatusMap;
        }
        if (msgIds.size() < 1000) {
            return this.messageManager.getReadStatusForMessagesWithId(msgIds, userId);
        }
        int begIndex = 0;
        int endIndex = 0;
        while (begIndex < msgIds.size()) {
            endIndex = begIndex + 1000;
            if (endIndex > msgIds.size()) {
                endIndex = msgIds.size();
            }
            ArrayList<Long> tempMsgIdList = new ArrayList<Long>();
            tempMsgIdList.addAll(msgIds.subList(begIndex, endIndex));
            Map statusMap = this.messageManager.getReadStatusForMessagesWithId(tempMsgIdList, userId);
            msgIdStatusMap.putAll(statusMap);
            begIndex = endIndex;
        }
        return msgIdStatusMap;
    }

    public List getDiscussionForumsWithTopicsMembershipNoAttachments(String contextId) {
        LOG.debug((Object)"getDiscussionForumsWithTopicsMembershipNoAttachments()");
        return this.forumManager.getForumByTypeAndContextWithTopicsMembership(this.typeManager.getDiscussionForumType(), contextId);
    }

    public List getPendingMsgsInTopic(Long topicId) {
        return this.messageManager.getPendingMsgsInTopic(topicId);
    }

    public int getNumModTopicsWithModPermissionByPermissionLevel(List membershipList) {
        return this.forumManager.getNumModTopicCurrentUserHasModPermForWithPermissionLevel(membershipList);
    }

    public int getNumModTopicsWithModPermissionByPermissionLevelName(List membershipList) {
        return this.forumManager.getNumModTopicCurrentUserHasModPermForWithPermissionLevelName(membershipList);
    }

    private String getEventMessage(Object object) {
        String eventMessagePrefix = "";
        String toolId = ToolManager.getCurrentTool().getId();
        eventMessagePrefix = toolId.equals("sakai.messagecenter") ? "/messagesAndForums" : (toolId.equals("sakai.messages") ? "/messages" : "/forums");
        return eventMessagePrefix + this.getContextSiteId() + "/" + object.toString() + "/" + this.sessionManager.getCurrentSessionUserId();
    }

    public String getContextForTopicById(Long topicId) {
        return this.getTopicById(topicId).getOpenForum().getArea().getContextId();
    }

    public String getContextForForumById(Long forumId) {
        return this.getForumById(forumId).getArea().getContextId();
    }

    public String getContextForMessageById(Long messageId) {
        return this.getMessageById(messageId).getTopic().getOpenForum().getArea().getContextId();
    }

    public String ForumIdForMessage(Long messageId) {
        return this.getMessageById(messageId).getTopic().getOpenForum().getId().toString();
    }

    public Set<String> getUsersAllowedForTopic(Long topicId, boolean checkReadPermission, boolean checkModeratePermission) {
        Site currentSite;
        LOG.debug((Object)("getUsersAllowedForTopic(" + topicId + ", " + checkReadPermission + ", " + checkModeratePermission + ")"));
        if (topicId == null) {
            throw new IllegalArgumentException("Null topicId passed to getUsersAllowedToReadTopic");
        }
        HashSet<String> usersAllowed = new HashSet<String>();
        Set topicItems = new HashSet();
        DiscussionTopic topicWithMemberships = (DiscussionTopic)this.forumManager.getTopicByIdWithMemberships(topicId);
        if (topicWithMemberships != null && topicWithMemberships.getMembershipItemSet() != null) {
            topicItems = topicWithMemberships.getMembershipItemSet();
        }
        Set rolesInSite = null;
        HashSet groupsInSite = new HashSet();
        String siteId = ToolManager.getCurrentPlacement().getContext();
        try {
            currentSite = this.siteService.getSite(siteId);
            rolesInSite = currentSite.getRoles();
            Collection groups = currentSite.getGroups();
            if (groups != null) {
                groupsInSite = new HashSet(groups);
            }
        }
        catch (IdUnusedException iue) {
            LOG.warn((Object)("No site found with id: " + siteId + ". No users returned by getUsersAllowedToReadTopic"));
            return new HashSet<String>();
        }
        ArrayList<DBMembershipItem> revisedMembershipItemSet = new ArrayList<DBMembershipItem>();
        if (rolesInSite != null) {
            for (Role role : rolesInSite) {
                DBMembershipItem roleItem = this.getDBMember(topicItems, role.getId(), DBMembershipItem.TYPE_ROLE);
                if (roleItem == null) continue;
                revisedMembershipItemSet.add(roleItem);
            }
        }
        for (Group group : groupsInSite) {
            DBMembershipItem groupItem = this.getDBMember(topicItems, group.getTitle(), DBMembershipItem.TYPE_GROUP);
            if (groupItem == null) continue;
            revisedMembershipItemSet.add(groupItem);
        }
        for (DBMembershipItem membershipItem : revisedMembershipItemSet) {
            if (!(checkReadPermission && membershipItem.getPermissionLevel().getRead() != false && !checkModeratePermission || !checkReadPermission && checkModeratePermission && membershipItem.getPermissionLevel().getModeratePostings() != false) && (!checkReadPermission || !membershipItem.getPermissionLevel().getRead().booleanValue() || !checkModeratePermission || !membershipItem.getPermissionLevel().getModeratePostings().booleanValue())) continue;
            if (membershipItem.getType().equals(DBMembershipItem.TYPE_ROLE)) {
                LOG.debug((Object)("Adding users in role: " + membershipItem.getName() + " with read: " + membershipItem.getPermissionLevel().getRead()));
                Set usersInRole = currentSite.getUsersHasRole(membershipItem.getName());
                usersAllowed.addAll(usersInRole);
                continue;
            }
            if (!membershipItem.getType().equals(DBMembershipItem.TYPE_GROUP)) continue;
            String groupName = membershipItem.getName();
            for (Group group : groupsInSite) {
                Set groupMembers;
                if (!group.getTitle().equals(groupName) || (groupMembers = group.getMembers()) == null) continue;
                for (Member member : groupMembers) {
                    usersAllowed.add(member.getUserId());
                }
            }
        }
        return usersAllowed;
    }

    public List<Attachment> getTopicAttachments(Long topicId) {
        return this.forumManager.getTopicAttachments(topicId);
    }
}

