/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums.ui;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.sakaiproject.api.app.messageforums.Area;
import org.sakaiproject.api.app.messageforums.AreaManager;
import org.sakaiproject.api.app.messageforums.Attachment;
import org.sakaiproject.api.app.messageforums.Message;
import org.sakaiproject.api.app.messageforums.MessageForumsForumManager;
import org.sakaiproject.api.app.messageforums.MessageForumsMessageManager;
import org.sakaiproject.api.app.messageforums.MessageForumsTypeManager;
import org.sakaiproject.api.app.messageforums.PrivateForum;
import org.sakaiproject.api.app.messageforums.PrivateMessage;
import org.sakaiproject.api.app.messageforums.PrivateMessageRecipient;
import org.sakaiproject.api.app.messageforums.PrivateTopic;
import org.sakaiproject.api.app.messageforums.Topic;
import org.sakaiproject.api.app.messageforums.UniqueArrayList;
import org.sakaiproject.api.app.messageforums.cover.SynopticMsgcntrManagerCover;
import org.sakaiproject.api.app.messageforums.ui.PrivateMessageManager;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.component.app.messageforums.TestUtil;
import org.sakaiproject.component.app.messageforums.dao.hibernate.PrivateMessageImpl;
import org.sakaiproject.component.app.messageforums.dao.hibernate.PrivateMessageRecipientImpl;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.id.api.IdManager;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateOptimisticLockingFailureException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivateMessageManagerImpl
extends HibernateDaoSupport
implements PrivateMessageManager {
    private static final Log LOG = LogFactory.getLog(PrivateMessageManagerImpl.class);
    private static final String QUERY_AGGREGATE_COUNT = "findAggregatePvtMsgCntForUserInContext";
    private static final String QUERY_MESSAGES_BY_USER_TYPE_AND_CONTEXT = "findPrvtMsgsByUserTypeContext";
    private static final String QUERY_MESSAGES_BY_ID_WITH_RECIPIENTS = "findPrivateMessageByIdWithRecipients";
    private AreaManager areaManager;
    private MessageForumsMessageManager messageManager;
    private MessageForumsForumManager forumManager;
    private MessageForumsTypeManager typeManager;
    private IdManager idManager;
    private SessionManager sessionManager;
    private EmailService emailService;
    private ContentHostingService contentHostingService;
    private static final String MESSAGES_TITLE = "pvt_message_nav";
    private static final String PVT_RECEIVED = "pvt_received";
    private static final String PVT_SENT = "pvt_sent";
    private static final String PVT_DELETED = "pvt_deleted";
    private static final String PVT_DRAFTS = "pvt_drafts";
    private static final String EMAIL_FOOTER1 = "pvt_email_footer1";
    private static final String EMAIL_FOOTER2 = "pvt_email_footer2";
    private static final String EMAIL_FOOTER3 = "pvt_email_footer3";
    private static final String EMAIL_FOOTER4 = "pvt_email_footer4";
    public static final String PVTMSG_MODE_RECEIVED = "pvt_received";
    public static final String PVTMSG_MODE_SENT = "pvt_sent";
    public static final String PVTMSG_MODE_DELETE = "pvt_deleted";
    public static final String PVTMSG_MODE_DRAFT = "pvt_drafts";

    public void init() {
        LOG.info((Object)"init()");
    }

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public boolean getPrivateAreaEnabled() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getPrivateAreaEnabled()");
        }
        return this.areaManager.isPrivateAreaEnabled();
    }

    public void setPrivateAreaEnabled(boolean value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setPrivateAreaEnabled(value: " + value + ")"));
        }
    }

    public boolean isPrivateAreaEnabled() {
        return this.areaManager.isPrivateAreaEnabled();
    }

    public Area getPrivateMessageArea() {
        return this.areaManager.getPrivateArea();
    }

    public Area getPrivateMessageArea(String siteId) {
        return this.areaManager.getPrivateArea(siteId);
    }

    public void savePrivateMessageArea(Area area) {
        this.areaManager.saveArea(area);
    }

    public PrivateForum initializePrivateMessageArea(Area area, List aggregateList) {
        return this.initializePrivateMessageArea(area, aggregateList, this.getCurrentUser());
    }

    public PrivateForum initializePrivateMessageArea(Area area, List aggregateList, String userId) {
        return this.initializePrivateMessageArea(area, aggregateList, userId, this.getContextId());
    }

    public PrivateForum initializePrivateMessageArea(Area area, List aggregateList, String userId, String siteId) {
        aggregateList.clear();
        aggregateList.addAll(this.initializeMessageCounts(userId, siteId));
        this.getHibernateTemplate().lock((Object)area, LockMode.NONE);
        PrivateForum pf = this.forumManager.getPrivateForumByOwnerArea(userId, area);
        if (pf == null) {
            pf = this.forumManager.createPrivateForum(this.getResourceBundleString(MESSAGES_TITLE), userId);
            PrivateTopic receivedTopic = this.forumManager.createPrivateForumTopic("pvt_received", true, false, userId, pf.getId());
            PrivateTopic sentTopic = this.forumManager.createPrivateForumTopic("pvt_sent", true, false, userId, pf.getId());
            PrivateTopic deletedTopic = this.forumManager.createPrivateForumTopic("pvt_deleted", true, false, userId, pf.getId());
            PrivateTopic draftTopic = this.forumManager.createPrivateForumTopic("pvt_drafts", true, false, userId, pf.getId());
            this.forumManager.savePrivateForumTopic(receivedTopic, userId, siteId);
            this.forumManager.savePrivateForumTopic(sentTopic, userId, siteId);
            this.forumManager.savePrivateForumTopic(deletedTopic, userId, siteId);
            this.forumManager.savePrivateForumTopic(draftTopic);
            pf.addTopic((Topic)receivedTopic);
            pf.addTopic((Topic)sentTopic);
            pf.addTopic((Topic)deletedTopic);
            pf.addTopic((Topic)draftTopic);
            pf.setArea(area);
            PrivateForum oldForum = this.forumManager.getPrivateForumByOwnerAreaNull(userId);
            if (oldForum != null) {
                oldForum = this.initializationHelper(oldForum, userId);
                List pvtTopics = oldForum.getTopics();
                for (int i = 0; i < pvtTopics.size(); ++i) {
                    PrivateTopic currentTopic = (PrivateTopic)pvtTopics.get(i);
                    if (currentTopic == null || currentTopic.getTitle().equals("pvt_received") || currentTopic.getTitle().equals("pvt_sent") || currentTopic.getTitle().equals("pvt_deleted") || currentTopic.getTitle().equals("pvt_drafts") || !area.getContextId().equals(currentTopic.getContextId())) continue;
                    currentTopic.setPrivateForum(pf);
                    this.forumManager.savePrivateForumTopic(currentTopic, userId, siteId);
                    pf.addTopic((Topic)currentTopic);
                }
                if (oldForum.getAutoForward() != null) {
                    pf.setAutoForward(oldForum.getAutoForward());
                }
                if (oldForum.getAutoForwardEmail() != null) {
                    pf.setAutoForwardEmail(oldForum.getAutoForwardEmail());
                }
            }
            this.forumManager.savePrivateForum(pf, userId);
        } else {
            pf = this.forumManager.getPrivateForumByOwnerAreaWithAllTopics(userId, area);
        }
        return pf;
    }

    public PrivateForum initializationHelper(PrivateForum forum) {
        return this.initializationHelper(forum, this.getCurrentUser());
    }

    public PrivateForum initializationHelper(PrivateForum forum, String userId) {
        PrivateForum pf = this.forumManager.getPrivateForumByOwnerAreaNullWithAllTopics(userId);
        return pf;
    }

    public PrivateForum initializationHelper(PrivateForum forum, Area area) {
        return this.initializationHelper(forum, area, this.getCurrentUser());
    }

    public PrivateForum initializationHelper(PrivateForum forum, Area area, String userId) {
        PrivateForum pf = this.forumManager.getPrivateForumByOwnerAreaWithAllTopics(userId, area);
        return pf;
    }

    public void savePrivateMessage(Message message) {
        this.messageManager.saveMessage(message);
    }

    public void savePrivateMessage(Message message, boolean logEvent) {
        this.messageManager.saveMessage(message, logEvent);
    }

    public Message getMessageById(Long id) {
        return this.messageManager.getMessageById(id);
    }

    public Attachment createPvtMsgAttachment(String attachId, String name) {
        try {
            Attachment attach = this.messageManager.createAttachment();
            attach.setAttachmentId(attachId);
            attach.setAttachmentName(name);
            ContentResource cr = this.contentHostingService.getResource(attachId);
            attach.setAttachmentSize(Long.valueOf(cr.getContentLength()).toString());
            attach.setCreatedBy(cr.getProperties().getProperty(cr.getProperties().getNamePropCreator()));
            attach.setModifiedBy(cr.getProperties().getProperty(cr.getProperties().getNamePropModifiedBy()));
            attach.setAttachmentType(cr.getContentType());
            String tempString = cr.getUrl();
            String newString = "";
            char[] oneChar = new char[1];
            for (int i = 0; i < tempString.length(); ++i) {
                if (tempString.charAt(i) != ' ') {
                    oneChar[0] = tempString.charAt(i);
                    String concatString = new String(oneChar);
                    newString = newString.concat(concatString);
                    continue;
                }
                newString = newString.concat("%20");
            }
            attach.setAttachmentUrl("/url");
            return attach;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addAttachToPvtMsg(PrivateMessage pvtMsgData, Attachment pvtMsgAttach) {
        pvtMsgData.addAttachment(pvtMsgAttach);
    }

    public void removePvtMsgAttachment(Attachment o) {
        o.getMessage().removeAttachment(o);
    }

    public Attachment getPvtMsgAttachment(Long pvtMsgAttachId) {
        return this.messageManager.getAttachmentById(pvtMsgAttachId);
    }

    public int getTotalNoMessages(Topic topic) {
        return this.messageManager.findMessageCountByTopicId(topic.getId());
    }

    public int getUnreadNoMessages(Topic topic) {
        return this.messageManager.findUnreadMessageCountByTopicId(topic.getId());
    }

    public void saveAreaAndForumSettings(Area area, PrivateForum forum) {
        this.saveForumSettings(forum);
        if (this.isInstructor() || this.isEmailPermit()) {
            this.savePrivateMessageArea(area);
        }
    }

    public void saveForumSettings(PrivateForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveForumSettings(forum: " + forum + ")"));
        }
        if (forum == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        this.forumManager.savePrivateForum(forum);
    }

    public boolean isMutableTopicFolder(String parentTopicId) {
        return false;
    }

    public void createTopicFolderInForum(PrivateForum pf, String folderName) {
        String userId = this.getCurrentUser();
        PrivateTopic createdTopic = this.forumManager.createPrivateForumTopic(folderName, true, true, userId, pf.getId());
        createdTopic.setContextId(this.getContextId());
        createdTopic.setTypeUuid(this.typeManager.getUserDefinedPrivateTopicType());
        this.forumManager.savePrivateForumTopic(createdTopic);
        pf.addTopic((Topic)createdTopic);
        this.forumManager.savePrivateForum(pf);
    }

    public void createTopicFolderInTopic(PrivateForum pf, PrivateTopic parentTopic, String folderName) {
        String userId = this.getCurrentUser();
        PrivateTopic createdTopic = this.forumManager.createPrivateForumTopic(folderName, true, true, userId, pf.getId());
        createdTopic.setParentTopic(parentTopic);
        this.forumManager.savePrivateForumTopic(createdTopic);
        pf.addTopic((Topic)createdTopic);
        this.forumManager.savePrivateForum(pf);
    }

    public void renameTopicFolder(PrivateForum pf, String topicUuid, String newName) {
        String userId = this.getCurrentUser();
        List pvtTopics = pf.getTopics();
        for (PrivateTopic element : pvtTopics) {
            if (!element.getUuid().equals(topicUuid)) continue;
            element.setTitle(newName);
            element.setModifiedBy(userId);
            element.setModified(new Date());
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"messages.revisefolder", (String)this.getEventMessage(element), (boolean)false));
        }
        this.forumManager.savePrivateForum(pf);
    }

    public void deleteTopicFolder(PrivateForum pf, String topicUuid) {
        List pvtTopics = pf.getTopics();
        for (PrivateTopic element : pvtTopics) {
            if (!element.getUuid().equals(topicUuid)) continue;
            pf.removeTopic((Topic)element);
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"messages.deletefolder", (String)this.getEventMessage(element), (boolean)false));
            break;
        }
        this.forumManager.savePrivateForum(pf);
    }

    public Topic getTopicByUuid(String topicUuid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getTopicByIdWithMessages(final Long" + topicUuid + ")"));
        }
        return this.forumManager.getTopicByUuid(topicUuid);
    }

    public void movePvtMsgTopic(PrivateMessage message, Topic oldTopic, Topic newTopic) {
        List recipients = message.getRecipients();
        String newTopicTypeUuid = this.getTopicTypeUuid(newTopic.getTitle());
        String oldTopicTypeUuid = this.getTopicTypeUuid(oldTopic.getTitle());
        for (PrivateMessageRecipient element : recipients) {
            LOG.debug((Object)("element.getTypeUuid(): " + element.getTypeUuid() + ", oldTopicTypeUuid: " + oldTopicTypeUuid + ", element.getUserId(): " + element.getUserId() + ", getCurrentUser(): " + this.getCurrentUser()));
            if (!element.getTypeUuid().equals(oldTopicTypeUuid) || !element.getUserId().equals(this.getCurrentUser())) continue;
            element.setTypeUuid(newTopicTypeUuid);
        }
        this.savePrivateMessage((Message)message, false);
    }

    public PrivateMessage createPrivateMessage(String typeUuid) {
        PrivateMessageImpl message = new PrivateMessageImpl();
        message.setUuid(this.idManager.createUuid());
        message.setTypeUuid(typeUuid);
        message.setCreated(new Date());
        message.setCreatedBy(this.getCurrentUser());
        LOG.debug((Object)("message " + message.getUuid() + " created successfully"));
        return message;
    }

    public boolean hasNextMessage(PrivateMessage message) {
        boolean next = false;
        if (message != null && message.getTopic() != null && message.getTopic().getMessages() != null) {
            for (Message m : message.getTopic().getMessages()) {
                if (next) {
                    return true;
                }
                if (!m.getId().equals(message.getId())) continue;
                next = true;
            }
        }
        return false;
    }

    public boolean hasPreviousMessage(PrivateMessage message) {
        PrivateMessage prev = null;
        if (message != null && message.getTopic() != null && message.getTopic().getMessages() != null) {
            for (Message m : message.getTopic().getMessages()) {
                if (m.getId().equals(message.getId())) {
                    return prev != null;
                }
                prev = (PrivateMessage)m;
            }
        }
        return false;
    }

    public PrivateMessage getNextMessage(PrivateMessage message) {
        boolean next = false;
        if (message != null && message.getTopic() != null && message.getTopic().getMessages() != null) {
            for (Message m : message.getTopic().getMessages()) {
                if (next) {
                    return (PrivateMessage)m;
                }
                if (!m.getId().equals(message.getId())) continue;
                next = true;
            }
        }
        return null;
    }

    public PrivateMessage getPreviousMessage(PrivateMessage message) {
        PrivateMessage prev = null;
        if (message != null && message.getTopic() != null && message.getTopic().getMessages() != null) {
            for (Message m : message.getTopic().getMessages()) {
                if (m.getId().equals(message.getId())) {
                    return prev;
                }
                prev = (PrivateMessage)m;
            }
        }
        return null;
    }

    public List getMessagesByTopic(String userId, Long topicId) {
        return null;
    }

    public List getReceivedMessages(String orderField, String order) {
        return this.getMessagesByType(this.typeManager.getReceivedPrivateMessageType(), orderField, order);
    }

    public List getSentMessages(String orderField, String order) {
        return this.getMessagesByType(this.typeManager.getSentPrivateMessageType(), orderField, order);
    }

    public List getDeletedMessages(String orderField, String order) {
        return this.getMessagesByType(this.typeManager.getDeletedPrivateMessageType(), orderField, order);
    }

    public List getDraftedMessages(String orderField, String order) {
        return this.getMessagesByType(this.typeManager.getDraftPrivateMessageType(), orderField, order);
    }

    public PrivateMessage initMessageWithAttachmentsAndRecipients(PrivateMessage msg) {
        PrivateMessage pmReturn = (PrivateMessage)this.messageManager.getMessageByIdWithAttachments(msg.getId());
        this.getHibernateTemplate().initialize((Object)pmReturn.getRecipients());
        return pmReturn;
    }

    public List getMessagesByType(final String typeUuid, final String orderField, final String order) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getMessagesByType(typeUuid:" + typeUuid + ", orderField: " + orderField + ", order:" + order + ")"));
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(PrivateMessageManagerImpl.QUERY_MESSAGES_BY_USER_TYPE_AND_CONTEXT);
                Query qOrdered = session.createQuery(q.getQueryString() + " order by " + orderField + " " + order);
                qOrdered.setParameter("userId", (Object)PrivateMessageManagerImpl.this.getCurrentUser(), (Type)Hibernate.STRING);
                qOrdered.setParameter("typeUuid", (Object)typeUuid, (Type)Hibernate.STRING);
                qOrdered.setParameter("contextId", (Object)PrivateMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                return qOrdered.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List getMessagesByTypeByContext(final String typeUuid, final String contextId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getMessagesByTypeForASite(typeUuid:" + typeUuid + ")"));
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(PrivateMessageManagerImpl.QUERY_MESSAGES_BY_USER_TYPE_AND_CONTEXT);
                q.setParameter("userId", (Object)PrivateMessageManagerImpl.this.getCurrentUser(), (Type)Hibernate.STRING);
                q.setParameter("typeUuid", (Object)typeUuid, (Type)Hibernate.STRING);
                q.setParameter("contextId", (Object)contextId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List getMessagesByTypeByContext(final String typeUuid, final String contextId, final String userId, final String orderField, final String order) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getMessagesByTypeForASite(typeUuid:" + typeUuid + ")"));
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(PrivateMessageManagerImpl.QUERY_MESSAGES_BY_USER_TYPE_AND_CONTEXT);
                Query qOrdered = session.createQuery(q.getQueryString() + " order by " + orderField + " " + order);
                qOrdered.setParameter("userId", (Object)userId, (Type)Hibernate.STRING);
                qOrdered.setParameter("typeUuid", (Object)typeUuid, (Type)Hibernate.STRING);
                qOrdered.setParameter("contextId", (Object)contextId, (Type)Hibernate.STRING);
                return qOrdered.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public int findMessageCount(String typeUuid, List aggregateList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("findMessageCount executing with typeUuid: " + typeUuid));
        }
        if (typeUuid == null) {
            LOG.error((Object)"findMessageCount failed with typeUuid: null");
            throw new IllegalArgumentException("Null Argument");
        }
        if (aggregateList == null) {
            LOG.error((Object)"findMessageCount failed with aggregateList: null");
            throw new IllegalStateException("aggregateList is null");
        }
        int totalCount = 0;
        for (Object[] element : aggregateList) {
            if (!typeUuid.equals(element[1])) continue;
            totalCount += ((Integer)element[2]).intValue();
        }
        return totalCount;
    }

    public int findUnreadMessageCount(String typeUuid, List aggregateList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("findUnreadMessageCount executing with typeUuid: " + typeUuid));
        }
        if (typeUuid == null) {
            LOG.error((Object)"findUnreadMessageCount failed with typeUuid: null");
            throw new IllegalArgumentException("Null Argument");
        }
        if (aggregateList == null) {
            LOG.error((Object)"findMessageCount failed with aggregateList: Null");
            throw new IllegalStateException("aggregateList is null");
        }
        int unreadCount = 0;
        for (Object[] element : aggregateList) {
            if (!typeUuid.equals(element[1]) || Boolean.TRUE.equals(element[0])) continue;
            unreadCount = (Integer)element[2];
            break;
        }
        return unreadCount;
    }

    private List initializeMessageCounts(final String userId, final String contextId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"initializeMessageCounts executing");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(PrivateMessageManagerImpl.QUERY_AGGREGATE_COUNT);
                q.setParameter("contextId", (Object)contextId, (Type)Hibernate.STRING);
                q.setParameter("userId", (Object)userId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List getPrivateMessageCountsForAllSites() {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findUnreadPvtMsgCntByUserForAllSites");
                q.setParameter("userId", (Object)PrivateMessageManagerImpl.this.getCurrentUser(), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public void deletePrivateMessage(PrivateMessage message, String typeUuid) {
        PrivateMessageRecipient pmrReturned;
        String userId = this.getCurrentUser();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deletePrivateMessage(message:" + message + ", typeUuid:" + typeUuid + ")"));
        }
        PrivateMessage pvtMessage = this.getPrivateMessageWithRecipients(message);
        PrivateMessageRecipientImpl pmrReadSearch = new PrivateMessageRecipientImpl(userId, typeUuid, this.getContextId(), Boolean.TRUE, Boolean.valueOf(false));
        PrivateMessageRecipientImpl pmrNonReadSearch = new PrivateMessageRecipientImpl(userId, typeUuid, this.getContextId(), Boolean.FALSE, Boolean.valueOf(false));
        int indexDelete = -1;
        int indexRead = pvtMessage.getRecipients().indexOf(pmrReadSearch);
        if (indexRead != -1) {
            indexDelete = indexRead;
        } else {
            int indexNonRead = pvtMessage.getRecipients().indexOf(pmrNonReadSearch);
            if (indexNonRead != -1) {
                indexDelete = indexNonRead;
            } else {
                LOG.error((Object)("deletePrivateMessage -- cannot find private message for user: " + userId + ", typeUuid: " + typeUuid));
            }
        }
        if (indexDelete != -1 && (pmrReturned = (PrivateMessageRecipient)pvtMessage.getRecipients().get(indexDelete)) != null) {
            PrivateMessageRecipientImpl pmrDeletedSearch = new PrivateMessageRecipientImpl(userId, this.typeManager.getDeletedPrivateMessageType(), this.getContextId(), Boolean.TRUE, Boolean.valueOf(false));
            int indexDeleted = pvtMessage.getRecipients().indexOf(pmrDeletedSearch);
            if (indexDeleted == -1) {
                boolean prevReadStatus = pmrReturned.getRead();
                pmrReturned.setRead(Boolean.TRUE);
                String contextId = this.getContextId();
                if (!prevReadStatus) {
                    this.decrementMessagesSynopticToolInfo(userId, contextId, 20);
                }
                pmrReturned.setTypeUuid(this.typeManager.getDeletedPrivateMessageType());
            } else {
                pvtMessage.getRecipients().remove(indexDelete);
            }
        }
    }

    public void decrementMessagesSynopticToolInfo(String userId, String siteId, int numOfAttempts) {
        try {
            SynopticMsgcntrManagerCover.decrementMessagesSynopticToolInfo((String)userId, (String)siteId);
        }
        catch (HibernateOptimisticLockingFailureException holfe) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (--numOfAttempts <= 0) {
                System.out.println("PrivateMessageManagerImpl: decrementMessagesSynopticToolInfo: HibernateOptimisticLockingFailureException no more retries left");
                holfe.printStackTrace();
            }
            System.out.println("PrivateMessageManagerImpl: decrementMessagesSynopticToolInfo: HibernateOptimisticLockingFailureException: attempts left: " + numOfAttempts);
            this.decrementMessagesSynopticToolInfo(userId, siteId, numOfAttempts);
        }
    }

    public void incrementMessagesSynopticToolInfo(String userId, String siteId, int numOfAttempts) {
        try {
            SynopticMsgcntrManagerCover.incrementMessagesSynopticToolInfo((String)userId, (String)siteId);
        }
        catch (HibernateOptimisticLockingFailureException holfe) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (--numOfAttempts <= 0) {
                System.out.println("PrivateMessageManagerImpl: incrementMessagesSynopticToolInfo: HibernateOptimisticLockingFailureException no more retries left");
                holfe.printStackTrace();
            }
            System.out.println("PrivateMessageManagerImpl: incrementMessagesSynopticToolInfo: HibernateOptimisticLockingFailureException: attempts left: " + numOfAttempts);
            this.incrementMessagesSynopticToolInfo(userId, siteId, numOfAttempts);
        }
    }

    public void sendPrivateMessage(PrivateMessage message, Map<User, Boolean> recipients, boolean asEmail) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("sendPrivateMessage(message: " + message + ", recipients: " + recipients + ")"));
            }
            if (message == null || recipients == null) {
                throw new IllegalArgumentException("Null Argument");
            }
            if (recipients.size() == 0 && !message.getDraft().booleanValue()) {
                return;
            }
            String currentUserAsString = this.getCurrentUser();
            User currentUser = UserDirectoryService.getCurrentUser();
            UniqueArrayList recipientList = new UniqueArrayList();
            if (message.getDraft().booleanValue()) {
                PrivateMessageRecipientImpl receiver = new PrivateMessageRecipientImpl(currentUserAsString, this.typeManager.getDraftPrivateMessageType(), this.getContextId(), Boolean.TRUE, Boolean.valueOf(false));
                recipientList.add(receiver);
                message.setRecipients((List)recipientList);
                this.savePrivateMessage((Message)message, false);
                return;
            }
            ArrayList<String> additionalHeaders = new ArrayList<String>(1);
            additionalHeaders.add("Content-Type: text/html");
            String defaultEmail = "postmaster@" + ServerConfigurationService.getServerName();
            String systemEmail = ServerConfigurationService.getString((String)"msgcntr.notification.from.address", (String)defaultEmail);
            systemEmail = !ServerConfigurationService.getBoolean((String)"msgcntr.notification.user.real.from", (boolean)false) ? ServerConfigurationService.getString((String)"msgcntr.notification.from.address", (String)defaultEmail) : (currentUser.getEmail() != null ? currentUser.getEmail() : ServerConfigurationService.getString((String)"msgcntr.notification.from.address", (String)defaultEmail));
            String bodyString = this.buildMessageBody(message);
            Area currentArea = null;
            List privateForums = null;
            HashMap<String, PrivateForum> pfMap = null;
            currentArea = this.getAreaByContextIdAndTypeId(this.typeManager.getPrivateMessageAreaType());
            privateForums = currentArea.getPrivateForums();
            pfMap = new HashMap<String, PrivateForum>();
            for (int i = 0; i < privateForums.size(); ++i) {
                PrivateForum pf1 = (PrivateForum)privateForums.get(i);
                pfMap.put(pf1.getOwner(), pf1);
            }
            boolean forwardingEnabled = false;
            ArrayList<InternetAddress> fAddresses = new ArrayList<InternetAddress>();
            for (Map.Entry<User, Boolean> entrySet : recipients.entrySet()) {
                PrivateForum oldPf;
                User u = entrySet.getKey();
                Boolean bcc = entrySet.getValue();
                String userId = u.getId();
                PrivateForum pf = null;
                if (pfMap.containsKey(userId)) {
                    pf = (PrivateForum)pfMap.get(userId);
                }
                if (pf != null && pf.getAutoForward().booleanValue() && pf.getAutoForwardEmail() != null) {
                    forwardingEnabled = true;
                    fAddresses.add(new InternetAddress(pf.getAutoForwardEmail()));
                }
                if (pf == null && (oldPf = this.forumManager.getPrivateForumByOwnerAreaNull(userId)) != null && oldPf.getAutoForward().booleanValue() && oldPf.getAutoForwardEmail() != null) {
                    forwardingEnabled = true;
                    fAddresses.add(new InternetAddress(oldPf.getAutoForwardEmail()));
                }
                Boolean isRecipientCurrentUser = currentUserAsString.equals(userId) ? Boolean.TRUE : Boolean.FALSE;
                PrivateMessageRecipientImpl receiver = new PrivateMessageRecipientImpl(userId, this.typeManager.getReceivedPrivateMessageType(), this.getContextId(), isRecipientCurrentUser, bcc);
                recipientList.add(receiver);
            }
            if (asEmail) {
                additionalHeaders.add("From: " + systemEmail);
                additionalHeaders.add("Subject: " + message.getTitle());
                this.emailService.sendToUsers(recipients.keySet(), additionalHeaders, bodyString);
            }
            if (forwardingEnabled) {
                InternetAddress[] fAddressesArr = new InternetAddress[fAddresses.size()];
                fAddressesArr = fAddresses.toArray(fAddressesArr);
                this.emailService.sendMail(new InternetAddress(systemEmail), fAddressesArr, message.getTitle(), bodyString, fAddressesArr, null, additionalHeaders);
            }
            PrivateMessageRecipientImpl sender = new PrivateMessageRecipientImpl(currentUserAsString, this.typeManager.getSentPrivateMessageType(), this.getContextId(), Boolean.TRUE, Boolean.valueOf(false));
            recipientList.add(sender);
            message.setRecipients((List)recipientList);
            this.savePrivateMessage((Message)message, false);
        }
        catch (MessagingException e) {
            LOG.warn((Object)("PrivateMessageManagerImpl.sendPrivateMessage: exception: " + e.getMessage()), (Throwable)e);
        }
    }

    private String buildMessageBody(PrivateMessage message) {
        ToolConfiguration tool;
        User currentUser = UserDirectoryService.getCurrentUser();
        StringBuilder body = new StringBuilder(message.getBody());
        body.insert(0, "From: " + currentUser.getDisplayName() + "<p/>");
        String sendToString = message.getRecipientsAsText();
        if (sendToString.indexOf("[") > 0) {
            sendToString = sendToString.substring(0, sendToString.indexOf("["));
            if ((sendToString = sendToString.trim()).length() > 0) {
                sendToString = sendToString + "; ";
            }
            sendToString = sendToString + this.getResourceBundleString("pvt_HiddenRecipients");
        } else if (ServerConfigurationService.getBoolean((String)"msg.displayEid", (boolean)true)) {
            String originalSendTo = sendToString;
            if (!(sendToString = sendToString.replaceAll("\\([^)]+\\(.*", "")).equals(originalSendTo)) {
                if ((sendToString = sendToString.trim()).length() > 0) {
                    sendToString = sendToString + "; ";
                }
                sendToString = sendToString + this.getResourceBundleString("pvt_HiddenRecipients");
            }
        } else if (sendToString.indexOf("(") > 0) {
            sendToString = sendToString.substring(0, sendToString.indexOf("("));
            if ((sendToString = sendToString.trim()).length() > 0) {
                sendToString = sendToString + "; ";
            }
            sendToString = sendToString + this.getResourceBundleString("pvt_HiddenRecipients");
        }
        body.insert(0, "To: " + sendToString + "<p/>");
        if (message.getAttachments() != null && message.getAttachments().size() > 0) {
            body.append("<br/><br/>");
            for (Attachment attachment : message.getAttachments()) {
                body.append("<a href=\"" + this.messageManager.getAttachmentUrl(attachment.getAttachmentId()) + "\">" + attachment.getAttachmentName() + "</a><br/>");
            }
        }
        String siteTitle = null;
        try {
            siteTitle = SiteService.getSite((String)this.getContextId()).getTitle();
        }
        catch (IdUnusedException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        String thisPageId = "";
        ToolSession ts = this.sessionManager.getCurrentToolSession();
        if (ts != null && (tool = SiteService.findTool((String)ts.getPlacementId())) != null) {
            thisPageId = tool.getPageId();
        }
        String footer = "<p>----------------------<br>" + this.getResourceBundleString(EMAIL_FOOTER1) + " " + ServerConfigurationService.getString((String)"ui.service") + " " + this.getResourceBundleString(EMAIL_FOOTER2) + " \"" + siteTitle + "\" " + this.getResourceBundleString(EMAIL_FOOTER3) + "\n" + this.getResourceBundleString(EMAIL_FOOTER4) + " <a href=\"" + ServerConfigurationService.getPortalUrl() + "/site/" + ToolManager.getCurrentPlacement().getContext() + "/page/" + thisPageId + "\">";
        footer = footer + siteTitle + "</a>.</p>";
        body.append(footer);
        String bodyString = body.toString();
        return bodyString;
    }

    public void markMessageAsReadForUser(PrivateMessage message) {
        this.markMessageAsReadForUser(message, this.getContextId());
    }

    public void markMessageAsReadForUser(PrivateMessage message, String contextId) {
        this.markMessageAsReadForUser(message, contextId, this.getCurrentUser(), ToolManager.getCurrentTool().getId());
    }

    public void markMessageAsReadForUser(PrivateMessage message, String contextId, String userId, String toolId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("markMessageAsReadForUser(message: " + message + ")"));
        }
        if (message == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        PrivateMessage pvtMessage = this.getPrivateMessageWithRecipients(message);
        PrivateMessageRecipientImpl searchRecipient = new PrivateMessageRecipientImpl(userId, this.typeManager.getReceivedPrivateMessageType(), contextId, Boolean.FALSE, Boolean.valueOf(false));
        List recipientList = pvtMessage.getRecipients();
        if (recipientList == null || recipientList.size() == 0) {
            LOG.error((Object)("markMessageAsReadForUser(message: " + message + ") has empty recipient list"));
            throw new RuntimeException("markMessageAsReadForUser(message: " + message + ") has empty recipient list");
        }
        int recordIndex = -1;
        for (int i = 0; i < pvtMessage.getRecipients().size(); ++i) {
            if (!((PrivateMessageRecipientImpl)pvtMessage.getRecipients().get(i)).getUserId().equals(searchRecipient.getUserId()) || ((PrivateMessageRecipientImpl)recipientList.get(recordIndex = i)).getRead().booleanValue()) continue;
            ((PrivateMessageRecipientImpl)recipientList.get(recordIndex)).setRead(Boolean.TRUE);
        }
        if (recordIndex != -1) {
            this.decrementMessagesSynopticToolInfo(searchRecipient.getUserId(), contextId, 20);
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"messages.read", (String)this.getEventMessage(pvtMessage, toolId, userId, contextId), (boolean)false));
        }
    }

    public void markMessageAsUnreadForUser(PrivateMessage message) {
        this.markMessageAsUnreadForUser(message, this.getContextId());
    }

    public void markMessageAsUnreadForUser(PrivateMessage message, String contextId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("markMessageAsUnreadForUser(message: " + message + ")"));
        }
        if (message == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        String userId = this.getCurrentUser();
        PrivateMessage pvtMessage = this.getPrivateMessageWithRecipients(message);
        PrivateMessageRecipientImpl searchRecipient = new PrivateMessageRecipientImpl(userId, this.typeManager.getReceivedPrivateMessageType(), contextId, Boolean.TRUE, Boolean.valueOf(false));
        List recipientList = pvtMessage.getRecipients();
        if (recipientList == null || recipientList.size() == 0) {
            LOG.error((Object)("markMessageAsUnreadForUser(message: " + message + ") has empty recipient list"));
            throw new RuntimeException("markMessageAsUnreadForUser(message: " + message + ") has empty recipient list");
        }
        int recordIndex = -1;
        for (int i = 0; i < pvtMessage.getRecipients().size(); ++i) {
            if (!((PrivateMessageRecipientImpl)pvtMessage.getRecipients().get(i)).getUserId().equals(searchRecipient.getUserId()) || !((PrivateMessageRecipientImpl)recipientList.get(recordIndex = i)).getRead().booleanValue()) continue;
            ((PrivateMessageRecipientImpl)recipientList.get(recordIndex)).setRead(Boolean.FALSE);
        }
        if (recordIndex != -1) {
            try {
                Site currentSite = SiteService.getSite((String)contextId);
                this.incrementMessagesSynopticToolInfo(searchRecipient.getUserId(), contextId, 20);
            }
            catch (IdUnusedException e) {
                e.printStackTrace();
            }
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"messages.unread", (String)this.getEventMessage(pvtMessage), (boolean)false));
        }
    }

    private PrivateMessage getPrivateMessageWithRecipients(final PrivateMessage message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getPrivateMessageWithRecipients(message: " + message + ")"));
        }
        if (message == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(PrivateMessageManagerImpl.QUERY_MESSAGES_BY_ID_WITH_RECIPIENTS);
                q.setParameter("id", (Object)message.getId(), (Type)Hibernate.LONG);
                return q.uniqueResult();
            }
        };
        PrivateMessage pvtMessage = (PrivateMessage)this.getHibernateTemplate().execute(hcb);
        if (pvtMessage == null) {
            LOG.error((Object)("getPrivateMessageWithRecipients(message: " + message + ") could not find message"));
            throw new RuntimeException("getPrivateMessageWithRecipients(message: " + message + ") could not find message");
        }
        return pvtMessage;
    }

    public List searchPvtMsgs(String typeUuid, String searchText, Date searchFromDate, Date searchToDate, boolean searchByText, boolean searchByAuthor, boolean searchByBody, boolean searchByLabel, boolean searchByDate) {
        return this.messageManager.findPvtMsgsBySearchText(typeUuid, searchText, searchFromDate, searchToDate, searchByText, searchByAuthor, searchByBody, searchByLabel, searchByDate);
    }

    public String getAuthorString() {
        String authorString = this.getCurrentUser();
        try {
            authorString = UserDirectoryService.getUser((String)authorString).getSortName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return authorString;
    }

    private String getCurrentUser() {
        if (TestUtil.isRunningTests()) {
            return "test-user";
        }
        return this.sessionManager.getCurrentSessionUserId();
    }

    public AreaManager getAreaManager() {
        return this.areaManager;
    }

    public void setAreaManager(AreaManager areaManager) {
        this.areaManager = areaManager;
    }

    public MessageForumsMessageManager getMessageManager() {
        return this.messageManager;
    }

    public void setMessageManager(MessageForumsMessageManager messageManager) {
        this.messageManager = messageManager;
    }

    public void setTypeManager(MessageForumsTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setIdManager(IdManager idManager) {
        this.idManager = idManager;
    }

    public void setForumManager(MessageForumsForumManager forumManager) {
        this.forumManager = forumManager;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public boolean isInstructor() {
        LOG.debug((Object)"isInstructor()");
        return this.isInstructor(UserDirectoryService.getCurrentUser());
    }

    public boolean isSectionTA() {
        LOG.debug((Object)"isSectionTA()");
        return this.isSectionTA(UserDirectoryService.getCurrentUser());
    }

    private boolean isInstructor(User user) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isInstructor(User " + user + ")"));
        }
        if (user != null) {
            return SecurityService.unlock((User)user, (String)"site.upd", (String)this.getContextSiteId());
        }
        return false;
    }

    private boolean isSectionTA(User user) {
        if (user != null) {
            return SecurityService.unlock((User)user, (String)"section.role.ta", (String)this.getContextSiteId());
        }
        return false;
    }

    public boolean isEmailPermit() {
        LOG.debug((Object)"isEmailPermit()");
        return this.isEmailPermit(UserDirectoryService.getCurrentUser());
    }

    private boolean isEmailPermit(User user) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isEmailPermit(User " + user + ")"));
        }
        if (user != null) {
            return SecurityService.unlock((User)user, (String)"msg.emailout", (String)this.getContextSiteId());
        }
        return false;
    }

    public boolean isAllowToFieldGroups() {
        LOG.debug((Object)"isAllowToFieldGroups()");
        return this.isAllowToFieldGroups(UserDirectoryService.getCurrentUser());
    }

    private boolean isAllowToFieldGroups(User user) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isAllowToFieldGroups(User " + user + ")"));
        }
        if (user != null) {
            return SecurityService.unlock((User)user, (String)"msg.permissions.allowToField.groups", (String)this.getContextSiteId());
        }
        return false;
    }

    public boolean isAllowToFieldAllParticipants() {
        LOG.debug((Object)"isAllowToFieldAllParticipants()");
        return this.isAllowToFieldAllParticipants(UserDirectoryService.getCurrentUser());
    }

    private boolean isAllowToFieldAllParticipants(User user) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isAllowToFieldAllParticipants(User " + user + ")"));
        }
        if (user != null) {
            return SecurityService.unlock((User)user, (String)"msg.permissions.allowToField.allParticipants", (String)this.getContextSiteId());
        }
        return false;
    }

    public boolean isAllowToFieldRoles() {
        LOG.debug((Object)"isAllowToFieldRoles()");
        return this.isAllowToFieldRoles(UserDirectoryService.getCurrentUser());
    }

    private boolean isAllowToFieldRoles(User user) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isAllowToFieldRoles(User " + user + ")"));
        }
        if (user != null) {
            return SecurityService.unlock((User)user, (String)"msg.permissions.allowToField.roles", (String)this.getContextSiteId());
        }
        return false;
    }

    public boolean isAllowToViewHiddenGroups() {
        LOG.debug((Object)"isAllowToViewHiddenGroups()");
        return this.isAllowToViewHiddenGroups(UserDirectoryService.getCurrentUser());
    }

    private boolean isAllowToViewHiddenGroups(User user) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isAllowToViewHiddenGroups(User " + user + ")"));
        }
        if (user != null) {
            return SecurityService.unlock((User)user, (String)"msg.permissions.viewHidden.groups", (String)this.getContextSiteId());
        }
        return false;
    }

    public String getContextSiteId() {
        LOG.debug((Object)"getContextSiteId()");
        return "/site/" + ToolManager.getCurrentPlacement().getContext();
    }

    public String getContextId() {
        LOG.debug((Object)"getContextId()");
        if (TestUtil.isRunningTests()) {
            return "01001010";
        }
        return ToolManager.getCurrentPlacement().getContext();
    }

    public String getTopicTypeUuid(String topicTitle) {
        String topicTypeUuid = "pvt_received".equals(topicTitle) ? this.typeManager.getReceivedPrivateMessageType() : ("pvt_sent".equals(topicTitle) ? this.typeManager.getSentPrivateMessageType() : ("pvt_deleted".equals(topicTitle) ? this.typeManager.getDeletedPrivateMessageType() : ("pvt_drafts".equals(topicTitle) ? this.typeManager.getDraftPrivateMessageType() : this.typeManager.getCustomTopicType(topicTitle))));
        return topicTypeUuid;
    }

    public Area getAreaByContextIdAndTypeId(final String typeId) {
        LOG.debug((Object)("getAreaByContextIdAndTypeId executing for current user: " + this.getCurrentUser()));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findAreaByContextIdAndTypeId");
                q.setParameter("contextId", (Object)PrivateMessageManagerImpl.this.getContextId(), (Type)Hibernate.STRING);
                q.setParameter("typeId", (Object)typeId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Area)this.getHibernateTemplate().execute(hcb);
    }

    public String getResourceBundleString(String key) {
        return this.areaManager.getResourceBundleString(key);
    }

    private String getEventMessage(Object object) {
        return this.getEventMessage(object, ToolManager.getCurrentTool().getId(), this.getCurrentUser(), this.getContextId());
    }

    private String getEventMessage(Object object, String toolId, String userId, String contextId) {
        String eventMessagePrefix = "";
        eventMessagePrefix = toolId.equals("sakai.messagecenter") ? "/messagesAndForums/site/" : (toolId.equals("sakai.messages") ? "/messages/site/" : "/forums/site/");
        return eventMessagePrefix + contextId + "/" + object.toString() + "/" + userId;
    }
}

