/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.messageforums.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.messageforums.Area;
import org.sakaiproject.api.app.messageforums.AreaManager;
import org.sakaiproject.api.app.messageforums.DBMembershipItem;
import org.sakaiproject.api.app.messageforums.DiscussionForum;
import org.sakaiproject.api.app.messageforums.DiscussionTopic;
import org.sakaiproject.api.app.messageforums.MessageForumsTypeManager;
import org.sakaiproject.api.app.messageforums.PermissionLevelManager;
import org.sakaiproject.api.app.messageforums.PermissionManager;
import org.sakaiproject.api.app.messageforums.ui.DiscussionForumManager;
import org.sakaiproject.api.app.messageforums.ui.UIPermissionsManager;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.app.messageforums.TestUtil;
import org.sakaiproject.component.app.messageforums.dao.hibernate.DBMembershipItemImpl;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.thread_local.cover.ThreadLocalManager;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.cover.UserDirectoryService;

public class UIPermissionsManagerImpl
implements UIPermissionsManager {
    private static final Log LOG = LogFactory.getLog(UIPermissionsManagerImpl.class);
    private AuthzGroupService authzGroupService;
    private SessionManager sessionManager;
    private ToolManager toolManager;
    private PermissionManager permissionManager;
    private PermissionLevelManager permissionLevelManager;
    private MessageForumsTypeManager typeManager;
    private SecurityService securityService;
    private DiscussionForumManager forumManager;
    private AreaManager areaManager;

    public void init() {
        LOG.info((Object)"init()");
    }

    public void setAreaManager(AreaManager areaManager) {
        this.areaManager = areaManager;
    }

    public void setForumManager(DiscussionForumManager forumManager) {
        this.forumManager = forumManager;
    }

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setAuthzGroupService(AuthzGroupService " + authzGroupService + ")"));
        }
        this.authzGroupService = authzGroupService;
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setSessionManager(SessionManager " + sessionManager + ")"));
        }
        this.sessionManager = sessionManager;
    }

    public void setToolManager(ToolManager toolManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setToolManager(ToolManager " + toolManager + ")"));
        }
        this.toolManager = toolManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setPermissionManager(PermissionManager " + permissionManager + ")"));
        }
        this.permissionManager = permissionManager;
    }

    public void setTypeManager(MessageForumsTypeManager typeManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setTypeManager(MessageForumsTypeManager " + typeManager + ")"));
        }
        this.typeManager = typeManager;
    }

    public void setSecurityService(SecurityService securityService) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setSecurityService(SecurityService" + securityService + ")"));
        }
        this.securityService = securityService;
    }

    public boolean isNewForum() {
        LOG.debug((Object)"isNewForum()");
        if (this.isSuperUser()) {
            return true;
        }
        try {
            Iterator iter = this.getAreaItemsByCurrentUser();
            while (iter.hasNext()) {
                DBMembershipItem item = (DBMembershipItem)iter.next();
                if (!item.getPermissionLevel().getNewForum().booleanValue()) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public boolean isChangeSettings(DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isChangeSettings(DiscussionForum " + forum + ")"));
        }
        if (this.isSuperUser()) {
            return true;
        }
        if (this.securityService.unlock(SiteService.SECURE_UPDATE_SITE, this.getContextSiteId())) {
            return true;
        }
        if (this.forumManager.isForumOwner(forum)) {
            return true;
        }
        try {
            Iterator iter = this.getForumItemsByCurrentUser(forum);
            while (iter.hasNext()) {
                DBMembershipItem item = (DBMembershipItem)iter.next();
                if (!item.getPermissionLevel().getChangeSettings().booleanValue()) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public boolean isNewTopic(DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isNewTopic(DiscussionForum " + forum + ")"));
        }
        if (this.isSuperUser()) {
            return true;
        }
        try {
            Iterator iter = this.getForumItemsByCurrentUser(forum);
            while (iter.hasNext()) {
                DBMembershipItem item = (DBMembershipItem)iter.next();
                if (!item.getPermissionLevel().getNewTopic().booleanValue()) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public boolean isNewResponse(DiscussionTopic topic, DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isNewResponse(DiscussionTopic " + topic + "), DiscussionForum" + forum + ""));
        }
        try {
            if (this.checkBaseConditions(topic, forum)) {
                return true;
            }
            Iterator iter = this.getTopicItemsByCurrentUser(topic);
            while (iter.hasNext()) {
                DBMembershipItem item = (DBMembershipItem)iter.next();
                if (!item.getPermissionLevel().getNewResponse().booleanValue() || forum == null || !forum.getDraft().equals(Boolean.FALSE) || !forum.getLocked().equals(Boolean.FALSE) || !topic.getDraft().equals(Boolean.FALSE) || !topic.getLocked().equals(Boolean.FALSE)) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public boolean isNewResponseToResponse(DiscussionTopic topic, DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isNewResponseToResponse(DiscussionTopic " + topic + " , DiscussionForum" + forum + ") "));
        }
        try {
            if (this.checkBaseConditions(topic, forum)) {
                return true;
            }
            Iterator iter = this.getTopicItemsByCurrentUser(topic);
            while (iter.hasNext()) {
                DBMembershipItem item = (DBMembershipItem)iter.next();
                if (!item.getPermissionLevel().getNewResponseToResponse().booleanValue() || !forum.getDraft().equals(Boolean.FALSE) || !forum.getLocked().equals(Boolean.FALSE) || !topic.getDraft().equals(Boolean.FALSE) || !topic.getLocked().equals(Boolean.FALSE)) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public boolean isMovePostings(DiscussionTopic topic, DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isMovePostings(DiscussionTopic " + topic + "), DiscussionForum" + forum + ""));
        }
        try {
            if (this.checkBaseConditions(topic, forum)) {
                return true;
            }
            Iterator iter = this.getTopicItemsByCurrentUser(topic);
            while (iter.hasNext()) {
                DBMembershipItem item = (DBMembershipItem)iter.next();
                if (!item.getPermissionLevel().getMovePosting().booleanValue() || !forum.getDraft().equals(Boolean.FALSE) || !forum.getLocked().equals(Boolean.FALSE) || !topic.getDraft().equals(Boolean.FALSE) || !topic.getLocked().equals(Boolean.FALSE)) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public boolean isChangeSettings(DiscussionTopic topic, DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isChangeSettings(DiscussionTopic " + topic + "), DiscussionForum" + forum + ""));
        }
        if (this.isSuperUser()) {
            return true;
        }
        if (this.securityService.unlock(SiteService.SECURE_UPDATE_SITE, this.getContextSiteId())) {
            return true;
        }
        try {
            if (this.forumManager.isTopicOwner(topic)) {
                return true;
            }
            Iterator iter = this.getTopicItemsByCurrentUser(topic);
            while (iter.hasNext()) {
                DBMembershipItem item = (DBMembershipItem)iter.next();
                if (!item.getPermissionLevel().getChangeSettings().booleanValue()) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public boolean isPostToGradebook(DiscussionTopic topic, DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isPostToGradebook(DiscussionTopic " + topic + ", DiscussionForum" + forum + ")"));
        }
        try {
            if (this.checkBaseConditions(topic, forum)) {
                return true;
            }
            Iterator iter = this.getTopicItemsByCurrentUser(topic);
            while (iter.hasNext()) {
                DBMembershipItem item = (DBMembershipItem)iter.next();
                if (!item.getPermissionLevel().getPostToGradebook().booleanValue() || !forum.getDraft().equals(Boolean.FALSE) || !topic.getDraft().equals(Boolean.FALSE)) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public boolean isRead(DiscussionTopic topic, DiscussionForum forum) {
        return this.isRead(topic, forum, this.getCurrentUserId());
    }

    public boolean isRead(DiscussionTopic topic, DiscussionForum forum, String userId) {
        return this.isRead(topic, forum, userId, this.getContextId());
    }

    public boolean isRead(DiscussionTopic topic, DiscussionForum forum, String userId, String siteId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isRead(DiscussionTopic " + topic + ", DiscussionForum" + forum + ")"));
        }
        return this.isRead(topic.getId(), topic.getDraft(), forum.getDraft(), userId, siteId);
    }

    public boolean isRead(Long topicId, Boolean isTopicDraft, Boolean isForumDraft, String userId, String siteId) {
        try {
            if (this.checkBaseConditions(null, null, userId, "/site/" + siteId)) {
                return true;
            }
            Iterator iter = this.getTopicItemsByUser(topicId, userId, siteId);
            while (iter.hasNext()) {
                DBMembershipItem item = (DBMembershipItem)iter.next();
                if (!item.getPermissionLevel().getRead().booleanValue() || !isForumDraft.equals(Boolean.FALSE) || !isTopicDraft.equals(Boolean.FALSE)) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public boolean isReviseAny(DiscussionTopic topic, DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isReviseAny(DiscussionTopic " + topic + ", DiscussionForum" + forum + ")"));
        }
        try {
            if (this.checkBaseConditions(topic, forum)) {
                return true;
            }
            if (topic.getLocked() == null || topic.getLocked().equals(Boolean.TRUE)) {
                LOG.debug((Object)("This topic is locked " + topic));
                return false;
            }
            if (topic.getDraft() == null || topic.getDraft().equals(Boolean.TRUE)) {
                LOG.debug((Object)("This topic is at draft stage " + topic));
            }
            Iterator iter = this.getTopicItemsByCurrentUser(topic);
            while (iter.hasNext()) {
                DBMembershipItem item = (DBMembershipItem)iter.next();
                if (!item.getPermissionLevel().getReviseAny().booleanValue() || !forum.getDraft().equals(Boolean.FALSE) || !forum.getLocked().equals(Boolean.FALSE) || !topic.getDraft().equals(Boolean.FALSE) || !topic.getLocked().equals(Boolean.FALSE)) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public boolean isReviseOwn(DiscussionTopic topic, DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isReviseOwn(DiscussionTopic " + topic + ", DiscussionForum" + forum + ")"));
        }
        if (this.checkBaseConditions(topic, forum)) {
            return true;
        }
        try {
            if (this.checkBaseConditions(topic, forum)) {
                return true;
            }
            if (topic.getLocked() == null || topic.getLocked().equals(Boolean.TRUE)) {
                LOG.debug((Object)("This topic is locked " + topic));
                return false;
            }
            if (topic.getDraft() == null || topic.getDraft().equals(Boolean.TRUE)) {
                LOG.debug((Object)("This topic is at draft stage " + topic));
            }
            Iterator iter = this.getTopicItemsByCurrentUser(topic);
            while (iter.hasNext()) {
                DBMembershipItem item = (DBMembershipItem)iter.next();
                if (!item.getPermissionLevel().getReviseOwn().booleanValue() || !forum.getDraft().equals(Boolean.FALSE) || !forum.getLocked().equals(Boolean.FALSE) || !topic.getDraft().equals(Boolean.FALSE) || !topic.getLocked().equals(Boolean.FALSE)) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public boolean isDeleteAny(DiscussionTopic topic, DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isDeleteAny(DiscussionTopic " + topic + ", DiscussionForum" + forum + ")"));
        }
        if (this.checkBaseConditions(topic, forum)) {
            return true;
        }
        try {
            if (this.checkBaseConditions(topic, forum)) {
                return true;
            }
            if (topic.getLocked() == null || topic.getLocked().equals(Boolean.TRUE)) {
                LOG.debug((Object)("This topic is locked " + topic));
                return false;
            }
            if (topic.getDraft() == null || topic.getDraft().equals(Boolean.TRUE)) {
                LOG.debug((Object)("This topic is at draft stage " + topic));
            }
            Iterator iter = this.getTopicItemsByCurrentUser(topic);
            while (iter.hasNext()) {
                DBMembershipItem item = (DBMembershipItem)iter.next();
                if (!item.getPermissionLevel().getDeleteAny().booleanValue() || !forum.getDraft().equals(Boolean.FALSE) || !forum.getLocked().equals(Boolean.FALSE) || !topic.getDraft().equals(Boolean.FALSE) || !topic.getLocked().equals(Boolean.FALSE)) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public boolean isDeleteOwn(DiscussionTopic topic, DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isDeleteOwn(DiscussionTopic " + topic + ", DiscussionForum" + forum + ")"));
        }
        if (this.checkBaseConditions(topic, forum)) {
            return true;
        }
        try {
            if (this.checkBaseConditions(topic, forum)) {
                return true;
            }
            if (topic.getLocked() == null || topic.getLocked().equals(Boolean.TRUE)) {
                LOG.debug((Object)("This topic is locked " + topic));
                return false;
            }
            if (topic.getDraft() == null || topic.getDraft().equals(Boolean.TRUE)) {
                LOG.debug((Object)("This topic is at draft stage " + topic));
            }
            Iterator iter = this.getTopicItemsByCurrentUser(topic);
            while (iter.hasNext()) {
                DBMembershipItem item = (DBMembershipItem)iter.next();
                if (!item.getPermissionLevel().getDeleteOwn().booleanValue() || !forum.getDraft().equals(Boolean.FALSE) || !forum.getLocked().equals(Boolean.FALSE) || !topic.getDraft().equals(Boolean.FALSE) || !topic.getLocked().equals(Boolean.FALSE)) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public boolean isMarkAsRead(DiscussionTopic topic, DiscussionForum forum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isMarkAsRead(DiscussionTopic " + topic + ", DiscussionForum" + forum + ")"));
        }
        if (this.checkBaseConditions(topic, forum)) {
            return true;
        }
        if (topic.getLocked() == null || topic.getLocked().equals(Boolean.TRUE)) {
            LOG.debug((Object)("This topic is locked " + topic));
            return false;
        }
        if (topic.getDraft() == null || topic.getDraft().equals(Boolean.TRUE)) {
            LOG.debug((Object)("This topic is at draft stage " + topic));
        }
        try {
            if (this.checkBaseConditions(topic, forum)) {
                return true;
            }
            if (topic.getLocked() == null || topic.getLocked().equals(Boolean.TRUE)) {
                LOG.debug((Object)("This topic is locked " + topic));
                return false;
            }
            if (topic.getDraft() == null || topic.getDraft().equals(Boolean.TRUE)) {
                LOG.debug((Object)("This topic is at draft stage " + topic));
            }
            Iterator iter = this.getTopicItemsByCurrentUser(topic);
            while (iter.hasNext()) {
                DBMembershipItem item = (DBMembershipItem)iter.next();
                if (!item.getPermissionLevel().getMarkAsRead().booleanValue() || !forum.getDraft().equals(Boolean.FALSE) || !forum.getLocked().equals(Boolean.FALSE) || !topic.getDraft().equals(Boolean.FALSE) || !topic.getLocked().equals(Boolean.FALSE)) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public boolean isModeratePostings(DiscussionTopic topic, DiscussionForum forum) {
        return this.isModeratePostings(topic, forum, this.getCurrentUserId());
    }

    public boolean isModeratePostings(DiscussionTopic topic, DiscussionForum forum, String userId) {
        return this.isModeratePostings(topic, forum, userId, this.getContextId());
    }

    public boolean isModeratePostings(DiscussionTopic topic, DiscussionForum forum, String userId, String siteId) {
        return this.isModeratePostings(topic.getId(), forum.getLocked(), forum.getDraft(), topic.getLocked(), topic.getDraft(), userId, siteId);
    }

    public boolean isModeratePostings(Long topicId, Boolean isForumLocked, Boolean isForumDraft, Boolean isTopicLocked, Boolean isTopicDraft, String userId, String siteId) {
        if (this.checkBaseConditions(null, null, userId, "/site/" + siteId)) {
            return true;
        }
        try {
            if (this.checkBaseConditions(null, null, userId, "/site/" + siteId)) {
                return true;
            }
            if (isTopicDraft == null || isTopicDraft.equals(Boolean.TRUE)) {
                LOG.debug((Object)("This topic is at draft stage " + topicId));
            }
            Iterator iter = this.getTopicItemsByUser(topicId, userId, siteId);
            while (iter.hasNext()) {
                DBMembershipItem item = (DBMembershipItem)iter.next();
                if (!item.getPermissionLevel().getModeratePostings().booleanValue() || !isForumDraft.equals(Boolean.FALSE) || !isTopicDraft.equals(Boolean.FALSE)) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public List getCurrentUserMemberships() {
        return this.getCurrentUserMemberships(this.getContextId());
    }

    public List getCurrentUserMemberships(String siteId) {
        ArrayList<String> userMemberships = new ArrayList<String>();
        String currRole = this.getCurrentUserRole(siteId);
        userMemberships.add(currRole);
        try {
            Collection groups = ThreadLocalManager.get((String)"message_center_current_member_groups") != null ? (Collection)ThreadLocalManager.get((String)"message_center_current_member_groups") : SiteService.getSite((String)this.toolManager.getCurrentPlacement().getContext()).getGroupsWithMember(this.getCurrentUserId());
            for (Group currentGroup : groups) {
                if (currentGroup == null) continue;
                userMemberships.add(currentGroup.getTitle());
            }
        }
        catch (IdUnusedException iue) {
            LOG.debug((Object)"No memberships found");
        }
        return userMemberships;
    }

    private Iterator getGroupsByCurrentUser() {
        ArrayList<String> memberof = new ArrayList<String>();
        try {
            Collection groups = SiteService.getSite((String)this.toolManager.getCurrentPlacement().getContext()).getGroupsWithMember(this.getCurrentUserId());
            for (Group currentGroup : groups) {
                memberof.add(currentGroup.getId());
            }
        }
        catch (IdUnusedException e) {
            LOG.debug((Object)"Group not found");
        }
        return memberof.iterator();
    }

    private Iterator getGroupNamesByCurrentUser(String siteId) {
        ArrayList<String> memberof = new ArrayList<String>();
        try {
            Collection groups = SiteService.getSite((String)siteId).getGroupsWithMember(this.getCurrentUserId());
            for (Group currentGroup : groups) {
                memberof.add(currentGroup.getTitle());
            }
        }
        catch (IdUnusedException e) {
            LOG.debug((Object)"Group not found");
        }
        return memberof.iterator();
    }

    private DBMembershipItem getAreaItemByUserRole() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getAreaItemByUserRole()");
        }
        Set membershipItems = this.forumManager.getDiscussionForumArea().getMembershipItemSet();
        return this.forumManager.getDBMember(membershipItems, this.getCurrentUserRole(), DBMembershipItem.TYPE_ROLE);
    }

    private Iterator getAreaItemsByCurrentUser() {
        Set areaItemsInThread;
        DBMembershipItem item;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getAreaItemsByCurrentUser()");
        }
        ArrayList<DBMembershipItem> areaItems = new ArrayList<DBMembershipItem>();
        if (ThreadLocalManager.get((String)"message_center_permission_set") == null || !((Boolean)ThreadLocalManager.get((String)"message_center_permission_set")).booleanValue()) {
            this.initMembershipForSite();
        }
        if ((item = this.forumManager.getDBMember(areaItemsInThread = (Set)ThreadLocalManager.get((String)"message_center_membership_area"), this.getCurrentUserRole(), DBMembershipItem.TYPE_ROLE)) != null) {
            areaItems.add(item);
        }
        try {
            Collection groups = (Collection)ThreadLocalManager.get((String)"message_center_current_member_groups");
            if (groups != null) {
                for (Group currentGroup : groups) {
                    DBMembershipItem groupItem = this.forumManager.getDBMember(areaItemsInThread, currentGroup.getTitle(), DBMembershipItem.TYPE_GROUP);
                    if (groupItem == null) continue;
                    areaItems.add(groupItem);
                }
            }
        }
        catch (Exception iue) {
            iue.printStackTrace();
        }
        return areaItems.iterator();
    }

    public Set getAreaItemsSet(Area area) {
        if (ThreadLocalManager.get((String)"message_center_permission_set") == null || !((Boolean)ThreadLocalManager.get((String)"message_center_permission_set")).booleanValue()) {
            this.initMembershipForSite();
        }
        Set allAreaSet = (Set)ThreadLocalManager.get((String)"message_center_membership_area");
        HashSet<DBMembershipItemImpl> returnSet = new HashSet<DBMembershipItemImpl>();
        if (allAreaSet != null) {
            for (DBMembershipItemImpl thisItem : allAreaSet) {
                if (thisItem.getArea() == null || area.getId() == null || !area.getId().equals(thisItem.getArea().getId())) continue;
                returnSet.add(thisItem);
            }
        }
        return returnSet;
    }

    private Iterator getForumItemsByCurrentUser(DiscussionForum forum) {
        DBMembershipItem item;
        ArrayList<DBMembershipItem> forumItems = new ArrayList<DBMembershipItem>();
        if (ThreadLocalManager.get((String)"message_center_permission_set") == null || !((Boolean)ThreadLocalManager.get((String)"message_center_permission_set")).booleanValue()) {
            this.initMembershipForSite();
        }
        Set forumItemsInThread = (Set)ThreadLocalManager.get((String)"message_center_membership_forum");
        HashSet<Object> thisForumItemSet = new HashSet<Object>();
        for (DBMembershipItemImpl thisItem : forumItemsInThread) {
            if (thisItem.getForum() == null || forum.getId() == null || !forum.getId().equals(thisItem.getForum().getId())) continue;
            thisForumItemSet.add(thisItem);
        }
        if (thisForumItemSet.size() == 0 && this.getAnonRole() && ".anon".equals(forum.getCreatedBy()) && forum.getTopicsSet() == null) {
            Set newForumMembershipset = forum.getMembershipItemSet();
            for (DBMembershipItem item2 : newForumMembershipset) {
                if (!".anon".equals(item2.getName())) continue;
                thisForumItemSet.add(item2);
            }
        }
        if ((item = this.forumManager.getDBMember(thisForumItemSet, this.getCurrentUserRole(), DBMembershipItem.TYPE_ROLE)) != null) {
            forumItems.add(item);
        }
        try {
            Collection groups = (Collection)ThreadLocalManager.get((String)"message_center_current_member_groups");
            if (groups != null) {
                for (Group currentGroup : groups) {
                    DBMembershipItem groupItem = this.forumManager.getDBMember(thisForumItemSet, currentGroup.getTitle(), DBMembershipItem.TYPE_GROUP);
                    if (groupItem == null) continue;
                    forumItems.add(groupItem);
                }
            }
        }
        catch (Exception iue) {
            iue.printStackTrace();
        }
        return forumItems.iterator();
    }

    public Set getForumItemsSet(DiscussionForum forum) {
        if (ThreadLocalManager.get((String)"message_center_permission_set") == null || !((Boolean)ThreadLocalManager.get((String)"message_center_permission_set")).booleanValue()) {
            this.initMembershipForSite();
        }
        Set allForumSet = (Set)ThreadLocalManager.get((String)"message_center_membership_forum");
        HashSet<DBMembershipItemImpl> returnSet = new HashSet<DBMembershipItemImpl>();
        for (DBMembershipItemImpl thisItem : allForumSet) {
            if (thisItem.getForum() == null || forum.getId() == null || !forum.getId().equals(thisItem.getForum().getId())) continue;
            returnSet.add(thisItem);
        }
        return returnSet;
    }

    private Iterator getTopicItemsByCurrentUser(DiscussionTopic topic) {
        return this.getTopicItemsByUser(topic, this.getCurrentUserId());
    }

    private Iterator getTopicItemsByUser(DiscussionTopic topic, String userId) {
        return this.getTopicItemsByUser(topic, userId, this.getContextId());
    }

    private Iterator getTopicItemsByUser(DiscussionTopic topic, String userId, String siteId) {
        return this.getTopicItemsByUser(topic.getId(), userId, siteId);
    }

    private Iterator getTopicItemsByUser(Long topicId, String userId, String siteId) {
        ArrayList<DBMembershipItem> topicItems = new ArrayList<DBMembershipItem>();
        if (ThreadLocalManager.get((String)"message_center_permission_set") == null || !((Boolean)ThreadLocalManager.get((String)"message_center_permission_set")).booleanValue()) {
            this.initMembershipForSite(siteId, userId);
        }
        Set topicItemsInThread = (Set)ThreadLocalManager.get((String)"message_center_membership_topic");
        HashSet<DBMembershipItemImpl> thisTopicItemSet = new HashSet<DBMembershipItemImpl>();
        for (DBMembershipItemImpl thisItem : topicItemsInThread) {
            if (thisItem.getTopic() == null || !topicId.equals(thisItem.getTopic().getId())) continue;
            thisTopicItemSet.add(thisItem);
        }
        DBMembershipItem item = this.forumManager.getDBMember(thisTopicItemSet, this.getUserRole(siteId, userId), DBMembershipItem.TYPE_ROLE, "/site/" + siteId);
        if (item != null) {
            topicItems.add(item);
        }
        try {
            Collection groups = (Collection)ThreadLocalManager.get((String)"message_center_current_member_groups");
            if (groups != null) {
                for (Group currentGroup : groups) {
                    DBMembershipItem groupItem = this.forumManager.getDBMember(thisTopicItemSet, currentGroup.getTitle(), DBMembershipItem.TYPE_GROUP, "/site/" + siteId);
                    if (groupItem == null) continue;
                    topicItems.add(groupItem);
                }
            }
        }
        catch (Exception iue) {
            iue.printStackTrace();
        }
        return topicItems.iterator();
    }

    public Set getTopicItemsSet(DiscussionTopic topic) {
        if (ThreadLocalManager.get((String)"message_center_permission_set") == null || !((Boolean)ThreadLocalManager.get((String)"message_center_permission_set")).booleanValue()) {
            this.initMembershipForSite();
        }
        Set allTopicSet = (Set)ThreadLocalManager.get((String)"message_center_membership_topic");
        HashSet<DBMembershipItemImpl> returnSet = new HashSet<DBMembershipItemImpl>();
        for (DBMembershipItemImpl thisItem : allTopicSet) {
            if (thisItem.getTopic() == null || topic.getId() == null || !topic.getId().equals(thisItem.getTopic().getId())) continue;
            returnSet.add(thisItem);
        }
        return returnSet;
    }

    public boolean isInstructor() {
        LOG.debug((Object)"isInstructor()");
        return this.isInstructor(UserDirectoryService.getCurrentUser());
    }

    private boolean isInstructor(User user) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isInstructor(User " + user + ")"));
        }
        if (user != null) {
            return this.securityService.unlock(user, "site.upd", this.getContextSiteId());
        }
        return false;
    }

    private String getContextSiteId() {
        LOG.debug((Object)"getContextSiteId()");
        return "/site/" + this.toolManager.getCurrentPlacement().getContext();
    }

    public void setPermissionLevelManager(PermissionLevelManager permissionLevelManager) {
        this.permissionLevelManager = permissionLevelManager;
    }

    private String getCurrentUserId() {
        LOG.debug((Object)"getCurrentUserId()");
        if (TestUtil.isRunningTests()) {
            return "test-user";
        }
        if (this.sessionManager.getCurrentSessionUserId() == null && this.getAnonRole()) {
            return ".anon";
        }
        return this.sessionManager.getCurrentSessionUserId();
    }

    private String getCurrentUserRole() {
        return this.getCurrentUserRole(this.getContextId());
    }

    private String getCurrentUserRole(String siteId) {
        LOG.debug((Object)"getCurrentUserRole()");
        if (this.authzGroupService.getUserRole(this.getCurrentUserId(), "/site/" + siteId) == null && this.sessionManager.getCurrentSessionUserId() == null && this.getAnonRole()) {
            return ".anon";
        }
        return this.authzGroupService.getUserRole(this.getCurrentUserId(), "/site/" + siteId);
    }

    private String getUserRole(String siteId, String userId) {
        String userRole;
        LOG.debug((Object)"getCurrentUserRole()");
        HashMap<String, String> roleMap = (HashMap<String, String>)ThreadLocalManager.get((String)"message_center_user_role_map");
        if (roleMap == null) {
            roleMap = new HashMap<String, String>();
        }
        if ((userRole = (String)roleMap.get(siteId + "-" + userId)) == null) {
            userRole = this.authzGroupService.getUserRole(userId, "/site/" + siteId);
            roleMap.put(siteId + "-" + userId, userRole);
            ThreadLocalManager.set((String)"message_center_user_role_map", roleMap);
        }
        if (userRole == null && this.sessionManager.getCurrentSessionUserId() == null && this.getAnonRole()) {
            return ".anon";
        }
        return userRole;
    }

    public boolean getAnonRole() {
        return this.forumManager.getAnonRole();
    }

    private String getContextId() {
        LOG.debug((Object)"getContextId()");
        if (TestUtil.isRunningTests()) {
            return "test-context";
        }
        Placement placement = this.toolManager.getCurrentPlacement();
        String presentSiteId = placement.getContext();
        return presentSiteId;
    }

    private boolean isSuperUser() {
        return this.isSuperUser(this.getCurrentUserId());
    }

    private boolean isSuperUser(String userId) {
        LOG.debug((Object)" isSuperUser()");
        return this.securityService.isSuperUser(userId);
    }

    private boolean checkBaseConditions(DiscussionTopic topic, DiscussionForum forum) {
        return this.checkBaseConditions(topic, forum, this.getCurrentUserId(), this.getContextId());
    }

    private boolean checkBaseConditions(DiscussionTopic topic, DiscussionForum forum, String userId, String contextSiteId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("checkBaseConditions(DiscussionTopic " + topic + ", DiscussionForum " + forum + ")"));
        }
        return this.isSuperUser(userId);
    }

    private boolean isRoleMember(String roleId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isRoleMember(String " + roleId + ")"));
        }
        return this.getCurrentUserRole().equals(roleId);
    }

    private boolean isGroupMember(String groupId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setAuthzGroupService(AuthzGroupService " + this.authzGroupService + ")"));
        }
        try {
            Collection groups = SiteService.getSite((String)this.toolManager.getCurrentPlacement().getContext()).getGroupsWithMember(this.getCurrentUserId());
            for (Group currentGroup : groups) {
                if (!currentGroup.getId().equals(groupId)) continue;
                return true;
            }
        }
        catch (IdUnusedException e) {
            LOG.debug((Object)("Group with id " + groupId + " not found"));
            return false;
        }
        return false;
    }

    private void initMembershipForSite() {
        this.initMembershipForSite(this.getContextId());
    }

    private void initMembershipForSite(String contextSiteId) {
        this.initMembershipForSite(contextSiteId, this.getCurrentUserId());
    }

    private void initMembershipForSite(String siteId, String userId) {
        if (ThreadLocalManager.get((String)"message_center_permission_set") != null && ((Boolean)ThreadLocalManager.get((String)"message_center_permission_set")).booleanValue()) {
            return;
        }
        Area dfa = this.forumManager.getDiscussionForumArea(siteId);
        Set areaItems = dfa.getMembershipItemSet();
        List forumItemsList = this.permissionLevelManager.getAllMembershipItemsForForumsForSite(dfa.getId());
        List topicItemsList = this.permissionLevelManager.getAllMembershipItemsForTopicsForSite(dfa.getId());
        HashSet<DBMembershipItemImpl> forumItems = new HashSet<DBMembershipItemImpl>();
        for (DBMembershipItemImpl forumItem : forumItemsList) {
            forumItems.add(forumItem);
        }
        HashSet<DBMembershipItemImpl> topicItems = new HashSet<DBMembershipItemImpl>();
        for (DBMembershipItemImpl topicItem : topicItemsList) {
            topicItems.add(topicItem);
        }
        Collection groups = null;
        try {
            Site currentSite = SiteService.getSite((String)siteId);
            groups = currentSite.getGroupsWithMember(userId);
        }
        catch (IdUnusedException iue) {
            iue.printStackTrace();
        }
        ThreadLocalManager.set((String)"message_center_current_member_groups", (Object)groups);
        ThreadLocalManager.set((String)"message_center_membership_area", (Object)areaItems);
        ThreadLocalManager.set((String)"message_center_membership_forum", forumItems);
        ThreadLocalManager.set((String)"message_center_membership_topic", topicItems);
        ThreadLocalManager.set((String)"message_center_permission_set", (Object)true);
    }
}

