/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.access.tool;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.cheftool.VmServlet;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.entity.api.EntityAccessOverloadException;
import org.sakaiproject.entity.api.EntityCopyrightException;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityNotDefinedException;
import org.sakaiproject.entity.api.EntityPermissionException;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.HttpAccess;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.tool.api.ActiveTool;
import org.sakaiproject.tool.api.ActiveToolManager;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.ToolException;
import org.sakaiproject.util.BaseResourceProperties;
import org.sakaiproject.util.BasicAuth;
import org.sakaiproject.util.ParameterParser;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.Validator;
import org.sakaiproject.util.Web;
import org.sakaiproject.util.api.FormattedText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessServlet
extends VmServlet {
    private static final Logger log = LoggerFactory.getLogger(AccessServlet.class);
    protected static ResourceLoader rb = new ResourceLoader("access");
    protected static final boolean STREAM_CONTENT = true;
    protected static final int STREAM_BUFFER_SIZE = 102400;
    protected static final String FORM_VALUE_DELIMETER = "^";
    protected boolean m_ready = false;
    protected static final String COPYRIGHT_PATH = "/copyright";
    protected static final String COPYRIGHT_REQUIRE = "/require";
    protected static final String COPYRIGHT_ACCEPT = "/accept";
    protected static final String COPYRIGHT_ACCEPT_REF = "ref";
    protected static final String COPYRIGHT_ACCEPT_URL = "url";
    protected static final String COPYRIGHT_ACCEPTED_REFS_ATTR = "Access.Copyright.Accepted";
    protected BasicAuth basicAuth = null;
    protected SecurityService securityService;
    protected EntityManager entityManager;
    protected ActiveToolManager activeToolManager;
    protected SessionManager sessionManager;
    protected FormattedText formattedText;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.startInit();
        this.basicAuth = new BasicAuth();
        this.basicAuth.init();
        this.securityService = (SecurityService)ComponentManager.get(SecurityService.class);
        this.entityManager = (EntityManager)ComponentManager.get(EntityManager.class);
        this.activeToolManager = (ActiveToolManager)ComponentManager.get(ActiveToolManager.class);
        this.sessionManager = (SessionManager)ComponentManager.get(SessionManager.class);
        this.formattedText = (FormattedText)ComponentManager.get(FormattedText.class);
    }

    public void startInit() {
        new AccessServletInit();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.basicAuth.doLogin(req);
        String option = req.getPathInfo();
        String[] parts = option.split("/");
        if (parts.length == 2 && parts[1].equals("login")) {
            this.doLogin(req, res, null);
        } else {
            this.dispatch(req, res);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.basicAuth.doLogin(req);
        String option = req.getPathInfo();
        String[] parts = option.split("/");
        if (parts.length == 2 && parts[1].equals("login")) {
            this.doLogin(req, res, null);
        } else {
            this.sendError(res, 404);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        ParameterParser params = (ParameterParser)req.getAttribute("sakai.wrapper.params");
        String path = params.getPath();
        if (path == null) {
            path = "";
        }
        if (!this.m_ready) {
            this.sendError(res, 503);
            return;
        }
        if (COPYRIGHT_PATH.equals(path)) {
            this.respondCopyrightAlertDemo(req, res);
            return;
        }
        if (COPYRIGHT_REQUIRE.equals(path)) {
            String acceptedRef = req.getParameter(COPYRIGHT_ACCEPT_REF);
            String returnPath = req.getParameter(COPYRIGHT_ACCEPT_URL);
            Reference aRef = this.entityManager.newReference(acceptedRef);
            this.securityService.pushAdvisor(new SecurityAdvisor(){

                public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                    return SecurityAdvisor.SecurityAdvice.ALLOWED;
                }
            });
            ResourceProperties props = aRef.getProperties();
            this.securityService.popAdvisor();
            if (props == null) {
                this.sendError(res, 404);
            }
            this.setVmReference("validator", new Validator(), req);
            this.setVmReference("formattedText", this.formattedText, req);
            this.setVmReference("props", props, req);
            this.setVmReference("tlang", rb, req);
            String acceptPath = Web.returnUrl((HttpServletRequest)req, (String)("/accept?ref=" + this.formattedText.escapeUrl(aRef.getReference()) + "&" + COPYRIGHT_ACCEPT_URL + "=" + this.formattedText.escapeUrl(returnPath)));
            this.setVmReference("accept", acceptPath, req);
            res.setContentType("text/html; charset=UTF-8");
            this.includeVm("vm/access/copyrightAlert.vm", req, res);
            return;
        }
        Vector<String> accepted = (Vector<String>)this.sessionManager.getCurrentSession().getAttribute(COPYRIGHT_ACCEPTED_REFS_ATTR);
        if (accepted == null) {
            accepted = new Vector<String>();
            this.sessionManager.getCurrentSession().setAttribute(COPYRIGHT_ACCEPTED_REFS_ATTR, accepted);
        }
        if (COPYRIGHT_ACCEPT.equals(path)) {
            String acceptedRef = req.getParameter(COPYRIGHT_ACCEPT_REF);
            Reference aRef = this.entityManager.newReference(acceptedRef);
            accepted.add(aRef.getReference());
            String returnPath = this.formattedText.escapeUrl(req.getParameter(COPYRIGHT_ACCEPT_URL));
            try {
                res.sendRedirect(Web.returnUrl((HttpServletRequest)req, (String)returnPath));
            }
            catch (IOException e) {
                this.sendError(res, 404);
            }
            return;
        }
        String origPath = path;
        path = this.preProcessPath(path, req);
        Reference ref = this.entityManager.newReference(path);
        AccessServletInfo info = this.newInfo(req);
        try {
            EntityProducer service = ref.getEntityProducer();
            if (service == null) {
                throw new EntityNotDefinedException(ref.getReference());
            }
            HttpAccess access = service.getHttpAccess();
            if (access == null) {
                throw new EntityNotDefinedException(ref.getReference());
            }
            access.handleAccess(req, res, ref, accepted);
        }
        catch (EntityNotDefinedException e) {
            log.debug("dispatch(): ref: " + ref.getReference(), (Throwable)e);
            this.sendError(res, 404);
            return;
        }
        catch (EntityPermissionException e) {
            if (this.sessionManager.getCurrentSessionUserId() == null) {
                try {
                    this.doLogin(req, res, origPath);
                }
                catch (IOException access) {
                    // empty catch block
                }
                return;
            }
            log.debug("dispatch(): ref: " + ref.getReference(), (Throwable)e);
            this.sendError(res, 403);
        }
        catch (EntityAccessOverloadException e) {
            log.info("dispatch(): ref: " + ref.getReference(), (Throwable)e);
            this.sendError(res, 503);
        }
        catch (EntityCopyrightException e) {
            try {
                String redirPath = "/require?ref=" + this.formattedText.escapeUrl(e.getReference()) + "&" + COPYRIGHT_ACCEPT_URL + "=" + this.formattedText.escapeUrl(req.getPathInfo());
                res.sendRedirect(Web.returnUrl((HttpServletRequest)req, (String)redirPath));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        catch (Throwable e) {
            log.warn("dispatch(): exception: ", e);
            this.sendError(res, 500);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("from:" + req.getRemoteAddr() + " path:" + params.getPath() + " options: " + info.optionsString() + " time: " + info.getElapsedTime());
            }
        }
    }

    protected String preProcessPath(String path, HttpServletRequest req) {
        return path;
    }

    protected void respondCopyrightAlertDemo(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        BaseResourceProperties props = new BaseResourceProperties();
        this.setVmReference("props", props, req);
        this.setVmReference("validator", new Validator(), req);
        this.setVmReference("formattedText", this.formattedText, req);
        this.setVmReference("sample", Boolean.TRUE.toString(), req);
        this.setVmReference("tlang", rb, req);
        res.setContentType("text/html; charset=UTF-8");
        this.includeVm("vm/access/copyrightAlert.vm", req, res);
    }

    protected void doLogin(HttpServletRequest req, HttpServletResponse res, String path) throws ToolException, IOException {
        if (this.basicAuth.doAuth(req, res)) {
            log.info("BASIC Auth Request Sent to the Browser ");
            return;
        }
        if (req.getHeader("Range") != null) {
            this.sendError(res, 403);
            return;
        }
        Session session = this.sessionManager.getCurrentSession();
        if (path != null) {
            session.setAttribute("sakai.tool.helper.done.url", (Object)Web.returnUrl((HttpServletRequest)req, (String)this.formattedText.escapeUrl(path)));
        }
        if (session.getAttribute("sakai.tool.helper.done.url") == null) {
            log.warn("doLogin - proceeding with null HELPER_DONE_URL");
        }
        ActiveTool tool = this.activeToolManager.getActiveTool("sakai.login");
        String context = req.getContextPath() + req.getServletPath() + "/login";
        tool.help(req, res, context, "/login");
    }

    protected AccessServletInfo newInfo(HttpServletRequest req) {
        return new AccessServletInfo(req);
    }

    protected void sendError(HttpServletResponse res, int code) {
        try {
            res.sendError(code);
        }
        catch (Throwable t) {
            log.warn("sendError: " + t);
        }
    }

    public class SimpleSecurityAdvisor
    implements SecurityAdvisor {
        protected String m_userId;
        protected String m_function;
        protected String m_reference;

        public SimpleSecurityAdvisor(String userId, String function, String reference) {
            this.m_userId = userId;
            this.m_function = function;
            this.m_reference = reference;
        }

        public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
            SecurityAdvisor.SecurityAdvice rv = SecurityAdvisor.SecurityAdvice.PASS;
            if (this.m_userId.equals(userId) && this.m_function.equals(function) && this.m_reference.equals(reference)) {
                rv = SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
            return rv;
        }
    }

    public class AccessServletInfo {
        protected long m_startTime = System.currentTimeMillis();
        protected Properties m_options = new Properties();

        public long getStartTime() {
            return this.m_startTime;
        }

        public long getElapsedTime() {
            return System.currentTimeMillis() - this.m_startTime;
        }

        public AccessServletInfo(HttpServletRequest req) {
            String type = req.getContentType();
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String[] values = req.getParameterValues(key);
                if (values.length == 1) {
                    this.m_options.put(key, values[0]);
                    continue;
                }
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < values.length; ++i) {
                    buf.append(values[i] + AccessServlet.FORM_VALUE_DELIMETER);
                }
                this.m_options.put(key, buf.toString());
            }
        }

        public String optionsString() {
            StringBuilder buf = new StringBuilder(1024);
            Enumeration<Object> e = this.m_options.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String o = this.m_options.getProperty(key);
                if (!(o instanceof String)) continue;
                buf.append(key);
                buf.append("=");
                if (key.equals("password")) {
                    buf.append("*****");
                } else {
                    buf.append(o.toString());
                }
                buf.append("&");
            }
            return buf.toString();
        }
    }

    public class AccessServletInit
    extends Thread {
        public AccessServletInit() {
            AccessServlet.this.m_ready = false;
            this.start();
        }

        @Override
        public void run() {
            AccessServlet.this.m_ready = true;
        }
    }
}

