/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.access.tool;

import java.io.IOException;
import java.io.InputStream;
import java.time.Year;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.sakaiproject.access.tool.AccessServlet;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.content.api.ContentCollection;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.api.ContentResourceEdit;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.InconsistentException;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServlet
extends AccessServlet {
    private static final Logger log = LoggerFactory.getLogger(WebServlet.class);
    protected ContentHostingService contentHostingService;
    protected UserDirectoryService userDirectoryService;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.contentHostingService = (ContentHostingService)ComponentManager.get(ContentHostingService.class);
        this.userDirectoryService = (UserDirectoryService)ComponentManager.get(UserDirectoryService.class);
    }

    private void setSession(HttpServletRequest req) {
        Session session;
        String sessionId = req.getParameter("session");
        if (sessionId != null && (session = this.sessionManager.getSession(sessionId)) != null) {
            session.setActive();
            this.sessionManager.setCurrentSession(session);
        }
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.setSession(req);
        super.dispatch(req, res);
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String option = req.getPathInfo();
        String[] parts = option.split("/");
        if (parts.length == 2 && parts[1].equals("login")) {
            this.doLogin(req, res, null);
        } else if (FileUpload.isMultipartContent((HttpServletRequest)req)) {
            this.setSession(req);
            this.postUpload(req, res);
        } else {
            this.sendError(res, 404);
        }
    }

    @Override
    protected String preProcessPath(String path, HttpServletRequest req) {
        if ("/".equals(path) && !req.getRequestURI().endsWith("/")) {
            return "/content";
        }
        return "/content" + path;
    }

    protected void postUpload(HttpServletRequest req, HttpServletResponse res) {
        String path = req.getPathInfo();
        log.debug("path {}", (Object)path);
        if (path == null) {
            path = "";
        }
        Enumeration e = req.getAttributeNames();
        while (e.hasMoreElements()) {
            String iname = (String)e.nextElement();
            log.debug("Item {}", (Object)iname);
            Object o = req.getAttribute(iname);
            if (o == null || !(o instanceof FileItem)) continue;
            FileItem fi = (FileItem)o;
            try {
                InputStream inputStream = fi.getInputStream();
                Throwable throwable = null;
                try {
                    if (this.writeFile(fi.getName(), fi.getContentType(), inputStream, path, req, res, true)) continue;
                    return;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException ioe) {
                log.warn("Problem getting InputStream", (Throwable)ioe);
            }
        }
    }

    protected boolean writeFile(String name, String type, InputStream inputStream, String dir, HttpServletRequest req, HttpServletResponse resp, boolean mkdir) {
        try {
            int i = name.lastIndexOf("/");
            if (i >= 0) {
                name = name.substring(i + 1);
            }
            if (name.length() < 1) {
                log.debug("no name left / removal");
                resp.sendError(403);
                return false;
            }
            if (!(dir = this.preProcessPath(dir, req)).endsWith("/")) {
                dir = dir + "/";
            }
            Reference ref = this.entityManager.newReference(dir);
            dir = ref.getId();
            String path = dir + name;
            ResourcePropertiesEdit resourceProperties = this.contentHostingService.newResourceProperties();
            try {
                log.debug("Trying Del {}", (Object)path);
                boolean isCollection = this.contentHostingService.getProperties(path).getBooleanProperty("CHEF:is-collection");
                if (isCollection) {
                    log.debug("Can't del, iscoll");
                    resp.sendError(403);
                    return false;
                }
                ContentResourceEdit edit = this.contentHostingService.editResource(path);
                log.debug("Got edit");
                this.contentHostingService.removeResource(edit);
            }
            catch (IdUnusedException isCollection) {
            }
            catch (Exception e) {
                log.debug("Can't del, exception {}: {}", e.getClass(), (Object)e.getMessage());
                resp.sendError(403);
                return false;
            }
            try {
                User user = this.userDirectoryService.getCurrentUser();
                String mycopyright = "copyright (c) " + Year.now() + ", " + user.getDisplayName() + ". All Rights Reserved. ";
                resourceProperties.addProperty("CHEF:copyright", mycopyright);
                resourceProperties.addProperty("DAV:displayname", name);
                log.debug("Trying Add {}", (Object)path);
                ContentResource contentResource = this.contentHostingService.addResource(path, type, inputStream, (ResourceProperties)resourceProperties, 0);
            }
            catch (InconsistentException e) {
                if (mkdir) {
                    try {
                        ContentCollection collection = this.contentHostingService.addCollection(dir, (ResourceProperties)resourceProperties);
                        return this.writeFile(name, type, inputStream, dir, req, resp, false);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                log.debug("Add fail, inconsistent");
                resp.sendError(409);
                return false;
            }
            catch (IdUsedException e) {
                log.debug("Add fail, in use");
                log.warn("access post IdUsedException:" + e.getMessage());
                resp.sendError(409);
                return false;
            }
            catch (Exception e) {
                log.debug("Add failed, exception {}: {}", e.getClass(), (Object)e.getMessage());
                resp.sendError(403);
                return false;
            }
        }
        catch (IOException e) {
            log.debug("overall fail IOException {}", (Throwable)e);
        }
        return true;
    }
}

