/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.help.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.sakaiproject.api.app.help.Category;
import org.sakaiproject.api.app.help.Resource;

public class ResourceBean
implements Resource,
Comparable<ResourceBean> {
    private Long id;
    private String docId;
    private String name;
    private Set<String> contexts = new HashSet<String>();
    private String location;
    private String source;
    private Long tstamp;
    private float score;
    private String formattedScore;
    private String defaultForTool;
    private String welcomePage;
    private Category category;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Set<String> getContexts() {
        return this.contexts;
    }

    public void setContexts(Set<String> contexts) {
        this.contexts = contexts;
    }

    public URL getUrl() throws MalformedURLException {
        return new URL(this.getLocation());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Long getTstamp() {
        return this.tstamp;
    }

    public void setTstamp(Long tstamp) {
        this.tstamp = tstamp;
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public String getDefaultForTool() {
        return this.defaultForTool;
    }

    public void setDefaultForTool(String defaultForTool) {
        this.defaultForTool = defaultForTool;
    }

    public String getFormattedScore() {
        this.formattedScore = String.valueOf(this.score);
        int index = this.formattedScore.indexOf(".");
        this.formattedScore = this.formattedScore.substring(0, index + 2);
        return this.formattedScore + "%";
    }

    @Override
    public int compareTo(ResourceBean resourceBean) {
        if (resourceBean.score != 0.0f) {
            return Float.compare(resourceBean.score, this.score);
        }
        return this.id.compareTo(resourceBean.id);
    }

    private String businessKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.docId);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceBean)) {
            return false;
        }
        ResourceBean other = (ResourceBean)obj;
        return this.businessKey().equals(other.businessKey());
    }

    public int hashCode() {
        return this.businessKey().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("docId=");
        sb.append(this.docId);
        sb.append(", name=");
        sb.append(this.name);
        sb.append(", location=");
        sb.append(this.location);
        sb.append(", defaultForTool=");
        sb.append(this.defaultForTool);
        sb.append(", welcomePage=");
        sb.append(this.welcomePage);
        sb.append(", source=");
        sb.append(this.source);
        return sb.toString();
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public String getWelcomePage() {
        return this.welcomePage;
    }

    public void setWelcomePage(String welcomePage) {
        this.welcomePage = welcomePage;
    }
}

