/*
 * Decompiled with CFR 0.152.
 */
package org.scalaexercises.content;

import org.scalaexercises.runtime.model.Exercise;
import scala.None$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class Exercise_doobie__batchUpdates$1$
implements Exercise {
    public static final Exercise_doobie__batchUpdates$1$ MODULE$ = new Exercise_doobie__batchUpdates$1$();
    private static final String name = "batchUpdates";
    private static final Some<String> description = new Some((Object)"<p>Other databases (including PostgreSQL) provide a way to do this in one shot by returning\nmultiple specified columns from the inserted row.</p><pre class=\"scala\"><code class=\"scala\">def insert3(name: String, age: Option[Int]): ConnectionIO[Person] = {\n  sql&quot;insert into person (name, age) values ($name, $age)&quot;\n    .update.withUniqueGeneratedKeys(&quot;id&quot;, &quot;name&quot;, &quot;age&quot;)\n}</code></pre><p>The <code>withUniqueGeneratedKeys</code> specifies that we expect exactly one row back (otherwise an\nexception will be thrown), and requires a list of columns to return.</p><p>This mechanism also works for updates, for databases that support it. In the case of multiple\nrow updates we use <code>withGeneratedKeys</code> and get a <code>Stream[ConnectionIO, Person]</code> back.</p><pre class=\"scala\"><code class=\"scala\">val up = {\n  sql&quot;update person set age = age + 1 where age is not null&quot;\n    .update\n    .withGeneratedKeys[Person](&quot;id&quot;, &quot;name&quot;, &quot;age&quot;)\n}</code></pre><h4> Batch Updates </h4><p><b>doobie</b> supports batch updating via the <code>updateMany</code> and <code>updateManyWithGeneratedKeys</code>\noperations on the <code>Update</code> data type. An <code>Update0</code>, which is the type of an sql&quot;...&quot;.update\nexpression, represents a parameterized statement where the arguments are known. An <code>Update[A]</code>\nis more general, and represents a parameterized statement where the composite argument of\ntype <code>A</code> is not known.\n</p>");
    private static final String code = "type PersonInfo = (String, Option[Short])\n\ndef insertMany(ps: List[PersonInfo]): ConnectionIO[Int] = {\n  val sql = \"insert into person (name, age) values (?, ?)\"\n  Update[PersonInfo](sql).updateMany(ps)\n}\n\n// Some rows to insert\nval data = List[PersonInfo]((\"Frank\", Some(12)), (\"Daddy\", None))\n\nval insertedRows = transactorBlock(insertMany(data)).unsafeRunSync()\n\ninsertedRows should be(res0)";
    private static final String packageName = "doobielib";
    private static final String qualifiedMethod = "doobielib.UpdatesSection.batchUpdates";
    private static final List<String> imports = (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"import cats.implicits._", "import DoobieUtils.PersonTable._", "import UpdatesSectionHelpers._", "import doobie._", "import doobie.implicits._", "import UpdatesSectionHelpers.Person", "import org.scalaexercises.definitions.Section", "import org.scalatest.flatspec.AnyFlatSpec", "import org.scalatest.matchers.should.Matchers"}));
    private static final None$ explanation = None$.MODULE$;

    public String name() {
        return name;
    }

    public Some<String> description() {
        return description;
    }

    public String code() {
        return code;
    }

    public String packageName() {
        return packageName;
    }

    public String qualifiedMethod() {
        return qualifiedMethod;
    }

    public List<String> imports() {
        return imports;
    }

    public None$ explanation() {
        return explanation;
    }

    private Exercise_doobie__batchUpdates$1$() {
    }
}

