/*
 * Decompiled with CFR 0.152.
 */
package org.scalaexercises.content;

import org.scalaexercises.runtime.model.Exercise;
import scala.None$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class Exercise_doobie__dealingWithInClause$1$
implements Exercise {
    public static final Exercise_doobie__dealingWithInClause$1$ MODULE$ = new Exercise_doobie__dealingWithInClause$1$();
    private static final String name = "dealingWithInClause";
    private static final Some<String> description = new Some((Object)"<h4> Dealing with IN Clauses </h4><p>A common irritant when dealing with SQL literals is the desire to inline a sequence of\narguments into an IN clause, but SQL does not support this notion (nor does JDBC do anything\nto assist). doobie supports this via statement fragments.</p><pre class=\"scala\"><code class=\"scala\">def populationIn(range: Range, codes: NonEmptyList[String]) = {\n  val q = fr&quot;&quot;&quot;\n   select code, name, population, gnp\n   from country\n   where population &gt; ${range.min}\n   and   population &lt; ${range.max}\n   and   &quot;&quot;&quot; ++ Fragments.in(fr&quot;code&quot;, codes) // code IN (...)\n  q.query[Country]\n}</code></pre><p>Note that the <code>IN</code> clause must be non-empty, so <code>codes</code> is a <code>NonEmptyList</code>.\n</p>");
    private static final String code = "val countriesName = transactorBlock(\n  populationIn(25000000 to 75000000, NonEmptyList.of(\"ESP\", \"USA\", \"FRA\"))\n    .to[List]).unsafeRunSync()\n  .map(_.name)\n\ncountriesName should be(List(res0, res1))";
    private static final String packageName = "doobielib";
    private static final String qualifiedMethod = "doobielib.ParameterizedQueriesSection.dealingWithInClause";
    private static final List<String> imports = (List)new .colon.colon((Object)"import cats.data.NonEmptyList", (List)new .colon.colon((Object)"import DoobieUtils.CountryTable._", (List)new .colon.colon((Object)"import ParameterizedQueryHelpers._", (List)new .colon.colon((Object)"import org.scalaexercises.definitions.Section", (List)new .colon.colon((Object)"import org.scalatest.flatspec.AnyFlatSpec", (List)new .colon.colon((Object)"import org.scalatest.matchers.should.Matchers", (List)Nil$.MODULE$))))));
    private static final None$ explanation = None$.MODULE$;

    public String name() {
        return name;
    }

    public Some<String> description() {
        return description;
    }

    public String code() {
        return code;
    }

    public String packageName() {
        return packageName;
    }

    public String qualifiedMethod() {
        return qualifiedMethod;
    }

    public List<String> imports() {
        return imports;
    }

    public None$ explanation() {
        return explanation;
    }

    private Exercise_doobie__dealingWithInClause$1$() {
    }
}

