/*
 * Decompiled with CFR 0.152.
 */
package org.scalaexercises.content;

import org.scalaexercises.runtime.model.Exercise;
import scala.None$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class Exercise_doobie__retrieveInfo$1$
implements Exercise {
    public static final Exercise_doobie__retrieveInfo$1$ MODULE$ = new Exercise_doobie__retrieveInfo$1$();
    private static final String name = "retrieveInfo";
    private static final Some<String> description = new Some((Object)"<h4>Retrieving info</h4><p>When we insert we usually want the new row back, so let\u2019s do that. First we\u2019ll do it the hard\nway, by inserting, getting the last used key via <code>lastVal()</code>, then selecting the indicated\nrow.</p><pre class=\"scala\"><code class=\"scala\">def insert2(name: String, age: Option[Short]): ConnectionIO[Person] =\n  for {\n    _ &lt;- sql&quot;insert into person (name, age) values ($name, $age)&quot;.update.run\n    id &lt;- sql&quot;select lastval()&quot;.query[Long].unique\n    p &lt;- sql&quot;select id, name, age from person where id = $id&quot;.query[Person].unique\n  } yield p</code></pre><p>This is irritating but it is supported by all databases (although the \u201cget the last used id\u201d\nfunction will vary by vendor).</p><p>Some database (like H2) allow you to return [only] the inserted id, allowing the above\noperation to be reduced to two statements (see below for an explanation of\n<code>withUniqueGeneratedKeys</code>).\n</p>");
    private static final String code = "def insert2_H2(name: String, age: Option[Int]): ConnectionIO[Person] =\n  for {\n    id <- sql\"insert into person (name, age) values ($name, $age)\".update\n      .withUniqueGeneratedKeys[Int](\"id\")\n    p <- sql\"select id, name, age from person where id = $id\".query[Person].unique\n  } yield p\n\nval person = transactorBlock(insert2_H2(\"Ramone\", Option(42))).unsafeRunSync()\n\nperson.name should be(res0)\nperson.age should be(Option(res1))";
    private static final String packageName = "doobielib";
    private static final String qualifiedMethod = "doobielib.UpdatesSection.retrieveInfo";
    private static final List<String> imports = (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"import cats.implicits._", "import DoobieUtils.PersonTable._", "import UpdatesSectionHelpers._", "import doobie._", "import doobie.implicits._", "import UpdatesSectionHelpers.Person", "import org.scalaexercises.definitions.Section", "import org.scalatest.flatspec.AnyFlatSpec", "import org.scalatest.matchers.should.Matchers"}));
    private static final None$ explanation = None$.MODULE$;

    public String name() {
        return name;
    }

    public Some<String> description() {
        return description;
    }

    public String code() {
        return code;
    }

    public String packageName() {
        return packageName;
    }

    public String qualifiedMethod() {
        return qualifiedMethod;
    }

    public List<String> imports() {
        return imports;
    }

    public None$ explanation() {
        return explanation;
    }

    private Exercise_doobie__retrieveInfo$1$() {
    }
}

