/*
 * Decompiled with CFR 0.152.
 */
package org.scalaexercises.content;

import org.scalaexercises.runtime.model.Exercise;
import scala.None$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class Exercise_doobie__safeInsertWithAttemptSome$1$
implements Exercise {
    public static final Exercise_doobie__safeInsertWithAttemptSome$1$ MODULE$ = new Exercise_doobie__safeInsertWithAttemptSome$1$();
    private static final String name = "safeInsertWithAttemptSome";
    private static final Some<String> description = new Some((Object)"<p>Let's do some exercises where errors will happen and see how to deal with them.</p><p>We're going to work with <code>person</code> table again, where the <code>name</code> column is marked as being\nunique.</p><pre class=\"scala\"><code class=\"scala\">CREATE TABLE IF NOT EXISTS person (\n  id IDENTITY,\n  name VARCHAR NOT NULL UNIQUE,\n  age INT)</code></pre><p>Alright, let\u2019s define a way to insert instances.</p><pre class=\"scala\"><code class=\"scala\">def insert(n: String, a: Option[Int]): ConnectionIO[Long] =\n  sql&quot;insert into person (name, age) values ($n, $a)&quot;\n    .update\n    .withUniqueGeneratedKeys(&quot;id&quot;)</code></pre><p>The following exercises will try to insert two people with the same name. The second\noperation will fail with a unique constraint violation. Let's see how we can avoid this\nerror by using several combinators.</p><p>A first approach could be to specify the <code>Throwable</code> that we want to trap by using\n<code>attemptSql</code> combinator.</p><p>To make simpler the code we built a method which prepares the database, makes the query and transacts\nit all:</p><pre class=\"scala\"><code class=\"scala\">def transactorBlock[A](f: =&gt; ConnectionIO[A]): IO[A] =\n  transactor.use((createPersonTable *&gt; f).transact[IO])</code></pre>");
    private static final String code = "def safeInsert(name: String, age: Option[Int]): ConnectionIO[Either[String, Long]] =\n  insert(name, age).attemptSql.map {\n    case Left(_) => Left(\"Oops!\")\n    case Right(value) => Right(value)\n  }\n\nval insertedRows = for {\n  john <- safeInsert(\"John\", Option(35))\n  otherJohn <- safeInsert(\"John\", Option(20))\n} yield otherJohn\n\nval result = transactorBlock(insertedRows).unsafeRunSync()\n\nresult should be(res0)";
    private static final String packageName = "doobielib";
    private static final String qualifiedMethod = "doobielib.ErrorHandlingSection.safeInsertWithAttemptSome";
    private static final List<String> imports = (List)new .colon.colon((Object)"import DoobieUtils.PersonTable._", (List)new .colon.colon((Object)"import ErrorHandlingSectionHelpers._", (List)new .colon.colon((Object)"import doobie._", (List)new .colon.colon((Object)"import doobie.implicits._", (List)new .colon.colon((Object)"import org.scalaexercises.definitions.Section", (List)new .colon.colon((Object)"import org.scalatest.flatspec.AnyFlatSpec", (List)new .colon.colon((Object)"import org.scalatest.matchers.should.Matchers", (List)Nil$.MODULE$)))))));
    private static final None$ explanation = None$.MODULE$;

    public String name() {
        return name;
    }

    public Some<String> description() {
        return description;
    }

    public String code() {
        return code;
    }

    public String packageName() {
        return packageName;
    }

    public String qualifiedMethod() {
        return qualifiedMethod;
    }

    public List<String> imports() {
        return imports;
    }

    public None$ explanation() {
        return explanation;
    }

    private Exercise_doobie__safeInsertWithAttemptSome$1$() {
    }
}

