/*
 * Decompiled with CFR 0.152.
 */
package org.scalaexercises.content;

import org.scalaexercises.runtime.model.Exercise;
import scala.None$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class Exercise_doobie__safeInsertWithAttemptSomeSqlState$1$
implements Exercise {
    public static final Exercise_doobie__safeInsertWithAttemptSomeSqlState$1$ MODULE$ = new Exercise_doobie__safeInsertWithAttemptSomeSqlState$1$();
    private static final String name = "safeInsertWithAttemptSomeSqlState";
    private static final Some<String> description = new Some((Object)"<p>If we want to trap a specific <code>SqlState</code> like <code>unique constraint violation</code>, we'll use the\n<code>attemptSomeSqlState</code>. We can specify several <code>SqlState</code> values and indicate what value we'll\nreturn in each case. We can:</p><ul><li>Use the <code>SqlState</code> values provided as constants in the contrib-postgresql add-on</li><li>Create a new <code>SqlState</code> value by typing <code>val UNIQUE_VIOLATION = SqlState(&quot;23505&quot;)</code>\n</li></ul>");
    private static final String code = "def safeInsert(name: String, age: Option[Int]): ConnectionIO[Either[String, Long]] =\n  insert(name, age)\n    .attemptSomeSqlState {\n      case FOREIGN_KEY_VIOLATION => \"Another error\"\n      case UNIQUE_VIOLATION => \"John is already here!\"\n    }\n\nval insertedRows = for {\n  john <- safeInsert(\"John\", Option(35))\n  otherJohn <- safeInsert(\"John\", Option(20))\n} yield otherJohn\n\nval result = transactorBlock(insertedRows).unsafeRunSync()\n\nresult should be(res0)";
    private static final String packageName = "doobielib";
    private static final String qualifiedMethod = "doobielib.ErrorHandlingSection.safeInsertWithAttemptSomeSqlState";
    private static final List<String> imports = (List)new .colon.colon((Object)"import DoobieUtils.PersonTable._", (List)new .colon.colon((Object)"import ErrorHandlingSectionHelpers._", (List)new .colon.colon((Object)"import doobie._", (List)new .colon.colon((Object)"import doobie.implicits._", (List)new .colon.colon((Object)"import org.scalaexercises.definitions.Section", (List)new .colon.colon((Object)"import org.scalatest.flatspec.AnyFlatSpec", (List)new .colon.colon((Object)"import org.scalatest.matchers.should.Matchers", (List)Nil$.MODULE$)))))));
    private static final None$ explanation = None$.MODULE$;

    public String name() {
        return name;
    }

    public Some<String> description() {
        return description;
    }

    public String code() {
        return code;
    }

    public String packageName() {
        return packageName;
    }

    public String qualifiedMethod() {
        return qualifiedMethod;
    }

    public List<String> imports() {
        return imports;
    }

    public None$ explanation() {
        return explanation;
    }

    private Exercise_doobie__safeInsertWithAttemptSomeSqlState$1$() {
    }
}

