/*
 * Decompiled with CFR 0.152.
 */
package org.scalaexercises.content;

import org.scalaexercises.runtime.model.Exercise;
import scala.None$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class Exercise_doobie__safeInsertWithExceptSqlState$1$
implements Exercise {
    public static final Exercise_doobie__safeInsertWithExceptSqlState$1$ MODULE$ = new Exercise_doobie__safeInsertWithExceptSqlState$1$();
    private static final String name = "safeInsertWithExceptSqlState";
    private static final Some<String> description = new Some((Object)"<p>Finally we can recover from an error with a new action by using <code>exceptSqlState</code>. In this\ncase, if the name already exists, we'll insert the person with a different name.\n</p>");
    private static final String code = "def safeInsert(name: String, age: Option[Int]): ConnectionIO[Long] =\n  insert(name, age)\n    .exceptSqlState {\n      case UNIQUE_VIOLATION => insert(name + \"_20\", age)\n    }\n\nval insertedRows = for {\n  john <- safeInsert(\"John\", Option(35))\n  otherJohn <- safeInsert(\"John\", Option(20))\n  info <- findPersonById(otherJohn)\n} yield info\n\nval result = transactorBlock(insertedRows).unsafeRunSync()\n\nresult.name should be(res0)\nresult.age should be(res1)";
    private static final String packageName = "doobielib";
    private static final String qualifiedMethod = "doobielib.ErrorHandlingSection.safeInsertWithExceptSqlState";
    private static final List<String> imports = (List)new .colon.colon((Object)"import DoobieUtils.PersonTable._", (List)new .colon.colon((Object)"import ErrorHandlingSectionHelpers._", (List)new .colon.colon((Object)"import doobie._", (List)new .colon.colon((Object)"import doobie.implicits._", (List)new .colon.colon((Object)"import org.scalaexercises.definitions.Section", (List)new .colon.colon((Object)"import org.scalatest.flatspec.AnyFlatSpec", (List)new .colon.colon((Object)"import org.scalatest.matchers.should.Matchers", (List)Nil$.MODULE$)))))));
    private static final None$ explanation = None$.MODULE$;

    public String name() {
        return name;
    }

    public Some<String> description() {
        return description;
    }

    public String code() {
        return code;
    }

    public String packageName() {
        return packageName;
    }

    public String qualifiedMethod() {
        return qualifiedMethod;
    }

    public List<String> imports() {
        return imports;
    }

    public None$ explanation() {
        return explanation;
    }

    private Exercise_doobie__safeInsertWithExceptSqlState$1$() {
    }
}

