/*
 * Decompiled with CFR 0.152.
 */
package org.scalaexercises.content;

import org.scalaexercises.content.Contribution_083c1a0154c1ee1105f7cb0c2a990a17ea2e5ef2$1$;
import org.scalaexercises.content.Contribution_2b363c83ecded4180f2e41b8fdab7d517a170fa7$1$;
import org.scalaexercises.content.Contribution_317a3d1751c3b626f3dbef8c57eb599dbc86f9c7$1$;
import org.scalaexercises.content.Contribution_92242a7a5f40334fcf8ced7ffe80004d735e741a$1$;
import org.scalaexercises.content.Contribution_adc734ec8ff4660f729b32af1e2b575cb5d3fccc$1$;
import org.scalaexercises.content.Contribution_bd6853866cebfdc371fbce48f0270fb098c5d85e$1$;
import org.scalaexercises.content.Contribution_c85571f6d8de6b13a3457282d40d8b2abb08e23d$1$;
import org.scalaexercises.content.Contribution_c855ff73f7d391b37b54316912fc1a50cf1bf431$1$;
import org.scalaexercises.content.Contribution_ce90db584c610fb74d265185809aa5e72094f8e1$1$;
import org.scalaexercises.content.Contribution_f14c2460aae546c4207e81b2e6c089e5d39cf271$1$;
import org.scalaexercises.content.Exercise_doobie__combineTwoPrograms$1$;
import org.scalaexercises.content.Exercise_doobie__combineTwoProgramsWithApplicative$1$;
import org.scalaexercises.content.Exercise_doobie__constantValue$1$;
import org.scalaexercises.content.Exercise_doobie__constantValueFromDatabase$1$;
import org.scalaexercises.runtime.model.Contribution;
import org.scalaexercises.runtime.model.Exercise;
import org.scalaexercises.runtime.model.Section;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class Section_doobie__connectingtodatabase$1$
implements Section {
    public static final Section_doobie__connectingtodatabase$1$ MODULE$ = new Section_doobie__connectingtodatabase$1$();
    private static final String name = "connecting_to_database";
    private static final Some<String> description = new Some((Object)"<h4>Introduction</h4><p>doobie is a monadic API that provides a number of data types that all work the same way\nbut describe computations in different contexts.</p><p>In the doobie high level API the most common types we will deal with have the form\nConnectionIO[A], specifying computations that take place in a context where a\njava.sql.Connection is available, ultimately producing a value of type A.</p><p>doobie programs are values. You can compose small programs to build larger programs. Once you\nhave constructed a program you wish to run, you interpret it into an effectful target monad of\nyour choice (Task or IO for example) and drop it into your main application wherever you like.</p><h4>First programs</h4><p>Before we can use doobie we need to import some symbols. We will use package imports here as a\nconvenience; this will give us the most commonly-used symbols when working with the high-level\nAPI.</p><pre class=\"scala\"><code class=\"scala\">import doobie._\nimport doobie.implicits._</code></pre><p>Let\u2019s also bring in Cats.</p><pre class=\"scala\"><code class=\"scala\">import cats._\nimport cats.effect._\nimport cats.implicits._</code></pre><p>In the doobie high level API the most common types we will deal with have the form <code>ConnectionIO[A]</code>,\nspecifying computations that take place in a context where a <code>java.sql.Connection</code> is available,\nultimately producing a value of type <code>A</code>.</p><p>So let\u2019s start with a <code>ConnectionIO</code> program that simply returns a constant.</p><pre class=\"scala\"><code class=\"scala\">val program1 = 42.pure[ConnectionIO]\n// program1: ConnectionIO[Int] = Pure(42)</code></pre><p>This is a perfectly respectable doobie program, but we can\u2019t run it as-is; we need a <code>Connection</code>\nfirst. There are several ways to do this, but here let\u2019s use a <code>Transactor</code>.</p><p><b>Note</b>: DriverManagerTransactors have the advantage of no connection pooling and configuration, so\nare perfect for testing. The main disadvantage is that it is slower than pooling connection managers,\nno provides upper bound for concurrent connections and executes blocking operations in an unbounded\npool of threads. The <code>doobie-hikari</code> add-on provides a <code>Transactor</code> implementation backed by a HikariCP\nconnection pool. The connection pool is a lifetime-managed object that must be shut down cleanly, so\nit is managed as a Resource.</p><pre class=\"scala\"><code class=\"scala\">import doobie.hikari._\n\n// Resource yielding a transactor configured with a bounded connect EC and an unbounded\n// transaction EC. Everything will be closed and shut down cleanly after use.\nval transactor: Resource[IO, HikariTransactor[IO]] =\n  for {\n    ce &lt;- ExecutionContexts.fixedThreadPool[IO](32) // our connect EC\n    be &lt;- Blocker[IO] // our blocking EC\n    xa &lt;- HikariTransactor.newHikariTransactor[IO](\n      &quot;org.h2.Driver&quot;, // driver classname\n      &quot;jdbc:h2:mem:test;DB_CLOSE_DELAY=-1&quot;, // connect URL\n      &quot;sa&quot;, // username\n      &quot;&quot;, // password\n      ce, // await connection here\n      be // execute JDBC operations here\n    )\n  } yield xa</code></pre><p>A <code>Transactor</code> is a data type that knows how to connect to a database, hand out connections, and\nclean them up; and with this knowledge it can transform <code>ConnectionIO ~&gt; IO</code>, which gives us a\nprogram we can run. Specifically it gives us an <code>IO</code> that, when run, will connect to the database\nand execute single transaction.</p><p>We are using <code>cats.effect.IO</code> as our final effect type, but you can use any monad <code>M[_]</code> given\n<code>cats.effect.Async[M]</code>. See Using Your Own Target Monad at the end of this chapter for more details.\n</p>");
    private static final List<Exercise> exercises = (List)new .colon.colon((Object)Exercise_doobie__constantValue$1$.MODULE$, (List)new .colon.colon((Object)Exercise_doobie__constantValueFromDatabase$1$.MODULE$, (List)new .colon.colon((Object)Exercise_doobie__combineTwoPrograms$1$.MODULE$, (List)new .colon.colon((Object)Exercise_doobie__combineTwoProgramsWithApplicative$1$.MODULE$, (List)Nil$.MODULE$))));
    private static final List<Nothing$> imports = Nil$.MODULE$;
    private static final Some<String> path = new Some((Object)"/src/main/scala/doobie/ConnectingToDatabaseSection.scala");
    private static final List<Contribution> contributions = (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Contribution[]{Contribution_adc734ec8ff4660f729b32af1e2b575cb5d3fccc$1$.MODULE$, Contribution_083c1a0154c1ee1105f7cb0c2a990a17ea2e5ef2$1$.MODULE$, Contribution_92242a7a5f40334fcf8ced7ffe80004d735e741a$1$.MODULE$, Contribution_317a3d1751c3b626f3dbef8c57eb599dbc86f9c7$1$.MODULE$, Contribution_c855ff73f7d391b37b54316912fc1a50cf1bf431$1$.MODULE$, Contribution_ce90db584c610fb74d265185809aa5e72094f8e1$1$.MODULE$, Contribution_c85571f6d8de6b13a3457282d40d8b2abb08e23d$1$.MODULE$, Contribution_f14c2460aae546c4207e81b2e6c089e5d39cf271$1$.MODULE$, Contribution_bd6853866cebfdc371fbce48f0270fb098c5d85e$1$.MODULE$, Contribution_2b363c83ecded4180f2e41b8fdab7d517a170fa7$1$.MODULE$}));

    public String name() {
        return name;
    }

    public Some<String> description() {
        return description;
    }

    public List<Exercise> exercises() {
        return exercises;
    }

    public List<Nothing$> imports() {
        return imports;
    }

    public Some<String> path() {
        return path;
    }

    public List<Contribution> contributions() {
        return contributions;
    }

    private Section_doobie__connectingtodatabase$1$() {
    }
}

