/*
 * Decompiled with CFR 0.152.
 */
package org.scalaexercises.content;

import org.scalaexercises.content.Contribution_317a3d1751c3b626f3dbef8c57eb599dbc86f9c7$2$;
import org.scalaexercises.content.Contribution_5cc598fff33940191974d37b26dd9d824e71cccc$1$;
import org.scalaexercises.content.Contribution_6dc6149374254b84d0c66200531b8bc3eae91f74$1$;
import org.scalaexercises.content.Contribution_92242a7a5f40334fcf8ced7ffe80004d735e741a$6$;
import org.scalaexercises.content.Contribution_adc734ec8ff4660f729b32af1e2b575cb5d3fccc$6$;
import org.scalaexercises.content.Contribution_c85571f6d8de6b13a3457282d40d8b2abb08e23d$6$;
import org.scalaexercises.content.Contribution_c855ff73f7d391b37b54316912fc1a50cf1bf431$6$;
import org.scalaexercises.content.Contribution_ce90db584c610fb74d265185809aa5e72094f8e1$6$;
import org.scalaexercises.content.Contribution_fc4c0d5408af3c40afa3d77fc76e72d87a53b56c$1$;
import org.scalaexercises.content.Exercise_doobie__safeInsertWithAttemptSome$1$;
import org.scalaexercises.content.Exercise_doobie__safeInsertWithAttemptSomeSqlState$1$;
import org.scalaexercises.content.Exercise_doobie__safeInsertWithExceptSqlState$1$;
import org.scalaexercises.runtime.model.Contribution;
import org.scalaexercises.runtime.model.Exercise;
import org.scalaexercises.runtime.model.Section;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class Section_doobie__errorhandling$1$
implements Section {
    public static final Section_doobie__errorhandling$1$ MODULE$ = new Section_doobie__errorhandling$1$();
    private static final String name = "error_handling";
    private static final Some<String> description = new Some((Object)"<h4>About Exceptions</h4><p>Exceptions are a fact of life when interacting with databases, and they are largely nondeterministic;\nwhether an operation will succeed or not depends on unpredictable factors like network health, the\ncurrent contents of tables, locking state, and so on. So we must decide whether to compute everything\nin a disjunction like <code>EitherT[ConnectionIO, Throwable, A]</code> or allow exceptions to propagate until they\nare caught explicitly. doobie adopts the second strategy: exceptions are allowed to propagate and\nescape unless handled explicitly (exactly as IO works). This means when a doobie action (transformed\nto some target monad) is executed, exceptions can escape.</p><p>There are three main types of exceptions that are likely to arise:</p><p><b>1.</b> Various types of <code>IOException</code> can happen with any kind of I/O, and these exceptions tend to be\nunrecoverable.</p><p><b>2.</b> Database exceptions, typically as a generic <code>SQLException</code> with a vendor-specific <code>SQLState</code> identifying the\nspecific error, are raised for common situations such as key violations. Some vendors (PostgreSQL for instance)\npublish a table of error codes, and in these cases doobie can provide a matching set of exception-handling\ncombinators. However in most cases the error codes must be passed down as folklore or discovered by\nexperimentation. There exist the XOPEN and SQL:2003 standards, but it seems that no vendor adheres closely to\nthese specifications. Some of these errors are recoverable and others aren\u2019t.</p><p><b>3.</b> doobie will raise an <code>InvariantViolation</code> in response to invalid type mappings, unknown JDBC constants\nreturned by drivers, observed <code>NULL</code> values, and other violations of invariants that doobie assumes. These exceptions\nindicate programmer error or driver non-compliance and are generally unrecoverable.</p><h4>MonadError and Derived Combinators</h4><p>All <b>doobie</b> monads have associated instances of the <code>Async</code> instance, which extends\n<code>MonadError[?[_], Throwable]</code>. This means <code>ConnectionIO</code>, etc., have the following primitive operations:</p><ul><li><code>attempt</code> converts <code>M[A]</code> into <code>M[Either[Throwable, A]]</code></li><li><code>fail</code> constructs an <code>M[A]</code> that fails with a provided <code>Throwable</code></li></ul><p>So any <b>doobie</b> program can be lifted into a disjunction simply by adding <code>.attempt</code>.</p><pre class=\"scala\"><code class=\"scala\">val p = 42.pure[ConnectionIO]\n// p: ConnectionIO[Int] = Pure(42)\n\np.attempt\n// res0: ConnectionIO[Either[Throwable, Int]] = Suspend(\n//   HandleErrorWith(\n//     FlatMapped(Pure(42), cats.Monad$$Lambda$8968/1197202183@4abff98c),\n//     cats.ApplicativeError$$Lambda$9059/715221672@694b43d5\n//   )\n// )</code></pre><p>From the <code>.attempt</code> and <code>fail</code> combinators we can derive many other operations, as described in the\nCats documentation. In addition doobie provides the following specialized combinators that only pay\nattention to <code>SQLException</code>:</p><ul><li><code>attemptSql</code> is like <code>attempt</code> but only traps <code>SQLException</code>.</li><li><code>attemptSomeSql</code> traps only specified <code>SQLException</code>s.</li><li><code>exceptSql</code> recovers from a SQLException with a new action.</li><li><code>onSqlException</code> executes an action on <code>SQLException</code> and discards its result.</li></ul><p>And finally we have a set of combinators that focus on SQLStates.</p><ul><li><code>attemptSqlState</code> is like <code>attemptSql</code> but yields <code>M[Either[SQLState, A]]</code>.</li><li><code>attemptSomeSqlState</code> traps only specified <code>SQLState</code>s.</li><li><code>exceptSqlState</code> recovers from a <code>SQLState</code> with a new action.</li><li><code>exceptSomeSqlState</code> recovers from specified <code>SQLState</code>s with a new action.\n</li></ul>");
    private static final List<Exercise> exercises = (List)new .colon.colon((Object)Exercise_doobie__safeInsertWithAttemptSome$1$.MODULE$, (List)new .colon.colon((Object)Exercise_doobie__safeInsertWithAttemptSomeSqlState$1$.MODULE$, (List)new .colon.colon((Object)Exercise_doobie__safeInsertWithExceptSqlState$1$.MODULE$, (List)Nil$.MODULE$)));
    private static final List<Nothing$> imports = Nil$.MODULE$;
    private static final Some<String> path = new Some((Object)"/src/main/scala/doobie/ErrorHandlingSection.scala");
    private static final List<Contribution> contributions = (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Contribution[]{Contribution_adc734ec8ff4660f729b32af1e2b575cb5d3fccc$6$.MODULE$, Contribution_92242a7a5f40334fcf8ced7ffe80004d735e741a$6$.MODULE$, Contribution_317a3d1751c3b626f3dbef8c57eb599dbc86f9c7$2$.MODULE$, Contribution_c855ff73f7d391b37b54316912fc1a50cf1bf431$6$.MODULE$, Contribution_ce90db584c610fb74d265185809aa5e72094f8e1$6$.MODULE$, Contribution_c85571f6d8de6b13a3457282d40d8b2abb08e23d$6$.MODULE$, Contribution_6dc6149374254b84d0c66200531b8bc3eae91f74$1$.MODULE$, Contribution_fc4c0d5408af3c40afa3d77fc76e72d87a53b56c$1$.MODULE$, Contribution_5cc598fff33940191974d37b26dd9d824e71cccc$1$.MODULE$}));

    public String name() {
        return name;
    }

    public Some<String> description() {
        return description;
    }

    public List<Exercise> exercises() {
        return exercises;
    }

    public List<Nothing$> imports() {
        return imports;
    }

    public Some<String> path() {
        return path;
    }

    public List<Contribution> contributions() {
        return contributions;
    }

    private Section_doobie__errorhandling$1$() {
    }
}

