/*
 * Scala.js (https://www.scala-js.org/)
 *
 * Copyright EPFL.
 *
 * Licensed under Apache License 2.0
 * (https://www.apache.org/licenses/LICENSE-2.0).
 *
 * See the NOTICE file distributed with this work for
 * additional information regarding copyright ownership.
 */

package scala.scalajs.js

/** Contains special primitives of interoperability with JavaScript which are
 *  of limited importance or rare usefulness.
 *
 *  In theory, all of the members of this package could equally well be part of
 *  the `scala.scalajs.js` package. They are sligthly "hidden" in this
 *  `special` package so that they are not used on a daily basis, but only when
 *  absolutely necessary.
 *
 *  Everything in this package is a "I-know-what-I-am-doing" API. Notably, no
 *  attempt is made to guide the user with types that are not hard
 *  requirements.
 */
package object special {

  /** Tests whether two values are equal according to ECMAScript's
   *  *Strict Equality Comparison* (`===`).
   *
   *  In Scala.js 0.6.x, this is equivalent to `x eq y`. It is provided to ease
   *  cross-compilation with Scala.js 1.x, where the definition of `x eq y` has
   *  been changed such that:
   *
   *  - `strictEquals(NaN, NaN)` is `false` whereas `NaN eq NaN` is `true`
   *  - `strictEquals(+0.0, -0.0)` is `true` whereas `+0.0 eq -0.0` is `false`
   *
   *  @return
   *    the result of `x === y` where `===` is the ECMAScript operator.
   */
  @inline
  def strictEquals(x: scala.Any, y: scala.Any): Boolean =
    x.asInstanceOf[AnyRef] eq y.asInstanceOf[AnyRef]

  /** Deletes a property of an object.
   *
   *  This method is the exact equivalent of the `delete obj[key]` statement
   *  of JavaScript (and by extension of `delete obj.key` if `key` is a
   *  constant string).
   *
   *  The property must be configurable. Otherwise, this method throws a
   *  [[js.TypeError]].
   *
   *  Rather than using this method, it is often preferable to use a
   *  [[js.Dictionary]] and its `-=` method.
   */
  def delete(obj: scala.Any, key: scala.Any): Unit =
    throw new java.lang.Error("stub")

  /** The value of the JavaScript `this` at the top-level of the generated
   *  file.
   *
   *  This returns the value that would be obtained by writing `this` at the
   *  top-level of the JavaScript file generated by Scala.js. In scripts, this
   *  is equivalent to the *global object*, but in other environments, it is
   *  not necessarily the case. For example, in CommonJS modules on Node.js,
   *  `this` is the object representing the `exports` of the current module,
   *  and it is `undefined` in ECMAScript modules.
   *
   *  Using this value should be rare, and mostly limited to writing code
   *  detecting what the global object is. For example, a typical detection
   *  code--in case we do not need to worry of ES modules--looks like:
   *  {{{
   *  val globalObject = {
   *    import js.Dynamic.{global => g}
   *    if (js.typeOf(g.global) != "undefined" && (g.global.Object eq g.Object)) {
   *      // Node.js environment detected
   *      g.global
   *    } else {
   *      // In all other well-known environment, we can use the global `this`
   *      js.special.fileLevelThis
   *    }
   *  }
   *  }}}
   *  Note that the above code is not comprehensive, as there can be JavaScript
   *  environments where the global object cannot be fetched neither through
   *  `global` nor `this`. If your code needs to run in such an environment, it
   *  is up to you to use an appropriate detection procedure.
   */
  @inline
  def fileLevelThis: scala.Any =
    scala.scalajs.runtime.linkingInfo.globalThis

  /** The value of the JavaScript `this` at the top-level of the generated
   *  file.
   *
   *  *Deprecated*: this value does not correspond to JavaScript's
   *  `globalThis` value. Use `fileLevelThis` instead.
   *
   *  This returns the value that would be obtained by writing `this` at the
   *  top-level of the JavaScript file generated by Scala.js. In scripts, this
   *  is equivalent to the *global object*, but in other environments, it is
   *  not necessarily the case. For example, in CommonJS modules on Node.js,
   *  `this` is the object representing the `exports` of the current module,
   *  and it is `undefined` in ECMAScript modules.
   *
   *  Using this value should be rare, and mostly limited to writing code
   *  detecting what the global object is. For example, a typical detection
   *  code--in case we do not need to worry of ES modules--looks like:
   *  {{{
   *  val globalObject = {
   *    import js.Dynamic.{global => g}
   *    if (js.typeOf(g.global) != "undefined" && (g.global.Object eq g.Object)) {
   *      // Node.js environment detected
   *      g.global
   *    } else {
   *      // In all other well-known environment, we can use the global `this`
   *      js.special.globalThis
   *    }
   *  }
   *  }}}
   *  Note that the above code is not comprehensive, as there can be JavaScript
   *  environments where the global object cannot be fetched neither through
   *  `global` nor `this`. If your code needs to run in such an environment, it
   *  is up to you to use an appropriate detection procedure.
   */
  @deprecated(
      "Does not correspond to JavaScript's globalThis. " +
      "Use fileLevelThis instead.",
      "0.6.29")
  @inline
  def globalThis: scala.Any =
    fileLevelThis

  /** Exact equivalent of the `debugger` keyword of JavaScript.
   *
   *  `debugger()` invokes any available debugging functionality.
   *  If no debugging functionality is available, this method has no effect.
   *
   *  MDN
   *
   *  Browser support:
   *  - Has no effect in Rhino nor, apparently, in Firefox
   *  - In Chrome, it has no effect unless the developer tools are opened
   *    beforehand.
   */
  def debugger(): Unit =
    throw new java.lang.Error("stub")

}
