/*
 * Decompiled with CFR 0.152.
 */
package org.scalajs.testing.adapter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import org.scalajs.jsenv.Input;
import org.scalajs.jsenv.JSUtils$;
import org.scalajs.jsenv.UnsupportedInputException;
import org.scalajs.testing.common.IsolatedTestSet;
import org.scalajs.testing.common.Serializer$;
import org.scalajs.testing.common.TestBridgeMode;
import org.scalajs.testing.common.TestBridgeMode$TestBridgeModeSerializer$;
import sbt.testing.TaskDef;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class HTMLRunnerBuilder$ {
    public static final HTMLRunnerBuilder$ MODULE$;

    static {
        new HTMLRunnerBuilder$();
    }

    public void writeToFile(File output, String title, Seq<Input> input, List<List<String>> frameworkImplClassNames, List<TaskDef> taskDefs) {
        Path outputPath = output.toPath();
        Path artifactsDir = Files.createTempDirectory(outputPath.getParent(), ".html-artifacts", new FileAttribute[0]);
        package$.MODULE$.addShutdownHook((Function0)new Serializable(artifactsDir){
            public static final long serialVersionUID = 0L;
            private final Path artifactsDir$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Files.walkFileTree(this.artifactsDir$1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            {
                this.artifactsDir$1 = artifactsDir$1;
            }
        });
        this.write(outputPath, artifactsDir, title, input, frameworkImplClassNames, taskDefs);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(Path output, Path artifactsDir, String title, Seq<Input> input, List<List<String>> frameworkImplClassNames, List<TaskDef> taskDefs) {
        Tuple2 tuple22;
        Path absoluteArtifacts = artifactsDir.toAbsolutePath();
        Path outputDir = output.toAbsolutePath().normalize().getParent();
        try {
            outputDir.relativize(absoluteArtifacts);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("cannot relativize `artifactsDir` with respect to `output`", illegalArgumentException);
        }
        Seq loadJSTags = (Seq)((TraversableLike)input.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(input, absoluteArtifacts, outputDir){
            public static final long serialVersionUID = 0L;
            private final Seq input$1;
            private final Path absoluteArtifacts$1;
            private final Path outputDir$1;

            public final String apply(Tuple2<Input, Object> x0$1) {
                block4: {
                    String string;
                    block3: {
                        Tuple2<Input, Object> tuple2;
                        block2: {
                            tuple2 = x0$1;
                            if (tuple2 == null) break block2;
                            Input input = (Input)tuple2._1();
                            int i = tuple2._2$mcI$sp();
                            if (!(input instanceof Input.Script)) break block2;
                            Input.Script script = (Input.Script)input;
                            Path script2 = script.script();
                            string = HTMLRunnerBuilder$.MODULE$.org$scalajs$testing$adapter$HTMLRunnerBuilder$$scriptTag$1(i, "text/javascript", script2, this.absoluteArtifacts$1, this.outputDir$1);
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        Input input = (Input)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        if (!(input instanceof Input.ESModule)) break block4;
                        Input.ESModule eSModule = (Input.ESModule)input;
                        Path module = eSModule.module();
                        string = HTMLRunnerBuilder$.MODULE$.org$scalajs$testing$adapter$HTMLRunnerBuilder$$scriptTag$1(i, "module", module, this.absoluteArtifacts$1, this.outputDir$1);
                    }
                    return string;
                }
                throw new UnsupportedInputException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported input for the generation of an HTML runner: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.input$1})));
            }
            {
                this.input$1 = input$1;
                this.absoluteArtifacts$1 = absoluteArtifacts$1;
                this.outputDir$1 = outputDir$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        IsolatedTestSet tests = new IsolatedTestSet(frameworkImplClassNames, taskDefs);
        TestBridgeMode.HTMLRunner mode = new TestBridgeMode.HTMLRunner(tests);
        String bridgeModeStr = Serializer$.MODULE$.serialize(mode, TestBridgeMode$TestBridgeModeSerializer$.MODULE$);
        String name = "test-runner.css";
        Tuple2 tuple2 = this.artifactPath$1(name, absoluteArtifacts, outputDir);
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String href = (String)tuple2._1();
        Path target = (Path)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)href, (Object)target);
        String href2 = (String)tuple23._1();
        Path target2 = (Path)tuple23._2();
        InputStream in = this.getClass().getResourceAsStream(name);
        try {
            Files.copy(in, target2, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            void var23_21;
            var23_21.close();
            throw throwable;
        }
        in.close();
        String cssHref = href2;
        String htmlContent = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      <!DOCTYPE html>\n      <html>\n        <head>\n          <title>", "</title>\n          <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n          <link rel=\"stylesheet\" type=\"text/css\" href=\"", "\" />\n          <script type=\"text/javascript\">\n            var __ScalaJSTestBridgeMode = \"", "\";\n          </script>\n          ", "\n        </head>\n        <body></body>\n      </html>\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.htmlEscaped(title), this.htmlEscaped(cssHref), JSUtils$.MODULE$.escapeJS(bridgeModeStr), loadJSTags.mkString("\n")}));
        Files.write(output, Arrays.asList((Object[])new String[]{htmlContent}), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private String htmlEscaped(String str) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(str)).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(char x0$2) {
                String string;
                char c = x0$2;
                switch (c) {
                    default: {
                        string = Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToCharacter((char)c)).toString());
                        break;
                    }
                    case '&': {
                        string = Predef$.MODULE$.augmentString("&amp;");
                        break;
                    }
                    case '\"': {
                        string = Predef$.MODULE$.augmentString("&quot;");
                        break;
                    }
                    case '>': {
                        string = Predef$.MODULE$.augmentString("&gt;");
                        break;
                    }
                    case '<': {
                        string = Predef$.MODULE$.augmentString("&lt;");
                    }
                }
                return string;
            }
        }, Predef$.MODULE$.StringCanBuildFrom());
    }

    private String joinRelPath(Path p) {
        Predef$.MODULE$.require(p.getRoot() == null);
        Iterator<Path> partsIter = p.iterator();
        StringBuilder result = new StringBuilder();
        while (partsIter.hasNext()) {
            result.append((Object)partsIter.next());
            Object object = partsIter.hasNext() ? result.append('/') : BoxedUnit.UNIT;
        }
        return result.toString();
    }

    private final Tuple2 artifactPath$1(String name, Path absoluteArtifacts$1, Path outputDir$1) {
        Path path = absoluteArtifacts$1.resolve(name);
        Path relPath = outputDir$1.relativize(path);
        return new Tuple2((Object)this.joinRelPath(relPath), (Object)path);
    }

    public final String org$scalajs$testing$adapter$HTMLRunnerBuilder$$scriptTag$1(int index, String tpe, Path content, Path absoluteArtifacts$1, Path outputDir$1) {
        Tuple2 tuple2;
        block2: {
            String string;
            try {
                string = this.joinRelPath(outputDir$1.relativize(content));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Tuple2 tuple22;
                Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)index);
                Path arg$macro$2 = content.getFileName();
                tuple2 = this.artifactPath$1(new StringOps("input%s-%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2})), absoluteArtifacts$1, outputDir$1);
                if (tuple2 == null) break block2;
                String src = (String)tuple2._1();
                Path target = (Path)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)src, (Object)target);
                String src2 = (String)tuple23._1();
                Path target2 = (Path)tuple23._2();
                Files.copy(content, target2, StandardCopyOption.REPLACE_EXISTING);
                string = src2;
            }
            String src = string;
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<script defer type=\"", "\" src=\"", "\"></script>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tpe, this.htmlEscaped(src)}));
        }
        throw new MatchError((Object)tuple2);
    }

    private HTMLRunnerBuilder$() {
        MODULE$ = this;
    }
}

