/*
 * Decompiled with CFR 0.152.
 */
package org.scalajs.testing.adapter;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import org.scalajs.jsenv.Input;
import org.scalajs.jsenv.JSUtils$;
import org.scalajs.jsenv.UnsupportedInputException;
import org.scalajs.testing.common.IsolatedTestSet;
import org.scalajs.testing.common.Serializer$;
import org.scalajs.testing.common.TestBridgeMode;
import org.scalajs.testing.common.TestBridgeMode$TestBridgeModeSerializer$;
import sbt.testing.TaskDef;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class HTMLRunnerBuilder$ {
    public static HTMLRunnerBuilder$ MODULE$;
    private final Regex tmpSuffixRE;

    static {
        new HTMLRunnerBuilder$();
    }

    private Regex tmpSuffixRE() {
        return this.tmpSuffixRE;
    }

    private URI tmpFile(String path, InputStream in) {
        URI uRI;
        try {
            String suffix = (String)this.tmpSuffixRE().findFirstIn((CharSequence)path).orNull(Predef$.MODULE$.$conforms());
            File f = File.createTempFile("tmp-", suffix);
            f.deleteOnExit();
            Files.copy(in, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
            uRI = f.toURI();
        }
        finally {
            in.close();
        }
        return uRI;
    }

    public void writeToFile(File output, String title, Seq<Input> input, List<List<String>> frameworkImplClassNames, List<TaskDef> taskDefs) {
        Seq jsFiles = (Seq)input.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Path script;
            Input input = x0$1;
            if (!(input instanceof Input.Script)) {
                throw new UnsupportedInputException(new StringBuilder(56).append("Unsupported input for the generation of an HTML runner: ").append(input).toString());
            }
            Input.Script script2 = (Input.Script)input;
            Path path = script = script2.script();
            return path;
        }, Seq$.MODULE$.canBuildFrom());
        Seq jsFileURIs = (Seq)jsFiles.map((Function1 & Serializable & scala.Serializable)f -> {
            URI uRI;
            try {
                uRI = f.toFile().toURI();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                uRI = MODULE$.tmpFile(((Object)f).toString(), Files.newInputStream(f, new OpenOption[0]));
            }
            return uRI;
        }, Seq$.MODULE$.canBuildFrom());
        String name = "test-runner.css";
        URI cssURI = this.tmpFile(name, this.getClass().getResourceAsStream(name));
        IsolatedTestSet tests = new IsolatedTestSet(frameworkImplClassNames, taskDefs);
        String htmlContent = this.render(title, (Seq<URI>)jsFileURIs, cssURI, tests);
        Files.write(output.toPath(), Arrays.asList((Object[])new String[]{htmlContent}), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private String render(String title, Seq<URI> jsFiles, URI css, IsolatedTestSet tests) {
        return new StringBuilder(325).append("\n    <!DOCTYPE html>\n    <html>\n      <head>\n        <title>").append(this.htmlEscaped(title)).append("</title>\n        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n        <link rel=\"stylesheet\" type=\"text/css\" href=\"").append(this.uristr$1(css)).append("\" />\n        <script type=\"text/javascript\">\n        ").append(this.injectBridgeMode(tests)).append("\n        </script>\n        ").append(((TraversableOnce)jsFiles.map((Function1 & Serializable & scala.Serializable)jsFile -> new StringBuilder(65).append("\n        <script type=\"text/javascript\" src=\"").append(this.uristr$1((URI)jsFile)).append("\"></script>\n        ").toString(), Seq$.MODULE$.canBuildFrom())).mkString("")).append("\n      </head>\n      <body></body>\n    </html>").toString();
    }

    private String injectBridgeMode(IsolatedTestSet tests) {
        TestBridgeMode.HTMLRunner mode = new TestBridgeMode.HTMLRunner(tests);
        String ser = Serializer$.MODULE$.serialize(mode, TestBridgeMode$TestBridgeModeSerializer$.MODULE$);
        return new StringBuilder(33).append("var __ScalaJSTestBridgeMode = \"").append(JSUtils$.MODULE$.escapeJS(ser)).append("\";").toString();
    }

    private String htmlEscaped(String str) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(str)).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> new StringOps(HTMLRunnerBuilder$.$anonfun$htmlEscaped$1(BoxesRunTime.unboxToChar((Object)x0$1))), Predef$.MODULE$.StringCanBuildFrom());
    }

    private final String uristr$1(URI uri) {
        return this.htmlEscaped(uri.toASCIIString());
    }

    public static final /* synthetic */ String $anonfun$htmlEscaped$1(char x0$1) {
        String string;
        char c = x0$1;
        switch (c) {
            case '<': {
                string = Predef$.MODULE$.augmentString("&lt;");
                break;
            }
            case '>': {
                string = Predef$.MODULE$.augmentString("&gt;");
                break;
            }
            case '\"': {
                string = Predef$.MODULE$.augmentString("&quot;");
                break;
            }
            case '&': {
                string = Predef$.MODULE$.augmentString("&amp;");
                break;
            }
            default: {
                string = Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToCharacter((char)c)).toString());
                break;
            }
        }
        return string;
    }

    private HTMLRunnerBuilder$() {
        MODULE$ = this;
        this.tmpSuffixRE = new StringOps(Predef$.MODULE$.augmentString("[a-zA-Z0-9-_.]*$")).r();
    }
}

