/*
 * Decompiled with CFR 0.152.
 */
package org.scalajs.core.tools.classpath.builder;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.scalajs.core.tools.classpath.builder.PhysicalFileSystem;
import org.scalajs.core.tools.io.FileVirtualJSFile$;
import org.scalajs.core.tools.io.FileVirtualScalaJSIRFile$;
import org.scalajs.core.tools.io.VirtualJSFile;
import org.scalajs.core.tools.io.VirtualScalaJSIRFile;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Traversable;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public abstract class PhysicalFileSystem$class {
    public static boolean isDirectory(PhysicalFileSystem $this, File f) {
        return f.isDirectory();
    }

    public static boolean isFile(PhysicalFileSystem $this, File f) {
        return f.isFile();
    }

    public static boolean isJSFile(PhysicalFileSystem $this, File f) {
        return f.isFile() && f.getName().endsWith(".js");
    }

    public static boolean isIRFile(PhysicalFileSystem $this, File f) {
        return f.isFile() && f.getName().endsWith(".sjsir");
    }

    public static boolean isJARFile(PhysicalFileSystem $this, File f) {
        return f.isFile() && f.getName().endsWith(".jar");
    }

    public static boolean exists(PhysicalFileSystem $this, File f) {
        return f.exists();
    }

    public static String getName(PhysicalFileSystem $this, File f) {
        return f.getName();
    }

    public static String getAbsolutePath(PhysicalFileSystem $this, File f) {
        return f.getAbsolutePath();
    }

    public static String getVersion(PhysicalFileSystem $this, File f) {
        return ((Object)BoxesRunTime.boxToLong((long)f.lastModified())).toString();
    }

    public static Traversable listFiles(PhysicalFileSystem $this, File d) {
        Predef$.MODULE$.require(d.isDirectory());
        return (Traversable)Option$.MODULE$.apply((Object)d.listFiles()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final List<File> apply(File[] x$1) {
                return Predef$.MODULE$.refArrayOps((Object[])x$1).toList();
            }
        }).getOrElse((Function0)new Serializable($this, d){
            public static final long serialVersionUID = 0L;
            private final File d$1;

            public final Nothing$ apply() {
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't list files in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.d$1})));
            }
            {
                this.d$1 = d$1;
            }
        });
    }

    public static VirtualJSFile toJSFile(PhysicalFileSystem $this, File f) {
        return FileVirtualJSFile$.MODULE$.apply(f);
    }

    public static VirtualScalaJSIRFile toIRFile(PhysicalFileSystem $this, File f) {
        return FileVirtualScalaJSIRFile$.MODULE$.apply(f);
    }

    public static Reader toReader(PhysicalFileSystem $this, File f) {
        return new BufferedReader(new FileReader(f));
    }

    public static InputStream toInputStream(PhysicalFileSystem $this, File f) {
        return new BufferedInputStream(new FileInputStream(f));
    }

    public static void $init$(PhysicalFileSystem $this) {
        $this.org$scalajs$core$tools$classpath$builder$PhysicalFileSystem$_setter_$DummyVersion_$eq("DUMMY_FILE");
    }
}

