/*
 * Decompiled with CFR 0.152.
 */
package org.scalajs.core.tools.javascript;

import java.io.BufferedReader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import org.scalajs.core.ir.Position;
import org.scalajs.core.tools.io.VirtualJSFile;
import org.scalajs.core.tools.javascript.JSFileBuilder;
import org.scalajs.core.tools.javascript.JSTreeBuilder;
import org.scalajs.core.tools.javascript.Printers;
import org.scalajs.core.tools.javascript.SourceMapWriter;
import org.scalajs.core.tools.javascript.Trees;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001A4A\u0001D\u0007\u00011!IQ\u0004\u0001B\u0001B\u0003%ad\u000b\u0005\n[\u0001\u0011\t\u0011)A\u0005]YB\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t\"\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005u!)a\b\u0001C\u0001\u007f!)A\t\u0001C!\u000b\"9A\n\u0001b\u0001\n\u001bi\u0005B\u0002)\u0001A\u00035a\nC\u0003R\u0001\u0011\u0005#\u000bC\u0003d\u0001\u0011\u0005C\rC\u0003o\u0001\u0011\u0005sN\u0001\u0011K'\u001aKG.\u001a\"vS2$WM],ji\"\u001cv.\u001e:dK6\u000b\u0007o\u0016:ji\u0016\u0014(B\u0001\b\u0010\u0003)Q\u0017M^1tGJL\u0007\u000f\u001e\u0006\u0003!E\tQ\u0001^8pYNT!AE\n\u0002\t\r|'/\u001a\u0006\u0003)U\tqa]2bY\u0006T7OC\u0001\u0017\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b75\tQ\"\u0003\u0002\u001d\u001b\ti!j\u0015$jY\u0016\u0014U/\u001b7eKJ\f\u0011A\u001c\t\u0003?!r!\u0001\t\u0014\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r:\u0012A\u0002\u001fs_>$hHC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9C%\u0001\u0004Qe\u0016$WMZ\u0005\u0003S)\u0012aa\u0015;sS:<'BA\u0014%\u0013\ta3$\u0001\u0003oC6,\u0017AA8x!\tyC'D\u00011\u0015\t\t$'\u0001\u0002j_*\t1'\u0001\u0003kCZ\f\u0017BA\u001b1\u0005\u00199&/\u001b;fe&\u0011qgG\u0001\r_V$\b/\u001e;Xe&$XM]\u0001\u0010g>,(oY3NCB<&/\u001b;feV\t!\b\u0005\u0002\u001bw%\u0011A(\u0004\u0002\u0010'>,(oY3NCB<&/\u001b;fe\u0006\u00012o\\;sG\u0016l\u0015\r],sSR,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0001\u000b%i\u0011\t\u00035\u0001AQ!H\u0003A\u0002yAQ!L\u0003A\u00029BQ\u0001O\u0003A\u0002i\nq!\u00193e\u0019&tW\r\u0006\u0002G\u0015B\u0011q\tS\u0007\u0002I%\u0011\u0011\n\n\u0002\u0005+:LG\u000fC\u0003L\r\u0001\u0007a$\u0001\u0003mS:,\u0017a\u0003(piN+G.Z2uK\u0012,\u0012AT\b\u0002\u001fv\tq@\u0001\u0007O_R\u001cV\r\\3di\u0016$\u0007%\u0001\bbI\u0012\u0004\u0016M\u001d;t\u001f\u001a4\u0015\u000e\\3\u0015\u0005McFC\u0001$U\u0011\u0015)\u0016\u00021\u0001W\u0003!\u0019X\r\\3di>\u0014\b\u0003B$X=eK!\u0001\u0017\u0013\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA$[\u0013\tYFEA\u0004C_>dW-\u00198\t\u000buK\u0001\u0019\u00010\u0002\t\u0019LG.\u001a\t\u0003?\u0006l\u0011\u0001\u0019\u0006\u0003c=I!A\u00191\u0003\u001bYK'\u000f^;bY*\u001bf)\u001b7f\u0003%\tG\r\u001a&T)J,W\r\u0006\u0002GK\")aM\u0003a\u0001O\u0006!AO]3f!\tA7N\u0004\u0002\u001bS&\u0011!.D\u0001\u0006)J,Wm]\u0005\u0003Y6\u0014A\u0001\u0016:fK*\u0011!.D\u0001\tG>l\u0007\u000f\\3uKR\ta\t")
public class JSFileBuilderWithSourceMapWriter
extends JSFileBuilder {
    private final SourceMapWriter sourceMapWriter;

    public SourceMapWriter sourceMapWriter() {
        return this.sourceMapWriter;
    }

    @Override
    public void addLine(String line) {
        super.addLine(line);
        this.sourceMapWriter().nextLine();
    }

    private final int NotSelected() {
        return -1;
    }

    @Override
    public void addPartsOfFile(VirtualJSFile file, Function1<String, Object> selector) {
        try (BufferedReader br = new BufferedReader(file.reader());){
            ArrayBuffer offsets = new ArrayBuffer();
            ArrayBuffer selectedLineLengths = new ArrayBuffer();
            String line = br.readLine();
            int selectedCount = 0;
            while (line != null) {
                ArrayBuffer arrayBuffer;
                if (BoxesRunTime.unboxToBoolean((Object)selector.apply((Object)line))) {
                    super.addLine(line);
                    offsets.$plus$eq((Object)BoxesRunTime.boxToInteger((int)selectedCount));
                    selectedLineLengths.$plus$eq((Object)BoxesRunTime.boxToInteger((int)line.length()));
                    ++selectedCount;
                    arrayBuffer = BoxedUnit.UNIT;
                } else {
                    arrayBuffer = offsets.$plus$eq((Object)BoxesRunTime.boxToInteger((int)-1));
                }
                line = br.readLine();
            }
            URI sourceFile = file.toURI();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsets.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)lineNumber -> {
                block0: {
                    int offset = BoxesRunTime.unboxToInt((Object)offsets.apply(lineNumber));
                    if (offset == -1) break block0;
                    Position originalPos = new Position(sourceFile, lineNumber, 0);
                    this.sourceMapWriter().startNode(0, originalPos, (Option<String>)None$.MODULE$);
                    this.sourceMapWriter().endNode(BoxesRunTime.unboxToInt((Object)selectedLineLengths.apply(offset)));
                    this.sourceMapWriter().nextLine();
                }
            });
        }
    }

    @Override
    public void addJSTree(Trees.Tree tree) {
        Printers.JSTreePrinterWithSourceMap printer = new Printers.JSTreePrinterWithSourceMap(this.outputWriter(), this.sourceMapWriter());
        printer.printTopLevelTree(tree);
    }

    @Override
    public void complete() {
        JSTreeBuilder.complete$(this);
        this.sourceMapWriter().complete();
    }

    public JSFileBuilderWithSourceMapWriter(String n, Writer ow, SourceMapWriter sourceMapWriter) {
        this.sourceMapWriter = sourceMapWriter;
        super(n, ow);
    }
}

