/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.io;

import java.io.File;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.scalanative.io.VirtualDirectory;
import scala.scalanative.io.VirtualDirectory$EmptyDirectory$;
import scala.scalanative.util.Scope;

public final class VirtualDirectory$ {
    public static final VirtualDirectory$ MODULE$;
    private final VirtualDirectory empty;

    static {
        new VirtualDirectory$();
    }

    public VirtualDirectory local(File file) {
        Predef$.MODULE$.assert(file.exists(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Local directory doesn't exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{VirtualDirectory$.MODULE$.scala$scalanative$io$VirtualDirectory$$absolute$1(this.file$1)}));
            }
            {
                this.file$1 = file$1;
            }
        });
        Predef$.MODULE$.assert(file.isDirectory(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not a directory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{VirtualDirectory$.MODULE$.scala$scalanative$io$VirtualDirectory$$absolute$1(this.file$1)}));
            }
            {
                this.file$1 = file$1;
            }
        });
        return new VirtualDirectory.LocalDirectory(file.toPath());
    }

    public VirtualDirectory jar(File file, Scope in) {
        String absolute = file.getAbsolutePath();
        Predef$.MODULE$.assert(file.exists(), (Function0)new Serializable(absolute){
            public static final long serialVersionUID = 0L;
            private final String absolute$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Jar doesn't exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.absolute$2}));
            }
            {
                this.absolute$2 = absolute$2;
            }
        });
        Predef$.MODULE$.assert(absolute.endsWith(".jar"), (Function0)new Serializable(absolute){
            public static final long serialVersionUID = 0L;
            private final String absolute$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not a jar: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.absolute$2}));
            }
            {
                this.absolute$2 = absolute$2;
            }
        });
        return new VirtualDirectory.JarDirectory(file.toPath(), in);
    }

    public VirtualDirectory real(File file, Scope in) {
        block4: {
            VirtualDirectory virtualDirectory;
            block3: {
                block2: {
                    if (!file.isDirectory()) break block2;
                    virtualDirectory = this.local(file);
                    break block3;
                }
                if (!file.getAbsolutePath().endsWith(".jar")) break block4;
                virtualDirectory = this.jar(file, in);
            }
            return virtualDirectory;
        }
        throw new UnsupportedOperationException(new StringBuilder().append((Object)"Neither a jar, nor a directory: ").append((Object)file).toString());
    }

    public VirtualDirectory empty() {
        return this.empty;
    }

    public final String scala$scalanative$io$VirtualDirectory$$absolute$1(File file$1) {
        return file$1.getAbsolutePath();
    }

    private VirtualDirectory$() {
        MODULE$ = this;
        this.empty = VirtualDirectory$EmptyDirectory$.MODULE$;
    }
}

