/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.nir.serialization;

import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple5;
import scala.runtime.BoxesRunTime;
import scala.scalanative.nir.Versions$;
import scala.scalanative.nir.serialization.Prelude;

public final class Prelude$
implements Serializable {
    public static Prelude$ MODULE$;
    private final int length;

    static {
        new Prelude$();
    }

    public int length() {
        return this.length;
    }

    public Prelude readFrom(ByteBuffer buffer, Function0<String> fileName) {
        buffer.position(0);
        int magic = buffer.getInt();
        int compat = buffer.getInt();
        int revision = buffer.getInt();
        Predef$.MODULE$.assert(magic == Versions$.MODULE$.magic(), (Function0 & java.io.Serializable & Serializable)() -> "Can't read non-NIR file.");
        Predef$.MODULE$.assert(compat == Versions$.MODULE$.compat() && revision <= Versions$.MODULE$.revision(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(105).append("Can't read binary-incompatible version of NIR from '").append(fileName.apply()).append("' (expected compat=").append(Versions$.MODULE$.compat()).append(", got ").append(compat).append("; expected revision=").append(Versions$.MODULE$.revision()).append(", got ").append(revision).append(").").toString());
        Prelude.Offsets offsets = new Prelude.Offsets(buffer.getInt(), buffer.getInt(), buffer.getInt(), buffer.getInt(), buffer.getInt(), buffer.getInt(), buffer.getInt(), buffer.getInt());
        boolean hasEntryPoints = buffer.get() != 0;
        return new Prelude(magic, compat, revision, offsets, hasEntryPoints);
    }

    public DataOutputStream writeTo(DataOutputStream out, Prelude prelude) {
        Prelude prelude2 = prelude;
        if (prelude2 == null) {
            throw new MatchError((Object)prelude2);
        }
        int magic = prelude2.magic();
        int compat = prelude2.compat();
        int revision = prelude2.revision();
        Prelude.Offsets offsets = prelude2.sections();
        boolean hasEntryPoints = prelude2.hasEntryPoints();
        Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToInteger((int)magic), (Object)BoxesRunTime.boxToInteger((int)compat), (Object)BoxesRunTime.boxToInteger((int)revision), (Object)offsets, (Object)BoxesRunTime.boxToBoolean((boolean)hasEntryPoints));
        int magic2 = BoxesRunTime.unboxToInt((Object)tuple5._1());
        int compat2 = BoxesRunTime.unboxToInt((Object)tuple5._2());
        int revision2 = BoxesRunTime.unboxToInt((Object)tuple5._3());
        Prelude.Offsets offsets2 = (Prelude.Offsets)tuple5._4();
        boolean hasEntryPoints2 = BoxesRunTime.unboxToBoolean((Object)tuple5._5());
        out.writeInt(magic2);
        out.writeInt(compat2);
        out.writeInt(revision2);
        out.writeInt(offsets2.offsets());
        out.writeInt(offsets2.strings());
        out.writeInt(offsets2.positions());
        out.writeInt(offsets2.globals());
        out.writeInt(offsets2.types());
        out.writeInt(offsets2.defns());
        out.writeInt(offsets2.vals());
        out.writeInt(offsets2.insts());
        out.writeBoolean(hasEntryPoints2);
        return out;
    }

    public Prelude apply(int magic, int compat, int revision, Prelude.Offsets sections, boolean hasEntryPoints) {
        return new Prelude(magic, compat, revision, sections, hasEntryPoints);
    }

    public Option<Tuple5<Object, Object, Object, Prelude.Offsets, Object>> unapply(Prelude x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)x$0.magic()), (Object)BoxesRunTime.boxToInteger((int)x$0.compat()), (Object)BoxesRunTime.boxToInteger((int)x$0.revision()), (Object)x$0.sections(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.hasEntryPoints())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Prelude$() {
        MODULE$ = this;
        this.length = 45;
    }
}

