/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.nir.serialization;

import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.UnrolledBuffer;
import scala.collection.mutable.UnrolledBuffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.NameTransformer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.scalanative.nir.Attr;
import scala.scalanative.nir.Attr$Abstract$;
import scala.scalanative.nir.Attr$AlwaysInline$;
import scala.scalanative.nir.Attr$DidOpt$;
import scala.scalanative.nir.Attr$Dyn$;
import scala.scalanative.nir.Attr$Extern$;
import scala.scalanative.nir.Attr$InlineHint$;
import scala.scalanative.nir.Attr$LinktimeResolved$;
import scala.scalanative.nir.Attr$MayInline$;
import scala.scalanative.nir.Attr$MaySpecialize$;
import scala.scalanative.nir.Attr$NoInline$;
import scala.scalanative.nir.Attr$NoOpt$;
import scala.scalanative.nir.Attr$NoSpecialize$;
import scala.scalanative.nir.Attr$Stub$;
import scala.scalanative.nir.Attr$UnOpt$;
import scala.scalanative.nir.Attrs;
import scala.scalanative.nir.Attrs$;
import scala.scalanative.nir.Bin;
import scala.scalanative.nir.Bin$And$;
import scala.scalanative.nir.Bin$Ashr$;
import scala.scalanative.nir.Bin$Fadd$;
import scala.scalanative.nir.Bin$Fdiv$;
import scala.scalanative.nir.Bin$Fmul$;
import scala.scalanative.nir.Bin$Frem$;
import scala.scalanative.nir.Bin$Fsub$;
import scala.scalanative.nir.Bin$Iadd$;
import scala.scalanative.nir.Bin$Imul$;
import scala.scalanative.nir.Bin$Isub$;
import scala.scalanative.nir.Bin$Lshr$;
import scala.scalanative.nir.Bin$Or$;
import scala.scalanative.nir.Bin$Sdiv$;
import scala.scalanative.nir.Bin$Shl$;
import scala.scalanative.nir.Bin$Srem$;
import scala.scalanative.nir.Bin$Udiv$;
import scala.scalanative.nir.Bin$Urem$;
import scala.scalanative.nir.Bin$Xor$;
import scala.scalanative.nir.Comp;
import scala.scalanative.nir.Comp$Feq$;
import scala.scalanative.nir.Comp$Fge$;
import scala.scalanative.nir.Comp$Fgt$;
import scala.scalanative.nir.Comp$Fle$;
import scala.scalanative.nir.Comp$Flt$;
import scala.scalanative.nir.Comp$Fne$;
import scala.scalanative.nir.Comp$Ieq$;
import scala.scalanative.nir.Comp$Ine$;
import scala.scalanative.nir.Comp$Sge$;
import scala.scalanative.nir.Comp$Sgt$;
import scala.scalanative.nir.Comp$Sle$;
import scala.scalanative.nir.Comp$Slt$;
import scala.scalanative.nir.Comp$Uge$;
import scala.scalanative.nir.Comp$Ugt$;
import scala.scalanative.nir.Comp$Ule$;
import scala.scalanative.nir.Comp$Ult$;
import scala.scalanative.nir.Conv;
import scala.scalanative.nir.Conv$Bitcast$;
import scala.scalanative.nir.Conv$Fpext$;
import scala.scalanative.nir.Conv$Fptosi$;
import scala.scalanative.nir.Conv$Fptoui$;
import scala.scalanative.nir.Conv$Fptrunc$;
import scala.scalanative.nir.Conv$Inttoptr$;
import scala.scalanative.nir.Conv$Ptrtoint$;
import scala.scalanative.nir.Conv$Sext$;
import scala.scalanative.nir.Conv$Sitofp$;
import scala.scalanative.nir.Conv$Trunc$;
import scala.scalanative.nir.Conv$Uitofp$;
import scala.scalanative.nir.Conv$Zext$;
import scala.scalanative.nir.Defn;
import scala.scalanative.nir.Global;
import scala.scalanative.nir.Global$None$;
import scala.scalanative.nir.Inst;
import scala.scalanative.nir.LinktimeCondition;
import scala.scalanative.nir.Next;
import scala.scalanative.nir.Next$None$;
import scala.scalanative.nir.Op;
import scala.scalanative.nir.Position;
import scala.scalanative.nir.Position$;
import scala.scalanative.nir.Prelude;
import scala.scalanative.nir.Prelude$;
import scala.scalanative.nir.Sig;
import scala.scalanative.nir.Sig$;
import scala.scalanative.nir.Type;
import scala.scalanative.nir.Type$Bool$;
import scala.scalanative.nir.Type$Byte$;
import scala.scalanative.nir.Type$Char$;
import scala.scalanative.nir.Type$Double$;
import scala.scalanative.nir.Type$Float$;
import scala.scalanative.nir.Type$Int$;
import scala.scalanative.nir.Type$Long$;
import scala.scalanative.nir.Type$Nothing$;
import scala.scalanative.nir.Type$Null$;
import scala.scalanative.nir.Type$Ptr$;
import scala.scalanative.nir.Type$Short$;
import scala.scalanative.nir.Type$Unit$;
import scala.scalanative.nir.Type$Vararg$;
import scala.scalanative.nir.Type$Virtual$;
import scala.scalanative.nir.Val;
import scala.scalanative.nir.Val$False$;
import scala.scalanative.nir.Val$Null$;
import scala.scalanative.nir.Val$True$;
import scala.scalanative.nir.Val$Unit$;
import scala.scalanative.nir.serialization.Tags$;
import scala.scalanative.util.package$;

@ScalaSignature(bytes="\u0006\u0005\tuc\u0001\u0002\u00192\u0005iB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\")A\u000b\u0001C\u0001+\"9!\f\u0001a\u0001\n\u0013Y\u0006b\u00021\u0001\u0001\u0004%I!\u0019\u0005\u0007O\u0002\u0001\u000b\u0015\u0002/\t\u0015\u0019\u0004\u0001\u0013!A\u0002B\u0003%\u0001\u000eC\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003\u0002\u0016!9\u0011q\u0003\u0001!\u0002\u0013Y\u0007\"CA\r\u0001\t\u0007I\u0011BA\u000e\u0011\u001d\ti\u0002\u0001Q\u0001\n9D\u0011\"a\b\u0001\u0005\u0004%I!!\t\t\u0011\u0005\r\u0002\u0001)A\u0005\u0003\u0003A\u0011\"!\n\u0001\u0005\u0004%I!a\n\t\u0011\u0005=\u0002\u0001)A\u0005\u0003SAq!!\r\u0001\t\u000b\t\u0019\u0004C\u0004\u0002>\u0001!I!a\u0010\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h!9\u0011\u0011\u0010\u0001\u0005\n\u0005m\u0004bBA@\u0001\u0011%\u0011\u0011\u0011\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\ty\t\u0001C\u0005\u0003#Cq!a%\u0001\t\u0013\t)\nC\u0004\u0002\u001e\u0002!I!a(\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\"9\u0011\u0011\u0017\u0001\u0005\n\u0005M\u0006bBA_\u0001\u0011%\u0011q\u0018\u0005\b\u0003\u0003\u0004A\u0011BAb\u0011\u001d\tY\r\u0001C\u0005\u0003\u001bDq!!6\u0001\t\u0013\t\u0019\u0004C\u0004\u0002X\u0002!I!!7\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\"9\u0011\u0011\u001d\u0001\u0005\n\u0005\r\bbBAt\u0001\u0011%\u0011\u0011\u001e\u0005\b\u0003W\u0004A\u0011BAw\u0011\u001d\t)\u0010\u0001C\u0005\u0003oDq!a@\u0001\t\u0013\u0011\t\u0001C\u0004\u0003\f\u0001!IA!\u0004\t\u000f\t=\u0001\u0001\"\u0003\u0003\u0012!9!\u0011\u0004\u0001\u0005\n\tm\u0001b\u0002B\u0016\u0001\u0011%!Q\u0006\u0005\b\u0005_\u0001A\u0011\u0002B\u0019\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{AqAa\u0010\u0001\t\u0013\u0011\t\u0005C\u0004\u0003L\u0001!IA!\u0014\t\u000f\t=\u0003\u0001\"\u0003\u0003R!9!\u0011\f\u0001\u0005\u0002\tm#A\u0005\"j]\u0006\u0014\u0018\u0010R3tKJL\u0017\r\\5{KJT!AM\u001a\u0002\u001bM,'/[1mSj\fG/[8o\u0015\t!T'A\u0002oSJT!AN\u001c\u0002\u0017M\u001c\u0017\r\\1oCRLg/\u001a\u0006\u0002q\u0005)1oY1mC\u000e\u00011C\u0001\u0001<!\taT(D\u00018\u0013\tqtG\u0001\u0004B]f\u0014VMZ\u0001\u0007EV4g-\u001a:\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015a\u00018j_*\tQ)\u0001\u0003kCZ\f\u0017BA$C\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\u000bEV4g-\u001a:OC6,\u0007C\u0001&R\u001d\tYu\n\u0005\u0002Mo5\tQJ\u0003\u0002Os\u00051AH]8pizJ!\u0001U\u001c\u0002\rA\u0013X\rZ3g\u0013\t\u00116K\u0001\u0004TiJLgn\u001a\u0006\u0003!^\na\u0001P5oSRtDc\u0001,Y3B\u0011q\u000bA\u0007\u0002c!)qh\u0001a\u0001\u0001\")\u0001j\u0001a\u0001\u0013\u0006aA.Y:u!>\u001c\u0018\u000e^5p]V\tA\f\u0005\u0002^=6\t1'\u0003\u0002`g\tA\u0001k\\:ji&|g.\u0001\tmCN$\bk\\:ji&|gn\u0018\u0013fcR\u0011!-\u001a\t\u0003y\rL!\u0001Z\u001c\u0003\tUs\u0017\u000e\u001e\u0005\bM\u0016\t\t\u00111\u0001]\u0003\rAH%M\u0001\u000eY\u0006\u001cH\u000fU8tSRLwN\u001c\u0011\u0011\rqJ7N\\A\u0001\u0013\tQwG\u0001\u0004UkBdWm\r\t\u0003;2L!!\\\u001a\u0003\u000fA\u0013X\r\\;eKB\u0019q\u000e^<\u000f\u0005A\u0014hB\u0001'r\u0013\u0005A\u0014BA:8\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001e<\u0003\u0007M+\u0017O\u0003\u0002toA!A\b\u001f>~\u0013\tIxG\u0001\u0004UkBdWM\r\t\u0003;nL!\u0001`\u001a\u0003\r\u001dcwNY1m!\tad0\u0003\u0002\u0000o\t\u0019\u0011J\u001c;\u0011\u000bq\n\u0019!a\u0002\n\u0007\u0005\u0015qGA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\ti\u0001R\u0001\u0004]\u0016$\u0018\u0002BA\t\u0003\u0017\u00111!\u0016*J\u0003\u001d\u0001(/\u001a7vI\u0016,\u0012a[\u0001\taJ,G.\u001e3fA\u00051\u0001.Z1eKJ,\u0012A\\\u0001\bQ\u0016\fG-\u001a:!\u0003\u00151\u0017\u000e\\3t+\t\t\t!\u0001\u0004gS2,7\u000fI\u0001\u0017kN,7/\u00128d_\u0012,G-T3nE\u0016\u0014h*Y7fgV\u0011\u0011\u0011\u0006\t\u0004y\u0005-\u0012bAA\u0017o\t9!i\\8mK\u0006t\u0017aF;tKN,enY8eK\u0012lU-\u001c2fe:\u000bW.Z:!\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0005\u0005U\u0002\u0003B8u\u0003o\u00012!XA\u001d\u0013\r\tYd\r\u0002\u0005\t\u00164g.\u0001\u0004hKR\u001cV-]\u000b\u0005\u0003\u0003\nI\u0005\u0006\u0003\u0002D\u0005m\u0003\u0003B8u\u0003\u000b\u0002B!a\u0012\u0002J1\u0001AaBA&#\t\u0007\u0011Q\n\u0002\u0002)F!\u0011qJA+!\ra\u0014\u0011K\u0005\u0004\u0003':$a\u0002(pi\"Lgn\u001a\t\u0004y\u0005]\u0013bAA-o\t\u0019\u0011I\\=\t\u0011\u0005u\u0013\u0003\"a\u0001\u0003?\nAaZ3u)B)A(!\u0019\u0002F%\u0019\u00111M\u001c\u0003\u0011q\u0012\u0017P\\1nKz\naaZ3u\u001fB$X\u0003BA5\u0003g\"B!a\u001b\u0002vA)A(!\u001c\u0002r%\u0019\u0011qN\u001c\u0003\r=\u0003H/[8o!\u0011\t9%a\u001d\u0005\u000f\u0005-#C1\u0001\u0002N!A\u0011Q\f\n\u0005\u0002\u0004\t9\bE\u0003=\u0003C\n\t(A\u0004hKRLe\u000e^:\u0015\u0005\u0005u\u0004cA8u{\u0006iq-\u001a;V)\u001aC4\u000b\u001e:j]\u001e$\u0012!S\u0001\tO\u0016$()\u001f;fgR\u0011\u0011q\u0011\t\u0006y\u0005\r\u0011\u0011\u0012\t\u0004y\u0005-\u0015bAAGo\t!!)\u001f;f\u0003\u001d9W\r\u001e\"p_2$\"!!\u000b\u0002\u0011\u001d,G/\u0011;ueN$\"!a&\u0011\u0007u\u000bI*C\u0002\u0002\u001cN\u0012Q!\u0011;ueN\fqaZ3u\u0003R$(\u000f\u0006\u0002\u0002\"B\u0019Q,a)\n\u0007\u0005\u00156G\u0001\u0003BiR\u0014\u0018AB4fi\nKg\u000e\u0006\u0002\u0002,B\u0019Q,!,\n\u0007\u0005=6GA\u0002CS:\f\u0001bZ3u\u0013:\u001cHo\u001d\u000b\u0003\u0003k\u0003Ba\u001c;\u00028B\u0019Q,!/\n\u0007\u0005m6G\u0001\u0003J]N$\u0018aB4fi&s7\u000f\u001e\u000b\u0003\u0003o\u000bqaZ3u\u0007>l\u0007\u000f\u0006\u0002\u0002FB\u0019Q,a2\n\u0007\u0005%7G\u0001\u0003D_6\u0004\u0018aB4fi\u000e{gN\u001e\u000b\u0003\u0003\u001f\u00042!XAi\u0013\r\t\u0019n\r\u0002\u0005\u0007>tg/\u0001\u0005hKR$UM\u001a8t\u0003\u001d9W\r\u001e#fM:$\"!a\u000e\u0002\u0015\u001d,Go\u00127pE\u0006d7\u000f\u0006\u0002\u0002`B\u0019q\u000e\u001e>\u0002\u0019\u001d,Go\u00127pE\u0006dw\n\u001d;\u0015\u0005\u0005\u0015\b\u0003\u0002\u001f\u0002ni\f\u0011bZ3u\u000f2|'-\u00197\u0015\u0003i\faaZ3u'&<GCAAx!\ri\u0016\u0011_\u0005\u0004\u0003g\u001c$aA*jO\u0006Aq-\u001a;M_\u000e\fG\u000e\u0006\u0002\u0002zB\u0019Q,a?\n\u0007\u0005u8GA\u0003M_\u000e\fG.\u0001\u0005hKRtU\r\u001f;t)\t\u0011\u0019\u0001\u0005\u0003pi\n\u0015\u0001cA/\u0003\b%\u0019!\u0011B\u001a\u0003\t9+\u0007\u0010^\u0001\bO\u0016$h*\u001a=u)\t\u0011)!A\u0003hKR|\u0005\u000f\u0006\u0002\u0003\u0014A\u0019QL!\u0006\n\u0007\t]1G\u0001\u0002Pa\u0006Iq-\u001a;QCJ\fWn\u001d\u000b\u0003\u0005;\u0001Ba\u001c;\u0003 A!!\u0011\u0005B\u0014\u001d\ri&1E\u0005\u0004\u0005K\u0019\u0014a\u0001,bY&!\u0011Q B\u0015\u0015\r\u0011)cM\u0001\tO\u0016$\b+\u0019:b[R\u0011!qD\u0001\tO\u0016$H+\u001f9fgR\u0011!1\u0007\t\u0005_R\u0014)\u0004E\u0002^\u0005oI1A!\u000f4\u0005\u0011!\u0016\u0010]3\u0002\u000f\u001d,G\u000fV=qKR\u0011!QG\u0001\bO\u0016$h+\u00197t)\t\u0011\u0019\u0005\u0005\u0003pi\n\u0015\u0003cA/\u0003H%\u0019!\u0011J\u001a\u0003\u0007Y\u000bG.\u0001\u0004hKR4\u0016\r\u001c\u000b\u0003\u0005\u000b\nAcZ3u\u0019&t7\u000e^5nK\u000e{g\u000eZ5uS>tGC\u0001B*!\ri&QK\u0005\u0004\u0005/\u001a$!\u0005'j].$\u0018.\\3D_:$\u0017\u000e^5p]\u0006Yq-\u001a;Q_NLG/[8o)\u0005a\u0006")
public final class BinaryDeserializer {
    private final ByteBuffer buffer;
    private Position lastPosition;
    private final /* synthetic */ Tuple3 x$1;
    private final Prelude prelude;
    private final Seq<Tuple2<Global, Object>> header;
    private final URI[] files;
    private final boolean usesEncodedMemberNames;

    private Position lastPosition() {
        return this.lastPosition;
    }

    private void lastPosition_$eq(Position x$1) {
        this.lastPosition = x$1;
    }

    private Prelude prelude() {
        return this.prelude;
    }

    private Seq<Tuple2<Global, Object>> header() {
        return this.header;
    }

    private URI[] files() {
        return this.files;
    }

    private boolean usesEncodedMemberNames() {
        return this.usesEncodedMemberNames;
    }

    public final Seq<Defn> deserialize() {
        UnrolledBuffer allDefns = UnrolledBuffer$.MODULE$.empty(ClassTag$.MODULE$.apply(Defn.class));
        this.header().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int offset = tuple2._2$mcI$sp();
            $this.buffer.position(offset);
            UnrolledBuffer unrolledBuffer = (UnrolledBuffer)allDefns.$plus$eq((Object)this.getDefn());
            return unrolledBuffer;
        });
        return allDefns.toSeq();
    }

    private <T> Seq<T> getSeq(Function0<T> getT) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.buffer.getInt()).map((Function1 & Serializable)x$2 -> getT.apply()).toSeq();
    }

    private <T> Option<T> getOpt(Function0<T> getT) {
        return this.buffer.get() == 0 ? None$.MODULE$ : new Some(getT.apply());
    }

    private Seq<Object> getInts() {
        return this.getSeq((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.buffer.getInt());
    }

    private String getUTF8String() {
        return new String(this.getBytes(), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getBytes() {
        void var1_1;
        byte[] arr = new byte[this.buffer.getInt()];
        this.buffer.get(arr);
        return var1_1;
    }

    private boolean getBool() {
        return this.buffer.get() != 0;
    }

    private Attrs getAttrs() {
        return Attrs$.MODULE$.fromSeq(this.getSeq((Function0 & Serializable)() -> this.getAttr()));
    }

    private Attr getAttr() {
        Attr attr;
        int n = this.buffer.getInt();
        switch (n) {
            case 1: {
                attr = Attr$MayInline$.MODULE$;
                break;
            }
            case 2: {
                attr = Attr$InlineHint$.MODULE$;
                break;
            }
            case 3: {
                attr = Attr$NoInline$.MODULE$;
                break;
            }
            case 4: {
                attr = Attr$AlwaysInline$.MODULE$;
                break;
            }
            case 5: {
                attr = Attr$MaySpecialize$.MODULE$;
                break;
            }
            case 6: {
                attr = Attr$NoSpecialize$.MODULE$;
                break;
            }
            case 7: {
                attr = Attr$UnOpt$.MODULE$;
                break;
            }
            case 8: {
                attr = Attr$NoOpt$.MODULE$;
                break;
            }
            case 9: {
                attr = Attr$DidOpt$.MODULE$;
                break;
            }
            case 10: {
                attr = new Attr.BailOpt(this.getUTF8String());
                break;
            }
            case 13: {
                attr = Attr$Dyn$.MODULE$;
                break;
            }
            case 14: {
                attr = Attr$Stub$.MODULE$;
                break;
            }
            case 11: {
                attr = Attr$Extern$.MODULE$;
                break;
            }
            case 12: {
                attr = new Attr.Link(this.getUTF8String());
                break;
            }
            case 15: {
                attr = Attr$Abstract$.MODULE$;
                break;
            }
            case 16: {
                attr = Attr$LinktimeResolved$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return attr;
    }

    private Bin getBin() {
        Bin bin;
        int n = this.buffer.getInt();
        switch (n) {
            case 33: {
                bin = Bin$Iadd$.MODULE$;
                break;
            }
            case 34: {
                bin = Bin$Fadd$.MODULE$;
                break;
            }
            case 35: {
                bin = Bin$Isub$.MODULE$;
                break;
            }
            case 36: {
                bin = Bin$Fsub$.MODULE$;
                break;
            }
            case 37: {
                bin = Bin$Imul$.MODULE$;
                break;
            }
            case 38: {
                bin = Bin$Fmul$.MODULE$;
                break;
            }
            case 39: {
                bin = Bin$Sdiv$.MODULE$;
                break;
            }
            case 40: {
                bin = Bin$Udiv$.MODULE$;
                break;
            }
            case 41: {
                bin = Bin$Fdiv$.MODULE$;
                break;
            }
            case 42: {
                bin = Bin$Srem$.MODULE$;
                break;
            }
            case 43: {
                bin = Bin$Urem$.MODULE$;
                break;
            }
            case 44: {
                bin = Bin$Frem$.MODULE$;
                break;
            }
            case 45: {
                bin = Bin$Shl$.MODULE$;
                break;
            }
            case 46: {
                bin = Bin$Lshr$.MODULE$;
                break;
            }
            case 47: {
                bin = Bin$Ashr$.MODULE$;
                break;
            }
            case 48: {
                bin = Bin$And$.MODULE$;
                break;
            }
            case 49: {
                bin = Bin$Or$.MODULE$;
                break;
            }
            case 50: {
                bin = Bin$Xor$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return bin;
    }

    private Seq<Inst> getInsts() {
        return this.getSeq((Function0 & Serializable)() -> this.getInst());
    }

    private Inst getInst() {
        Inst inst;
        Position pos = this.getPosition();
        int n = this.buffer.getInt();
        switch (n) {
            case 161: {
                inst = new Inst.Label(this.getLocal(), this.getParams(), pos);
                break;
            }
            case 162: {
                inst = new Inst.Let(this.getLocal(), this.getOp(), Next$None$.MODULE$, pos);
                break;
            }
            case 163: {
                inst = new Inst.Let(this.getLocal(), this.getOp(), this.getNext(), pos);
                break;
            }
            case 164: {
                inst = new Inst.Ret(this.getVal(), pos);
                break;
            }
            case 165: {
                inst = new Inst.Jump(this.getNext(), pos);
                break;
            }
            case 166: {
                inst = new Inst.If(this.getVal(), this.getNext(), this.getNext(), pos);
                break;
            }
            case 167: {
                inst = new Inst.Switch(this.getVal(), this.getNext(), this.getNexts(), pos);
                break;
            }
            case 168: {
                inst = new Inst.Throw(this.getVal(), this.getNext(), pos);
                break;
            }
            case 169: {
                inst = new Inst.Unreachable(this.getNext(), pos);
                break;
            }
            case 170: {
                inst = new Inst.LinktimeIf(this.getLinktimeCondition(), this.getNext(), this.getNext(), pos);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return inst;
    }

    private Comp getComp() {
        Comp comp;
        int n = this.buffer.getInt();
        switch (n) {
            case 65: {
                comp = Comp$Ieq$.MODULE$;
                break;
            }
            case 66: {
                comp = Comp$Ine$.MODULE$;
                break;
            }
            case 67: {
                comp = Comp$Ugt$.MODULE$;
                break;
            }
            case 68: {
                comp = Comp$Uge$.MODULE$;
                break;
            }
            case 69: {
                comp = Comp$Ult$.MODULE$;
                break;
            }
            case 70: {
                comp = Comp$Ule$.MODULE$;
                break;
            }
            case 71: {
                comp = Comp$Sgt$.MODULE$;
                break;
            }
            case 72: {
                comp = Comp$Sge$.MODULE$;
                break;
            }
            case 73: {
                comp = Comp$Slt$.MODULE$;
                break;
            }
            case 74: {
                comp = Comp$Sle$.MODULE$;
                break;
            }
            case 75: {
                comp = Comp$Feq$.MODULE$;
                break;
            }
            case 76: {
                comp = Comp$Fne$.MODULE$;
                break;
            }
            case 77: {
                comp = Comp$Fgt$.MODULE$;
                break;
            }
            case 78: {
                comp = Comp$Fge$.MODULE$;
                break;
            }
            case 79: {
                comp = Comp$Flt$.MODULE$;
                break;
            }
            case 80: {
                comp = Comp$Fle$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return comp;
    }

    private Conv getConv() {
        Conv conv;
        int n = this.buffer.getInt();
        switch (n) {
            case 97: {
                conv = Conv$Trunc$.MODULE$;
                break;
            }
            case 98: {
                conv = Conv$Zext$.MODULE$;
                break;
            }
            case 99: {
                conv = Conv$Sext$.MODULE$;
                break;
            }
            case 100: {
                conv = Conv$Fptrunc$.MODULE$;
                break;
            }
            case 101: {
                conv = Conv$Fpext$.MODULE$;
                break;
            }
            case 102: {
                conv = Conv$Fptoui$.MODULE$;
                break;
            }
            case 103: {
                conv = Conv$Fptosi$.MODULE$;
                break;
            }
            case 104: {
                conv = Conv$Uitofp$.MODULE$;
                break;
            }
            case 105: {
                conv = Conv$Sitofp$.MODULE$;
                break;
            }
            case 106: {
                conv = Conv$Ptrtoint$.MODULE$;
                break;
            }
            case 107: {
                conv = Conv$Inttoptr$.MODULE$;
                break;
            }
            case 108: {
                conv = Conv$Bitcast$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return conv;
    }

    private Seq<Defn> getDefns() {
        return this.getSeq((Function0 & Serializable)() -> this.getDefn());
    }

    private Defn getDefn() {
        Defn defn;
        Position pos = this.getPosition();
        int n = this.buffer.getInt();
        switch (n) {
            case 129: {
                defn = new Defn.Var(this.getAttrs(), this.getGlobal(), this.getType(), this.getVal(), pos);
                break;
            }
            case 130: {
                defn = new Defn.Const(this.getAttrs(), this.getGlobal(), this.getType(), this.getVal(), pos);
                break;
            }
            case 131: {
                defn = new Defn.Declare(this.getAttrs(), this.getGlobal(), this.getType(), pos);
                break;
            }
            case 132: {
                defn = new Defn.Define(this.getAttrs(), this.getGlobal(), this.getType(), this.getInsts(), pos);
                break;
            }
            case 133: {
                defn = new Defn.Trait(this.getAttrs(), this.getGlobal(), this.getGlobals(), pos);
                break;
            }
            case 134: {
                defn = new Defn.Class(this.getAttrs(), this.getGlobal(), this.getGlobalOpt(), this.getGlobals(), pos);
                break;
            }
            case 135: {
                defn = new Defn.Module(this.getAttrs(), this.getGlobal(), this.getGlobalOpt(), this.getGlobals(), pos);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return defn;
    }

    private Seq<Global> getGlobals() {
        return this.getSeq((Function0 & Serializable)() -> this.getGlobal());
    }

    private Option<Global> getGlobalOpt() {
        return this.getOpt((Function0 & Serializable)() -> this.getGlobal());
    }

    private Global getGlobal() {
        Global global;
        int n = this.buffer.getInt();
        switch (n) {
            case 193: {
                global = Global$None$.MODULE$;
                break;
            }
            case 194: {
                global = new Global.Top(this.getUTF8String());
                break;
            }
            case 195: {
                global = new Global.Member(new Global.Top(this.getUTF8String()), this.getSig());
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return global;
    }

    private Sig getSig() {
        Sig sig;
        Sig sig2 = new Sig(this.getUTF8String());
        if (this.usesEncodedMemberNames()) {
            sig = sig2;
        } else {
            Sig sig3;
            Sig.Unmangled unmangled = sig2.unmangled();
            if (unmangled instanceof Sig.Field) {
                Sig.Field field = (Sig.Field)unmangled;
                sig3 = Sig$.MODULE$.unmangledToMangled(field.copy(NameTransformer$.MODULE$.encode(field.id()), field.copy$default$2()));
            } else if (unmangled instanceof Sig.Method) {
                Sig.Method method = (Sig.Method)unmangled;
                sig3 = Sig$.MODULE$.unmangledToMangled(method.copy(NameTransformer$.MODULE$.encode(method.id()), method.copy$default$2(), method.copy$default$3()));
            } else {
                sig3 = Sig$.MODULE$.unmangledToMangled(unmangled);
            }
            sig = sig3;
        }
        return sig;
    }

    private long getLocal() {
        return this.buffer.getLong();
    }

    private Seq<Next> getNexts() {
        return this.getSeq((Function0 & Serializable)() -> this.getNext());
    }

    private Next getNext() {
        Next next;
        int n = this.buffer.getInt();
        if (Tags$.MODULE$.NoneNext() == n) {
            next = Next$None$.MODULE$;
        } else if (Tags$.MODULE$.UnwindNext() == n) {
            next = new Next.Unwind(this.getParam(), this.getNext());
        } else if (Tags$.MODULE$.CaseNext() == n) {
            next = new Next.Case(this.getVal(), this.getNext());
        } else if (Tags$.MODULE$.LabelNext() == n) {
            next = new Next.Label(this.getLocal(), this.getVals());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return next;
    }

    private Op getOp() {
        Op op;
        int n = this.buffer.getInt();
        if (Tags$.MODULE$.CallOp() == n) {
            op = new Op.Call(this.getType(), this.getVal(), this.getVals());
        } else if (Tags$.MODULE$.LoadOp() == n) {
            op = new Op.Load(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.StoreOp() == n) {
            op = new Op.Store(this.getType(), this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.ElemOp() == n) {
            op = new Op.Elem(this.getType(), this.getVal(), this.getVals());
        } else if (Tags$.MODULE$.ExtractOp() == n) {
            op = new Op.Extract(this.getVal(), this.getInts());
        } else if (Tags$.MODULE$.InsertOp() == n) {
            op = new Op.Insert(this.getVal(), this.getVal(), this.getInts());
        } else if (Tags$.MODULE$.StackallocOp() == n) {
            op = new Op.Stackalloc(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.BinOp() == n) {
            op = new Op.Bin(this.getBin(), this.getType(), this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.CompOp() == n) {
            op = new Op.Comp(this.getComp(), this.getType(), this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.ConvOp() == n) {
            op = new Op.Conv(this.getConv(), this.getType(), this.getVal());
        } else if (Tags$.MODULE$.ClassallocOp() == n) {
            op = new Op.Classalloc(this.getGlobal());
        } else if (Tags$.MODULE$.FieldloadOp() == n) {
            op = new Op.Fieldload(this.getType(), this.getVal(), this.getGlobal());
        } else if (Tags$.MODULE$.FieldstoreOp() == n) {
            op = new Op.Fieldstore(this.getType(), this.getVal(), this.getGlobal(), this.getVal());
        } else if (Tags$.MODULE$.FieldOp() == n) {
            op = new Op.Field(this.getVal(), this.getGlobal());
        } else if (Tags$.MODULE$.MethodOp() == n) {
            op = new Op.Method(this.getVal(), this.getSig());
        } else if (Tags$.MODULE$.DynmethodOp() == n) {
            op = new Op.Dynmethod(this.getVal(), this.getSig());
        } else if (Tags$.MODULE$.ModuleOp() == n) {
            op = new Op.Module(this.getGlobal());
        } else if (Tags$.MODULE$.AsOp() == n) {
            op = new Op.As(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.IsOp() == n) {
            op = new Op.Is(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.CopyOp() == n) {
            op = new Op.Copy(this.getVal());
        } else if (Tags$.MODULE$.SizeofOp() == n) {
            op = new Op.Sizeof(this.getType());
        } else if (Tags$.MODULE$.BoxOp() == n) {
            op = new Op.Box(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.UnboxOp() == n) {
            op = new Op.Unbox(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.VarOp() == n) {
            op = new Op.Var(this.getType());
        } else if (Tags$.MODULE$.VarloadOp() == n) {
            op = new Op.Varload(this.getVal());
        } else if (Tags$.MODULE$.VarstoreOp() == n) {
            op = new Op.Varstore(this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.ArrayallocOp() == n) {
            op = new Op.Arrayalloc(this.getType(), this.getVal());
        } else if (Tags$.MODULE$.ArrayloadOp() == n) {
            op = new Op.Arrayload(this.getType(), this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.ArraystoreOp() == n) {
            op = new Op.Arraystore(this.getType(), this.getVal(), this.getVal(), this.getVal());
        } else if (Tags$.MODULE$.ArraylengthOp() == n) {
            op = new Op.Arraylength(this.getVal());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return op;
    }

    private Seq<Val.Local> getParams() {
        return this.getSeq((Function0 & Serializable)() -> this.getParam());
    }

    private Val.Local getParam() {
        return new Val.Local(this.getLocal(), this.getType());
    }

    private Seq<Type> getTypes() {
        return this.getSeq((Function0 & Serializable)() -> this.getType());
    }

    private Type getType() {
        Type type;
        int n = this.buffer.getInt();
        if (Tags$.MODULE$.VarargType() == n) {
            type = Type$Vararg$.MODULE$;
        } else if (Tags$.MODULE$.PtrType() == n) {
            type = Type$Ptr$.MODULE$;
        } else if (Tags$.MODULE$.BoolType() == n) {
            type = Type$Bool$.MODULE$;
        } else if (Tags$.MODULE$.CharType() == n) {
            type = Type$Char$.MODULE$;
        } else if (Tags$.MODULE$.ByteType() == n) {
            type = Type$Byte$.MODULE$;
        } else if (Tags$.MODULE$.ShortType() == n) {
            type = Type$Short$.MODULE$;
        } else if (Tags$.MODULE$.IntType() == n) {
            type = Type$Int$.MODULE$;
        } else if (Tags$.MODULE$.LongType() == n) {
            type = Type$Long$.MODULE$;
        } else if (Tags$.MODULE$.FloatType() == n) {
            type = Type$Float$.MODULE$;
        } else if (Tags$.MODULE$.DoubleType() == n) {
            type = Type$Double$.MODULE$;
        } else if (Tags$.MODULE$.ArrayValueType() == n) {
            type = new Type.ArrayValue(this.getType(), this.buffer.getInt());
        } else if (Tags$.MODULE$.StructValueType() == n) {
            type = new Type.StructValue(this.getTypes());
        } else if (Tags$.MODULE$.FunctionType() == n) {
            type = new Type.Function(this.getTypes(), this.getType());
        } else if (Tags$.MODULE$.NullType() == n) {
            type = Type$Null$.MODULE$;
        } else if (Tags$.MODULE$.NothingType() == n) {
            type = Type$Nothing$.MODULE$;
        } else if (Tags$.MODULE$.VirtualType() == n) {
            type = Type$Virtual$.MODULE$;
        } else if (Tags$.MODULE$.VarType() == n) {
            type = new Type.Var(this.getType());
        } else if (Tags$.MODULE$.UnitType() == n) {
            type = Type$Unit$.MODULE$;
        } else if (Tags$.MODULE$.ArrayType() == n) {
            type = new Type.Array(this.getType(), this.getBool());
        } else if (Tags$.MODULE$.RefType() == n) {
            type = new Type.Ref(this.getGlobal(), this.getBool(), this.getBool());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return type;
    }

    private Seq<Val> getVals() {
        return this.getSeq((Function0 & Serializable)() -> this.getVal());
    }

    private Val getVal() {
        Val val;
        int n = this.buffer.getInt();
        if (Tags$.MODULE$.TrueVal() == n) {
            val = Val$True$.MODULE$;
        } else if (Tags$.MODULE$.FalseVal() == n) {
            val = Val$False$.MODULE$;
        } else if (Tags$.MODULE$.NullVal() == n) {
            val = Val$Null$.MODULE$;
        } else if (Tags$.MODULE$.ZeroVal() == n) {
            val = new Val.Zero(this.getType());
        } else if (Tags$.MODULE$.CharVal() == n) {
            val = new Val.Char((char)this.buffer.getShort());
        } else if (Tags$.MODULE$.ByteVal() == n) {
            val = new Val.Byte(this.buffer.get());
        } else if (Tags$.MODULE$.ShortVal() == n) {
            val = new Val.Short(this.buffer.getShort());
        } else if (Tags$.MODULE$.IntVal() == n) {
            val = new Val.Int(this.buffer.getInt());
        } else if (Tags$.MODULE$.LongVal() == n) {
            val = new Val.Long(this.buffer.getLong());
        } else if (Tags$.MODULE$.FloatVal() == n) {
            val = new Val.Float(this.buffer.getFloat());
        } else if (Tags$.MODULE$.DoubleVal() == n) {
            val = new Val.Double(this.buffer.getDouble());
        } else if (Tags$.MODULE$.StructValueVal() == n) {
            val = new Val.StructValue(this.getVals());
        } else if (Tags$.MODULE$.ArrayValueVal() == n) {
            val = new Val.ArrayValue(this.getType(), this.getVals());
        } else if (Tags$.MODULE$.CharsVal() == n) {
            val = new Val.Chars((Seq<Object>)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.byteArrayOps(this.getBytes())));
        } else if (Tags$.MODULE$.LocalVal() == n) {
            val = new Val.Local(this.getLocal(), this.getType());
        } else if (Tags$.MODULE$.GlobalVal() == n) {
            val = new Val.Global(this.getGlobal(), this.getType());
        } else if (Tags$.MODULE$.UnitVal() == n) {
            val = Val$Unit$.MODULE$;
        } else if (Tags$.MODULE$.ConstVal() == n) {
            val = new Val.Const(this.getVal());
        } else if (Tags$.MODULE$.StringVal() == n) {
            char[] chars = (char[])Array$.MODULE$.fill(this.buffer.getInt(), (Function0)(JFunction0.mcC.sp & Serializable)() -> $this.buffer.getChar(), (ClassTag)ClassTag$.MODULE$.Char());
            val = new Val.String(new String(chars));
        } else if (Tags$.MODULE$.VirtualVal() == n) {
            val = new Val.Virtual(this.buffer.getLong());
        } else if (Tags$.MODULE$.ClassOfVal() == n) {
            val = new Val.ClassOf(this.getGlobal());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return val;
    }

    private LinktimeCondition getLinktimeCondition() {
        Product product;
        int n = this.buffer.getInt();
        switch (n) {
            case 1: {
                product = new LinktimeCondition.SimpleCondition(this.getUTF8String(), this.getComp(), this.getVal(), this.getPosition());
                break;
            }
            case 2: {
                product = new LinktimeCondition.ComplexCondition(this.getBin(), this.getLinktimeCondition(), this.getLinktimeCondition(), this.getPosition());
                break;
            }
            default: {
                throw package$.MODULE$.unsupported(new StringBuilder(32).append("Unknown linktime condition tag: ").append(n).toString());
            }
        }
        return product;
    }

    public Position getPosition() {
        return this.readPosition$1();
    }

    /*
     * WARNING - void declaration
     */
    private final Position readPosition$1() {
        Position position;
        byte first = this.buffer.get();
        if (first == -1) {
            position = Position$.MODULE$.NoPosition();
        } else {
            void var2_11;
            Position position2;
            if ((first & 0xF) == 7) {
                URI file = this.files()[this.buffer.getInt()];
                int line = this.buffer.getInt();
                int column = this.buffer.getInt();
                position2 = new Position(file, line, column);
            } else {
                Position position3 = this.lastPosition();
                Position position4 = Position$.MODULE$.NoPosition();
                Predef$.MODULE$.assert(position3 == null ? position4 != null : !((Object)position3).equals(position4), (Function0 & Serializable)() -> "Position format error: first position must be full");
                if ((first & 1) == 0) {
                    int columnDiff = first >> 1;
                    position2 = new Position(this.lastPosition().source(), this.lastPosition().line(), this.lastPosition().column() + columnDiff);
                } else if ((first & 3) == 1) {
                    int lineDiff = first >> 2;
                    int column = this.buffer.get() & 0xFF;
                    position2 = new Position(this.lastPosition().source(), this.lastPosition().line() + lineDiff, column);
                } else {
                    Predef$.MODULE$.assert((first & 0xF) == 3, (Function0 & Serializable)() -> new StringBuilder(60).append("Position format error: first byte ").append(first).append(" does not match any format").toString());
                    short lineDiff = this.buffer.getShort();
                    int column = this.buffer.get() & 0xFF;
                    position2 = new Position(this.lastPosition().source(), this.lastPosition().line() + lineDiff, column);
                }
            }
            Position result = position2;
            this.lastPosition_$eq(result);
            position = var2_11;
        }
        return position;
    }

    public BinaryDeserializer(ByteBuffer buffer, String bufferName) {
        this.buffer = buffer;
        this.lastPosition = Position$.MODULE$.NoPosition();
        buffer.position(0);
        Prelude prelude = Prelude$.MODULE$.readFrom(buffer, bufferName);
        URI[] files = (URI[])Array$.MODULE$.fill(buffer.getInt(), (Function0 & Serializable)() -> new URI(this.getUTF8String()), ClassTag$.MODULE$.apply(URI.class));
        Seq pairs = this.getSeq((Function0 & Serializable)() -> new Tuple2((Object)this.getGlobal(), (Object)BoxesRunTime.boxToInteger((int)$this.buffer.getInt())));
        Tuple3 tuple3 = new Tuple3((Object)prelude, pairs, (Object)files);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Prelude prelude2 = (Prelude)tuple3._1();
        Seq header = (Seq)tuple3._2();
        URI[] files2 = (URI[])tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)prelude2, (Object)header, (Object)files2);
        this.x$1 = tuple32;
        this.prelude = (Prelude)this.x$1._1();
        this.header = (Seq)this.x$1._2();
        this.files = (URI[])this.x$1._3();
        this.usesEncodedMemberNames = this.prelude().revision() >= 9;
    }
}

