/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.nir.serialization;

import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple5;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.scalanative.nir.Versions;
import scala.scalanative.nir.Versions$;
import scala.scalanative.nir.serialization.Prelude;
import scala.scalanative.nir.serialization.package;
import scala.scalanative.nir.serialization.package$UnknownFormat$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Prelude$
implements Serializable {
    public static final Prelude$ MODULE$ = new Prelude$();
    private static final int length = 45;

    public int length() {
        return length;
    }

    private Either<package.NirDeserializationException, Versions.Version> readNIRVersion(ByteBuffer buffer, Function0<String> fileName) {
        Object object;
        buffer.position(0);
        if (Versions$.MODULE$.magic() != buffer.getInt()) {
            object = package$.MODULE$.Left().apply((Object)package$UnknownFormat$.MODULE$);
        } else {
            int compat = buffer.getInt();
            int revision = buffer.getInt();
            Versions.Version version = new Versions.Version(compat, revision);
            object = compat == Versions$.MODULE$.compat() && revision <= Versions$.MODULE$.revision() ? package$.MODULE$.Right().apply((Object)version) : package$.MODULE$.Left().apply((Object)new package.IncompatibleVersion(version, (String)fileName.apply()));
        }
        return object;
    }

    public Prelude readFrom(ByteBuffer buffer, Function0<String> fileName) {
        Prelude prelude;
        Either<package.NirDeserializationException, Prelude> either = this.tryReadFrom(buffer, fileName);
        if (either instanceof Left) {
            Left left = (Left)either;
            package.NirDeserializationException exception = (package.NirDeserializationException)left.value();
            throw exception;
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        Right right = (Right)either;
        Prelude prelude2 = prelude = (Prelude)right.value();
        return prelude2;
    }

    public Either<package.NirDeserializationException, Prelude> tryReadFrom(ByteBuffer buffer, Function0<String> fileName) {
        return this.readNIRVersion(buffer, fileName).map((Function1 & Serializable)nirVersion -> {
            Prelude.Offsets offsets = new Prelude.Offsets(buffer.getInt(), buffer.getInt(), buffer.getInt(), buffer.getInt(), buffer.getInt(), buffer.getInt(), buffer.getInt(), buffer.getInt());
            boolean hasEntryPoints = buffer.get() != 0;
            return new Prelude((Versions.Version)nirVersion, offsets, hasEntryPoints);
        });
    }

    public DataOutputStream writeTo(DataOutputStream out, Prelude prelude) {
        Prelude prelude2 = prelude;
        if (prelude2 == null) {
            throw new MatchError((Object)prelude2);
        }
        int magic = prelude2.magic();
        int compat = prelude2.compat();
        int revision = prelude2.revision();
        Prelude.Offsets offsets = prelude2.sections();
        boolean hasEntryPoints = prelude2.hasEntryPoints();
        Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToInteger((int)magic), (Object)BoxesRunTime.boxToInteger((int)compat), (Object)BoxesRunTime.boxToInteger((int)revision), (Object)offsets, (Object)BoxesRunTime.boxToBoolean((boolean)hasEntryPoints));
        Tuple5 tuple52 = tuple5;
        int magic2 = BoxesRunTime.unboxToInt((Object)tuple52._1());
        int compat2 = BoxesRunTime.unboxToInt((Object)tuple52._2());
        int revision2 = BoxesRunTime.unboxToInt((Object)tuple52._3());
        Prelude.Offsets offsets2 = (Prelude.Offsets)tuple52._4();
        boolean hasEntryPoints2 = BoxesRunTime.unboxToBoolean((Object)tuple52._5());
        out.writeInt(magic2);
        out.writeInt(compat2);
        out.writeInt(revision2);
        out.writeInt(offsets2.offsets());
        out.writeInt(offsets2.strings());
        out.writeInt(offsets2.positions());
        out.writeInt(offsets2.globals());
        out.writeInt(offsets2.types());
        out.writeInt(offsets2.defns());
        out.writeInt(offsets2.vals());
        out.writeInt(offsets2.insts());
        out.writeBoolean(hasEntryPoints2);
        return out;
    }

    public Prelude apply(int magic, int compat, int revision, Prelude.Offsets sections, boolean hasEntryPoints) {
        return new Prelude(magic, compat, revision, sections, hasEntryPoints);
    }

    public Option<Tuple5<Object, Object, Object, Prelude.Offsets, Object>> unapply(Prelude x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)x$0.magic()), (Object)BoxesRunTime.boxToInteger((int)x$0.compat()), (Object)BoxesRunTime.boxToInteger((int)x$0.revision()), (Object)x$0.sections(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.hasEntryPoints())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Prelude$.class);
    }

    private Prelude$() {
    }
}

