/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.io;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.scalanative.io.VirtualDirectory;
import scala.scalanative.io.VirtualDirectory$EmptyDirectory$;
import scala.scalanative.util.Scope;

public final class VirtualDirectory$
implements Serializable {
    private static final VirtualDirectory empty;
    private static final VirtualDirectory$EmptyDirectory$ EmptyDirectory;
    public static final VirtualDirectory$ MODULE$;

    private VirtualDirectory$() {
    }

    static {
        MODULE$ = new VirtualDirectory$();
        empty = VirtualDirectory$EmptyDirectory$.MODULE$;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(VirtualDirectory$.class);
    }

    public VirtualDirectory local(Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(31).append("Local directory doesn't exist: ").append(this.absolute$1(file)).toString());
        }
        if (!Files.isDirectory(file, new LinkOption[0])) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(17).append("Not a directory: ").append(this.absolute$1(file)).toString());
        }
        return new VirtualDirectory.LocalDirectory(file);
    }

    public VirtualDirectory jar(Path file, Scope in) {
        Path absolute = file.toAbsolutePath();
        if (!Files.exists(file, new LinkOption[0])) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(19).append("Jar doesn't exist: ").append(absolute).toString());
        }
        if (!absolute.toString().endsWith(".jar")) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(11).append("Not a jar: ").append(absolute).toString());
        }
        return new VirtualDirectory.JarDirectory(file, in);
    }

    public VirtualDirectory real(Path file, Scope in) {
        VirtualDirectory virtualDirectory;
        if (Files.isDirectory(file, new LinkOption[0])) {
            virtualDirectory = this.local(file);
        } else if (file.toString().endsWith(".jar")) {
            virtualDirectory = this.jar(file, in);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(32).append("Neither a jar, nor a directory: ").append(file).toString());
        }
        return virtualDirectory;
    }

    public VirtualDirectory empty() {
        return empty;
    }

    private final Path absolute$1(Path file$1) {
        return file$1.toAbsolutePath();
    }
}

