/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.nir.serialization;

import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.UnrolledBuffer;
import scala.collection.mutable.UnrolledBuffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.scalanative.nir.Attr;
import scala.scalanative.nir.Attr$Abstract$;
import scala.scalanative.nir.Attr$Alignment$;
import scala.scalanative.nir.Attr$AlwaysInline$;
import scala.scalanative.nir.Attr$BailOpt$;
import scala.scalanative.nir.Attr$Define$;
import scala.scalanative.nir.Attr$DidOpt$;
import scala.scalanative.nir.Attr$Dyn$;
import scala.scalanative.nir.Attr$Extern$;
import scala.scalanative.nir.Attr$Final$;
import scala.scalanative.nir.Attr$InlineHint$;
import scala.scalanative.nir.Attr$Link$;
import scala.scalanative.nir.Attr$LinktimeResolved$;
import scala.scalanative.nir.Attr$MayInline$;
import scala.scalanative.nir.Attr$MaySpecialize$;
import scala.scalanative.nir.Attr$NoInline$;
import scala.scalanative.nir.Attr$NoOpt$;
import scala.scalanative.nir.Attr$NoSpecialize$;
import scala.scalanative.nir.Attr$SafePublish$;
import scala.scalanative.nir.Attr$Stub$;
import scala.scalanative.nir.Attr$UnOpt$;
import scala.scalanative.nir.Attr$UsesIntrinsic$;
import scala.scalanative.nir.Attr$Volatile$;
import scala.scalanative.nir.Attrs;
import scala.scalanative.nir.Attrs$;
import scala.scalanative.nir.Bin;
import scala.scalanative.nir.Bin$And$;
import scala.scalanative.nir.Bin$Ashr$;
import scala.scalanative.nir.Bin$Fadd$;
import scala.scalanative.nir.Bin$Fdiv$;
import scala.scalanative.nir.Bin$Fmul$;
import scala.scalanative.nir.Bin$Frem$;
import scala.scalanative.nir.Bin$Fsub$;
import scala.scalanative.nir.Bin$Iadd$;
import scala.scalanative.nir.Bin$Imul$;
import scala.scalanative.nir.Bin$Isub$;
import scala.scalanative.nir.Bin$Lshr$;
import scala.scalanative.nir.Bin$Or$;
import scala.scalanative.nir.Bin$Sdiv$;
import scala.scalanative.nir.Bin$Shl$;
import scala.scalanative.nir.Bin$Srem$;
import scala.scalanative.nir.Bin$Udiv$;
import scala.scalanative.nir.Bin$Urem$;
import scala.scalanative.nir.Bin$Xor$;
import scala.scalanative.nir.Comp;
import scala.scalanative.nir.Comp$Feq$;
import scala.scalanative.nir.Comp$Fge$;
import scala.scalanative.nir.Comp$Fgt$;
import scala.scalanative.nir.Comp$Fle$;
import scala.scalanative.nir.Comp$Flt$;
import scala.scalanative.nir.Comp$Fne$;
import scala.scalanative.nir.Comp$Ieq$;
import scala.scalanative.nir.Comp$Ine$;
import scala.scalanative.nir.Comp$Sge$;
import scala.scalanative.nir.Comp$Sgt$;
import scala.scalanative.nir.Comp$Sle$;
import scala.scalanative.nir.Comp$Slt$;
import scala.scalanative.nir.Comp$Uge$;
import scala.scalanative.nir.Comp$Ugt$;
import scala.scalanative.nir.Comp$Ule$;
import scala.scalanative.nir.Comp$Ult$;
import scala.scalanative.nir.Conv;
import scala.scalanative.nir.Conv$Bitcast$;
import scala.scalanative.nir.Conv$Fpext$;
import scala.scalanative.nir.Conv$Fptosi$;
import scala.scalanative.nir.Conv$Fptoui$;
import scala.scalanative.nir.Conv$Fptrunc$;
import scala.scalanative.nir.Conv$Inttoptr$;
import scala.scalanative.nir.Conv$Ptrtoint$;
import scala.scalanative.nir.Conv$SSizeCast$;
import scala.scalanative.nir.Conv$Sext$;
import scala.scalanative.nir.Conv$Sitofp$;
import scala.scalanative.nir.Conv$Trunc$;
import scala.scalanative.nir.Conv$Uitofp$;
import scala.scalanative.nir.Conv$ZSizeCast$;
import scala.scalanative.nir.Conv$Zext$;
import scala.scalanative.nir.Defn;
import scala.scalanative.nir.Defn$Class$;
import scala.scalanative.nir.Defn$Const$;
import scala.scalanative.nir.Defn$Declare$;
import scala.scalanative.nir.Defn$Define$;
import scala.scalanative.nir.Defn$Define$DebugInfo$;
import scala.scalanative.nir.Defn$Define$DebugInfo$LexicalScope$;
import scala.scalanative.nir.Defn$Module$;
import scala.scalanative.nir.Defn$Trait$;
import scala.scalanative.nir.Defn$Var$;
import scala.scalanative.nir.Global;
import scala.scalanative.nir.Global$Member$;
import scala.scalanative.nir.Global$None$;
import scala.scalanative.nir.Global$Top$;
import scala.scalanative.nir.Inst;
import scala.scalanative.nir.Inst$If$;
import scala.scalanative.nir.Inst$Jump$;
import scala.scalanative.nir.Inst$Label$;
import scala.scalanative.nir.Inst$Let$;
import scala.scalanative.nir.Inst$LinktimeIf$;
import scala.scalanative.nir.Inst$Ret$;
import scala.scalanative.nir.Inst$Switch$;
import scala.scalanative.nir.Inst$Throw$;
import scala.scalanative.nir.Inst$Unreachable$;
import scala.scalanative.nir.LinktimeCondition;
import scala.scalanative.nir.LinktimeCondition$ComplexCondition$;
import scala.scalanative.nir.LinktimeCondition$SimpleCondition$;
import scala.scalanative.nir.Local;
import scala.scalanative.nir.Local$;
import scala.scalanative.nir.MemoryOrder;
import scala.scalanative.nir.MemoryOrder$AcqRel$;
import scala.scalanative.nir.MemoryOrder$Acquire$;
import scala.scalanative.nir.MemoryOrder$Monotonic$;
import scala.scalanative.nir.MemoryOrder$Release$;
import scala.scalanative.nir.MemoryOrder$SeqCst$;
import scala.scalanative.nir.MemoryOrder$Unordered$;
import scala.scalanative.nir.NIRSource;
import scala.scalanative.nir.Next;
import scala.scalanative.nir.Next$Case$;
import scala.scalanative.nir.Next$Label$;
import scala.scalanative.nir.Next$None$;
import scala.scalanative.nir.Next$Unwind$;
import scala.scalanative.nir.Op;
import scala.scalanative.nir.Op$AlignmentOf$;
import scala.scalanative.nir.Op$Arrayalloc$;
import scala.scalanative.nir.Op$Arraylength$;
import scala.scalanative.nir.Op$Arrayload$;
import scala.scalanative.nir.Op$Arraystore$;
import scala.scalanative.nir.Op$As$;
import scala.scalanative.nir.Op$Bin$;
import scala.scalanative.nir.Op$Box$;
import scala.scalanative.nir.Op$Call$;
import scala.scalanative.nir.Op$Classalloc$;
import scala.scalanative.nir.Op$Comp$;
import scala.scalanative.nir.Op$Conv$;
import scala.scalanative.nir.Op$Copy$;
import scala.scalanative.nir.Op$Dynmethod$;
import scala.scalanative.nir.Op$Elem$;
import scala.scalanative.nir.Op$Extract$;
import scala.scalanative.nir.Op$Fence$;
import scala.scalanative.nir.Op$Field$;
import scala.scalanative.nir.Op$Fieldload$;
import scala.scalanative.nir.Op$Fieldstore$;
import scala.scalanative.nir.Op$Insert$;
import scala.scalanative.nir.Op$Is$;
import scala.scalanative.nir.Op$Load$;
import scala.scalanative.nir.Op$Method$;
import scala.scalanative.nir.Op$Module$;
import scala.scalanative.nir.Op$SizeOf$;
import scala.scalanative.nir.Op$Stackalloc$;
import scala.scalanative.nir.Op$Store$;
import scala.scalanative.nir.Op$Unbox$;
import scala.scalanative.nir.Op$Var$;
import scala.scalanative.nir.Op$Varload$;
import scala.scalanative.nir.Op$Varstore$;
import scala.scalanative.nir.Sig;
import scala.scalanative.nir.SourceFile;
import scala.scalanative.nir.SourceFile$Relative$;
import scala.scalanative.nir.SourceFile$Virtual$;
import scala.scalanative.nir.SourcePosition;
import scala.scalanative.nir.SourcePosition$;
import scala.scalanative.nir.Type;
import scala.scalanative.nir.Type$Array$;
import scala.scalanative.nir.Type$ArrayValue$;
import scala.scalanative.nir.Type$Bool$;
import scala.scalanative.nir.Type$Byte$;
import scala.scalanative.nir.Type$Char$;
import scala.scalanative.nir.Type$Double$;
import scala.scalanative.nir.Type$Float$;
import scala.scalanative.nir.Type$Function$;
import scala.scalanative.nir.Type$Int$;
import scala.scalanative.nir.Type$Long$;
import scala.scalanative.nir.Type$Nothing$;
import scala.scalanative.nir.Type$Null$;
import scala.scalanative.nir.Type$Ptr$;
import scala.scalanative.nir.Type$Ref$;
import scala.scalanative.nir.Type$Short$;
import scala.scalanative.nir.Type$Size$;
import scala.scalanative.nir.Type$StructValue$;
import scala.scalanative.nir.Type$Unit$;
import scala.scalanative.nir.Type$Var$;
import scala.scalanative.nir.Type$Vararg$;
import scala.scalanative.nir.Type$Virtual$;
import scala.scalanative.nir.Val;
import scala.scalanative.nir.Val$ArrayValue$;
import scala.scalanative.nir.Val$Byte$;
import scala.scalanative.nir.Val$ByteString$;
import scala.scalanative.nir.Val$Char$;
import scala.scalanative.nir.Val$ClassOf$;
import scala.scalanative.nir.Val$Const$;
import scala.scalanative.nir.Val$Double$;
import scala.scalanative.nir.Val$False$;
import scala.scalanative.nir.Val$Float$;
import scala.scalanative.nir.Val$Global$;
import scala.scalanative.nir.Val$Int$;
import scala.scalanative.nir.Val$Local$;
import scala.scalanative.nir.Val$Long$;
import scala.scalanative.nir.Val$Null$;
import scala.scalanative.nir.Val$Short$;
import scala.scalanative.nir.Val$Size$;
import scala.scalanative.nir.Val$String$;
import scala.scalanative.nir.Val$StructValue$;
import scala.scalanative.nir.Val$True$;
import scala.scalanative.nir.Val$Unit$;
import scala.scalanative.nir.Val$Virtual$;
import scala.scalanative.nir.Val$Zero$;
import scala.scalanative.nir.serialization.DeserializationException;
import scala.scalanative.nir.serialization.Prelude;
import scala.scalanative.nir.serialization.Prelude$;
import scala.scalanative.util.ScalaStdlibCompat$;
import scala.scalanative.util.TypeOps$;
import scala.scalanative.util.TypeOps$TypeNarrowing$;
import scala.scalanative.util.package$;
import scala.util.control.NonFatal$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BinaryDeserializer {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BinaryDeserializer.class.getDeclaredField("0bitmap$1"));
    public long 0bitmap$1;
    private final ByteBuffer buffer;
    private final NIRSource nirSource;
    public Prelude prelude$lzy1;
    private Map offsets$lzy1;
    private Set globals$lzy1;
    private final LongMap<Object> cache;

    public BinaryDeserializer(ByteBuffer buffer, NIRSource nirSource) {
        this.buffer = buffer;
        this.nirSource = nirSource;
        this.cache = new LongMap();
    }

    public Prelude prelude() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    Prelude prelude;
                    this.prelude$lzy1 = prelude = Prelude$.MODULE$.readFrom(this.buffer, (Function0<String>)((Function0 & Serializable)this::prelude$$anonfun$1));
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return prelude;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.prelude$lzy1;
    }

    public final Seq<Defn> deserialize() {
        UnrolledBuffer allDefns = UnrolledBuffer$.MODULE$.empty(ClassTag$.MODULE$.apply(Defn.class));
        this.offsets().foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                UnrolledBuffer unrolledBuffer;
                Global global = (Global)tuple2._1();
                int offset = BoxesRunTime.unboxToInt((Object)tuple2._2());
                this.buffer.position(this.prelude().sections().defns() + offset);
                try {
                    unrolledBuffer = (UnrolledBuffer)allDefns.$plus$eq((Object)this.getDefn());
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable ex = throwable3 = (Throwable)option.get();
                        throw new DeserializationException(global, this.nirSource.debugName(), this.prelude().compat(), this.prelude().revision(), ex);
                    }
                    throw throwable;
                }
                return unrolledBuffer;
            }
            throw new MatchError((Object)tuple2);
        });
        return allDefns.toSeq();
    }

    private Map<Global, Object> offsets() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 1)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 1)) continue;
                try {
                    Map map;
                    boolean bl;
                    this.buffer.position(this.prelude().sections().offsets());
                    Map entries = (Map)Map$.MODULE$.empty();
                    do {
                        Global global = this.getGlobal();
                        int offset = this.getLebSignedInt();
                        Global global2 = global;
                        if (Global$None$.MODULE$.equals(global2)) {
                            bl = false;
                            continue;
                        }
                        entries.update((Object)global, (Object)BoxesRunTime.boxToInteger((int)offset));
                        bl = true;
                    } while (bl);
                    this.offsets$lzy1 = map = entries;
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 1);
                    return map;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 1);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 1);
        }
        return this.offsets$lzy1;
    }

    private Set<Global> globals() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 2)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 2)) continue;
                try {
                    Set set;
                    this.globals$lzy1 = set = this.offsets().keySet();
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 2);
                    return set;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 2);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 2);
        }
        return this.globals$lzy1;
    }

    private <T> T in(int start, Function0<T> getT) {
        int target = start + this.getLebUnsignedInt();
        return (T)this.cache.getOrElseUpdate(Int$.MODULE$.int2long(target), () -> this.in$$anonfun$1(getT, target));
    }

    private byte getTag() {
        return this.buffer.get();
    }

    private char getLebChar() {
        return (char)this.getLebUnsignedInt();
    }

    private short getLebShort() {
        return (short)this.getLebSignedInt();
    }

    private int getLebSignedInt() {
        int result = 0;
        int shift = 0;
        int count = 0;
        int n = -1;
        do {
            n = this.buffer.get();
            result |= (n & 0x7F) << shift;
            shift += 7;
        } while ((n & 0x80) != 0 && ++count < 5);
        if ((n & 0x80) == 128) {
            throw new Exception("Invalid LEB128 sequence");
        }
        if (shift < 32 && (n & 0x40) != 0) {
            result |= -1 << shift;
        }
        return result;
    }

    private long getLebSignedLong() {
        long result = 0L;
        int shift = 0;
        int count = 0;
        int n = -1;
        do {
            n = this.buffer.get();
            result |= (long)(n & 0x7F) << shift;
            shift += 7;
        } while ((n & 0x80) != 0 && ++count < 10);
        if ((n & 0x80) == 128) {
            throw new Exception("Invalid LEB128 sequence");
        }
        if (shift < 64 && (n & 0x40) != 0) {
            result |= -1L << shift;
        }
        return result;
    }

    public int getLebUnsignedInt() {
        int result = 0;
        int shift = 0;
        int count = 0;
        int n = -1;
        do {
            n = this.buffer.get();
            result |= (n & 0x7F) << shift;
            shift += 7;
        } while ((n & 0x80) != 0 && ++count < 5);
        if ((n & 0x80) == 128) {
            throw new Exception("Invalid LEB128 sequence");
        }
        return result;
    }

    public long getLebUnsignedLong() {
        long result = 0L;
        int shift = 0;
        int count = 0;
        int n = -1;
        do {
            n = this.buffer.get();
            result |= (long)(n & 0x7F) << shift;
            shift += 7;
        } while ((n & 0x80) != 0 && ++count < 10);
        if ((n & 0x80) == 128) {
            throw new Exception("Invalid LEB128 sequence");
        }
        return result;
    }

    private <T> Seq<T> getSeq(Function0<T> getT, ClassTag<T> evidence$1) {
        return ScalaStdlibCompat$.MODULE$.ArraySeqCompat().fill(this.getLebUnsignedInt(), getT, evidence$1);
    }

    private <T> Option<T> getOpt(Function0<T> getT) {
        if (this.buffer.get() == 0) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(getT.apply());
    }

    private String getString() {
        return (String)this.in(this.prelude().sections().strings(), this::getString$$anonfun$1);
    }

    private byte[] getBytes() {
        byte[] arr = new byte[this.getLebUnsignedInt()];
        this.buffer.get(arr);
        return arr;
    }

    private boolean getBool() {
        return this.buffer.get() != 0;
    }

    private Attrs getAttrs() {
        return Attrs$.MODULE$.fromSeq(this.getSeq(this::getAttrs$$anonfun$1, ClassTag$.MODULE$.apply(Attr.class)));
    }

    private Attr getAttr() {
        Attr attr;
        byte by = this.getTag();
        switch (by) {
            case 1: {
                attr = Attr$MayInline$.MODULE$;
                break;
            }
            case 2: {
                attr = Attr$InlineHint$.MODULE$;
                break;
            }
            case 3: {
                attr = Attr$NoInline$.MODULE$;
                break;
            }
            case 4: {
                attr = Attr$AlwaysInline$.MODULE$;
                break;
            }
            case 5: {
                attr = Attr$MaySpecialize$.MODULE$;
                break;
            }
            case 6: {
                attr = Attr$NoSpecialize$.MODULE$;
                break;
            }
            case 7: {
                attr = Attr$UnOpt$.MODULE$;
                break;
            }
            case 8: {
                attr = Attr$NoOpt$.MODULE$;
                break;
            }
            case 9: {
                attr = Attr$DidOpt$.MODULE$;
                break;
            }
            case 10: {
                attr = Attr$BailOpt$.MODULE$.apply(this.getString());
                break;
            }
            case 13: {
                attr = Attr$Dyn$.MODULE$;
                break;
            }
            case 14: {
                attr = Attr$Stub$.MODULE$;
                break;
            }
            case 11: {
                attr = Attr$Extern$.MODULE$.apply(this.getBool());
                break;
            }
            case 12: {
                attr = Attr$Link$.MODULE$.apply(this.getString());
                break;
            }
            case 22: {
                attr = Attr$Define$.MODULE$.apply(this.getString());
                break;
            }
            case 15: {
                attr = Attr$Abstract$.MODULE$;
                break;
            }
            case 16: {
                attr = Attr$Volatile$.MODULE$;
                break;
            }
            case 17: {
                attr = Attr$Final$.MODULE$;
                break;
            }
            case 18: {
                attr = Attr$SafePublish$.MODULE$;
                break;
            }
            case 19: {
                attr = Attr$LinktimeResolved$.MODULE$;
                break;
            }
            case 20: {
                attr = Attr$UsesIntrinsic$.MODULE$;
                break;
            }
            case 21: {
                attr = Attr$Alignment$.MODULE$.apply(this.getLebSignedInt(), this.getOpt(this::getAttr$$anonfun$1));
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
        }
        return attr;
    }

    private Bin getBin() {
        Bin bin;
        byte by = this.getTag();
        switch (by) {
            case 1: {
                bin = Bin$Iadd$.MODULE$;
                break;
            }
            case 2: {
                bin = Bin$Fadd$.MODULE$;
                break;
            }
            case 3: {
                bin = Bin$Isub$.MODULE$;
                break;
            }
            case 4: {
                bin = Bin$Fsub$.MODULE$;
                break;
            }
            case 5: {
                bin = Bin$Imul$.MODULE$;
                break;
            }
            case 6: {
                bin = Bin$Fmul$.MODULE$;
                break;
            }
            case 7: {
                bin = Bin$Sdiv$.MODULE$;
                break;
            }
            case 8: {
                bin = Bin$Udiv$.MODULE$;
                break;
            }
            case 9: {
                bin = Bin$Fdiv$.MODULE$;
                break;
            }
            case 10: {
                bin = Bin$Srem$.MODULE$;
                break;
            }
            case 11: {
                bin = Bin$Urem$.MODULE$;
                break;
            }
            case 12: {
                bin = Bin$Frem$.MODULE$;
                break;
            }
            case 13: {
                bin = Bin$Shl$.MODULE$;
                break;
            }
            case 14: {
                bin = Bin$Lshr$.MODULE$;
                break;
            }
            case 15: {
                bin = Bin$Ashr$.MODULE$;
                break;
            }
            case 16: {
                bin = Bin$And$.MODULE$;
                break;
            }
            case 17: {
                bin = Bin$Or$.MODULE$;
                break;
            }
            case 18: {
                bin = Bin$Xor$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
        }
        return bin;
    }

    private int getScopeId() {
        return this.getLebUnsignedInt();
    }

    private Seq<Inst> getInsts() {
        return (Seq)this.in(this.prelude().sections().insts(), this::getInsts$$anonfun$1);
    }

    private Inst getInst() {
        Inst inst;
        byte tag = this.getTag();
        SourcePosition pos = this.getPosition();
        byte by = tag;
        switch (by) {
            case 1: {
                inst = Inst$Label$.MODULE$.apply(this.getLocal(), this.getParams(), pos);
                break;
            }
            case 2: {
                inst = Inst$Let$.MODULE$.apply(this.getLocal(), this.getOp(), Next$None$.MODULE$, pos, this.scope$1());
                break;
            }
            case 3: {
                inst = Inst$Let$.MODULE$.apply(this.getLocal(), this.getOp(), this.getNext(), pos, this.scope$1());
                break;
            }
            case 4: {
                inst = Inst$Ret$.MODULE$.apply(this.getVal(), pos);
                break;
            }
            case 5: {
                inst = Inst$Jump$.MODULE$.apply(this.getNext(), pos);
                break;
            }
            case 6: {
                inst = Inst$If$.MODULE$.apply(this.getVal(), this.getNext(), this.getNext(), pos);
                break;
            }
            case 7: {
                inst = Inst$Switch$.MODULE$.apply(this.getVal(), this.getNext(), this.getNexts(), pos);
                break;
            }
            case 8: {
                inst = Inst$Throw$.MODULE$.apply(this.getVal(), this.getNext(), pos);
                break;
            }
            case 9: {
                inst = Inst$Unreachable$.MODULE$.apply(this.getNext(), pos);
                break;
            }
            case 10: {
                inst = Inst$LinktimeIf$.MODULE$.apply(this.getLinktimeCondition(), this.getNext(), this.getNext(), pos);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
        }
        return inst;
    }

    private Comp getComp() {
        Comp comp;
        byte by = this.getTag();
        switch (by) {
            case 1: {
                comp = Comp$Ieq$.MODULE$;
                break;
            }
            case 2: {
                comp = Comp$Ine$.MODULE$;
                break;
            }
            case 3: {
                comp = Comp$Ugt$.MODULE$;
                break;
            }
            case 4: {
                comp = Comp$Uge$.MODULE$;
                break;
            }
            case 5: {
                comp = Comp$Ult$.MODULE$;
                break;
            }
            case 6: {
                comp = Comp$Ule$.MODULE$;
                break;
            }
            case 7: {
                comp = Comp$Sgt$.MODULE$;
                break;
            }
            case 8: {
                comp = Comp$Sge$.MODULE$;
                break;
            }
            case 9: {
                comp = Comp$Slt$.MODULE$;
                break;
            }
            case 10: {
                comp = Comp$Sle$.MODULE$;
                break;
            }
            case 11: {
                comp = Comp$Feq$.MODULE$;
                break;
            }
            case 12: {
                comp = Comp$Fne$.MODULE$;
                break;
            }
            case 13: {
                comp = Comp$Fgt$.MODULE$;
                break;
            }
            case 14: {
                comp = Comp$Fge$.MODULE$;
                break;
            }
            case 15: {
                comp = Comp$Flt$.MODULE$;
                break;
            }
            case 16: {
                comp = Comp$Fle$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
        }
        return comp;
    }

    private Conv getConv() {
        Conv conv;
        byte by = this.getTag();
        switch (by) {
            case 1: {
                conv = Conv$Trunc$.MODULE$;
                break;
            }
            case 2: {
                conv = Conv$Zext$.MODULE$;
                break;
            }
            case 3: {
                conv = Conv$Sext$.MODULE$;
                break;
            }
            case 4: {
                conv = Conv$Fptrunc$.MODULE$;
                break;
            }
            case 5: {
                conv = Conv$Fpext$.MODULE$;
                break;
            }
            case 6: {
                conv = Conv$Fptoui$.MODULE$;
                break;
            }
            case 7: {
                conv = Conv$Fptosi$.MODULE$;
                break;
            }
            case 8: {
                conv = Conv$Uitofp$.MODULE$;
                break;
            }
            case 9: {
                conv = Conv$Sitofp$.MODULE$;
                break;
            }
            case 10: {
                conv = Conv$Ptrtoint$.MODULE$;
                break;
            }
            case 11: {
                conv = Conv$Inttoptr$.MODULE$;
                break;
            }
            case 12: {
                conv = Conv$Bitcast$.MODULE$;
                break;
            }
            case 13: {
                conv = Conv$SSizeCast$.MODULE$;
                break;
            }
            case 14: {
                conv = Conv$ZSizeCast$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
        }
        return conv;
    }

    private Defn.Define.DebugInfo.LexicalScope getLexicalScope() {
        return Defn$Define$DebugInfo$LexicalScope$.MODULE$.apply(this.getScopeId(), this.getScopeId(), this.getPosition());
    }

    private Defn.Define.DebugInfo getDebugInfo() {
        return Defn$Define$DebugInfo$.MODULE$.apply(this.getLocalNames(), this.getSeq(this::getDebugInfo$$anonfun$1, ClassTag$.MODULE$.apply(Defn.Define.DebugInfo.LexicalScope.class)));
    }

    private Defn getDefn() {
        Defn defn;
        byte tag = this.getTag();
        Global name = this.getGlobal();
        Attrs attrs = this.getAttrs();
        SourcePosition position = this.getPosition();
        byte by = tag;
        switch (by) {
            case 1: {
                Global global = (Global)TypeOps$.MODULE$.TypeNarrowing(name);
                defn = Defn$Var$.MODULE$.apply(attrs, (Global.Member)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(global, ClassTag$.MODULE$.apply(Global.Member.class)), this.getType(), this.getVal(), position);
                break;
            }
            case 2: {
                Global global = (Global)TypeOps$.MODULE$.TypeNarrowing(name);
                defn = Defn$Const$.MODULE$.apply(attrs, (Global.Member)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(global, ClassTag$.MODULE$.apply(Global.Member.class)), this.getType(), this.getVal(), position);
                break;
            }
            case 3: {
                Global global = (Global)TypeOps$.MODULE$.TypeNarrowing(name);
                Type type = (Type)TypeOps$.MODULE$.TypeNarrowing(this.getType());
                defn = Defn$Declare$.MODULE$.apply(attrs, (Global.Member)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(global, ClassTag$.MODULE$.apply(Global.Member.class)), (Type.Function)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(type, ClassTag$.MODULE$.apply(Type.Function.class)), position);
                break;
            }
            case 4: {
                Global global = (Global)TypeOps$.MODULE$.TypeNarrowing(name);
                Type type = (Type)TypeOps$.MODULE$.TypeNarrowing(this.getType());
                defn = Defn$Define$.MODULE$.apply(attrs, (Global.Member)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(global, ClassTag$.MODULE$.apply(Global.Member.class)), (Type.Function)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(type, ClassTag$.MODULE$.apply(Type.Function.class)), this.getInsts(), this.getDebugInfo(), position);
                break;
            }
            case 5: {
                Global global = (Global)TypeOps$.MODULE$.TypeNarrowing(name);
                Seq seq = (Seq)TypeOps$.MODULE$.TypeNarrowing(this.getGlobals());
                defn = Defn$Trait$.MODULE$.apply(attrs, (Global.Top)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(global, ClassTag$.MODULE$.apply(Global.Top.class)), (Seq<Global.Top>)((Seq)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(seq, ClassTag$.MODULE$.apply(Seq.class))), position);
                break;
            }
            case 6: {
                Global global = (Global)TypeOps$.MODULE$.TypeNarrowing(name);
                Option option = (Option)TypeOps$.MODULE$.TypeNarrowing(this.getGlobalOpt());
                Seq seq = (Seq)TypeOps$.MODULE$.TypeNarrowing(this.getGlobals());
                defn = Defn$Class$.MODULE$.apply(attrs, (Global.Top)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(global, ClassTag$.MODULE$.apply(Global.Top.class)), (Option<Global.Top>)((Option)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(option, ClassTag$.MODULE$.apply(Option.class))), (Seq<Global.Top>)((Seq)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(seq, ClassTag$.MODULE$.apply(Seq.class))), position);
                break;
            }
            case 7: {
                Global global = (Global)TypeOps$.MODULE$.TypeNarrowing(name);
                Option option = (Option)TypeOps$.MODULE$.TypeNarrowing(this.getGlobalOpt());
                Seq seq = (Seq)TypeOps$.MODULE$.TypeNarrowing(this.getGlobals());
                defn = Defn$Module$.MODULE$.apply(attrs, (Global.Top)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(global, ClassTag$.MODULE$.apply(Global.Top.class)), (Option<Global.Top>)((Option)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(option, ClassTag$.MODULE$.apply(Option.class))), (Seq<Global.Top>)((Seq)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(seq, ClassTag$.MODULE$.apply(Seq.class))), position);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
        }
        return defn;
    }

    private Seq<Global> getGlobals() {
        return this.getSeq(this::getGlobals$$anonfun$1, ClassTag$.MODULE$.apply(Global.class));
    }

    private Option<Global> getGlobalOpt() {
        return this.getOpt(this::getGlobalOpt$$anonfun$1);
    }

    private Global getGlobal() {
        return (Global)this.in(this.prelude().sections().globals(), this::getGlobal$$anonfun$1);
    }

    private Sig getSig() {
        return new Sig(this.getString());
    }

    private long getLocal() {
        return Local$.MODULE$.apply(this.getLebUnsignedLong());
    }

    private Seq<Next> getNexts() {
        return this.getSeq(this::getNexts$$anonfun$1, ClassTag$.MODULE$.apply(Next.class));
    }

    private Next getNext() {
        Next next;
        byte by = this.getTag();
        switch (by) {
            case 1: {
                next = Next$None$.MODULE$;
                break;
            }
            case 2: {
                next = Next$Unwind$.MODULE$.apply(this.getParam(), this.getNext());
                break;
            }
            case 3: {
                next = Next$Case$.MODULE$.apply(this.getVal(), this.getNext());
                break;
            }
            case 4: {
                next = Next$Label$.MODULE$.apply(this.getLocal(), this.getVals());
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
        }
        return next;
    }

    private Op getOp() {
        Op op;
        byte by = this.getTag();
        switch (by) {
            case 1: {
                Type type = (Type)TypeOps$.MODULE$.TypeNarrowing(this.getType());
                op = Op$Call$.MODULE$.apply((Type.Function)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(type, ClassTag$.MODULE$.apply(Type.Function.class)), this.getVal(), this.getVals());
                break;
            }
            case 2: {
                op = Op$Load$.MODULE$.apply(this.getType(), this.getVal(), (Option<MemoryOrder>)None$.MODULE$);
                break;
            }
            case 3: {
                op = Op$Load$.MODULE$.apply(this.getType(), this.getVal(), (Option<MemoryOrder>)Some$.MODULE$.apply((Object)this.getMemoryOrder()));
                break;
            }
            case 4: {
                op = Op$Store$.MODULE$.apply(this.getType(), this.getVal(), this.getVal(), (Option<MemoryOrder>)None$.MODULE$);
                break;
            }
            case 5: {
                op = Op$Store$.MODULE$.apply(this.getType(), this.getVal(), this.getVal(), (Option<MemoryOrder>)Some$.MODULE$.apply((Object)this.getMemoryOrder()));
                break;
            }
            case 6: {
                op = Op$Elem$.MODULE$.apply(this.getType(), this.getVal(), this.getVals());
                break;
            }
            case 7: {
                op = Op$Extract$.MODULE$.apply(this.getVal(), this.getSeq(this::getOp$$anonfun$1, ClassTag$.MODULE$.apply(Integer.TYPE)));
                break;
            }
            case 8: {
                op = Op$Insert$.MODULE$.apply(this.getVal(), this.getVal(), this.getSeq(this::getOp$$anonfun$2, ClassTag$.MODULE$.apply(Integer.TYPE)));
                break;
            }
            case 9: {
                op = Op$Stackalloc$.MODULE$.apply(this.getType(), this.getVal());
                break;
            }
            case 10: {
                op = Op$Bin$.MODULE$.apply(this.getBin(), this.getType(), this.getVal(), this.getVal());
                break;
            }
            case 11: {
                op = Op$Comp$.MODULE$.apply(this.getComp(), this.getType(), this.getVal(), this.getVal());
                break;
            }
            case 12: {
                op = Op$Conv$.MODULE$.apply(this.getConv(), this.getType(), this.getVal());
                break;
            }
            case 36: {
                op = Op$Fence$.MODULE$.apply(this.getMemoryOrder());
                break;
            }
            case 13: {
                Global global = (Global)TypeOps$.MODULE$.TypeNarrowing(this.getGlobal());
                op = Op$Classalloc$.MODULE$.apply((Global.Top)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(global, ClassTag$.MODULE$.apply(Global.Top.class)), (Option<Val>)None$.MODULE$);
                break;
            }
            case 14: {
                Global global = (Global)TypeOps$.MODULE$.TypeNarrowing(this.getGlobal());
                op = Op$Classalloc$.MODULE$.apply((Global.Top)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(global, ClassTag$.MODULE$.apply(Global.Top.class)), (Option<Val>)Some$.MODULE$.apply((Object)this.getVal()));
                break;
            }
            case 16: {
                Global global = (Global)TypeOps$.MODULE$.TypeNarrowing(this.getGlobal());
                op = Op$Fieldload$.MODULE$.apply(this.getType(), this.getVal(), (Global.Member)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(global, ClassTag$.MODULE$.apply(Global.Member.class)));
                break;
            }
            case 17: {
                Global global = (Global)TypeOps$.MODULE$.TypeNarrowing(this.getGlobal());
                op = Op$Fieldstore$.MODULE$.apply(this.getType(), this.getVal(), (Global.Member)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(global, ClassTag$.MODULE$.apply(Global.Member.class)), this.getVal());
                break;
            }
            case 15: {
                Global global = (Global)TypeOps$.MODULE$.TypeNarrowing(this.getGlobal());
                op = Op$Field$.MODULE$.apply(this.getVal(), (Global.Member)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(global, ClassTag$.MODULE$.apply(Global.Member.class)));
                break;
            }
            case 18: {
                op = Op$Method$.MODULE$.apply(this.getVal(), this.getSig());
                break;
            }
            case 27: {
                op = Op$Dynmethod$.MODULE$.apply(this.getVal(), this.getSig());
                break;
            }
            case 19: {
                Global global = (Global)TypeOps$.MODULE$.TypeNarrowing(this.getGlobal());
                op = Op$Module$.MODULE$.apply((Global.Top)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(global, ClassTag$.MODULE$.apply(Global.Top.class)));
                break;
            }
            case 20: {
                op = Op$As$.MODULE$.apply(this.getType(), this.getVal());
                break;
            }
            case 21: {
                op = Op$Is$.MODULE$.apply(this.getType(), this.getVal());
                break;
            }
            case 22: {
                op = Op$Copy$.MODULE$.apply(this.getVal());
                break;
            }
            case 25: {
                op = Op$Box$.MODULE$.apply(this.getType(), this.getVal());
                break;
            }
            case 26: {
                op = Op$Unbox$.MODULE$.apply(this.getType(), this.getVal());
                break;
            }
            case 28: {
                op = Op$Var$.MODULE$.apply(this.getType());
                break;
            }
            case 29: {
                op = Op$Varload$.MODULE$.apply(this.getVal());
                break;
            }
            case 30: {
                op = Op$Varstore$.MODULE$.apply(this.getVal(), this.getVal());
                break;
            }
            case 31: {
                op = Op$Arrayalloc$.MODULE$.apply(this.getType(), this.getVal(), (Option<Val>)None$.MODULE$);
                break;
            }
            case 32: {
                op = Op$Arrayalloc$.MODULE$.apply(this.getType(), this.getVal(), (Option<Val>)Some$.MODULE$.apply((Object)this.getVal()));
                break;
            }
            case 33: {
                op = Op$Arrayload$.MODULE$.apply(this.getType(), this.getVal(), this.getVal());
                break;
            }
            case 34: {
                op = Op$Arraystore$.MODULE$.apply(this.getType(), this.getVal(), this.getVal(), this.getVal());
                break;
            }
            case 35: {
                op = Op$Arraylength$.MODULE$.apply(this.getVal());
                break;
            }
            case 23: {
                op = Op$SizeOf$.MODULE$.apply(this.getType());
                break;
            }
            case 24: {
                op = Op$AlignmentOf$.MODULE$.apply(this.getType());
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
        }
        return op;
    }

    private Seq<Val.Local> getParams() {
        return this.getSeq(this::getParams$$anonfun$1, ClassTag$.MODULE$.apply(Val.Local.class));
    }

    private Val.Local getParam() {
        return Val$Local$.MODULE$.apply(this.getLocal(), this.getType());
    }

    private Seq<Type> getTypes() {
        return this.getSeq(this::getTypes$$anonfun$1, ClassTag$.MODULE$.apply(Type.class));
    }

    private Type getType() {
        return (Type)this.in(this.prelude().sections().types(), this::getType$$anonfun$1);
    }

    private Seq<Val> getVals() {
        return this.getSeq(this::getVals$$anonfun$1, ClassTag$.MODULE$.apply(Val.class));
    }

    private Val getVal() {
        return (Val)this.in(this.prelude().sections().vals(), this::getVal$$anonfun$1);
    }

    private MemoryOrder getMemoryOrder() {
        MemoryOrder memoryOrder;
        byte by = this.getTag();
        switch (by) {
            case 1: {
                memoryOrder = MemoryOrder$Unordered$.MODULE$;
                break;
            }
            case 2: {
                memoryOrder = MemoryOrder$Monotonic$.MODULE$;
                break;
            }
            case 3: {
                memoryOrder = MemoryOrder$Acquire$.MODULE$;
                break;
            }
            case 4: {
                memoryOrder = MemoryOrder$Release$.MODULE$;
                break;
            }
            case 5: {
                memoryOrder = MemoryOrder$AcqRel$.MODULE$;
                break;
            }
            case 6: {
                memoryOrder = MemoryOrder$SeqCst$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
        }
        return memoryOrder;
    }

    private LinktimeCondition getLinktimeCondition() {
        Product product;
        byte by = this.getTag();
        if (1 == by) {
            product = LinktimeCondition$SimpleCondition$.MODULE$.apply(this.getString(), this.getComp(), this.getVal(), this.getPosition());
        } else if (2 == by) {
            product = LinktimeCondition$ComplexCondition$.MODULE$.apply(this.getBin(), this.getLinktimeCondition(), this.getLinktimeCondition(), this.getPosition());
        } else {
            byte n = by;
            throw package$.MODULE$.unsupported(new StringBuilder(32).append("Unknown linktime condition tag: ").append(n).toString());
        }
        return product;
    }

    public SourcePosition getPosition() {
        return (SourcePosition)this.in(this.prelude().sections().positions(), this::getPosition$$anonfun$1);
    }

    public scala.collection.immutable.Map<Local, String> getLocalNames() {
        int size = this.getLebUnsignedInt();
        if (size == 0) {
            return Predef$.MODULE$.Map().empty();
        }
        Builder b = Predef$.MODULE$.Map().newBuilder();
        b.sizeHint(size);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach((Function1 & Serializable)x$1 -> this.getLocalNames$$anonfun$1(b, BoxesRunTime.unboxToInt((Object)x$1)));
        return (scala.collection.immutable.Map)b.result();
    }

    private final String prelude$$anonfun$1() {
        return this.nirSource.debugName();
    }

    private final Object in$$anonfun$1(Function0 getT$1, int target$1) {
        Object object;
        int pos = this.buffer.position();
        this.buffer.position(target$1);
        try {
            object = getT$1.apply();
        }
        finally {
            this.buffer.position(pos);
        }
        return object;
    }

    private final char $anonfun$1() {
        return this.getLebChar();
    }

    private final String getString$$anonfun$1() {
        char[] chars = (char[])Array$.MODULE$.fill(this.getLebUnsignedInt(), this::$anonfun$1, ClassTag$.MODULE$.apply(Character.TYPE));
        return new String(chars);
    }

    private final Attr getAttrs$$anonfun$1() {
        return this.getAttr();
    }

    private final String getAttr$$anonfun$1() {
        return this.getString();
    }

    private final Inst getInsts$$anonfun$1$$anonfun$1() {
        return this.getInst();
    }

    private final Seq getInsts$$anonfun$1() {
        return this.getSeq(this::getInsts$$anonfun$1$$anonfun$1, ClassTag$.MODULE$.apply(Inst.class));
    }

    private final int scope$1() {
        return this.getScopeId();
    }

    private final Defn.Define.DebugInfo.LexicalScope getDebugInfo$$anonfun$1() {
        return this.getLexicalScope();
    }

    private final Global getGlobals$$anonfun$1() {
        return this.getGlobal();
    }

    private final Global getGlobalOpt$$anonfun$1() {
        return this.getGlobal();
    }

    private final Global getGlobal$$anonfun$1() {
        Global global;
        byte by = this.getTag();
        switch (by) {
            case 1: {
                global = Global$None$.MODULE$;
                break;
            }
            case 2: {
                global = Global$Top$.MODULE$.apply(this.getString());
                break;
            }
            case 3: {
                Global global2 = (Global)TypeOps$.MODULE$.TypeNarrowing(this.getGlobal());
                global = Global$Member$.MODULE$.apply((Global.Top)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(global2, ClassTag$.MODULE$.apply(Global.Top.class)), this.getSig());
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
        }
        return global;
    }

    private final Next getNexts$$anonfun$1() {
        return this.getNext();
    }

    private final int getOp$$anonfun$1() {
        return this.getLebSignedInt();
    }

    private final int getOp$$anonfun$2() {
        return this.getLebSignedInt();
    }

    private final Val.Local getParams$$anonfun$1() {
        return this.getParam();
    }

    private final Type getTypes$$anonfun$1() {
        return this.getType();
    }

    private final Type getType$$anonfun$1() {
        Type type;
        byte by = this.getTag();
        switch (by) {
            case 1: {
                type = Type$Vararg$.MODULE$;
                break;
            }
            case 3: {
                type = Type$Ptr$.MODULE$;
                break;
            }
            case 2: {
                type = Type$Bool$.MODULE$;
                break;
            }
            case 4: {
                type = Type$Char$.MODULE$;
                break;
            }
            case 5: {
                type = Type$Byte$.MODULE$;
                break;
            }
            case 6: {
                type = Type$Short$.MODULE$;
                break;
            }
            case 7: {
                type = Type$Int$.MODULE$;
                break;
            }
            case 8: {
                type = Type$Long$.MODULE$;
                break;
            }
            case 9: {
                type = Type$Float$.MODULE$;
                break;
            }
            case 10: {
                type = Type$Double$.MODULE$;
                break;
            }
            case 11: {
                type = Type$ArrayValue$.MODULE$.apply(this.getType(), this.getLebUnsignedInt());
                break;
            }
            case 12: {
                type = Type$StructValue$.MODULE$.apply(this.getTypes());
                break;
            }
            case 13: {
                type = Type$Function$.MODULE$.apply(this.getTypes(), this.getType());
                break;
            }
            case 14: {
                type = Type$Null$.MODULE$;
                break;
            }
            case 15: {
                type = Type$Nothing$.MODULE$;
                break;
            }
            case 16: {
                type = Type$Virtual$.MODULE$;
                break;
            }
            case 17: {
                type = Type$Var$.MODULE$.apply(this.getType());
                break;
            }
            case 18: {
                type = Type$Unit$.MODULE$;
                break;
            }
            case 19: {
                type = Type$Array$.MODULE$.apply(this.getType(), this.getBool());
                break;
            }
            case 20: {
                Global global = (Global)TypeOps$.MODULE$.TypeNarrowing(this.getGlobal());
                type = Type$Ref$.MODULE$.apply((Global.Top)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(global, ClassTag$.MODULE$.apply(Global.Top.class)), this.getBool(), this.getBool());
                break;
            }
            case 21: {
                type = Type$Size$.MODULE$;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
        }
        return type;
    }

    private final Val getVals$$anonfun$1() {
        return this.getVal();
    }

    private final Val getVal$$anonfun$1() {
        Val val;
        byte by = this.getTag();
        switch (by) {
            case 1: {
                val = Val$True$.MODULE$;
                break;
            }
            case 2: {
                val = Val$False$.MODULE$;
                break;
            }
            case 3: {
                val = Val$Null$.MODULE$;
                break;
            }
            case 4: {
                val = Val$Zero$.MODULE$.apply(this.getType());
                break;
            }
            case 6: {
                val = Val$Byte$.MODULE$.apply(this.buffer.get());
                break;
            }
            case 5: {
                val = Val$Char$.MODULE$.apply(this.getLebChar());
                break;
            }
            case 7: {
                val = Val$Short$.MODULE$.apply(this.getLebShort());
                break;
            }
            case 8: {
                val = Val$Int$.MODULE$.apply(this.getLebSignedInt());
                break;
            }
            case 9: {
                val = Val$Long$.MODULE$.apply(this.getLebSignedLong());
                break;
            }
            case 10: {
                val = Val$Float$.MODULE$.apply(this.buffer.getFloat());
                break;
            }
            case 11: {
                val = Val$Double$.MODULE$.apply(this.buffer.getDouble());
                break;
            }
            case 12: {
                val = Val$StructValue$.MODULE$.apply(this.getVals());
                break;
            }
            case 13: {
                val = Val$ArrayValue$.MODULE$.apply(this.getType(), this.getVals());
                break;
            }
            case 14: {
                val = Val$ByteString$.MODULE$.apply(this.getBytes());
                break;
            }
            case 15: {
                val = Val$Local$.MODULE$.apply(this.getLocal(), this.getType());
                break;
            }
            case 16: {
                val = Val$Global$.MODULE$.apply(this.getGlobal(), this.getType());
                break;
            }
            case 17: {
                val = Val$Unit$.MODULE$;
                break;
            }
            case 18: {
                val = Val$Const$.MODULE$.apply(this.getVal());
                break;
            }
            case 19: {
                val = Val$String$.MODULE$.apply(this.getString());
                break;
            }
            case 20: {
                val = Val$Virtual$.MODULE$.apply(this.getLebUnsignedLong());
                break;
            }
            case 21: {
                Global global = (Global)TypeOps$.MODULE$.TypeNarrowing(this.getGlobal());
                val = Val$ClassOf$.MODULE$.apply((Global.Top)TypeOps$TypeNarrowing$.MODULE$.narrow$extension(global, ClassTag$.MODULE$.apply(Global.Top.class)));
                break;
            }
            case 23: {
                val = Val$Size$.MODULE$.apply(this.getLebUnsignedLong());
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
        }
        return val;
    }

    private final SourcePosition getPosition$$anonfun$1() {
        Product product;
        String string = this.getString();
        if ("".equals(string)) {
            product = SourceFile$Virtual$.MODULE$;
        } else {
            String path = string;
            product = SourceFile$Relative$.MODULE$.apply(path);
        }
        SourceFile file = product;
        int line = this.getLebUnsignedInt();
        int column = this.getLebUnsignedInt();
        return SourcePosition$.MODULE$.apply(file, line, column, this.nirSource);
    }

    private final /* synthetic */ Builder getLocalNames$$anonfun$1(Builder b$1, int x$1) {
        int n = x$1;
        Local local = (Local)Predef$.MODULE$.ArrowAssoc((Object)new Local(this.getLocal()));
        return (Builder)b$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)local, (Object)this.getString()));
    }
}

