/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.util;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.UnrolledBuffer;
import scala.collection.mutable.UnrolledBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class Stats$
implements Serializable {
    private static final Map<String, Object> times;
    private static final Map<String, Object> counts;
    private static final Map<String, UnrolledBuffer<Object>> dists;
    public static final Stats$ MODULE$;

    private Stats$() {
    }

    static {
        MODULE$ = new Stats$();
        times = (Map)Map$.MODULE$.empty();
        counts = (Map)Map$.MODULE$.empty();
        dists = (Map)Map$.MODULE$.empty();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Stats$.class);
    }

    private void printTotal() {
        Map totalTimes = (Map)Map$.MODULE$.empty();
        Map totalCounts = (Map)Map$.MODULE$.empty();
        Map totalThreads = (Map)Map$.MODULE$.empty();
        times.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                long v = BoxesRunTime.unboxToLong((Object)tuple2._2());
                String key = k.split(":")[1];
                totalTimes.update((Object)key, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)totalTimes.getOrElse((Object)key, this::printTotal$$anonfun$1$$anonfun$1)) + v)));
                totalThreads.update((Object)key, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)totalThreads.getOrElse((Object)key, this::printTotal$$anonfun$1$$anonfun$2)) + 1L)));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        counts.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                long v = BoxesRunTime.unboxToLong((Object)tuple2._2());
                String key = k.split(":")[1];
                totalCounts.update((Object)key, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)totalCounts.getOrElse((Object)key, this::printTotal$$anonfun$2$$anonfun$1)) + v)));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        Predef$.MODULE$.println((Object)"--- Total");
        ((IterableOnceOps)totalTimes.toSeq().sortBy((Function1 & Serializable)_$1 -> (String)_$1._1(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                long time = BoxesRunTime.unboxToLong((Object)tuple2._2());
                String ms = BoxesRunTime.boxToDouble((double)((double)time / 1000000.0)).toString();
                long count = BoxesRunTime.unboxToLong((Object)totalCounts.apply((Object)key));
                long threads = BoxesRunTime.unboxToLong((Object)totalThreads.apply((Object)key));
                Predef$.MODULE$.println((Object)new StringBuilder(23).append(key).append(": ").append(ms).append(" ms, ").append(count).append(" times, ").append(threads).append(" threads").toString());
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        if (dists.nonEmpty()) {
            Predef$.MODULE$.println((Object)"--- Total (Dist)");
            this.printDist();
            return;
        }
    }

    private void printDist() {
        Seq elems = (Seq)dists.toSeq().sortBy((Function1 & Serializable)_$2 -> (String)_$2._1(), (Ordering)Ordering.String$.MODULE$);
        elems.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                UnrolledBuffer measurements = (UnrolledBuffer)tuple2._2();
                Predef$.MODULE$.println((Object)new StringBuilder(1).append(key).append(":").toString());
                Predef$.MODULE$.println((Object)new StringBuilder(7).append("  min: ").append(measurements.min((Ordering)Ordering.Long$.MODULE$)).toString());
                Predef$.MODULE$.println((Object)new StringBuilder(7).append("  max: ").append(measurements.max((Ordering)Ordering.Long$.MODULE$)).toString());
                Predef$.MODULE$.println((Object)new StringBuilder(7).append("  avg: ").append(BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)measurements.map((Function1)(JFunction1.mcDJ.sp & Serializable)_$3 -> _$3)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)measurements.size()).toString());
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private void printThread(String id) {
        Predef$.MODULE$.println((Object)new StringBuilder(11).append("--- Thread ").append(id).toString());
        ((IterableOnceOps)times.toSeq().sortBy((Function1 & Serializable)_$4 -> (String)_$4._1(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                long time = BoxesRunTime.unboxToLong((Object)tuple2._2());
                if (key.startsWith(id)) {
                    String ms = BoxesRunTime.boxToDouble((double)((double)time / 1000000.0)).toString();
                    long count = BoxesRunTime.unboxToLong((Object)counts.apply((Object)key));
                    String k = key.split(":")[1];
                    Predef$.MODULE$.println((Object)new StringBuilder(13).append(k).append(": ").append(ms).append(" ms, ").append(count).append(" times").toString());
                    return;
                }
            }
        });
    }

    private void printThreads() {
        Set threads = (Set)Set$.MODULE$.empty();
        times.keys().foreach((Function1 & Serializable)k -> (Set)threads.$plus$eq((Object)k.split(":")[0]));
        ((IterableOnceOps)threads.toSeq().sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)id -> this.printThread((String)id));
    }

    private void print() {
        Stats$ stats$ = this;
        synchronized (stats$) {
            this.printTotal();
            this.printThreads();
        }
    }

    private void clear() {
        Stats$ stats$ = this;
        synchronized (stats$) {
            times.clear();
            counts.clear();
        }
    }

    private String threadKey(String key) {
        return new StringBuilder(1).append(Thread.currentThread().getId()).append(":").append(key).toString();
    }

    public <T> T in(Function0<T> f) {
        this.clear();
        Object res = f.apply();
        this.print();
        return (T)res;
    }

    public <T> T time(String key, Function0<T> f) {
        long start = System.nanoTime();
        Object res = f.apply();
        long end = System.nanoTime();
        long t = end - start;
        String k = this.threadKey(key);
        Map<String, Object> map = times;
        synchronized (map) {
            times.update((Object)k, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)times.getOrElse((Object)k, this::time$$anonfun$1)) + t)));
        }
        Map<String, Object> map2 = counts;
        synchronized (map2) {
            counts.update((Object)k, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)counts.getOrElse((Object)k, this::time$$anonfun$2)) + 1L)));
        }
        return (T)res;
    }

    public void dist(String key, long value) {
        Map<String, UnrolledBuffer<Object>> map = dists;
        synchronized (map) {
            UnrolledBuffer buf = (UnrolledBuffer)dists.getOrElseUpdate((Object)key, this::$anonfun$2);
            UnrolledBuffer cfr_ignored_0 = (UnrolledBuffer)buf.$plus$eq((Object)BoxesRunTime.boxToLong((long)value));
        }
    }

    private final long printTotal$$anonfun$1$$anonfun$1() {
        return 0L;
    }

    private final long printTotal$$anonfun$1$$anonfun$2() {
        return 0L;
    }

    private final long printTotal$$anonfun$2$$anonfun$1() {
        return 0L;
    }

    private final long time$$anonfun$1() {
        return 0L;
    }

    private final long time$$anonfun$2() {
        return 0L;
    }

    private final UnrolledBuffer $anonfun$2() {
        return UnrolledBuffer$.MODULE$.empty(ClassTag$.MODULE$.apply(Long.TYPE));
    }
}

